/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.webdav.methods;

import java.io.IOException;
import java.util.Hashtable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.modeshape.common.logging.Logger;
import org.modeshape.webdav.ITransaction;
import org.modeshape.webdav.exceptions.AccessDeniedException;
import org.modeshape.webdav.exceptions.LockFailedException;
import org.modeshape.webdav.exceptions.ObjectAlreadyExistsException;
import org.modeshape.webdav.exceptions.WebdavException;
import org.modeshape.webdav.locking.ResourceLocks;
import org.modeshape.webdav.methods.AbstractMethod;
import org.modeshape.webdav.methods.DoCopy;
import org.modeshape.webdav.methods.DoDelete;

public class DoMove
extends AbstractMethod {
    private static Logger LOG = Logger.getLogger(DoMove.class);
    private final ResourceLocks resourceLocks;
    private final DoDelete doDelete;
    private final DoCopy doCopy;
    private final boolean readOnly;

    public DoMove(ResourceLocks resourceLocks, DoDelete doDelete, DoCopy doCopy, boolean readOnly) {
        this.resourceLocks = resourceLocks;
        this.doDelete = doDelete;
        this.doCopy = doCopy;
        this.readOnly = readOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void execute(ITransaction transaction, HttpServletRequest req, HttpServletResponse resp) throws IOException, LockFailedException {
        if (!this.readOnly) {
            LOG.trace("-- " + this.getClass().getName(), new Object[0]);
            String sourcePath = this.getRelativePath(req);
            Hashtable<String, Integer> errorList = new Hashtable<String, Integer>();
            if (!this.isUnlocked(transaction, req, this.resourceLocks, sourcePath)) {
                resp.setStatus(423);
                return;
            }
            String destinationPath = req.getHeader("Destination");
            if (destinationPath == null) {
                resp.sendError(400);
                return;
            }
            if (!this.isUnlocked(transaction, req, this.resourceLocks, destinationPath)) {
                resp.setStatus(423);
                return;
            }
            String tempLockOwner = "doMove" + System.currentTimeMillis() + req.toString();
            if (this.resourceLocks.lock(transaction, sourcePath, tempLockOwner, false, 0, 10, true)) {
                try {
                    if (!this.doCopy.copyResource(transaction, req, resp)) return;
                    errorList = new Hashtable();
                    this.doDelete.deleteResource(transaction, sourcePath, errorList, req, resp);
                    if (errorList.isEmpty()) return;
                    this.sendReport(req, resp, errorList);
                    return;
                }
                catch (AccessDeniedException e) {
                    resp.sendError(403);
                    return;
                }
                catch (ObjectAlreadyExistsException e) {
                    resp.sendError(404, req.getRequestURI());
                    return;
                }
                catch (WebdavException e) {
                    resp.sendError(500);
                    return;
                }
                finally {
                    this.resourceLocks.unlockTemporaryLockedObjects(transaction, sourcePath, tempLockOwner);
                }
            } else {
                errorList.put(req.getHeader("Destination"), 423);
                this.sendReport(req, resp, errorList);
            }
            return;
        } else {
            resp.sendError(403);
        }
    }
}

