/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.wsdl;

import java.io.StringReader;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.NamespaceRegistry;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.OperationType;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.Types;
import javax.wsdl.WSDLElement;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.http.HTTPAddress;
import javax.wsdl.extensions.http.HTTPBinding;
import javax.wsdl.extensions.http.HTTPOperation;
import javax.wsdl.extensions.http.HTTPUrlEncoded;
import javax.wsdl.extensions.http.HTTPUrlReplacement;
import javax.wsdl.extensions.mime.MIMEContent;
import javax.wsdl.extensions.mime.MIMEMimeXml;
import javax.wsdl.extensions.mime.MIMEMultipartRelated;
import javax.wsdl.extensions.mime.MIMEPart;
import javax.wsdl.extensions.schema.Schema;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPFault;
import javax.wsdl.extensions.soap.SOAPHeader;
import javax.wsdl.extensions.soap.SOAPHeaderFault;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.wsdl.extensions.soap12.SOAP12Address;
import javax.wsdl.extensions.soap12.SOAP12Binding;
import javax.wsdl.extensions.soap12.SOAP12Body;
import javax.wsdl.extensions.soap12.SOAP12Fault;
import javax.wsdl.extensions.soap12.SOAP12Header;
import javax.wsdl.extensions.soap12.SOAP12HeaderFault;
import javax.wsdl.extensions.soap12.SOAP12Operation;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLLocator;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.modeshape.common.annotation.NotThreadSafe;
import org.modeshape.jcr.api.sequencer.Sequencer;
import org.modeshape.sequencer.sramp.NamespaceEntityResolver;
import org.modeshape.sequencer.sramp.SymbolSpace;
import org.modeshape.sequencer.wsdl.WsdlReader;
import org.modeshape.sequencer.xsd.XsdReader;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

@NotThreadSafe
public class Wsdl11Reader
extends WsdlReader<Definition> {
    protected static final SymbolSpace MESSAGES = new SymbolSpace("Messages");
    protected static final SymbolSpace PORT_TYPES = new SymbolSpace("PortTypes");
    protected static final SymbolSpace BINDINGS = new SymbolSpace("Bindings");
    protected static final SymbolSpace PORTS = new SymbolSpace("Ports");
    protected static final SymbolSpace SERVICES = new SymbolSpace("Services");
    protected Map<WSDLElement, String> uuidForComponent;
    protected Map<WSDLElement, String> nameForComponent;

    public Wsdl11Reader(Sequencer.Context context, String baseUri) {
        super(context, baseUri);
    }

    @Override
    protected Definition parse(InputSource source) throws Exception {
        WSDLReader wsdlReader = WSDLFactory.newInstance().newWSDLReader();
        wsdlReader.setFeature("javax.wsdl.verbose", false);
        wsdlReader.setFeature("javax.wsdl.importDocuments", false);
        CustomWSDLLocator locator = new CustomWSDLLocator(source, this.baseUri);
        return wsdlReader.readWSDL((WSDLLocator)locator);
    }

    @Override
    protected void process(Definition definition, Node outputNode, long sizeOfFile) throws Exception {
        this.uuidForComponent = new HashMap<WSDLElement, String>();
        this.nameForComponent = new HashMap<WSDLElement, String>();
        outputNode.setProperty("sramp:contentType", "application/wsdl+xml");
        outputNode.setProperty("sramp:contentSize", sizeOfFile);
        this.processDocumentation((WSDLElement)definition, outputNode);
        this.processExtensibilityElements((WSDLElement)definition, outputNode);
        this.processTypes(definition.getTypes(), outputNode);
        this.processMessages(definition.getMessages(), outputNode);
        this.processPortTypes(definition.getPortTypes(), outputNode);
        this.processBindings(definition.getBindings(), outputNode);
        this.processServices(definition.getServices(), outputNode);
    }

    protected void processTypes(Types types, Node parentNode) throws Exception {
        if (types == null) {
            return;
        }
        XsdReader xsdReader = new XsdReader(this.context);
        for (Object obj : types.getExtensibilityElements()) {
            if (!(obj instanceof Schema)) continue;
            this.processSchema((Schema)obj, parentNode, xsdReader);
        }
    }

    protected void processSchema(Schema schema, Node parentNode, XsdReader xsdReader) throws Exception {
        Element schemaElement = schema.getElement();
        NodeList childNodes = schemaElement.getChildNodes();
        int len = childNodes.getLength();
        block3: for (int i = 0; i != len; ++i) {
            org.w3c.dom.Node child = childNodes.item(i);
            switch (child.getNodeType()) {
                case 1: {
                    Element element = (Element)child;
                    if (this.processXsdReference(element, parentNode) || this.processXsdAnnotation(element, parentNode)) continue block3;
                    String schemaContent = this.writeXml(schemaElement);
                    InputSource source = new InputSource(new StringReader(schemaContent));
                    Node schemaNode = parentNode.addNode("wsdl:schema", "xs:schemaDocument");
                    xsdReader.read(source, schemaNode);
                    continue block3;
                }
            }
        }
    }

    protected boolean processXsdReference(Element element, Node parentNode) throws RepositoryException {
        String localName = element.getLocalName();
        String type = null;
        if ("xs:import".equals(localName)) {
            type = "wsdl:importedXsd";
        } else if ("xs:include".equals(localName)) {
            type = "wsdl:includedXsd";
        } else if ("xs:redefine".equals(localName)) {
            type = "wsdl:redefinedXsd";
        } else {
            return false;
        }
        Node xsdNode = parentNode.addNode(type, type);
        String namespace = this.getAttributeValue(element, "http://www.w3.org/2001/XMLSchema", "xs:namespace");
        String location = this.getAttributeValue(element, "http://www.w3.org/2001/XMLSchema", "xs:schemaLocation");
        String id = this.getAttributeValue(element, "http://www.w3.org/2001/XMLSchema", "xs:id");
        xsdNode.setProperty("xs:schemaLocation", location);
        if (namespace != null) {
            xsdNode.setProperty("xs:namespace", namespace);
        }
        if (id != null) {
            xsdNode.setProperty("xs:id", id);
        }
        return true;
    }

    protected String getAttributeValue(Element element, String namespaceUri, String localName) {
        String result = element.getAttributeNS(namespaceUri, localName);
        if (result != null && result.length() != 0) {
            return result;
        }
        result = element.getAttribute(localName);
        if (result != null && result.length() != 0) {
            return result;
        }
        Attr namespaceAttr = element.getAttributeNode(localName);
        return namespaceAttr != null ? namespaceAttr.getValue() : null;
    }

    protected boolean processXsdAnnotation(Element element, Node parentNode) {
        this.logger.debug("Ignoring xsd annotation", new Object[0]);
        String localName = element.getLocalName();
        return "xs:annotation".equals(localName);
    }

    protected void processMessages(Map<String, Message> messages, Node parentNode) throws Exception {
        if (messages.isEmpty()) {
            return;
        }
        Node messagesNode = parentNode.addNode("wsdl:messages", "wsdl:messages");
        for (Map.Entry<String, Message> entry : messages.entrySet()) {
            Message message = entry.getValue();
            this.processMessage(message, messagesNode);
        }
    }

    protected void processMessage(Message message, Node messagesNode) throws Exception {
        Node messageNode = this.addChildNode(messagesNode, message.getQName(), "wsdl:message");
        this.setReferenceable(messageNode, MESSAGES, message.getQName());
        this.processDocumentation((WSDLElement)message, messageNode);
        this.processExtensibilityElements((WSDLElement)message, messageNode);
        for (Map.Entry entry : message.getParts().entrySet()) {
            this.processPart((Part)entry.getValue(), messageNode);
        }
    }

    protected void processPart(Part part, Node parentNode) throws Exception {
        QName typeName;
        String partName = this.context.valueFactory().createName(part.getName());
        Node partNode = parentNode.addNode(partName, "wsdl:part");
        partNode.setProperty("wsdl:ncName", part.getName());
        QName elementName = part.getElementName();
        if (elementName != null) {
            partNode.setProperty("wsdl:elementName", elementName.getLocalPart());
            partNode.setProperty("wsdl:elementNamespace", elementName.getNamespaceURI());
            this.setReference(partNode, "wsdl:element", XsdReader.ELEMENT_DECLARATION, elementName);
        }
        if ((typeName = part.getTypeName()) != null) {
            partNode.setProperty("wsdl:typeName", typeName.getLocalPart());
            partNode.setProperty("wsdl:typeNamespace", typeName.getNamespaceURI());
            this.setReference(partNode, "wsdl:type", XsdReader.TYPE_DEFINITIONS, typeName);
        }
        this.processDocumentation((WSDLElement)part, partNode);
        this.processExtensibilityElements((WSDLElement)part, partNode);
    }

    protected void processPortTypes(Map<String, PortType> portTypes, Node parentNode) throws Exception {
        if (portTypes.isEmpty()) {
            return;
        }
        Node portTypesNode = parentNode.addNode("wsdl:portTypes", "wsdl:portTypes");
        for (PortType portType : portTypes.values()) {
            this.processPortType(portType, portTypesNode);
        }
    }

    protected void processPortType(PortType portType, Node portTypesNode) throws Exception {
        QName qname = portType.getQName();
        Node portTypeNode = this.addChildNode(portTypesNode, qname, "wsdl:portType");
        this.setReferenceable(portTypeNode, PORT_TYPES, qname);
        for (Operation operation : portType.getOperations()) {
            this.processOperation(operation, portTypeNode);
        }
        this.processDocumentation((WSDLElement)portType, portTypeNode);
        this.processExtensibilityElements((WSDLElement)portType, portTypeNode);
    }

    protected void processOperation(Operation operation, Node parentNode) throws Exception {
        String operationName = operation.getName();
        Node operationNode = parentNode.addNode(this.context.valueFactory().createName(operationName), "wsdl:operation");
        operationNode.setProperty("wsdl:ncName", operationName);
        OperationType style = operation.getStyle();
        this.processInput(operation.getInput(), operationNode, style, operationName);
        this.processOutput(operation.getOutput(), operationNode, style, operationName);
        for (Fault fault : operation.getFaults().values()) {
            this.processFault(fault, operationNode);
        }
        if (OperationType.REQUEST_RESPONSE.equals(style) || OperationType.SOLICIT_RESPONSE.equals(style)) {
            operationNode.setProperty("wsdl:parameterOrder", this.listToStringArray(operation.getParameterOrdering()));
        }
        this.processDocumentation((WSDLElement)operation, operationNode);
        this.processExtensibilityElements((WSDLElement)operation, operationNode);
    }

    protected void processInput(Input input, Node parentNode, OperationType style, String operationName) throws Exception {
        if (input == null) {
            return;
        }
        String name = input.getName();
        if (name == null) {
            if (OperationType.ONE_WAY.equals(style)) {
                name = operationName;
            } else if (OperationType.NOTIFICATION.equals(style)) {
                name = operationName;
            } else if (OperationType.REQUEST_RESPONSE.equals(style)) {
                name = operationName + "Request";
            } else if (OperationType.SOLICIT_RESPONSE.equals(style)) {
                name = operationName + "Solicit";
            }
        }
        Node inputNode = parentNode.addNode("wsdl:input", "wsdl:operationInput");
        this.uuidForComponent.put((WSDLElement)input, inputNode.getIdentifier());
        this.nameForComponent.put((WSDLElement)input, name);
        inputNode.setProperty("wsdl:ncName", name);
        Message message = input.getMessage();
        if (message != null) {
            QName messageName = message.getQName();
            inputNode.setProperty("wsdl:messageName", messageName.getLocalPart());
            inputNode.setProperty("wsdl:messageNamespace", messageName.getNamespaceURI());
            this.setReference(inputNode, "wsdl:message", MESSAGES, messageName);
        }
        this.processDocumentation((WSDLElement)input, inputNode);
        this.processExtensibilityElements((WSDLElement)input, inputNode);
    }

    protected void processOutput(Output out, Node operationNode, OperationType style, String operationName) throws Exception {
        if (out == null) {
            return;
        }
        String name = out.getName();
        if (name == null) {
            if (OperationType.ONE_WAY.equals(style)) {
                name = operationName;
            } else if (OperationType.NOTIFICATION.equals(style)) {
                name = operationName;
            } else if (OperationType.REQUEST_RESPONSE.equals(style)) {
                name = operationName + "Response";
            } else if (OperationType.SOLICIT_RESPONSE.equals(style)) {
                name = operationName + "Response";
            }
        }
        Node outputNode = operationNode.addNode("wsdl:output", "wsdl:operationOutput");
        this.uuidForComponent.put((WSDLElement)out, outputNode.getIdentifier());
        this.nameForComponent.put((WSDLElement)out, name);
        outputNode.setProperty("wsdl:ncName", name);
        Message message = out.getMessage();
        if (message != null) {
            QName messageName = message.getQName();
            outputNode.setProperty("wsdl:messageName", messageName.getLocalPart());
            outputNode.setProperty("wsdl:messageNamespace", messageName.getNamespaceURI());
            this.setReference(outputNode, "wsdl:message", MESSAGES, messageName);
        }
        this.processDocumentation((WSDLElement)out, outputNode);
        this.processExtensibilityElements((WSDLElement)out, outputNode);
    }

    protected void processFault(Fault fault, Node parentNode) throws Exception {
        if (fault == null) {
            return;
        }
        Node faultNode = parentNode.addNode("wsdl:fault", "wsdl:fault");
        faultNode.setProperty("wsdl:ncName", fault.getName());
        Message message = fault.getMessage();
        if (message != null) {
            QName messageName = message.getQName();
            faultNode.setProperty("wsdl:messageName", messageName.getLocalPart());
            faultNode.setProperty("wsdl:messageNamespace", messageName.getNamespaceURI());
            this.setReference(faultNode, "wsdl:message", MESSAGES, messageName);
        }
        this.processDocumentation((WSDLElement)fault, faultNode);
        this.processExtensibilityElements((WSDLElement)fault, faultNode);
    }

    protected void processBindings(Map<String, Binding> bindings, Node parentNode) throws Exception {
        if (bindings.isEmpty()) {
            return;
        }
        Node bindingNode = parentNode.addNode("wsdl:bindings", "wsdl:bindings");
        for (Binding binding : bindings.values()) {
            this.processBinding(binding, bindingNode);
        }
    }

    protected void processBinding(Binding binding, Node bindingsNode) throws Exception {
        QName qname = binding.getQName();
        Node bindingNode = this.addChildNode(bindingsNode, qname, "wsdl:binding");
        this.setReferenceable(bindingNode, BINDINGS, qname);
        PortType portType = binding.getPortType();
        if (portType != null) {
            QName typeName = portType.getQName();
            bindingNode.setProperty("wsdl:typeName", typeName.getLocalPart());
            bindingNode.setProperty("wsdl:typeNamespace", typeName.getNamespaceURI());
            this.setReference(bindingNode, "wsdl:type", PORT_TYPES, typeName);
        }
        binding.getBindingOperations();
        for (BindingOperation operation : binding.getBindingOperations()) {
            this.processBindingOperation(operation, bindingNode);
        }
        this.processDocumentation((WSDLElement)binding, bindingNode);
        this.processExtensibilityElements((WSDLElement)binding, bindingNode);
    }

    protected void processBindingOperation(BindingOperation operation, Node parentNode) throws Exception {
        String operationName = operation.getName();
        String name = this.context.valueFactory().createName(operationName);
        Node bindingOperation = parentNode.addNode(name, "wsdl:bindingOperation");
        bindingOperation.setProperty("wsdl:ncName", operationName);
        Operation portTypeOperation = operation.getOperation();
        OperationType type = portTypeOperation.getStyle();
        this.processBindingInput(operation.getBindingInput(), bindingOperation, type, operationName, portTypeOperation);
        this.processBindingOutput(operation.getBindingOutput(), bindingOperation, type, operationName, portTypeOperation);
        for (BindingFault fault : operation.getBindingFaults().values()) {
            this.processBindingFault(fault, bindingOperation);
        }
        this.processDocumentation((WSDLElement)operation, bindingOperation);
        this.processExtensibilityElements((WSDLElement)operation, bindingOperation);
    }

    protected void processBindingInput(BindingInput input, Node parentNode, OperationType style, String operationName, Operation operation) throws Exception {
        if (input == null) {
            return;
        }
        String name = input.getName();
        if (name == null) {
            if (OperationType.ONE_WAY.equals(style)) {
                name = operationName;
            } else if (OperationType.NOTIFICATION.equals(style)) {
                name = operationName;
            } else if (OperationType.REQUEST_RESPONSE.equals(style)) {
                name = operationName + "Request";
            } else if (OperationType.SOLICIT_RESPONSE.equals(style)) {
                name = operationName + "Solicit";
            }
        }
        Node bindingInputNode = parentNode.addNode("wsdl:input", "wsdl:bindingOperationInput");
        bindingInputNode.setProperty("wsdl:ncName", name);
        Input opInput = operation.getInput();
        bindingInputNode.setProperty("wsdl:input", this.uuidForComponent((WSDLElement)opInput));
        bindingInputNode.setProperty("wsdl:inputName", this.nameForComponent.get(opInput));
        this.processDocumentation((WSDLElement)input, bindingInputNode);
        this.processExtensibilityElements((WSDLElement)input, bindingInputNode);
    }

    protected void processBindingOutput(BindingOutput out, Node parentNode, OperationType style, String operationName, Operation operation) throws Exception {
        if (out == null) {
            return;
        }
        String name = out.getName();
        if (name == null) {
            if (OperationType.ONE_WAY.equals(style)) {
                name = operationName;
            } else if (OperationType.NOTIFICATION.equals(style)) {
                name = operationName;
            } else if (OperationType.REQUEST_RESPONSE.equals(style)) {
                name = operationName + "Response";
            } else if (OperationType.SOLICIT_RESPONSE.equals(style)) {
                name = operationName + "Response";
            }
        }
        Node bindingOutputNode = parentNode.addNode("wsdl:output", "wsdl:bindingOperationOutput");
        bindingOutputNode.setProperty("wsdl:ncName", name);
        Output opOutput = operation.getOutput();
        bindingOutputNode.setProperty("wsdl:output", this.uuidForComponent((WSDLElement)opOutput));
        bindingOutputNode.setProperty("wsdl:outputName", this.nameForComponent.get(opOutput));
        this.processDocumentation((WSDLElement)out, bindingOutputNode);
        this.processExtensibilityElements((WSDLElement)out, bindingOutputNode);
    }

    protected void processBindingFault(BindingFault fault, Node parentNode) throws Exception {
        if (fault == null) {
            return;
        }
        Node bindingFaultNode = parentNode.addNode("wsdl:fault", "wsdl:bindingOperationFault");
        bindingFaultNode.setProperty("wsdl:ncName", fault.getName());
        this.processDocumentation((WSDLElement)fault, bindingFaultNode);
        this.processExtensibilityElements((WSDLElement)fault, bindingFaultNode);
    }

    protected void processServices(Map<String, Service> services, Node parentNode) throws Exception {
        if (services.isEmpty()) {
            return;
        }
        Node servicesNode = parentNode.addNode("wsdl:services", "wsdl:services");
        for (Service service : services.values()) {
            this.processService(service, servicesNode);
        }
    }

    protected void processService(Service service, Node parentNode) throws Exception {
        QName qname = service.getQName();
        Node serviceNode = this.addChildNode(parentNode, qname, "wsdl:service");
        this.setReferenceable(serviceNode, SERVICES, qname);
        for (Port port : service.getPorts().values()) {
            this.processPort(port, serviceNode);
        }
        this.processDocumentation((WSDLElement)service, serviceNode);
        this.processExtensibilityElements((WSDLElement)service, serviceNode);
    }

    protected void processPort(Port port, Node parentNode) throws Exception {
        String name = port.getName();
        Node portNode = parentNode.addNode(this.context.valueFactory().createName(name), "wsdl:port");
        QName bindingName = port.getBinding().getQName();
        this.setReference(portNode, "wsdl:binding", BINDINGS, bindingName);
        portNode.setProperty("wsdl:ncName", name);
        this.processDocumentation((WSDLElement)port, portNode);
        this.processExtensibilityElements((WSDLElement)port, portNode);
    }

    protected void processDocumentation(WSDLElement wsdlElement, Node outputNode) throws Exception {
        if (wsdlElement == null) {
            return;
        }
        Element docElement = wsdlElement.getDocumentationElement();
        if (docElement == null) {
            return;
        }
        String content = null;
        int numChildNodes = docElement.getChildNodes().getLength();
        content = numChildNodes == 0 ? docElement.getTextContent() : (numChildNodes == 1 ? docElement.getTextContent() : this.writeXml(docElement));
        if (content == null) {
            return;
        }
        if ((content = content.trim()).length() != 0) {
            outputNode.setProperty("sramp:description", this.cleanDocumentationContent(content));
        }
    }

    protected String cleanDocumentationContent(String content) {
        Pattern REMOVE_WHITESPACE_AND_LINE_FEEDS_PATTERN = Pattern.compile("[\\n\\r\\s]+");
        Matcher matcher = REMOVE_WHITESPACE_AND_LINE_FEEDS_PATTERN.matcher(content);
        return matcher.replaceAll(" ");
    }

    protected void processExtensibilityElements(WSDLElement wsdlElement, Node outputNode) throws Exception {
        if (wsdlElement == null) {
            return;
        }
        for (Map.Entry entry : wsdlElement.getExtensionAttributes().entrySet()) {
            Attr attribute = (Attr)entry.getValue();
            String namespaceUri = attribute.getNamespaceURI();
            if ("http://schemas.xmlsoap.org/wsdl/".equals(namespaceUri)) continue;
            String localName = attribute.getLocalName();
            String value = attribute.getNodeValue();
            if (value == null) continue;
            if (namespaceUri != null) {
                NamespaceRegistry namespaceRegistry = outputNode.getSession().getWorkspace().getNamespaceRegistry();
                String prefix = this.registerNamespace(namespaceRegistry, namespaceUri, attribute.getPrefix());
                String propertyName = prefix + ":" + localName;
                outputNode.setProperty(propertyName, value);
                continue;
            }
            outputNode.setProperty(localName, value);
        }
        for (ExtensibilityElement element : wsdlElement.getExtensibilityElements()) {
            this.processExtensibilityElement(element, outputNode);
        }
    }

    protected void processExtensibilityElement(ExtensibilityElement element, Node parentNode) throws Exception {
        if (element == null) {
            return;
        }
        if (element instanceof SOAP12Address) {
            this.processSOAP12Address((SOAP12Address)element, parentNode);
        } else if (element instanceof SOAP12Binding) {
            this.processSOAP12Binding((SOAP12Binding)element, parentNode);
        } else if (element instanceof SOAP12Body) {
            this.processSOAP12Body((SOAP12Body)element, parentNode);
        } else if (element instanceof SOAP12Fault) {
            this.processSOAP12Fault((SOAP12Fault)element, parentNode);
        } else if (element instanceof SOAP12Header) {
            this.processSOAP12Header((SOAP12Header)element, parentNode);
        } else if (element instanceof SOAP12HeaderFault) {
            this.processSOAP12HeaderFault((SOAP12HeaderFault)element, parentNode);
        } else if (element instanceof SOAP12Operation) {
            this.processSOAP12Operation((SOAP12Operation)element, parentNode);
        } else if (element instanceof SOAPAddress) {
            this.processSOAPAddress((SOAPAddress)element, parentNode);
        } else if (element instanceof SOAPBinding) {
            this.processSOAPBinding((SOAPBinding)element, parentNode);
        } else if (element instanceof SOAPBody) {
            this.processSOAPBody((SOAPBody)element, parentNode);
        } else if (element instanceof SOAPFault) {
            this.processSOAPFault((SOAPFault)element, parentNode);
        } else if (element instanceof SOAPHeader) {
            this.processSOAPHeader((SOAPHeader)element, parentNode);
        } else if (element instanceof SOAPHeaderFault) {
            this.processSOAPHeaderFault((SOAPHeaderFault)element, parentNode);
        } else if (element instanceof SOAPOperation) {
            this.processSOAPOperation((SOAPOperation)element, parentNode);
        } else if (element instanceof MIMEMultipartRelated) {
            this.processMIMEMultipartRelated((MIMEMultipartRelated)element, parentNode);
        } else if (element instanceof MIMEContent) {
            this.processMIMEContent((MIMEContent)element, parentNode);
        } else if (element instanceof MIMEPart) {
            this.processMIMEPart((MIMEPart)element, parentNode);
        } else if (element instanceof MIMEMimeXml) {
            this.processMIMEMimeXml((MIMEMimeXml)element, parentNode);
        } else if (element instanceof HTTPAddress) {
            this.processHTTPAddress((HTTPAddress)element, parentNode);
        } else if (element instanceof HTTPBinding) {
            this.processHTTPBinding((HTTPBinding)element, parentNode);
        } else if (element instanceof HTTPOperation) {
            this.processHTTPOperation((HTTPOperation)element, parentNode);
        } else if (element instanceof HTTPUrlEncoded) {
            this.processHTTPUrlEncoded((HTTPUrlEncoded)element, parentNode);
        } else if (element instanceof HTTPUrlReplacement) {
            this.processHTTPUrlReplacement((HTTPUrlReplacement)element, parentNode);
        } else {
            this.processUnknownExtensionElement(element, parentNode);
        }
    }

    protected void processHTTPAddress(HTTPAddress element, Node parentNode) throws Exception {
        Node addressNode = parentNode.addNode("wsdl:httpAddress", "wsdl:httpAddress");
        addressNode.setProperty("wsdl:location", element.getLocationURI());
    }

    protected void processHTTPBinding(HTTPBinding element, Node parentNode) throws Exception {
        Node bindingNode = parentNode.addNode("wsdl:httpBinding", "wsdl:httpBinding");
        bindingNode.setProperty("wsdl:verb", element.getVerb());
    }

    protected void processHTTPOperation(HTTPOperation element, Node parentNode) throws Exception {
        Node operationNode = parentNode.addNode("wsdl:httpOperation", "wsdl:httpOperation");
        operationNode.setProperty("wsdl:location", element.getLocationURI());
    }

    protected void processHTTPUrlEncoded(HTTPUrlEncoded element, Node parentNode) throws Exception {
        parentNode.addNode("wsdl:httpUrlEncoded", "wsdl:httpUrlEncoded");
    }

    protected void processHTTPUrlReplacement(HTTPUrlReplacement element, Node parentNode) throws Exception {
        parentNode.addNode("wsdl:httpUrlReplacement", "wsdl:httpUrlReplacement");
    }

    protected void processSOAP12Address(SOAP12Address element, Node parentNode) throws Exception {
        Node addressNode = parentNode.addNode("wsdl:soapAddress", "wsdl:soapAddress");
        addressNode.setProperty("wsdl:soapLocation", element.getLocationURI());
    }

    protected void processSOAP12Binding(SOAP12Binding element, Node parentNode) throws Exception {
        Node bindingNode = parentNode.addNode("wsdl:soapBinding", "wsdl:soapBinding");
        bindingNode.setProperty("wsdl:style", element.getStyle());
        bindingNode.setProperty("wsdl:transport", element.getTransportURI());
    }

    protected void processSOAP12Operation(SOAP12Operation element, Node parentNode) throws Exception {
        Node operationNode = parentNode.addNode("wsdl:soapOperation", "wsdl:soapOperation");
        operationNode.setProperty("wsdl:style", element.getStyle());
        operationNode.setProperty("wsdl:soapAction", element.getSoapActionURI());
    }

    protected void processSOAP12Body(SOAP12Body element, Node parentNode) throws Exception {
        Node bodyNode = parentNode.addNode("wsdl:soapBody", "wsdl:soapBody");
        bodyNode.setProperty("wsdl:encodingStyle", element.getEncodingStyle());
        bodyNode.setProperty("wsdl:parts", this.listToStringArray(element.getParts()));
        bodyNode.setProperty("wsdl:use", element.getUse());
    }

    protected void processSOAP12Fault(SOAP12Fault element, Node parentNode) throws Exception {
        Node faultNode = parentNode.addNode("wsdl:soapFault", "wsdl:soapFault");
        faultNode.setProperty("wsdl:encodingStyle", element.getEncodingStyle());
        faultNode.setProperty("wsdl:use", element.getUse());
    }

    protected void processSOAP12Header(SOAP12Header element, Node parentNode) throws Exception {
        Node headerNode = parentNode.addNode("wsdl:soapHeader", "wsdl:soapHeader");
        headerNode.setProperty("wsdl:encodingStyle", element.getEncodingStyle());
        headerNode.setProperty("wsdl:message", element.getMessage().toString());
        headerNode.setProperty("wsdl:part", element.getPart());
        headerNode.setProperty("wsdl:use", element.getUse());
        for (SOAP12HeaderFault fault : element.getSOAP12HeaderFaults()) {
            this.processSOAP12HeaderFault(fault, headerNode);
        }
    }

    protected void processSOAP12HeaderFault(SOAP12HeaderFault element, Node parentNode) throws Exception {
        Node faultNode = parentNode.addNode("wsdl:soapHeaderFault", "wsdl:soapHeaderFault");
        faultNode.setProperty("wsdl:encodingStyle", element.getEncodingStyle());
        faultNode.setProperty("wsdl:use", element.getUse());
    }

    protected void processSOAPAddress(SOAPAddress element, Node parentNode) throws Exception {
        Node addressNode = parentNode.addNode("wsdl:soapAddress", "wsdl:soapAddress");
        addressNode.setProperty("wsdl:soapLocation", element.getLocationURI());
    }

    protected void processSOAPBinding(SOAPBinding element, Node parentNode) throws Exception {
        Node bindingNode = parentNode.addNode("wsdl:soapBinding", "wsdl:soapBinding");
        bindingNode.setProperty("wsdl:style", element.getStyle());
        bindingNode.setProperty("wsdl:transport", element.getTransportURI());
    }

    protected void processSOAPOperation(SOAPOperation element, Node parentNode) throws Exception {
        Node operationNode = parentNode.addNode("wsdl:soapOperation", "wsdl:soapOperation");
        operationNode.setProperty("wsdl:style", element.getStyle());
        operationNode.setProperty("wsdl:soapAction", element.getSoapActionURI());
    }

    protected void processSOAPBody(SOAPBody element, Node parentNode) throws Exception {
        Node bodyNode = parentNode.addNode("wsdl:soapBody", "wsdl:soapBody");
        bodyNode.setProperty("wsdl:encodingStyle", this.listToStringArray(element.getEncodingStyles()));
        bodyNode.setProperty("wsdl:parts", this.listToStringArray(element.getParts()));
        bodyNode.setProperty("wsdl:use", element.getUse());
    }

    protected void processSOAPFault(SOAPFault element, Node parentNode) throws Exception {
        Node faultNode = parentNode.addNode("wsdl:soapFault", "wsdl:soapFault");
        faultNode.setProperty("wsdl:encodingStyle", this.listToStringArray(element.getEncodingStyles()));
        faultNode.setProperty("wsdl:use", element.getUse());
    }

    protected void processSOAPHeader(SOAPHeader element, Node parentNode) throws Exception {
        Node headerNode = parentNode.addNode("wsdl:soapHeader", "wsdl:soapHeader");
        headerNode.setProperty("wsdl:encodingStyle", this.listToStringArray(element.getEncodingStyles()));
        headerNode.setProperty("wsdl:message", element.getMessage().toString());
        headerNode.setProperty("wsdl:part", element.getPart());
        headerNode.setProperty("wsdl:use", element.getUse());
        for (SOAPHeaderFault fault : element.getSOAPHeaderFaults()) {
            this.processSOAPHeaderFault(fault, headerNode);
        }
    }

    protected void processSOAPHeaderFault(SOAPHeaderFault element, Node parentNode) throws Exception {
        Node faultNode = parentNode.addNode("wsdl:soapHeaderFault", "wsdl:soapHeaderFault");
        faultNode.setProperty("wsdl:encodingStyle", this.listToStringArray(element.getEncodingStyles()));
        faultNode.setProperty("wsdl:use", element.getUse());
    }

    protected void processMIMEMultipartRelated(MIMEMultipartRelated element, Node parentNode) throws Exception {
        Node mimeMultipartNode = parentNode.addNode("wsdl:mimeMultipartRelated", "wsdl:mimeMultipartRelated");
        for (MIMEPart part : element.getMIMEParts()) {
            this.processMIMEPart(part, mimeMultipartNode);
        }
    }

    protected void processMIMEPart(MIMEPart element, Node parentNode) throws Exception {
        Node mimePartNode = parentNode.addNode("wsdl:mimePart", "wsdl:mimePart");
        for (ExtensibilityElement child : element.getExtensibilityElements()) {
            this.processExtensibilityElement(child, mimePartNode);
        }
    }

    protected void processMIMEContent(MIMEContent element, Node parentNode) throws Exception {
        Node mimeContentNode = parentNode.addNode("wsdl:mimeContent", "wsdl:mimeContent");
        mimeContentNode.setProperty("wsdl:mimePart", element.getPart());
        mimeContentNode.setProperty("wsdl:mimeType", element.getType());
    }

    protected void processMIMEMimeXml(MIMEMimeXml element, Node parentNode) throws Exception {
        Node mimeXmlNode = parentNode.addNode("wsdl:mimeXml", "wsdl:mimeXml");
        mimeXmlNode.setProperty("wsdl:mimePart", element.getPart());
    }

    protected void processUnknownExtensionElement(ExtensibilityElement element, Node parentNode) throws Exception {
        this.logger.debug("Unknown extension element: {0}", new Object[]{element});
    }

    protected void setReferenceable(Node node, SymbolSpace space, QName qname) throws RepositoryException {
        this.setReferenceable(node, space, qname.getNamespaceURI(), qname.getLocalPart());
    }

    protected void setReferenceable(Node node, SymbolSpace space, String namespace, String name) throws RepositoryException {
        this.registerForSymbolSpace(space, namespace, name, node.getIdentifier());
    }

    protected void setReference(Node node, String propertyName, SymbolSpace space, QName name) throws RepositoryException {
        this.setReference(node, propertyName, space, name.getNamespaceURI(), name.getLocalPart());
    }

    protected String writeXml(org.w3c.dom.Node xmlNode) throws TransformerFactoryConfigurationError, TransformerException {
        DOMSource source = new DOMSource(xmlNode);
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        Transformer xformer = TransformerFactory.newInstance().newTransformer();
        xformer.transform(source, result);
        return writer.toString();
    }

    protected Node addChildNode(Node parentNode, QName qname, String primaryType) throws RepositoryException {
        String localName = qname.getLocalPart();
        String namespace = qname.getNamespaceURI();
        Node childNode = parentNode.addNode(this.context.valueFactory().createName(localName), primaryType);
        childNode.setProperty("wsdl:ncName", localName);
        childNode.setProperty("wsdl:namespace", namespace);
        return childNode;
    }

    protected String uuidForComponent(WSDLElement component) {
        String uuid = this.uuidForComponent.get(component);
        if (uuid == null) {
            uuid = UUID.randomUUID().toString();
            this.uuidForComponent.put(component, uuid);
        }
        return uuid;
    }

    private String[] listToStringArray(List<?> list) {
        if (list == null) {
            return null;
        }
        String[] result = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            result[i] = list.get(i).toString();
        }
        return result;
    }

    protected class CustomWSDLLocator
    implements WSDLLocator {
        protected final InputSource baseInputSource;
        protected final InputSource emptyInputSource;
        protected final String baseUri;

        protected CustomWSDLLocator(InputSource baseInputSource, String baseUri) {
            this.baseInputSource = baseInputSource;
            this.emptyInputSource = new InputSource(new StringReader(""));
            this.baseUri = baseUri;
        }

        public String getLatestImportURI() {
            return this.baseUri;
        }

        public InputSource getImportInputSource(String parentLocation, String importLocation) {
            return this.emptyInputSource;
        }

        public String getBaseURI() {
            return this.baseUri;
        }

        public InputSource getBaseInputSource() {
            return this.baseInputSource;
        }

        public void close() {
        }
    }

    protected class PortTypeResolvers {
        private final Map<QName, NamespaceEntityResolver> resolversByKind = new HashMap<QName, NamespaceEntityResolver>();

        protected PortTypeResolvers() {
        }

        public NamespaceEntityResolver get(QName portTypeName) {
            NamespaceEntityResolver resolver = this.resolversByKind.get(portTypeName);
            if (resolver == null) {
                resolver = new NamespaceEntityResolver();
                this.resolversByKind.put(portTypeName, resolver);
            }
            return resolver;
        }
    }
}

