/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.embedded;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Random;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.solr.servlet.SolrDispatchFilter;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.SessionIdManager;
import org.mortbay.jetty.bio.SocketConnector;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.FilterHolder;
import org.mortbay.jetty.servlet.HashSessionIdManager;

public class JettySolrRunner {
    Server server;
    FilterHolder dispatchFilter;
    String context;

    public JettySolrRunner(String context, int port) {
        this.init(context, port);
    }

    public JettySolrRunner(String context, int port, String solrConfigFilename) {
        this.init(context, port);
        if (solrConfigFilename != null) {
            this.dispatchFilter.setInitParameter("solrconfig-filename", solrConfigFilename);
        }
    }

    private void init(String context, int port) {
        this.context = context;
        this.server = new Server(port);
        if (System.getProperty("jetty.testMode") != null) {
            SocketConnector connector = new SocketConnector();
            connector.setPort(port);
            connector.setReuseAddress(true);
            this.server.setConnectors(new Connector[]{connector});
            this.server.setSessionIdManager((SessionIdManager)new HashSessionIdManager(new Random()));
        }
        this.server.setStopAtShutdown(true);
        Context root = new Context((HandlerContainer)this.server, context, 1);
        root.addServlet(Servlet404.class, "/*");
        this.dispatchFilter = root.addFilter(SolrDispatchFilter.class, "*", 1);
    }

    public void start() throws Exception {
        this.start(true);
    }

    public void start(boolean waitForSolr) throws Exception {
        if (!this.server.isRunning()) {
            this.server.start();
        }
        if (waitForSolr) {
            this.waitForSolr(this.context);
        }
    }

    public void stop() throws Exception {
        if (this.server.isRunning()) {
            this.server.stop();
            this.server.join();
        }
    }

    public void waitForSolr(String context) throws Exception {
        int port = this.getLocalPort();
        URL url = new URL("http://localhost:" + port + context + "/select?q={!raw+f=junit_test_query}ping");
        IOException ex = null;
        for (int i = 0; i < 600; ++i) {
            try {
                InputStream stream = url.openStream();
                stream.close();
            }
            catch (IOException e) {
                ex = e;
                Thread.sleep(200L);
                continue;
            }
            return;
        }
        throw new RuntimeException("Jetty/Solr unresponsive", ex);
    }

    public int getLocalPort() {
        Connector[] conns = this.server.getConnectors();
        if (0 == conns.length) {
            throw new RuntimeException("Jetty Server has no Connectors");
        }
        return conns[0].getLocalPort();
    }

    public static void main(String[] args) {
        try {
            JettySolrRunner jetty = new JettySolrRunner("/solr", 3456);
            jetty.start();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static class Servlet404
    extends HttpServlet {
        public void service(HttpServletRequest req, HttpServletResponse res) throws IOException {
            res.sendError(404, "Can not find: " + req.getRequestURI());
        }
    }
}

