/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.txn;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.cache.SessionEnvironment;
import org.modeshape.jcr.cache.change.ChangeSet;
import org.modeshape.jcr.cache.document.TransactionalWorkspaceCache;
import org.modeshape.jcr.cache.document.WorkspaceCache;
import org.modeshape.jcr.txn.Transactions;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.Path;
import org.modeshape.jcr.value.Property;

public final class SynchronizedTransactions
extends Transactions {
    protected static final Set<String> ACTIVE_TRACE_SYNCHRONIZATIONS = new HashSet<String>();

    public SynchronizedTransactions(SessionEnvironment.MonitorFactory monitorFactory, TransactionManager txnMgr) {
        super(monitorFactory, txnMgr);
        assert (txnMgr != null);
    }

    @Override
    public Transactions.Transaction begin() throws NotSupportedException, SystemException {
        Transaction txn = this.txnMgr.getTransaction();
        Transactions.BaseTransaction result = null;
        if (txn == null) {
            this.txnMgr.begin();
            result = new Transactions.SimpleTransaction(this, this.txnMgr);
        } else {
            try {
                result = new SynchronizedTransaction(this.txnMgr);
            }
            catch (RollbackException e) {
                return new RollbackOnlyTransaction();
            }
        }
        if (this.logger.isTraceEnabled()) {
            if (txn == null) {
                txn = this.txnMgr.getTransaction();
            }
            assert (txn != null);
            String id = txn.toString();
            if (!ACTIVE_TRACE_SYNCHRONIZATIONS.contains(id)) {
                if (result instanceof SynchronizedTransaction) {
                    this.logger.trace("Found user transaction {0}", new Object[]{txn});
                } else {
                    this.logger.trace("Begin transaction {0}", new Object[]{id});
                }
                try {
                    txn.registerSynchronization((Synchronization)new TransactionTracer(id));
                }
                catch (RollbackException e) {
                    return new RollbackOnlyTransaction();
                }
            } else {
                this.logger.trace("Tracer already registered for transaction {0}", new Object[]{id});
            }
        }
        return result;
    }

    @Override
    public void updateCache(WorkspaceCache workspace, ChangeSet changes, Transactions.Transaction transaction) {
        if (changes != null && !changes.isEmpty()) {
            if (transaction instanceof SynchronizedTransaction) {
                SynchronizedTransaction synched = (SynchronizedTransaction)transaction;
                synched.addUpdate(new WorkspaceUpdates(workspace, changes));
                if (workspace instanceof TransactionalWorkspaceCache) {
                    ((TransactionalWorkspaceCache)workspace).changedWithinTransaction(changes);
                }
            } else if (!(transaction instanceof RollbackOnlyTransaction)) {
                workspace.changed(changes);
            }
        }
    }

    protected final class TransactionTracer
    implements Synchronization {
        private String txnId;

        protected TransactionTracer(String id) {
            this.txnId = id;
            ACTIVE_TRACE_SYNCHRONIZATIONS.add(id);
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int status) {
            ACTIVE_TRACE_SYNCHRONIZATIONS.remove(this.txnId);
            switch (status) {
                case 3: {
                    SynchronizedTransactions.this.logger.trace("Commit transaction '{0}'", new Object[]{this.txnId});
                    break;
                }
                case 4: {
                    SynchronizedTransactions.this.logger.trace("Roll back transaction '{0}'", new Object[]{this.txnId});
                    break;
                }
            }
        }
    }

    protected static final class SynchronizedMonitor
    implements SessionEnvironment.Monitor {
        private final SessionEnvironment.Monitor delegate;
        private final AtomicLong changesCount;

        protected SynchronizedMonitor(SessionEnvironment.Monitor delegate) {
            this.delegate = delegate;
            this.changesCount = new AtomicLong(0L);
        }

        @Override
        public void recordAdd(String workspace, NodeKey key, Path path, Name primaryType, Set<Name> mixinTypes, Iterator<Property> propertiesIterator) {
            this.delegate.recordAdd(workspace, key, path, primaryType, mixinTypes, propertiesIterator);
        }

        @Override
        public void recordUpdate(String workspace, NodeKey key, Path path, Name primaryType, Set<Name> mixinTypes, Iterator<Property> properties) {
            this.delegate.recordUpdate(workspace, key, path, primaryType, mixinTypes, properties);
        }

        @Override
        public void recordRemove(String workspace, Iterable<NodeKey> keys) {
            this.delegate.recordRemove(workspace, keys);
        }

        @Override
        public void recordChanged(long changedNodesCount) {
            this.changesCount.getAndAdd(changedNodesCount);
        }

        protected void dispatchRecordedChanges() {
            this.delegate.recordChanged(this.changesCount.get());
        }
    }

    protected static final class WorkspaceUpdates {
        private final WorkspaceCache workspace;
        private final ChangeSet changes;

        protected WorkspaceUpdates(WorkspaceCache workspace, ChangeSet changes) {
            this.workspace = workspace;
            this.changes = changes;
        }

        protected void apply() {
            this.workspace.changed(this.changes);
        }
    }

    protected class RollbackOnlyTransaction
    implements Transactions.Transaction {
        @Override
        public SessionEnvironment.Monitor createMonitor() {
            return SynchronizedTransactions.this.newMonitor();
        }

        @Override
        public void commit() {
        }

        @Override
        public void rollback() {
        }

        @Override
        public void uponCompletion(Transactions.TransactionFunction function) {
        }
    }

    protected class SynchronizedTransaction
    extends Transactions.BaseTransaction {
        private final Synchronization synchronization;
        private final List<WorkspaceUpdates> updates;
        private final SynchronizedMonitor monitor;
        private boolean finished;

        protected SynchronizedTransaction(TransactionManager txnMgr) throws SystemException, RollbackException {
            super(SynchronizedTransactions.this, txnMgr);
            this.updates = new LinkedList<WorkspaceUpdates>();
            this.finished = false;
            this.synchronization = new Synchronization(){

                public void beforeCompletion() {
                }

                public void afterCompletion(int status) {
                    switch (status) {
                        case 3: {
                            SynchronizedTransaction.this.afterCommit();
                            break;
                        }
                        case 4: {
                            break;
                        }
                    }
                }
            };
            this.monitor = new SynchronizedMonitor(SynchronizedTransactions.this.newMonitor());
            txnMgr.getTransaction().registerSynchronization(this.synchronization);
        }

        protected void addUpdate(WorkspaceUpdates updates) {
            assert (updates != null);
            assert (!this.finished);
            this.updates.add(updates);
        }

        @Override
        public void commit() {
        }

        @Override
        public void rollback() {
        }

        protected void afterCommit() {
            this.executeFunctions();
            this.monitor.dispatchRecordedChanges();
            for (WorkspaceUpdates update : this.updates) {
                update.apply();
            }
            this.finished = true;
        }

        @Override
        public SessionEnvironment.Monitor createMonitor() {
            return this.monitor;
        }
    }
}

