/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.javafile;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.modeshape.common.util.CheckArg;
import org.modeshape.sequencer.javafile.JavaMetadataUtil;
import org.modeshape.sequencer.javafile.metadata.AnnotationMetadata;
import org.modeshape.sequencer.javafile.metadata.EnumMetadata;
import org.modeshape.sequencer.javafile.metadata.FieldMetadata;
import org.modeshape.sequencer.javafile.metadata.ImportMetadata;
import org.modeshape.sequencer.javafile.metadata.MethodMetadata;
import org.modeshape.sequencer.javafile.metadata.ModifierMetadata;
import org.modeshape.sequencer.javafile.metadata.PackageMetadata;
import org.modeshape.sequencer.javafile.metadata.TypeMetadata;
import org.modeshape.sequencer.javafile.metadata.Variable;

public abstract class AbstractJavaMetadata {
    protected List<ImportMetadata> createImportMetadata(CompilationUnit unit) {
        ArrayList<ImportMetadata> metadata = new ArrayList<ImportMetadata>();
        List imports = unit.imports();
        if (!imports.isEmpty()) {
            for (ImportDeclaration importDeclaration : imports) {
                if (importDeclaration.isOnDemand()) {
                    metadata.add(ImportMetadata.onDemand(JavaMetadataUtil.getName(importDeclaration.getName())));
                    continue;
                }
                metadata.add(ImportMetadata.single(JavaMetadataUtil.getName(importDeclaration.getName())));
            }
        }
        return metadata;
    }

    protected PackageMetadata createPackageMetadata(CompilationUnit unit) {
        PackageMetadata packageMetadata = null;
        List annotations = null;
        PackageDeclaration packageDeclaration = unit.getPackage();
        if (packageDeclaration != null) {
            annotations = packageDeclaration.annotations();
            packageMetadata = new PackageMetadata(JavaMetadataUtil.getName(unit.getPackage().getName()));
            if (!annotations.isEmpty()) {
                for (Object object : annotations) {
                    packageMetadata.getAnnotations().add(this.createAnnotationMetadataFor((Annotation)object));
                }
            }
        }
        return packageMetadata;
    }

    protected AnnotationMetadata createAnnotationMetadataFor(Annotation annotation) {
        if (annotation instanceof NormalAnnotation) {
            NormalAnnotation normalAnnotation = (NormalAnnotation)annotation;
            LinkedHashMap<String, String> memberValues = new LinkedHashMap<String, String>();
            List values = normalAnnotation.values();
            for (MemberValuePair pair : values) {
                memberValues.put(pair.getName().getIdentifier(), JavaMetadataUtil.expressionString(pair.getValue()));
            }
            return AnnotationMetadata.normalAnnotation(JavaMetadataUtil.getName(normalAnnotation.getTypeName()), memberValues);
        }
        if (annotation instanceof MarkerAnnotation) {
            MarkerAnnotation markerAnnotation = (MarkerAnnotation)annotation;
            return AnnotationMetadata.markerAnnotation(JavaMetadataUtil.getName(markerAnnotation.getTypeName()));
        }
        if (annotation instanceof SingleMemberAnnotation) {
            SingleMemberAnnotation singleMemberAnnotation = (SingleMemberAnnotation)annotation;
            return AnnotationMetadata.singleMemberAnnotation(JavaMetadataUtil.getName(singleMemberAnnotation.getTypeName()), JavaMetadataUtil.expressionString(singleMemberAnnotation.getValue()));
        }
        return null;
    }

    protected List<TypeMetadata> createTypeMetadata(CompilationUnit unit) {
        ArrayList<TypeMetadata> metadata = new ArrayList<TypeMetadata>();
        List topLevelType = unit.types();
        for (AbstractTypeDeclaration abstractTypeDeclaration : topLevelType) {
            if (abstractTypeDeclaration instanceof TypeDeclaration) {
                TypeDeclaration typeDeclaration = (TypeDeclaration)abstractTypeDeclaration;
                if (typeDeclaration.isInterface()) {
                    TypeMetadata interfaceMetadata = TypeMetadata.interfaceType(JavaMetadataUtil.getName((Name)typeDeclaration.getName()));
                    for (Type superInterfaceType : typeDeclaration.superInterfaceTypes()) {
                        interfaceMetadata.getInterfaceNames().add(this.getTypeName(superInterfaceType));
                    }
                    metadata.add(interfaceMetadata);
                } else {
                    MethodDeclaration[] methodDeclarations;
                    FieldDeclaration[] fieldDeclarations;
                    TypeMetadata classMetadata = TypeMetadata.classType(JavaMetadataUtil.getName((Name)typeDeclaration.getName()));
                    this.processModifiersOfTypeDeclaration((AbstractTypeDeclaration)typeDeclaration, classMetadata);
                    Type superClassType = typeDeclaration.getSuperclassType();
                    if (superClassType != null) {
                        classMetadata.setSuperTypeName(this.getTypeName(superClassType));
                    }
                    for (Type superInterfaceType : typeDeclaration.superInterfaceTypes()) {
                        classMetadata.getInterfaceNames().add(this.getTypeName(superInterfaceType));
                    }
                    for (FieldDeclaration fieldDeclaration : fieldDeclarations = typeDeclaration.getFields()) {
                        FieldMetadata fieldMetadata = this.getFieldMetadataFrom(fieldDeclaration);
                        classMetadata.getFields().add(fieldMetadata);
                    }
                    for (MethodDeclaration methodDeclaration : methodDeclarations = typeDeclaration.getMethods()) {
                        MethodMetadata methodMetadata = this.getMethodMetadataFrom(methodDeclaration);
                        classMetadata.getMethods().add(methodMetadata);
                    }
                    metadata.add(classMetadata);
                }
            }
            if (abstractTypeDeclaration instanceof EnumDeclaration) {
                EnumDeclaration enumDeclaration = (EnumDeclaration)abstractTypeDeclaration;
                EnumMetadata enumMetadata = TypeMetadata.enumType(JavaMetadataUtil.getName((Name)enumDeclaration.getName()));
                this.processModifiersOfTypeDeclaration((AbstractTypeDeclaration)enumDeclaration, enumMetadata);
                List enumValues = enumDeclaration.enumConstants();
                for (EnumConstantDeclaration enumValue : enumValues) {
                    enumMetadata.getValues().add(enumValue.getName().getIdentifier());
                }
                for (Type superInterfaceType : enumDeclaration.superInterfaceTypes()) {
                    enumMetadata.getInterfaceNames().add(this.getTypeName(superInterfaceType));
                }
                List bodyDecls = enumDeclaration.bodyDeclarations();
                for (BodyDeclaration bodyDecl : bodyDecls) {
                    if (bodyDecl instanceof FieldDeclaration) {
                        FieldMetadata fieldMetadata = this.getFieldMetadataFrom((FieldDeclaration)bodyDecl);
                        enumMetadata.getFields().add(fieldMetadata);
                        continue;
                    }
                    if (!(bodyDecl instanceof MethodDeclaration)) continue;
                    MethodMetadata methodMetadata = this.getMethodMetadataFrom((MethodDeclaration)bodyDecl);
                    enumMetadata.getMethods().add(methodMetadata);
                }
                metadata.add(enumMetadata);
            }
            if (!(abstractTypeDeclaration instanceof AnnotationTypeDeclaration)) continue;
        }
        return metadata;
    }

    protected void processModifiersOfTypeDeclaration(AbstractTypeDeclaration typeDeclaration, TypeMetadata classMetadata) {
        List modifiers = typeDeclaration.modifiers();
        for (IExtendedModifier extendedModifier : modifiers) {
            if (extendedModifier.isAnnotation()) {
                if (!(extendedModifier instanceof MarkerAnnotation)) continue;
                MarkerAnnotation marker = (MarkerAnnotation)extendedModifier;
                classMetadata.getAnnotations().add(AnnotationMetadata.markerAnnotation(JavaMetadataUtil.getName(marker.getTypeName())));
                continue;
            }
            Modifier modifier = (Modifier)extendedModifier;
            classMetadata.getModifiers().add(new ModifierMetadata(modifier.getKeyword().toString()));
        }
    }

    protected MethodMetadata getMethodMetadataFrom(MethodDeclaration methodDeclaration) {
        if (methodDeclaration != null) {
            if (methodDeclaration.isConstructor()) {
                return this.getConstructorMetadataFrom(methodDeclaration);
            }
            return this.getMethodTypeMemberMetadataFrom(methodDeclaration);
        }
        return null;
    }

    protected MethodMetadata getMethodTypeMemberMetadataFrom(MethodDeclaration methodDeclaration) {
        MethodMetadata methodTypeMemberMetadata = MethodMetadata.methodMemberType(JavaMetadataUtil.getName((Name)methodDeclaration.getName()));
        this.processReturnTypeOfMethodDeclaration(methodDeclaration, methodTypeMemberMetadata);
        this.processModifiersOfMethodDeclaration(methodDeclaration, methodTypeMemberMetadata);
        this.processParametersOfMethodDeclaration(methodDeclaration, methodTypeMemberMetadata);
        List params = methodDeclaration.parameters();
        for (SingleVariableDeclaration singleVariableDeclaration : params) {
            singleVariableDeclaration.getName();
        }
        return methodTypeMemberMetadata;
    }

    protected void processReturnTypeOfMethodDeclaration(MethodDeclaration methodDeclaration, MethodMetadata methodMetadata) {
        Type type = methodDeclaration.getReturnType2();
        if (type.isPrimitiveType()) {
            methodMetadata.setReturnType(FieldMetadata.primitiveType(((PrimitiveType)type).getPrimitiveTypeCode().toString()));
        }
        if (type.isSimpleType()) {
            methodMetadata.setReturnType(FieldMetadata.simpleType(JavaMetadataUtil.getName(((SimpleType)type).getName())));
        }
    }

    protected void processParametersOfMethodDeclaration(MethodDeclaration methodDeclaration, MethodMetadata methodMetadata) {
        for (SingleVariableDeclaration singleVariableDeclaration : methodDeclaration.parameters()) {
            Type type = singleVariableDeclaration.getType();
            if (type.isPrimitiveType()) {
                FieldMetadata primitiveFieldMetadata = this.processVariableDeclaration(singleVariableDeclaration, type);
                methodMetadata.getParameters().add(primitiveFieldMetadata);
            }
            if (type.isParameterizedType()) {
                FieldMetadata parameterizedTypeFieldMetadata = this.processVariableDeclaration(singleVariableDeclaration, type);
                methodMetadata.getParameters().add(parameterizedTypeFieldMetadata);
            }
            if (type.isQualifiedType()) {
                // empty if block
            }
            if (type.isSimpleType()) {
                FieldMetadata simpleTypeFieldMetadata = this.processVariableDeclaration(singleVariableDeclaration, type);
                methodMetadata.getParameters().add(simpleTypeFieldMetadata);
            }
            if (type.isArrayType()) {
                FieldMetadata arrayTypeFieldMetadata = this.processVariableDeclaration(singleVariableDeclaration, type);
                methodMetadata.getParameters().add(arrayTypeFieldMetadata);
            }
            if (!type.isWildcardType()) continue;
        }
    }

    private FieldMetadata processVariableDeclaration(SingleVariableDeclaration singleVariableDeclaration, Type type) {
        if (type.isPrimitiveType()) {
            FieldMetadata primitiveFieldMetadata = FieldMetadata.primitiveType(((PrimitiveType)type).getPrimitiveTypeCode().toString());
            Variable variable = new Variable();
            variable.setName(JavaMetadataUtil.getName((Name)singleVariableDeclaration.getName()));
            primitiveFieldMetadata.setName(variable.getName());
            primitiveFieldMetadata.getVariables().add(variable);
            for (IExtendedModifier extendedModifier : singleVariableDeclaration.modifiers()) {
                if (extendedModifier.isAnnotation()) {
                    primitiveFieldMetadata.getAnnotations().add(this.createAnnotationMetadataFor((Annotation)extendedModifier));
                    continue;
                }
                Modifier modifier = (Modifier)extendedModifier;
                primitiveFieldMetadata.getModifiers().add(new ModifierMetadata(modifier.getKeyword().toString()));
            }
            return primitiveFieldMetadata;
        }
        if (type.isSimpleType()) {
            SimpleType simpleType = (SimpleType)type;
            FieldMetadata simpleTypeFieldMetadata = FieldMetadata.simpleType(JavaMetadataUtil.getName(simpleType.getName()));
            Variable variable = new Variable();
            variable.setName(JavaMetadataUtil.getName((Name)singleVariableDeclaration.getName()));
            simpleTypeFieldMetadata.setName(variable.getName());
            simpleTypeFieldMetadata.getVariables().add(variable);
            for (IExtendedModifier simpleTypeExtendedModifier : singleVariableDeclaration.modifiers()) {
                if (simpleTypeExtendedModifier.isAnnotation()) {
                    simpleTypeFieldMetadata.getAnnotations().add(this.createAnnotationMetadataFor((Annotation)simpleTypeExtendedModifier));
                    continue;
                }
                Modifier modifier = (Modifier)simpleTypeExtendedModifier;
                simpleTypeFieldMetadata.getModifiers().add(new ModifierMetadata(modifier.getKeyword().toString()));
            }
            return simpleTypeFieldMetadata;
        }
        if (type.isParameterizedType()) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            FieldMetadata parameterizedTypeFieldMetadata = FieldMetadata.parametrizedType(this.getTypeName((Type)parameterizedType));
            Variable variable = new Variable();
            variable.setName(JavaMetadataUtil.getName((Name)singleVariableDeclaration.getName()));
            parameterizedTypeFieldMetadata.setName(variable.getName());
            parameterizedTypeFieldMetadata.getVariables().add(variable);
            for (IExtendedModifier parameterizedExtendedModifier : singleVariableDeclaration.modifiers()) {
                if (parameterizedExtendedModifier.isAnnotation()) {
                    parameterizedTypeFieldMetadata.getAnnotations().add(this.createAnnotationMetadataFor((Annotation)parameterizedExtendedModifier));
                    continue;
                }
                Modifier modifier = (Modifier)parameterizedExtendedModifier;
                parameterizedTypeFieldMetadata.getModifiers().add(new ModifierMetadata(modifier.getKeyword().toString()));
            }
            return parameterizedTypeFieldMetadata;
        }
        if (type.isArrayType()) {
            ArrayType arrayType = (ArrayType)type;
            FieldMetadata arrayTypeFieldMetadata = FieldMetadata.arrayType(this.getTypeName((Type)arrayType));
            Variable variable = new Variable();
            variable.setName(JavaMetadataUtil.getName((Name)singleVariableDeclaration.getName()));
            arrayTypeFieldMetadata.setName(variable.getName());
            arrayTypeFieldMetadata.getVariables().add(variable);
            for (IExtendedModifier arrayTypeExtendedModifier : singleVariableDeclaration.modifiers()) {
                if (arrayTypeExtendedModifier.isAnnotation()) {
                    arrayTypeFieldMetadata.getAnnotations().add(this.createAnnotationMetadataFor((Annotation)arrayTypeExtendedModifier));
                    continue;
                }
                Modifier modifier = (Modifier)arrayTypeExtendedModifier;
                arrayTypeFieldMetadata.getModifiers().add(new ModifierMetadata(modifier.getKeyword().toString()));
            }
            return arrayTypeFieldMetadata;
        }
        return null;
    }

    private String getTypeName(Type type) {
        CheckArg.isNotNull((Object)type, (String)"type");
        if (type.isPrimitiveType()) {
            PrimitiveType primitiveType = (PrimitiveType)type;
            return primitiveType.getPrimitiveTypeCode().toString();
        }
        if (type.isSimpleType()) {
            SimpleType simpleType = (SimpleType)type;
            return JavaMetadataUtil.getName(simpleType.getName());
        }
        if (type.isParameterizedType()) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return this.getTypeName(parameterizedType.getType());
        }
        if (type.isArrayType()) {
            ArrayType arrayType = (ArrayType)type;
            Type elementType = arrayType.getElementType();
            if (elementType.isPrimitiveType()) {
                return ((PrimitiveType)elementType).getPrimitiveTypeCode().toString();
            }
            if (elementType.isSimpleType()) {
                return JavaMetadataUtil.getName(((SimpleType)elementType).getName());
            }
        }
        return null;
    }

    protected MethodMetadata getConstructorMetadataFrom(MethodDeclaration methodDeclaration) {
        MethodMetadata constructorMetadata = MethodMetadata.constructorType(JavaMetadataUtil.getName((Name)methodDeclaration.getName()));
        this.processModifiersOfMethodDeclaration(methodDeclaration, constructorMetadata);
        this.processParametersOfMethodDeclaration(methodDeclaration, constructorMetadata);
        return constructorMetadata;
    }

    protected FieldMetadata getFieldMetadataFrom(FieldDeclaration fieldDeclaration) {
        if (fieldDeclaration != null && fieldDeclaration.getType() != null && !fieldDeclaration.fragments().isEmpty()) {
            Type type = fieldDeclaration.getType();
            if (type.isPrimitiveType()) {
                return this.processPrimitiveType(fieldDeclaration);
            }
            if (type.isParameterizedType()) {
                return this.processParameterizedType(fieldDeclaration);
            }
            if (type.isSimpleType()) {
                return this.processSimpleType(fieldDeclaration);
            }
            if (type.isArrayType()) {
                return this.processArrayTypeFrom(fieldDeclaration);
            }
            if (type.isQualifiedType()) {
                // empty if block
            }
            if (type.isWildcardType()) {
                // empty if block
            }
        }
        return null;
    }

    protected FieldMetadata processArrayTypeFrom(FieldDeclaration fieldDeclaration) {
        ArrayType arrayType = (ArrayType)fieldDeclaration.getType();
        FieldMetadata arrayTypeFieldMetadata = null;
        Type type = arrayType.getElementType();
        if (type.isPrimitiveType()) {
            PrimitiveType primitiveType = (PrimitiveType)type;
            arrayTypeFieldMetadata = FieldMetadata.arrayType(primitiveType.getPrimitiveTypeCode().toString());
            this.processModifiersAndVariablesOfFieldDeclaration(fieldDeclaration, arrayTypeFieldMetadata);
            arrayTypeFieldMetadata.setName(this.getFieldName(fieldDeclaration));
            return arrayTypeFieldMetadata;
        }
        if (type.isSimpleType()) {
            SimpleType simpleType = (SimpleType)type;
            arrayTypeFieldMetadata = FieldMetadata.arrayType(JavaMetadataUtil.getName(simpleType.getName()));
            this.processModifiersAndVariablesOfFieldDeclaration(fieldDeclaration, arrayTypeFieldMetadata);
            arrayTypeFieldMetadata.setName(this.getFieldName(fieldDeclaration));
            return arrayTypeFieldMetadata;
        }
        return null;
    }

    private void processModifiersAndVariablesOfFieldDeclaration(FieldDeclaration fieldDeclaration, FieldMetadata arrayTypeFieldMetadata) {
        this.processModifiersOfFieldDeclaration(fieldDeclaration, arrayTypeFieldMetadata);
        this.processVariablesOfVariableDeclarationFragment(fieldDeclaration, arrayTypeFieldMetadata);
    }

    protected FieldMetadata processSimpleType(FieldDeclaration fieldDeclaration) {
        SimpleType simpleType = (SimpleType)fieldDeclaration.getType();
        FieldMetadata simpleTypeFieldMetadata = FieldMetadata.simpleType(JavaMetadataUtil.getName(simpleType.getName()));
        this.processModifiersOfFieldDeclaration(fieldDeclaration, simpleTypeFieldMetadata);
        this.processVariablesOfVariableDeclarationFragment(fieldDeclaration, simpleTypeFieldMetadata);
        simpleTypeFieldMetadata.setName(this.getFieldName(fieldDeclaration));
        return simpleTypeFieldMetadata;
    }

    protected FieldMetadata processParameterizedType(FieldDeclaration fieldDeclaration) {
        ParameterizedType parameterizedType = (ParameterizedType)fieldDeclaration.getType();
        Type typeOfParameterizedType = parameterizedType.getType();
        FieldMetadata referenceFieldMetadata = this.createParameterizedFieldMetadataFrom(typeOfParameterizedType);
        this.processModifiersOfFieldDeclaration(fieldDeclaration, referenceFieldMetadata);
        referenceFieldMetadata.setName(this.getFieldName(fieldDeclaration));
        this.processVariablesOfVariableDeclarationFragment(fieldDeclaration, referenceFieldMetadata);
        return referenceFieldMetadata;
    }

    protected String getFieldName(FieldDeclaration fieldDeclaration) {
        FieldVisitor visitor = new FieldVisitor();
        fieldDeclaration.accept((ASTVisitor)visitor);
        return visitor.name;
    }

    protected FieldMetadata processPrimitiveType(FieldDeclaration fieldDeclaration) {
        PrimitiveType primitiveType = (PrimitiveType)fieldDeclaration.getType();
        FieldMetadata primitiveFieldMetadata = FieldMetadata.primitiveType(primitiveType.getPrimitiveTypeCode().toString());
        primitiveFieldMetadata.setName(this.getFieldName(fieldDeclaration));
        this.processModifiersOfFieldDeclaration(fieldDeclaration, primitiveFieldMetadata);
        this.processVariablesOfVariableDeclarationFragment(fieldDeclaration, primitiveFieldMetadata);
        return primitiveFieldMetadata;
    }

    protected void processModifiersOfFieldDeclaration(FieldDeclaration fieldDeclaration, FieldMetadata fieldMetadata) {
        List extendedModifiers = fieldDeclaration.modifiers();
        for (IExtendedModifier extendedModifier : extendedModifiers) {
            if (extendedModifier.isAnnotation()) {
                Annotation annotation = (Annotation)extendedModifier;
                fieldMetadata.getAnnotations().add(this.createAnnotationMetadataFor(annotation));
                continue;
            }
            Modifier modifier = (Modifier)extendedModifier;
            ModifierMetadata modifierMetadata = new ModifierMetadata(modifier.getKeyword().toString());
            fieldMetadata.getModifiers().add(modifierMetadata);
        }
    }

    protected void processModifiersOfMethodDeclaration(MethodDeclaration methodDeclaration, MethodMetadata methodMetadata) {
        List extendedModifiers = methodDeclaration.modifiers();
        for (IExtendedModifier extendedModifier : extendedModifiers) {
            if (extendedModifier.isAnnotation()) {
                Annotation annotation = (Annotation)extendedModifier;
                methodMetadata.getAnnotations().add(this.createAnnotationMetadataFor(annotation));
                continue;
            }
            Modifier modifier = (Modifier)extendedModifier;
            methodMetadata.getModifiers().add(new ModifierMetadata(modifier.getKeyword().toString()));
        }
    }

    protected FieldMetadata createParameterizedFieldMetadataFrom(Type type) {
        FieldMetadata parameterizedTypeFieldMetadata = null;
        if (type.isSimpleType()) {
            SimpleType simpleType = (SimpleType)type;
            parameterizedTypeFieldMetadata = FieldMetadata.parametrizedType(JavaMetadataUtil.getName(simpleType.getName()));
        }
        return parameterizedTypeFieldMetadata;
    }

    protected void processVariablesOfVariableDeclarationFragment(FieldDeclaration fieldDeclaration, FieldMetadata fieldMetadata) {
        List fragments = fieldDeclaration.fragments();
        for (VariableDeclarationFragment fragment : fragments) {
            fieldMetadata.getVariables().add(new Variable(JavaMetadataUtil.getName((Name)fragment.getName())));
        }
    }

    class FieldVisitor
    extends ASTVisitor {
        String name;

        FieldVisitor() {
        }

        public boolean visit(VariableDeclarationFragment node) {
            this.name = node.getName().getFullyQualifiedName();
            return super.visit(node);
        }
    }
}

