/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.git;

import org.modeshape.common.annotation.Immutable;

@Immutable
public final class CallSpecification {
    protected static final String DELIMITER_STR = "/";
    protected static final char DELIMITER = "/".charAt(0);
    private final String id;
    private final String[] parts;
    private final int numParts;
    private final int parameterCount;

    public CallSpecification(String id) {
        this.id = id;
        String relative = id.replaceFirst("^[/]", "");
        this.parts = relative.split(DELIMITER_STR);
        this.numParts = this.parts.length;
        this.parameterCount = this.numParts - 1;
        assert (this.numParts > 0);
    }

    public String getFunctionName() {
        return this.parts[0];
    }

    public String getId() {
        return this.id;
    }

    public int parameterCount() {
        return this.parameterCount;
    }

    public String parameter(int index) {
        return this.parts[index + 1];
    }

    public String parametersAsPath(int fromIndex) {
        return this.parametersAsPath(fromIndex, this.numParts);
    }

    public String parametersAsPath(int fromIndex, int toIndex) {
        assert (++fromIndex < this.numParts);
        assert (toIndex <= this.numParts);
        StringBuilder sb = new StringBuilder();
        for (int i = fromIndex; i != toIndex; ++i) {
            sb.append(DELIMITER);
            sb.append(this.parts[i]);
        }
        return sb.toString();
    }

    public String lastParameter() {
        if (this.numParts == 0) {
            return null;
        }
        return this.parts[this.numParts - 1];
    }

    public String childId(String childPart) {
        return this.id + DELIMITER + childPart;
    }

    public String getParentId() {
        if (this.numParts == 0) {
            return "";
        }
        if (this.numParts == 1) {
            return DELIMITER_STR;
        }
        StringBuilder sb = new StringBuilder();
        int length = this.numParts - 1;
        for (int i = 0; i != length; ++i) {
            String part = this.parts[i];
            sb.append(DELIMITER);
            sb.append(part);
        }
        return sb.toString();
    }

    public String toString() {
        return this.id;
    }
}

