/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.subsystem;

import java.util.List;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;

abstract class AbstractModeShapeRemoveStepHandler
extends AbstractRemoveStepHandler {
    protected final Logger log = Logger.getLogger((String)((Object)((Object)this)).getClass().getName());

    AbstractModeShapeRemoveStepHandler() {
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        String repositoryName = null;
        for (ServiceName serviceName : this.servicesToRemove(context, operation, model)) {
            context.removeService(serviceName);
            if (!this.log.isDebugEnabled()) continue;
            if (repositoryName == null) {
                repositoryName = this.repositoryName(operation);
            }
            this.log.debugf("service '%s' removed for repository '%s'", (Object)serviceName, (Object)repositoryName);
        }
    }

    protected void recoverServices(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        String repositoryName = null;
        ServiceRegistry serviceRegistry = context.getServiceRegistry(false);
        for (ServiceName serviceName : this.servicesToRemove(context, operation, model)) {
            context.getServiceTarget().addService(serviceName, serviceRegistry.getService(serviceName).getService());
            if (!this.log.isDebugEnabled()) continue;
            if (repositoryName == null) {
                repositoryName = this.repositoryName(operation);
            }
            this.log.debugf("service '%s' recovered for repository '%s'", (Object)serviceName, (Object)repositoryName);
        }
    }

    abstract List<ServiceName> servicesToRemove(OperationContext var1, ModelNode var2, ModelNode var3) throws OperationFailedException;

    String repositoryName(ModelNode operation) throws OperationFailedException {
        PathAddress pathAddress = PathAddress.pathAddress((ModelNode)operation.get("address"));
        for (PathElement pathElement : pathAddress) {
            if (!pathElement.getKey().equalsIgnoreCase("repository")) continue;
            return pathElement.getValue();
        }
        throw new OperationFailedException("Cannot determine repository name for: " + operation.asString());
    }
}

