/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.subsystem;

import java.util.HashMap;
import java.util.Map;

public enum Attribute {
    UNKNOWN(null),
    ACCESS_TYPE("access-type"),
    ALLOW_WORKSPACE_CREATION("allow-workspace-creation"),
    ANALYZER_CLASSNAME("analyzer-classname"),
    ANALYZER_MODULE("analyzer-module"),
    ANONYMOUS_ROLES("anonymous-roles"),
    ANONYMOUS_USERNAME("anonymous-username"),
    ASYNC_THREAD_POOL_SIZE("async-thread-pool-size"),
    ASYNC_MAX_QUEUE_SIZE("async-max-queue-size"),
    BATCH_SIZE("batch-size"),
    CACHE_CONTAINER("cache-container"),
    CACHE_NAME("cache-name"),
    CHANNEL_NAME("channel-name"),
    CLASSNAME("classname"),
    CLUSTER_NAME("cluster-name"),
    CLUSTER_STACK("cluster-stack"),
    CONNECTION_FACTORY_JNDI_NAME("connection-factory-jndi-name"),
    COPY_BUFFER_SIZE("copy-buffer-size"),
    DATA_CACHE_NAME("data-cache-name"),
    DATA_SOURCE_JNDI_NAME("data-source-jndi-name"),
    DEFAULT_WORKSPACE("default-workspace"),
    DOCUMENT_OPTIMIZATION_THREAD_POOL("document-optimization-thread-pool"),
    DOCUMENT_OPTIMIZATION_INITIAL_TIME("document-optimization-initial-time"),
    DOCUMENT_OPTIMIZATION_INTERVAL("document-optimization-interval"),
    DOCUMENT_OPTIMIZATION_CHILD_COUNT_TARGET("document-optimization-child-count-target"),
    DOCUMENT_OPTIMIZATION_CHILD_COUNT_TOLERANCE("document-optimization-child-count-tolerance"),
    ENABLE_MONITORING("enable-monitoring"),
    ENABLE_QUERIES("enable-queries"),
    GARBAGE_COLLECTION_THREAD_POOL("garbage-collection-thread-pool"),
    GARBAGE_COLLECTION_INITIAL_TIME("garbage-collection-initial-time"),
    GARBAGE_COLLECTION_INTERVAL("garbage-collection-interval"),
    FORMAT("format"),
    JNDI_NAME("jndi-name"),
    LOCK_CACHE_NAME("lock-cache-name"),
    LOCKING_STRATEGY("locking-strategy"),
    META_CACHE_NAME("metadata-cache-name"),
    CHUNK_SIZE("chunk-size"),
    MIN_VALUE_SIZE("min-value-size"),
    MIN_STRING_SIZE("min-string-size"),
    MODE("mode"),
    SYSTEM_CONTENT_MODE("systemContentMode"),
    MODULE("module"),
    NAME("name"),
    PATH("path"),
    PATH_EXPRESSION("path-expression"),
    QUEUE_JNDI_NAME("queue-jndi-name"),
    READER_STRATEGY("reader-strategy"),
    REBUILD_UPON_STARTUP("rebuild-upon-startup"),
    REBUILD_UPON_STARTUP_MODE("rebuild-upon-startup-mode"),
    REBUILD_UPON_STARTUP_INCLUDE_SYSTEM_CONTENT("rebuild-upon-startup-include-system-content"),
    REFRESH_PERIOD("refresh-period"),
    RELATIVE_TO("relative-to"),
    RETRY_MARKER_LOOKUP("retry-marker-lookup"),
    RETRY_INIT_PERIOD("retry-initialize-period"),
    SECURITY_DOMAIN("security-domain"),
    SOURCE_PATH("source-path"),
    SOURCE_RELATIVE_TO("source-relative-to"),
    STORE_NAME("store-name"),
    THREAD_POOL("thread-pool"),
    USE_ANONYMOUS_IF_AUTH_FAILED("use-anonymous-upon-failed-authentication"),
    WORKSPACE_NAMES("workspace-names"),
    CACHE_TTL_SECONDS("cacheTtlSeconds"),
    QUERYABLE("queryable"),
    READONLY("readonly"),
    EXPLODED("exploded"),
    AUTO_DEPLOY("auto-deploy");

    private final String name;
    private static final Map<String, Attribute> attributes;

    private Attribute(String name) {
        this.name = name;
    }

    public String getLocalName() {
        return this.name;
    }

    public static Attribute forName(String localName) {
        Attribute attribute = attributes.get(localName);
        return attribute == null ? UNKNOWN : attribute;
    }

    static {
        HashMap<String, Attribute> map = new HashMap<String, Attribute>();
        for (Attribute attribute : Attribute.values()) {
            String name = attribute.getLocalName();
            if (name == null) continue;
            map.put(name, attribute);
        }
        attributes = map;
    }
}

