/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.response;

import java.io.IOException;
import java.io.Writer;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.util.FastWriter;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.response.XMLWriter;
import org.apache.solr.schema.DateField;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.search.DocList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TextResponseWriter {
    protected final FastWriter writer;
    protected final IndexSchema schema;
    protected final SolrQueryRequest req;
    protected final SolrQueryResponse rsp;
    protected Set<String> returnFields;
    protected int level;
    protected boolean doIndent;

    public TextResponseWriter(Writer writer, SolrQueryRequest req, SolrQueryResponse rsp) {
        this.writer = FastWriter.wrap((Writer)writer);
        this.schema = req.getSchema();
        this.req = req;
        this.rsp = rsp;
        String indent = req.getParams().get("indent");
        if (indent != null && !"".equals(indent) && !"off".equals(indent)) {
            this.doIndent = true;
        }
        this.returnFields = rsp.getReturnFields();
    }

    public void close() throws IOException {
        this.writer.flushBuffer();
    }

    public Writer getWriter() {
        return this.writer;
    }

    public void indent() throws IOException {
        if (this.doIndent) {
            this.indent(this.level);
        }
    }

    public void indent(int lev) throws IOException {
        this.writer.write(XMLWriter.indentChars, 0, Math.min((lev << 1) + 1, XMLWriter.indentChars.length));
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public int level() {
        return this.level;
    }

    public int incLevel() {
        return ++this.level;
    }

    public int decLevel() {
        return --this.level;
    }

    public void setIndent(boolean doIndent) {
        this.doIndent = doIndent;
    }

    public abstract void writeNamedList(String var1, NamedList var2) throws IOException;

    public void writeVal(String name, Object val) throws IOException {
        if (val == null) {
            this.writeNull(name);
        } else if (val instanceof String) {
            this.writeStr(name, val.toString(), true);
        } else if (val instanceof Integer) {
            this.writeInt(name, val.toString());
        } else if (val instanceof Boolean) {
            this.writeBool(name, val.toString());
        } else if (val instanceof Long) {
            this.writeLong(name, val.toString());
        } else if (val instanceof Date) {
            this.writeDate(name, (Date)val);
        } else if (val instanceof Float) {
            this.writeFloat(name, ((Float)val).floatValue());
        } else if (val instanceof Double) {
            this.writeDouble(name, (Double)val);
        } else if (val instanceof Document) {
            this.writeDoc(name, (Document)val, this.returnFields, 0.0f, false);
        } else if (val instanceof SolrDocument) {
            this.writeSolrDocument(name, (SolrDocument)val, this.returnFields, null);
        } else if (val instanceof DocList) {
            this.writeDocList(name, (DocList)val, this.returnFields, null);
        } else if (val instanceof SolrDocumentList) {
            this.writeSolrDocumentList(name, (SolrDocumentList)val, this.returnFields, null);
        } else if (val instanceof Map) {
            this.writeMap(name, (Map)val, false, true);
        } else if (val instanceof NamedList) {
            this.writeNamedList(name, (NamedList)val);
        } else if (val instanceof Iterable) {
            this.writeArray(name, ((Iterable)val).iterator());
        } else if (val instanceof Object[]) {
            this.writeArray(name, (Object[])val);
        } else if (val instanceof Iterator) {
            this.writeArray(name, (Iterator)val);
        } else {
            this.writeStr(name, val.getClass().getName() + ':' + val.toString(), true);
        }
    }

    public abstract void writeDoc(String var1, Document var2, Set<String> var3, float var4, boolean var5) throws IOException;

    public abstract void writeSolrDocument(String var1, SolrDocument var2, Set<String> var3, Map var4) throws IOException;

    public abstract void writeDocList(String var1, DocList var2, Set<String> var3, Map var4) throws IOException;

    public abstract void writeSolrDocumentList(String var1, SolrDocumentList var2, Set<String> var3, Map var4) throws IOException;

    public abstract void writeStr(String var1, String var2, boolean var3) throws IOException;

    public abstract void writeMap(String var1, Map var2, boolean var3, boolean var4) throws IOException;

    public abstract void writeArray(String var1, Object[] var2) throws IOException;

    public abstract void writeArray(String var1, Iterator var2) throws IOException;

    public abstract void writeNull(String var1) throws IOException;

    public abstract void writeInt(String var1, String var2) throws IOException;

    public void writeInt(String name, int val) throws IOException {
        this.writeInt(name, Integer.toString(val));
    }

    public abstract void writeLong(String var1, String var2) throws IOException;

    public void writeLong(String name, long val) throws IOException {
        this.writeLong(name, Long.toString(val));
    }

    public abstract void writeBool(String var1, String var2) throws IOException;

    public void writeBool(String name, boolean val) throws IOException {
        this.writeBool(name, Boolean.toString(val));
    }

    public abstract void writeFloat(String var1, String var2) throws IOException;

    public void writeFloat(String name, float val) throws IOException {
        String s = Float.toString(val);
        if (val > Float.NEGATIVE_INFINITY && val < Float.POSITIVE_INFINITY) {
            this.writeFloat(name, s);
        } else {
            this.writeStr(name, s, false);
        }
    }

    public abstract void writeDouble(String var1, String var2) throws IOException;

    public void writeDouble(String name, double val) throws IOException {
        String s = Double.toString(val);
        if (val > Double.NEGATIVE_INFINITY && val < Double.POSITIVE_INFINITY) {
            this.writeDouble(name, s);
        } else {
            this.writeStr(name, s, false);
        }
    }

    public void writeDate(String name, Date val) throws IOException {
        this.writeDate(name, DateField.formatExternal(val));
    }

    public abstract void writeDate(String var1, String var2) throws IOException;

    public abstract void writeShort(String var1, String var2) throws IOException;

    public void writeShort(String name, short val) throws IOException {
        this.writeShort(name, Short.toString(val));
    }

    public abstract void writeByte(String var1, String var2) throws IOException;

    public void writeByte(String name, byte val) throws IOException {
        this.writeByte(name, Byte.toString(val));
    }
}

