/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.subsystem;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.modeshape.common.util.StringUtil;
import org.modeshape.jboss.service.SequencerService;
import org.modeshape.jboss.subsystem.ModeShapeServiceNames;
import org.modeshape.jboss.subsystem.ModelAttributes;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.ModeShapeEngine;
import org.modeshape.jcr.RepositoryConfiguration;

public class AddSequencer
extends AbstractAddStepHandler {
    public static final AddSequencer INSTANCE = new AddSequencer();
    private static final Logger LOG = Logger.getLogger((String)AddSequencer.class.getPackage().getName());

    private AddSequencer() {
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        AddSequencer.populate(operation, model);
    }

    static void populate(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (AttributeDefinition attribute : ModelAttributes.SEQUENCER_ATTRIBUTES) {
            attribute.validateAndSet(operation, model);
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) {
        ServiceTarget target = context.getServiceTarget();
        Properties props = new Properties();
        ModelNode address = operation.require("address");
        PathAddress pathAddress = PathAddress.pathAddress((ModelNode)address);
        String repositoryName = pathAddress.getElement(1).getValue();
        String sequencerName = pathAddress.getLastElement().getValue();
        props.put("name", sequencerName);
        for (String key : operation.keys()) {
            ModelNode node;
            if (key.equals("address") || key.equals("operation") || key.equals("operation-headers") || !(node = operation.get(key)).isDefined()) continue;
            if (key.equals("classname") && ModelAttributes.SEQUENCER_CLASSNAME.isMarshallable(operation)) {
                props.put("classname", node.asString());
                continue;
            }
            if (key.equals("module") && ModelAttributes.MODULE.isMarshallable(operation)) {
                props.put("classloader", node.asString());
                continue;
            }
            if (key.equals("path-expressions")) {
                ArrayList<String> pathExpressions = new ArrayList<String>();
                for (ModelNode pathExpression : operation.get("path-expressions").asList()) {
                    pathExpressions.add(pathExpression.asString());
                }
                props.put("pathExpressions", pathExpressions);
                continue;
            }
            if (key.equals("properties")) {
                for (Property property : node.asPropertyList()) {
                    props.put(property.getName(), property.getValue().asString());
                }
                continue;
            }
            props.put(key, node.asString());
        }
        this.ensureClassLoadingPropertyIsSet(props);
        SequencerService sequencerService = new SequencerService(repositoryName, props);
        ServiceBuilder sequencerBuilder = target.addService(ModeShapeServiceNames.sequencerServiceName(repositoryName, sequencerName), (Service)sequencerService);
        sequencerBuilder.addDependency(ModeShapeServiceNames.ENGINE, ModeShapeEngine.class, sequencerService.getModeShapeEngineInjector());
        sequencerBuilder.addDependency(ModeShapeServiceNames.repositoryServiceName(repositoryName), JcrRepository.class, sequencerService.getJcrRepositoryInjector());
        sequencerBuilder.setInitialMode(ServiceController.Mode.ACTIVE);
        ServiceController controller = sequencerBuilder.install();
        newControllers.add(controller);
    }

    protected boolean requiresRuntime(OperationContext context) {
        return true;
    }

    private void ensureClassLoadingPropertyIsSet(Properties sequencerProperties) {
        int index;
        if (sequencerProperties.containsKey("classloader")) {
            return;
        }
        String sequencerClassName = sequencerProperties.getProperty("classname");
        if (StringUtil.isBlank((String)sequencerClassName)) {
            LOG.warnv("Required property: {0} not found among the sequencer properties: {1}", (Object)"classname", (Object)sequencerProperties);
            return;
        }
        String fqSequencerClass = RepositoryConfiguration.getBuiltInSequencerClassName((String)sequencerClassName);
        if (fqSequencerClass == null) {
            fqSequencerClass = sequencerClassName;
        }
        String sequencerModuleName = (index = fqSequencerClass.lastIndexOf(".")) != -1 ? fqSequencerClass.substring(0, index) : fqSequencerClass;
        sequencerProperties.setProperty("classloader", sequencerModuleName);
    }
}

