/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.classfile;

import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.modeshape.common.util.StringUtil;
import org.modeshape.jcr.api.sequencer.Sequencer;
import org.modeshape.sequencer.classfile.ClassFileRecorder;
import org.modeshape.sequencer.classfile.metadata.AnnotationMetadata;
import org.modeshape.sequencer.classfile.metadata.ClassMetadata;
import org.modeshape.sequencer.classfile.metadata.EnumMetadata;
import org.modeshape.sequencer.classfile.metadata.FieldMetadata;
import org.modeshape.sequencer.classfile.metadata.MethodMetadata;
import org.modeshape.sequencer.javafile.metadata.ImportMetadata;

public class DefaultClassFileRecorder
implements ClassFileRecorder {
    @Override
    public void recordClass(Sequencer.Context context, Node outputNode, ClassMetadata classMetadata) throws RepositoryException {
        Node classNode = this.getClassNode(classMetadata, outputNode);
        this.writeClassMetaInformation(context, classMetadata, classNode);
        Node constructorsNode = classNode.addNode("class:constructors", "class:constructors");
        this.writeMethods(constructorsNode, classMetadata.getConstructors());
        Node methodsNode = classNode.addNode("class:methods", "class:methods");
        this.writeMethods(methodsNode, classMetadata.getMethods());
        Node fieldsNode = classNode.addNode("class:fields", "class:fields");
        this.writeFieldsNode(fieldsNode, classMetadata.getFields());
        this.writeImports(classNode, classMetadata.getImports());
    }

    private void writeClassMetaInformation(Sequencer.Context context, ClassMetadata classMetadata, Node classNode) throws RepositoryException {
        classNode.setProperty("class:name", classMetadata.getClassName());
        classNode.setProperty("class:sequencedDate", context.getTimestamp());
        String superClassName = classMetadata.getSuperclassName();
        if (StringUtil.isBlank((String)superClassName)) {
            superClassName = Object.class.getCanonicalName();
        }
        classNode.setProperty("class:superClassName", superClassName);
        classNode.setProperty("class:visibility", classMetadata.getVisibility().getDescription());
        classNode.setProperty("class:abstract", classMetadata.isAbstract());
        classNode.setProperty("class:interface", classMetadata.isInterface());
        classNode.setProperty("class:final", classMetadata.isFinal());
        classNode.setProperty("class:strictFp", classMetadata.isStrictFp());
        classNode.setProperty("class:interfaces", classMetadata.getInterfaces());
        if ("class:enum".equalsIgnoreCase(classNode.getProperty("jcr:primaryType").getString())) {
            classNode.setProperty("class:enumValues", ((EnumMetadata)classMetadata).getValues().toArray(new String[0]));
        }
    }

    private Node getClassNode(ClassMetadata classMetadata, Node outputNode) throws RepositoryException {
        int i;
        String[] packagePath = classMetadata.getClassName().split("\\.");
        if (packagePath.length > 1) {
            int numPkgs = packagePath.length - 1;
            for (i = 0; i < numPkgs; ++i) {
                outputNode = outputNode.addNode(packagePath[i]);
                outputNode.addMixin("class:package");
            }
        }
        Node classNode = outputNode.addNode(packagePath[i]);
        String actualType = classMetadata.isEnumeration() ? "class:enum" : "class:class";
        classNode.setPrimaryType(actualType);
        return classNode;
    }

    private void writeFieldsNode(Node fieldsNode, List<FieldMetadata> fields) throws RepositoryException {
        for (FieldMetadata field : fields) {
            Node fieldNode = fieldsNode.addNode(field.getName(), "class:field");
            fieldNode.setProperty("class:name", field.getName());
            fieldNode.setProperty("class:typeClassName", field.getTypeName());
            fieldNode.setProperty("class:visibility", field.getVisibility().getDescription());
            fieldNode.setProperty("class:static", field.isStatic());
            fieldNode.setProperty("class:final", field.isFinal());
            fieldNode.setProperty("class:transient", field.isTransient());
            fieldNode.setProperty("class:volatile", field.isVolatile());
            this.writeAnnotationsNode(fieldNode, field.getAnnotations());
        }
    }

    private void writeMethods(Node rootNode, List<MethodMetadata> methods) throws RepositoryException {
        for (MethodMetadata method : methods) {
            Node methodNode = rootNode.addNode(method.getId(), "class:method");
            methodNode.setProperty("class:name", method.getName());
            methodNode.setProperty("class:returnTypeClassName", method.getReturnType());
            methodNode.setProperty("class:visibility", method.getVisibility().getDescription());
            methodNode.setProperty("class:static", method.isStatic());
            methodNode.setProperty("class:final", method.isFinal());
            methodNode.setProperty("class:abstract", method.isAbstract());
            methodNode.setProperty("class:strictFp", method.isStrictFp());
            methodNode.setProperty("class:native", method.isNative());
            methodNode.setProperty("class:synchronized", method.isSynchronized());
            Node parametersNode = methodNode.addNode("class:methodParameters", "class:parameters");
            int num = 0;
            for (String paramType : method.getParameters()) {
                String paramName = "p" + ++num;
                Node field = parametersNode.addNode(paramName, "class:parameter");
                field.setProperty("class:name", paramName);
                field.setProperty("class:typeClassName", paramType);
                field.setProperty("class:final", false);
            }
            this.writeAnnotationsNode(methodNode, method.getAnnotations());
        }
    }

    private void writeAnnotationsNode(Node rootNode, List<AnnotationMetadata> annotations) throws RepositoryException {
        if (annotations.isEmpty()) {
            return;
        }
        Node annotationsNode = rootNode.addNode("class:annotations", "class:annotations");
        for (AnnotationMetadata annotation : annotations) {
            Node annotationNode = annotationsNode.addNode("class:annotation", "class:annotation");
            annotationNode.setProperty("class:name", annotation.getAnnotationClassName());
            for (Map.Entry<String, String> entry : annotation.getMemberValues().entrySet()) {
                Node annotationMember = annotationNode.addNode(entry.getKey(), "class:annotationMember");
                annotationMember.setProperty("class:name", entry.getKey());
                annotationMember.setProperty("class:value", entry.getValue());
            }
        }
    }

    private void writeImports(Node classNode, List<ImportMetadata> imports) throws RepositoryException {
        assert (classNode != null);
        assert (imports != null);
        if (!imports.isEmpty()) {
            String[] values = new String[imports.size()];
            int i = 0;
            for (ImportMetadata imported : imports) {
                values[i++] = imported.getName();
            }
            classNode.setProperty("class:imports", values);
        }
    }
}

