/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.federation;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.modeshape.common.annotation.NotThreadSafe;
import org.modeshape.jcr.Connectors;
import org.modeshape.jcr.api.value.DateTime;
import org.modeshape.jcr.bus.ChangeBus;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.cache.change.RecordingChanges;
import org.modeshape.jcr.federation.FederatedDocumentStore;
import org.modeshape.jcr.spi.federation.ConnectorChangeSet;
import org.modeshape.jcr.value.DateTimeFactory;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.Path;
import org.modeshape.jcr.value.PathFactory;
import org.modeshape.jcr.value.Property;
import org.modeshape.jcr.value.WorkspaceAndPath;

@NotThreadSafe
public class ConnectorChangeSetImpl
implements ConnectorChangeSet {
    private final Connectors connectors;
    private final String connectorSourceName;
    private final Connectors.PathMappings pathMappings;
    private final String processId;
    private final String repositoryKey;
    private final ChangeBus bus;
    private final Map<String, RecordingChanges> changesByWorkspace = new HashMap<String, RecordingChanges>();
    private final DateTimeFactory timeFactory;
    private final String journalId;

    public ConnectorChangeSetImpl(Connectors connectors, Connectors.PathMappings mappings, String processId, String repositoryKey, ChangeBus bus, DateTimeFactory timeFactory, String journalId) {
        this.connectors = connectors;
        this.connectorSourceName = mappings.getConnectorSourceName();
        this.timeFactory = timeFactory;
        this.pathMappings = mappings;
        this.processId = processId;
        this.repositoryKey = repositoryKey;
        this.bus = bus;
        this.journalId = journalId;
        assert (this.connectors != null);
        assert (this.connectorSourceName != null);
        assert (this.pathMappings != null);
        assert (this.processId != null);
        assert (this.repositoryKey != null);
        assert (this.bus != null);
        assert (this.timeFactory != null);
    }

    protected final RecordingChanges changesFor(WorkspaceAndPath workspaceAndPath) {
        return this.changesFor(workspaceAndPath.getWorkspaceName());
    }

    protected final RecordingChanges changesFor(String workspaceName) {
        RecordingChanges changes = this.changesByWorkspace.get(workspaceName);
        if (changes == null) {
            changes = new RecordingChanges(this.processId, this.repositoryKey, workspaceName, this.journalId);
            this.changesByWorkspace.put(workspaceName, changes);
        }
        return changes;
    }

    @Override
    public void nodeCreated(String docId, String parentDocId, String path, Name primaryType, Set<Name> mixinTypes, Map<Name, Property> properties) {
        NodeKey key = this.nodeKey(docId);
        NodeKey parentKey = this.nodeKey(parentDocId);
        Path externalPath = (Path)this.pathMappings.getPathFactory().create(path);
        for (WorkspaceAndPath wsAndPath : this.pathMappings.resolveExternalPathToInternal(externalPath)) {
            this.changesFor(wsAndPath).nodeCreated(key, parentKey, wsAndPath.getPath(), primaryType, mixinTypes, properties);
        }
    }

    @Override
    public void nodeRemoved(String docId, String parentDocId, String path, Name primaryType, Set<Name> mixinTypes) {
        NodeKey key = this.nodeKey(docId);
        NodeKey parentKey = this.nodeKey(parentDocId);
        Path externalPath = (Path)this.pathMappings.getPathFactory().create(path);
        for (WorkspaceAndPath wsAndPath : this.pathMappings.resolveExternalPathToInternal(externalPath)) {
            this.changesFor(wsAndPath).nodeRemoved(key, parentKey, wsAndPath.getPath(), primaryType, mixinTypes);
        }
        this.connectors.externalNodeRemoved(docId);
    }

    @Override
    public void nodeMoved(String docId, Name primaryType, Set<Name> mixinTypes, String newParentDocId, String oldParentDocId, String newPath, String oldPath) {
        NodeKey key = this.nodeKey(docId);
        NodeKey newParentKey = this.nodeKey(newParentDocId);
        NodeKey oldParentKey = this.nodeKey(oldParentDocId);
        Path newExternalPath = (Path)this.pathMappings.getPathFactory().create(newPath);
        Path oldExternalPath = (Path)this.pathMappings.getPathFactory().create(oldPath);
        Collection<WorkspaceAndPath> newWsAndPaths = this.pathMappings.resolveExternalPathToInternal(newExternalPath);
        Collection<WorkspaceAndPath> oldWsAndPaths = this.pathMappings.resolveExternalPathToInternal(oldExternalPath);
        int numNew = newWsAndPaths.size();
        int numOld = oldWsAndPaths.size();
        if (numNew == 0) {
            if (numOld == 0) {
                return;
            }
            for (WorkspaceAndPath wsAndOldPath : oldWsAndPaths) {
                this.changesFor(wsAndOldPath.getWorkspaceName()).nodeRemoved(key, oldParentKey, wsAndOldPath.getPath(), primaryType, mixinTypes);
            }
            return;
        }
        if (numOld == 0) {
            Map<Name, Property> properties = Collections.emptyMap();
            for (WorkspaceAndPath wsAndNewPath : newWsAndPaths) {
                this.changesFor(wsAndNewPath.getWorkspaceName()).nodeCreated(key, newParentKey, wsAndNewPath.getPath(), primaryType, mixinTypes, properties);
            }
            return;
        }
        assert (numNew >= 1);
        assert (numOld >= 1);
        if (numNew == 1 && numOld == 1) {
            String oldWorkspace;
            WorkspaceAndPath newWsAndPath = newWsAndPaths.iterator().next();
            WorkspaceAndPath oldWsAndPath = newWsAndPaths.iterator().next();
            String newWorkspace = newWsAndPath.getWorkspaceName();
            if (newWorkspace.equals(oldWorkspace = oldWsAndPath.getWorkspaceName())) {
                this.changesFor(newWorkspace).nodeMoved(key, primaryType, mixinTypes, newParentKey, oldParentKey, newWsAndPath.getPath(), oldWsAndPath.getPath());
                return;
            }
            this.changesFor(oldWsAndPath.getWorkspaceName()).nodeRemoved(key, oldParentKey, oldWsAndPath.getPath(), primaryType, mixinTypes);
            Map<Name, Property> properties = Collections.emptyMap();
            this.changesFor(newWsAndPath.getWorkspaceName()).nodeCreated(key, newParentKey, newWsAndPath.getPath(), primaryType, mixinTypes, properties);
            return;
        }
        assert (numNew > 1 || numOld > 1);
        for (WorkspaceAndPath wsAndNewPath : newWsAndPaths) {
            boolean found = false;
            Iterator<WorkspaceAndPath> oldWsAndPathsIter = oldWsAndPaths.iterator();
            while (oldWsAndPathsIter.hasNext()) {
                String oldWorkspace;
                WorkspaceAndPath wsAndOldPath = oldWsAndPathsIter.next();
                String newWorkspace = wsAndNewPath.getWorkspaceName();
                if (!newWorkspace.equals(oldWorkspace = wsAndOldPath.getWorkspaceName())) continue;
                found = true;
                this.changesFor(newWorkspace).nodeMoved(key, primaryType, mixinTypes, newParentKey, oldParentKey, wsAndNewPath.getPath(), wsAndOldPath.getPath());
                oldWsAndPathsIter.remove();
            }
            if (found) continue;
            Map<Name, Property> properties = Collections.emptyMap();
            this.changesFor(wsAndNewPath).nodeCreated(key, newParentKey, wsAndNewPath.getPath(), primaryType, mixinTypes, properties);
        }
        for (WorkspaceAndPath oldWsAndPath : oldWsAndPaths) {
            this.changesFor(oldWsAndPath).nodeRemoved(key, oldParentKey, oldWsAndPath.getPath(), primaryType, mixinTypes);
        }
    }

    @Override
    public void nodeReordered(String docId, Name primaryType, Set<Name> mixinTypes, String parentDocId, String newPath, String oldNameSegment, String reorderedBeforeNameSegment) {
        NodeKey key = this.nodeKey(docId);
        NodeKey parentKey = this.nodeKey(parentDocId);
        PathFactory pathFactory = this.pathMappings.getPathFactory();
        Path newExternalPath = (Path)pathFactory.create(newPath);
        Path parentPath = newExternalPath.getParent();
        Path oldExternalPath = pathFactory.create(parentPath, pathFactory.createSegment(oldNameSegment));
        Path reorderedBeforePath = reorderedBeforeNameSegment == null ? null : pathFactory.create(parentPath, pathFactory.createSegment(reorderedBeforeNameSegment));
        for (WorkspaceAndPath wsAndPath : this.pathMappings.resolveExternalPathToInternal(newExternalPath)) {
            this.changesFor(wsAndPath).nodeReordered(key, primaryType, mixinTypes, parentKey, wsAndPath.getPath(), oldExternalPath, reorderedBeforePath);
        }
    }

    @Override
    public void propertyAdded(String docId, Name nodePrimaryType, Set<Name> nodeMixinTypes, String nodePath, Property property) {
        NodeKey key = this.nodeKey(docId);
        Path externalPath = (Path)this.pathMappings.getPathFactory().create(nodePath);
        for (WorkspaceAndPath wsAndPath : this.pathMappings.resolveExternalPathToInternal(externalPath)) {
            this.changesFor(wsAndPath).propertyAdded(key, nodePrimaryType, nodeMixinTypes, wsAndPath.getPath(), property);
        }
    }

    @Override
    public void propertyRemoved(String docId, Name nodePrimaryType, Set<Name> nodeMixinTypes, String nodePath, Property property) {
        NodeKey key = this.nodeKey(docId);
        Path externalPath = (Path)this.pathMappings.getPathFactory().create(nodePath);
        for (WorkspaceAndPath wsAndPath : this.pathMappings.resolveExternalPathToInternal(externalPath)) {
            this.changesFor(wsAndPath).propertyRemoved(key, nodePrimaryType, nodeMixinTypes, wsAndPath.getPath(), property);
        }
    }

    @Override
    public void propertyChanged(String docId, Name nodePrimaryType, Set<Name> nodeMixinTypes, String nodePath, Property oldProperty, Property newProperty) {
        NodeKey key = this.nodeKey(docId);
        Path externalPath = (Path)this.pathMappings.getPathFactory().create(nodePath);
        for (WorkspaceAndPath wsAndPath : this.pathMappings.resolveExternalPathToInternal(externalPath)) {
            this.changesFor(wsAndPath).propertyChanged(key, nodePrimaryType, nodeMixinTypes, wsAndPath.getPath(), newProperty, oldProperty);
        }
    }

    @Override
    public void publish(Map<String, String> data) {
        DateTime now = this.timeFactory.create();
        if (data == null) {
            data = Collections.emptyMap();
        }
        for (RecordingChanges changes : this.changesByWorkspace.values()) {
            changes.freeze(this.connectorSourceName, data, now);
            this.bus.notify(changes);
        }
        this.changesByWorkspace.clear();
    }

    private NodeKey nodeKey(String documentId) {
        return FederatedDocumentStore.documentIdToNodeKey(this.connectorSourceName, documentId);
    }

    public String toString() {
        return "Change set for connector '" + this.connectorSourceName + "': " + this.changesByWorkspace;
    }
}

