/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.mapdb.BTreeKeySerializer;
import org.mapdb.BTreeMap;
import org.mapdb.DB;
import org.mapdb.DBMaker;
import org.mapdb.HTreeMap;
import org.mapdb.Serializer;
import org.modeshape.common.collection.SingleIterator;
import org.modeshape.common.collection.Supplier;
import org.modeshape.common.util.ObjectUtil;
import org.modeshape.jcr.ExecutionContext;
import org.modeshape.jcr.api.value.DateTime;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.query.Tuples;
import org.modeshape.jcr.query.model.TypeSystem;
import org.modeshape.jcr.value.DateTimeFactory;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.NameFactory;
import org.modeshape.jcr.value.Path;
import org.modeshape.jcr.value.PathFactory;
import org.modeshape.jcr.value.Reference;
import org.modeshape.jcr.value.ReferenceFactory;
import org.modeshape.jcr.value.StringFactory;
import org.modeshape.jcr.value.UriFactory;
import org.modeshape.jcr.value.ValueFactories;
import org.modeshape.jcr.value.ValueFactory;

public class BufferManager
implements AutoCloseable {
    private static final Supplier<DB> OFF_HEAP_DB_SUPPLIER = new Supplier<DB>(){

        public DB get() {
            return DBMaker.newMemoryDirectDB().make();
        }
    };
    private static final Supplier<DB> ON_HEAP_DB_SUPPLIER = new Supplier<DB>(){

        public DB get() {
            return DBMaker.newMemoryDB().make();
        }
    };
    private static final Serializer<?> DEFAULT_SERIALIZER = Serializer.BASIC;
    private static final BTreeKeySerializer<?> DEFAULT_BTREE_KEY_SERIALIZER = BTreeKeySerializer.BASIC;
    private final Map<Class<?>, Serializer<?>> serializersByClass;
    private final Map<Class<?>, BTreeKeySerializer<?>> bTreeKeySerializersByClass;
    private final Map<Class<?>, BTreeKeySerializer<?>> packedBTreeKeySerializersByClass;
    private final DbHolder offheap;
    private final DbHolder onheap;
    private final AtomicLong dbCounter = new AtomicLong();

    public BufferManager(ExecutionContext context) {
        this(context, OFF_HEAP_DB_SUPPLIER, ON_HEAP_DB_SUPPLIER);
    }

    protected BufferManager(ExecutionContext context, Supplier<DB> offheapDbSupplier, Supplier<DB> onheapDbSupplier) {
        this.offheap = new DbHolder(offheapDbSupplier);
        this.onheap = new DbHolder(onheapDbSupplier);
        ValueFactories factories = context.getValueFactories();
        PathFactory pathFactory = factories.getPathFactory();
        NameFactory nameFactory = factories.getNameFactory();
        StringFactory stringFactory = factories.getStringFactory();
        ReferenceFactory refFactory = factories.getReferenceFactory();
        UriFactory uriFactory = factories.getUriFactory();
        DateTimeFactory dateFactory = factories.getDateFactory();
        ValueFactory<BigDecimal> decimalFactory = factories.getDecimalFactory();
        this.serializersByClass = new HashMap();
        this.serializersByClass.put(String.class, Serializer.STRING);
        this.serializersByClass.put(Long.class, Serializer.LONG);
        this.serializersByClass.put(Boolean.class, Serializer.BOOLEAN);
        this.serializersByClass.put(Double.class, new DoubleSerializer());
        this.serializersByClass.put(BigDecimal.class, new ValueSerializer<BigDecimal>(stringFactory, decimalFactory));
        this.serializersByClass.put(URI.class, new ValueSerializer<URI>(stringFactory, uriFactory));
        this.serializersByClass.put(DateTime.class, new ValueSerializer<DateTime>(stringFactory, dateFactory));
        this.serializersByClass.put(Path.class, new ValueSerializer<Path>(stringFactory, pathFactory));
        this.serializersByClass.put(Name.class, new ValueSerializer<Name>(stringFactory, nameFactory));
        this.serializersByClass.put(Reference.class, new ValueSerializer<Reference>(stringFactory, refFactory));
        this.serializersByClass.put(NodeKey.class, new Serializer<NodeKey>(){

            public void serialize(DataOutput out, NodeKey value) throws IOException {
                out.writeUTF(value.toString());
            }

            public NodeKey deserialize(DataInput in, int available) throws IOException {
                String keyStr = in.readUTF();
                return new NodeKey(keyStr);
            }

            public int fixedSize() {
                return -1;
            }
        });
        this.bTreeKeySerializersByClass = new HashMap();
        this.packedBTreeKeySerializersByClass = new HashMap();
        for (Map.Entry<Class<?>, Serializer<?>> entry : this.serializersByClass.entrySet()) {
            Serializer<?> serializer = entry.getValue();
            DelegatingKeySerializer bTreeSerializer = new DelegatingKeySerializer(serializer);
            this.bTreeKeySerializersByClass.put(entry.getKey(), bTreeSerializer);
            this.packedBTreeKeySerializersByClass.put(entry.getKey(), bTreeSerializer);
        }
        this.packedBTreeKeySerializersByClass.put(String.class, new PackedStringKeySerializer<String>(stringFactory, stringFactory));
        this.packedBTreeKeySerializersByClass.put(Name.class, new PackedStringKeySerializer<Name>(stringFactory, nameFactory));
        this.packedBTreeKeySerializersByClass.put(Path.class, new PackedStringKeySerializer<Path>(stringFactory, pathFactory));
        this.packedBTreeKeySerializersByClass.put(Name.class, new PackedStringKeySerializer<Name>(stringFactory, nameFactory));
        this.packedBTreeKeySerializersByClass.put(DateTime.class, new PackedStringKeySerializer<DateTime>(stringFactory, dateFactory));
        this.packedBTreeKeySerializersByClass.put(URI.class, new PackedStringKeySerializer<URI>(stringFactory, uriFactory));
        this.packedBTreeKeySerializersByClass.put(Reference.class, new PackedStringKeySerializer<Reference>(stringFactory, refFactory));
        this.packedBTreeKeySerializersByClass.put(BigDecimal.class, new PackedStringKeySerializer<BigDecimal>(stringFactory, decimalFactory));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block11: {
            RuntimeException error = null;
            try {
                this.onheap.close();
            }
            catch (RuntimeException e) {
                error = e;
            }
            finally {
                block12: {
                    try {
                        this.offheap.close();
                    }
                    catch (RuntimeException e) {
                        if (error != null) break block12;
                        error = e;
                    }
                }
                if (error == null) break block11;
                throw error;
            }
        }
    }

    public <T> QueueBufferMaker<T> createQueueBuffer(Serializer<T> serializer) {
        return new MakeOrderedBuffer<T>("buffer-" + this.dbCounter.incrementAndGet(), serializer);
    }

    public <T> DistinctBufferMaker<T> createDistinctBuffer(Serializer<T> distinctSerializer) {
        return new MakeDistinctBuffer<T>("buffer-" + this.dbCounter.incrementAndGet(), distinctSerializer);
    }

    public <K, V> SortingBufferMaker<K, V> createSortingBuffer(BTreeKeySerializer<K> keySerializer, Serializer<V> valueSerializer) {
        return new MakeSortingBuffer<K, V>("buffer-" + this.dbCounter.incrementAndGet(), keySerializer, valueSerializer);
    }

    public <K extends Comparable<K>, V> SortingBufferMaker<K, V> createSortingWithDuplicatesBuffer(Serializer<K> keySerializer, Comparator<?> keyComparator, Serializer<V> valueSerializer) {
        return new MakeSortingWithDuplicatesBuffer<K, V>("buffer-" + this.dbCounter.incrementAndGet(), keySerializer, keyComparator, valueSerializer);
    }

    public Serializer<?> serializerFor(TypeSystem.TypeFactory<?> type) {
        Serializer<?> result = this.serializersByClass.get(type.getType());
        if (result != null) {
            return result;
        }
        if (type instanceof Tuples.TupleFactory) {
            return ((Tuples.TupleFactory)((Object)type)).getSerializer(this);
        }
        return DEFAULT_SERIALIZER;
    }

    public BTreeKeySerializer<?> bTreeKeySerializerFor(TypeSystem.TypeFactory<?> type, boolean pack) {
        Map<Class<?>, BTreeKeySerializer<?>> byClass = pack ? this.packedBTreeKeySerializersByClass : this.bTreeKeySerializersByClass;
        BTreeKeySerializer<?> result = byClass.get(type.getType());
        if (result == null) {
            result = DEFAULT_BTREE_KEY_SERIALIZER;
        }
        KeySerializerWithComparator serializer = (KeySerializerWithComparator)result;
        Comparator<?> comparator = type.getComparator();
        return serializer.withComparator(comparator);
    }

    protected final DB db(boolean useHeap) {
        return useHeap ? this.onheap.get() : this.offheap.get();
    }

    protected final void delete(String name, boolean onHeap) {
        this.db(onHeap).delete(name);
    }

    public static class ValueSerializer<V>
    implements Serializer<V>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final transient ValueFactory<V> valueFactory;
        private final transient StringFactory stringFactory;

        public ValueSerializer(StringFactory stringFactory, ValueFactory<V> valueFactory) {
            this.valueFactory = valueFactory;
            this.stringFactory = stringFactory;
        }

        public int fixedSize() {
            return -1;
        }

        public void serialize(DataOutput out, V value) throws IOException {
            out.writeUTF((String)this.stringFactory.create(value));
        }

        public V deserialize(DataInput in, int available) throws IOException {
            String pathStr = in.readUTF();
            return this.valueFactory.create(pathStr);
        }

        public String toString() {
            return "ValueSerializer<" + (Object)((Object)this.valueFactory.getPropertyType()) + ">";
        }
    }

    public static class DoubleSerializer
    implements Serializer<Double>,
    Serializable {
        private static final long serialVersionUID = 1L;

        public void serialize(DataOutput out, Double value) throws IOException {
            out.writeDouble(value);
        }

        public Double deserialize(DataInput in, int available) throws IOException {
            if (available == 0) {
                return null;
            }
            return in.readDouble();
        }

        public int fixedSize() {
            return -1;
        }
    }

    public static class PackedStringKeySerializer<K extends Comparable<K>>
    extends BTreeKeySerializer<K>
    implements Serializable,
    KeySerializerWithComparator<K> {
        private static final long serialVersionUID = 1L;
        private static final Charset UTF8_CHARSET = Charset.forName("UTF8");
        private final transient ValueFactory<K> valueFactory;
        private final transient StringFactory stringFactory;
        protected final transient Comparator<K> comparator;

        public PackedStringKeySerializer(StringFactory stringFactory, ValueFactory<K> valueFactory) {
            this(stringFactory, valueFactory, null);
        }

        protected PackedStringKeySerializer(StringFactory stringFactory, ValueFactory<K> valueFactory, Comparator<K> comparator) {
            this.valueFactory = valueFactory;
            this.stringFactory = stringFactory;
            this.comparator = comparator != null ? comparator : new Comparator<K>(){

                @Override
                public int compare(K o1, K o2) {
                    return o1.compareTo(o2);
                }
            };
        }

        @Override
        public BTreeKeySerializer<K> withComparator(Comparator<?> comparator) {
            if (comparator == null) {
                return this;
            }
            return new PackedStringKeySerializer<K>(this.stringFactory, this.valueFactory, comparator);
        }

        public Comparator<K> getComparator() {
            return this.comparator;
        }

        public void serialize(DataOutput out, int start, int end, Object[] keys) throws IOException {
            byte[] previous = null;
            for (int i = start; i < end; ++i) {
                String key = (String)this.stringFactory.create(keys[i]);
                byte[] b = key.getBytes(UTF8_CHARSET);
                PackedStringKeySerializer.leadingValuePackWrite((DataOutput)out, (byte[])b, previous, (int)0);
                previous = b;
            }
        }

        public Object[] deserialize(DataInput in, int start, int end, int size) throws IOException {
            Object[] ret = new Object[size];
            byte[] previous = null;
            for (int i = start; i < end; ++i) {
                byte[] b = PackedStringKeySerializer.leadingValuePackRead((DataInput)in, previous, (int)0);
                if (b == null) continue;
                String str = new String(b, UTF8_CHARSET);
                ret[i] = this.valueFactory.create(str);
                previous = b;
            }
            return ret;
        }

        public String toString() {
            return "ValueSerializer<" + (Object)((Object)this.valueFactory.getPropertyType()) + ">";
        }
    }

    public static interface KeySerializerWithComparator<K> {
        public BTreeKeySerializer<K> withComparator(Comparator<?> var1);
    }

    public static final class DelegatingKeySerializer<K extends Comparable<K>>
    extends BTreeKeySerializer<K>
    implements Serializable,
    KeySerializerWithComparator<K> {
        private static final long serialVersionUID = 1L;
        protected final transient Serializer<K> defaultSerializer;
        protected final transient Comparator<K> comparator;

        protected DelegatingKeySerializer(Serializer<K> defaultSerializer) {
            this(defaultSerializer, null);
        }

        protected DelegatingKeySerializer(Serializer<K> defaultSerializer, Comparator<K> comparator) {
            this.defaultSerializer = defaultSerializer;
            this.comparator = comparator != null ? comparator : new NaturalComparator();
        }

        public Comparator<K> getComparator() {
            return this.comparator;
        }

        @Override
        public BTreeKeySerializer<K> withComparator(Comparator<?> comparator) {
            if (comparator == null) {
                return this;
            }
            return new DelegatingKeySerializer<K>(this.defaultSerializer, comparator);
        }

        public void serialize(DataOutput out, int start, int end, Object[] keys) throws IOException {
            for (int i = start; i < end; ++i) {
                this.defaultSerializer.serialize(out, (Object)((Comparable)keys[i]));
            }
        }

        public Object[] deserialize(DataInput in, int start, int end, int size) throws IOException {
            Object[] ret = new Object[size];
            for (int i = start; i < end; ++i) {
                ret[i] = this.defaultSerializer.deserialize(in, -1);
            }
            return ret;
        }

        public String toString() {
            return "DelegatingBTreeSerializer<" + this.defaultSerializer + ">";
        }
    }

    protected static class NaturalComparator<K extends Comparable<K>>
    implements Comparator<K>,
    Serializable {
        private static final long serialVersionUID = 1L;

        protected NaturalComparator() {
        }

        @Override
        public int compare(K o1, K o2) {
            return o1.compareTo(o2);
        }
    }

    protected static final class UniqueKeySerializer<K extends Comparable<K>>
    extends BTreeKeySerializer<UniqueKey<K>>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        protected final transient Serializer<K> keySerializer;
        protected final transient Comparator<UniqueKey<K>> comparator;

        protected UniqueKeySerializer(Serializer<K> keySerializer, Comparator<UniqueKey<K>> comparator) {
            this.keySerializer = keySerializer;
            this.comparator = comparator;
        }

        public Comparator<UniqueKey<K>> getComparator() {
            return this.comparator;
        }

        public void serialize(DataOutput out, int start, int end, Object[] keys) throws IOException {
            for (int i = start; i < end; ++i) {
                UniqueKey key = (UniqueKey)keys[i];
                this.keySerializer.serialize(out, key.actualKey);
                out.writeLong(key.id);
            }
        }

        public Object[] deserialize(DataInput in, int start, int end, int size) throws IOException {
            Object[] ret = new Object[size];
            for (int i = start; i < end; ++i) {
                Comparable key = (Comparable)this.keySerializer.deserialize(in, -1);
                long id = in.readLong();
                ret[i] = new UniqueKey<Comparable>(key, id);
            }
            return ret;
        }

        public String toString() {
            return "UniqueKeySerializer<" + this.keySerializer + ">";
        }
    }

    protected static final class ComparableUniqueKeyComparator<K>
    implements Comparator<UniqueKey<K>>,
    Serializable {
        private static final long serialVersionUID = 1L;

        protected ComparableUniqueKeyComparator() {
        }

        @Override
        public int compare(UniqueKey<K> o1, UniqueKey<K> o2) {
            if (o1 == o2) {
                return 0;
            }
            int diff = ObjectUtil.compareWithNulls((Comparable)((Comparable)o1.actualKey), (Comparable)((Comparable)o2.actualKey));
            if (diff != 0) {
                return diff;
            }
            long ldiff = o1.id - o2.id;
            return ldiff == 0L ? 0 : (ldiff <= 0L ? -1 : 1);
        }
    }

    protected static final class UniqueKeyComparator<K>
    implements Comparator<UniqueKey<K>>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final transient Comparator<K> valueComparator;

        protected UniqueKeyComparator(Comparator<K> valueComparator) {
            this.valueComparator = valueComparator;
        }

        @Override
        public int compare(UniqueKey<K> o1, UniqueKey<K> o2) {
            if (o1 == o2) {
                return 0;
            }
            int diff = this.valueComparator.compare(o1.actualKey, o2.actualKey);
            if (diff != 0) {
                return diff;
            }
            long ldiff = o1.id - o2.id;
            return ldiff == 0L ? 0 : (ldiff <= 0L ? -1 : 1);
        }
    }

    protected final class MakeSortingWithDuplicatesBuffer<K extends Comparable<K>, V>
    implements SortingBufferMaker<K, V> {
        private final String name;
        private boolean useHeap = true;
        private boolean keepsize = false;
        private final Serializer<K> keySerializer;
        private final Serializer<V> valueSerializer;
        private final Comparator<K> keyComparator;

        protected MakeSortingWithDuplicatesBuffer(String name, Serializer<K> keySerializer, Comparator<?> keyComparator, Serializer<V> valueSerializer) {
            this.name = name;
            this.keySerializer = keySerializer;
            this.valueSerializer = valueSerializer;
            this.keyComparator = keyComparator;
        }

        @Override
        public SortingBufferMaker<K, V> keepSize(boolean keepBufferSize) {
            this.keepsize = keepBufferSize;
            return this;
        }

        @Override
        public SortingBufferMaker<K, V> useHeap(boolean useHeap) {
            this.useHeap = useHeap;
            return this;
        }

        @Override
        public SortingBuffer<K, V> make() {
            Comparator comparator = (Comparator)((Object)(this.keyComparator != null ? new UniqueKeyComparator<K>(this.keyComparator) : new ComparableUniqueKeyComparator()));
            UniqueKeySerializer<K> uniqueKeySerializer = new UniqueKeySerializer<K>(this.keySerializer, comparator);
            DB.BTreeMapMaker maker = BufferManager.this.db(this.useHeap).createTreeMap(this.name).keySerializer(uniqueKeySerializer).valueSerializer(this.valueSerializer);
            if (this.keepsize) {
                maker = maker.counterEnable();
            }
            BTreeMap buffer = maker.make();
            return new CloseableSortingBufferWithDuplicates(this.name, this.useHeap, buffer);
        }
    }

    protected final class MakeSortingBuffer<K, V>
    implements SortingBufferMaker<K, V> {
        private final String name;
        private boolean useHeap = true;
        private boolean keepsize = false;
        private final BTreeKeySerializer<K> keySerializer;
        private final Serializer<V> valueSerializer;

        protected MakeSortingBuffer(String name, BTreeKeySerializer<K> keySerializer, Serializer<V> valueSerializer) {
            this.name = name;
            this.keySerializer = keySerializer;
            this.valueSerializer = valueSerializer;
        }

        @Override
        public SortingBufferMaker<K, V> keepSize(boolean keepBufferSize) {
            this.keepsize = keepBufferSize;
            return this;
        }

        @Override
        public SortingBufferMaker<K, V> useHeap(boolean useHeap) {
            this.useHeap = useHeap;
            return this;
        }

        @Override
        public SortingBuffer<K, V> make() {
            DB.BTreeMapMaker maker = BufferManager.this.db(this.useHeap).createTreeMap(this.name).keySerializer(this.keySerializer).valueSerializer(this.valueSerializer);
            if (this.keepsize) {
                maker = maker.counterEnable();
            }
            BTreeMap buffer = maker.make();
            return new CloseableSortingBuffer(this.name, this.useHeap, buffer);
        }
    }

    protected final class MakeDistinctBuffer<T>
    implements DistinctBufferMaker<T> {
        private final String name;
        private boolean useHeap = true;
        private boolean keepsize = false;
        private final Serializer<T> serializer;

        protected MakeDistinctBuffer(String name, Serializer<T> serializer) {
            assert (name != null);
            assert (serializer != null);
            this.name = name;
            this.serializer = serializer;
        }

        @Override
        public DistinctBufferMaker<T> keepSize(boolean keepBufferSize) {
            this.keepsize = keepBufferSize;
            return this;
        }

        @Override
        public DistinctBufferMaker<T> useHeap(boolean useHeap) {
            this.useHeap = useHeap;
            return this;
        }

        @Override
        public DistinctBuffer<T> make() {
            DB.HTreeSetMaker maker = BufferManager.this.db(this.useHeap).createHashSet(this.name).serializer(this.serializer);
            if (this.keepsize) {
                maker = maker.counterEnable();
            }
            Set buffer = maker.make();
            return new CloseableDistinctBuffer(this.name, this.useHeap, buffer);
        }
    }

    protected final class MakeOrderedBuffer<T>
    implements QueueBufferMaker<T> {
        private final String name;
        private boolean useHeap = true;
        private final Serializer<T> serializer;

        protected MakeOrderedBuffer(String name, Serializer<T> serializer) {
            assert (name != null);
            assert (serializer != null);
            this.name = name;
            this.serializer = serializer;
        }

        @Override
        public MakeOrderedBuffer<T> useHeap(boolean useHeap) {
            this.useHeap = useHeap;
            return this;
        }

        @Override
        public QueueBuffer<T> make() {
            HTreeMap values = BufferManager.this.db(this.useHeap).createHashMap(this.name).valueSerializer(this.serializer).counterEnable().make();
            return new CloseableQueueBuffer(this.name, this.useHeap, values);
        }
    }

    protected final class CloseableSortingBufferWithDuplicates<K extends Comparable<K>, V>
    extends CloseableBuffer
    implements SortingBuffer<K, V> {
        private final NavigableMap<UniqueKey<K>, V> buffer;
        private final AtomicLong counter;

        protected CloseableSortingBufferWithDuplicates(String name, boolean onHeap, NavigableMap<UniqueKey<K>, V> buffer) {
            super(name, onHeap);
            this.counter = new AtomicLong();
            this.buffer = buffer;
        }

        @Override
        public boolean isEmpty() {
            return this.buffer.isEmpty();
        }

        @Override
        public long size() {
            return this.buffer.size();
        }

        @Override
        public void put(K sortable, V record) {
            this.buffer.put(new UniqueKey<K>(sortable, this.counter.incrementAndGet()), record);
        }

        @Override
        public Iterator<V> getAll(K key) {
            UniqueKey<K> lowest = new UniqueKey<K>(key, 0L);
            UniqueKey<K> pastHighest = new UniqueKey<K>(key, Long.MAX_VALUE);
            SortedMap<UniqueKey<K>, V> map = this.buffer.subMap(lowest, pastHighest);
            if (map == null || map.isEmpty()) {
                return null;
            }
            final Iterator<Map.Entry<UniqueKey<K>, V>> entryIter = map.entrySet().iterator();
            return new Iterator<V>(){

                @Override
                public boolean hasNext() {
                    return entryIter.hasNext();
                }

                @Override
                public V next() {
                    return ((Map.Entry)entryIter.next()).getValue();
                }

                @Override
                public void remove() {
                    entryIter.remove();
                }
            };
        }

        @Override
        public Iterator<V> getAll(K lowerKey, boolean includeLowerKey, K upperKey, boolean includeUpperKey) {
            UniqueKey<K> highest;
            UniqueKey<K> lowest = includeLowerKey ? new UniqueKey<K>(lowerKey, 0L) : new UniqueKey<K>(lowerKey, Long.MAX_VALUE);
            UniqueKey<K> uniqueKey = highest = includeUpperKey ? new UniqueKey<K>(upperKey, Long.MAX_VALUE) : new UniqueKey<K>(upperKey, 0L);
            if (upperKey == null) {
                if (lowerKey == null) {
                    return Collections.emptyList().iterator();
                }
                return this.buffer.tailMap(lowest, includeLowerKey).values().iterator();
            }
            if (lowerKey == null) {
                assert (upperKey != null);
                return this.buffer.headMap(highest, includeUpperKey).values().iterator();
            }
            assert (lowerKey != null);
            assert (upperKey != null);
            return this.buffer.subMap(lowest, includeLowerKey, highest, includeUpperKey).values().iterator();
        }

        @Override
        public Iterator<V> ascending() {
            final Iterator entryIter = this.buffer.entrySet().iterator();
            return new Iterator<V>(){

                @Override
                public boolean hasNext() {
                    return entryIter.hasNext();
                }

                @Override
                public V next() {
                    return ((Map.Entry)entryIter.next()).getValue();
                }

                @Override
                public void remove() {
                    entryIter.remove();
                }
            };
        }

        @Override
        public Iterator<V> descending() {
            final Iterator entryIter = this.buffer.descendingMap().entrySet().iterator();
            return new Iterator<V>(){

                @Override
                public boolean hasNext() {
                    return entryIter.hasNext();
                }

                @Override
                public V next() {
                    return ((Map.Entry)entryIter.next()).getValue();
                }

                @Override
                public void remove() {
                    entryIter.remove();
                }
            };
        }

        public String toString() {
            return "SortingBufferWithDuplicateKeys(" + this.name + ")";
        }
    }

    protected static final class UniqueKey<K> {
        protected final K actualKey;
        protected final long id;
        private final int hc;

        protected UniqueKey(K actualKey, long id) {
            this.actualKey = actualKey;
            this.id = id;
            this.hc = actualKey != null ? actualKey.hashCode() : 0;
        }

        public int hashCode() {
            return this.hc;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof UniqueKey) {
                UniqueKey that = (UniqueKey)obj;
                if (this.actualKey == null && that.actualKey != null) {
                    return false;
                }
                if (!this.actualKey.equals(that.actualKey)) {
                    return false;
                }
                return this.id == that.id;
            }
            return false;
        }

        public String toString() {
            return "[" + this.actualKey + "," + this.id + "]";
        }
    }

    protected final class CloseableSortingBuffer<K, V>
    extends CloseableBuffer
    implements SortingBuffer<K, V> {
        private final NavigableMap<K, V> buffer;

        protected CloseableSortingBuffer(String name, boolean onHeap, NavigableMap<K, V> buffer) {
            super(name, onHeap);
            this.buffer = buffer;
        }

        @Override
        public boolean isEmpty() {
            return this.buffer.isEmpty();
        }

        @Override
        public long size() {
            return this.buffer.size();
        }

        @Override
        public void put(K sortable, V record) {
            this.buffer.put(sortable, record);
        }

        @Override
        public Iterator<V> getAll(K key) {
            Object value = this.buffer.get(key);
            return value == null ? null : new SingleIterator(value);
        }

        @Override
        public Iterator<V> getAll(K lowerKey, boolean includeLowerKey, K upperKey, boolean includeUpperKey) {
            if (lowerKey == null) {
                if (upperKey == null) {
                    return this.buffer.values().iterator();
                }
                return this.buffer.headMap(upperKey, includeUpperKey).values().iterator();
            }
            assert (lowerKey != null);
            if (upperKey == null) {
                return this.buffer.tailMap(lowerKey, includeLowerKey).values().iterator();
            }
            return this.buffer.subMap(lowerKey, includeLowerKey, upperKey, includeUpperKey).values().iterator();
        }

        @Override
        public Iterator<V> ascending() {
            final Iterator entryIter = this.buffer.entrySet().iterator();
            return new Iterator<V>(){

                @Override
                public boolean hasNext() {
                    return entryIter.hasNext();
                }

                @Override
                public V next() {
                    return ((Map.Entry)entryIter.next()).getValue();
                }

                @Override
                public void remove() {
                    entryIter.remove();
                }
            };
        }

        @Override
        public Iterator<V> descending() {
            final Iterator entryIter = this.buffer.descendingMap().entrySet().iterator();
            return new Iterator<V>(){

                @Override
                public boolean hasNext() {
                    return entryIter.hasNext();
                }

                @Override
                public V next() {
                    return ((Map.Entry)entryIter.next()).getValue();
                }

                @Override
                public void remove() {
                    entryIter.remove();
                }
            };
        }

        public String toString() {
            return "SortingBuffer(" + this.name + ")";
        }
    }

    protected final class CloseableDistinctBuffer<T>
    extends CloseableBuffer
    implements DistinctBuffer<T> {
        private final Set<T> buffer;

        protected CloseableDistinctBuffer(String name, boolean onHeap, Set<T> buffer) {
            super(name, onHeap);
            this.buffer = buffer;
        }

        @Override
        public boolean isEmpty() {
            return this.buffer.isEmpty();
        }

        @Override
        public long size() {
            return this.buffer.size();
        }

        @Override
        public boolean contains(T value) {
            return !this.buffer.add(value);
        }

        @Override
        public Iterator<T> iterator() {
            return this.buffer.iterator();
        }

        public String toString() {
            return "DistinctBuffer(" + this.name + ")";
        }
    }

    protected final class CloseableQueueBuffer<T>
    extends CloseableBuffer
    implements QueueBuffer<T> {
        protected final Map<Long, T> buffer;
        private final AtomicLong size;

        protected CloseableQueueBuffer(String name, boolean onHeap, Map<Long, T> buffer) {
            super(name, onHeap);
            this.size = new AtomicLong();
            this.buffer = buffer;
        }

        @Override
        public boolean isEmpty() {
            return this.buffer.isEmpty();
        }

        @Override
        public long size() {
            return this.size.get();
        }

        @Override
        public void append(T value) {
            this.buffer.put(this.size.getAndIncrement(), value);
        }

        @Override
        public Iterator<T> iterator() {
            final AtomicLong counter = new AtomicLong(0L);
            return new Iterator<T>(){

                @Override
                public boolean hasNext() {
                    return counter.get() < (long)CloseableQueueBuffer.this.buffer.size();
                }

                @Override
                public T next() {
                    Long key = counter.getAndIncrement();
                    if (key.intValue() < CloseableQueueBuffer.this.buffer.size()) {
                        return CloseableQueueBuffer.this.buffer.get(key);
                    }
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public String toString() {
            return "QueueBuffer(" + this.name + ",size=" + this.size.get() + ")";
        }
    }

    protected abstract class CloseableBuffer
    implements Buffer {
        protected final String name;
        protected final boolean onHeap;

        protected CloseableBuffer(String name, boolean onHeap) {
            this.name = name;
            this.onHeap = onHeap;
        }

        @Override
        public void close() {
            BufferManager.this.delete(this.name, this.onHeap);
        }
    }

    protected static final class DbHolder
    implements AutoCloseable {
        private final AtomicReference<DB> reference = new AtomicReference();
        private final Lock lock = new ReentrantLock();
        private final Supplier<DB> supplier;

        protected DbHolder(Supplier<DB> supplier) {
            this.supplier = supplier;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DB get() {
            DB db = this.reference.get();
            if (db == null) {
                try {
                    this.lock.lock();
                    db = (DB)this.supplier.get();
                    this.reference.set(db);
                }
                finally {
                    this.lock.unlock();
                }
            }
            return db;
        }

        @Override
        public void close() {
            DB db = this.reference.getAndSet(null);
            if (db != null) {
                db.close();
            }
        }
    }

    public static interface SortingBufferMaker<SortType, RecordType> {
        public SortingBufferMaker<SortType, RecordType> useHeap(boolean var1);

        public SortingBufferMaker<SortType, RecordType> keepSize(boolean var1);

        public SortingBuffer<SortType, RecordType> make();
    }

    public static interface DistinctBufferMaker<T> {
        public DistinctBufferMaker<T> useHeap(boolean var1);

        public DistinctBufferMaker<T> keepSize(boolean var1);

        public DistinctBuffer<T> make();
    }

    public static interface QueueBufferMaker<T> {
        public QueueBufferMaker<T> useHeap(boolean var1);

        public QueueBuffer<T> make();
    }

    public static interface SortingBuffer<SortType, RecordType>
    extends Buffer {
        public void put(SortType var1, RecordType var2);

        public Iterator<RecordType> ascending();

        public Iterator<RecordType> descending();

        public Iterator<RecordType> getAll(SortType var1);

        public Iterator<RecordType> getAll(SortType var1, boolean var2, SortType var3, boolean var4);
    }

    public static interface DistinctBuffer<T>
    extends Buffer,
    Iterable<T>,
    Predicate<T> {
        @Override
        public Iterator<T> iterator();
    }

    public static interface Predicate<T> {
        public boolean contains(T var1);
    }

    public static interface QueueBuffer<T>
    extends Buffer,
    Iterable<T> {
        public void append(T var1);

        @Override
        public Iterator<T> iterator();
    }

    public static interface Buffer
    extends AutoCloseable {
        public boolean isEmpty();

        public long size();

        @Override
        public void close();
    }
}

