/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.RangeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import org.modeshape.common.annotation.NotThreadSafe;
import org.modeshape.common.collection.Problem;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.api.query.QueryResult;
import org.modeshape.jcr.cache.CachedNode;
import org.modeshape.jcr.cache.CachedNodeSupplier;
import org.modeshape.jcr.query.BufferManager;
import org.modeshape.jcr.query.JcrQueryContext;
import org.modeshape.jcr.query.NodeSequence;
import org.modeshape.jcr.query.QueryResults;
import org.modeshape.jcr.query.engine.process.RestartableSequence;

@NotThreadSafe
public class JcrQueryResult
implements QueryResult {
    public static final String JCR_SCORE_COLUMN_NAME = "jcr:score";
    public static final String JCR_PATH_COLUMN_NAME = "jcr:path";
    public static final String JCR_NAME_COLUMN_NAME = "jcr:name";
    public static final String JCR_UUID_COLUMN_NAME = "jcr:uuid";
    public static final String MODE_LOCALNAME_COLUMN_NAME = "mode:localName";
    public static final String MODE_DEPTH_COLUMN_NAME = "mode:depth";
    protected static final Set<String> PSEUDO_COLUMNS = org.modeshape.common.collection.Collections.unmodifiableSet((Object[])new String[]{"jcr:score", "jcr:path", "jcr:name", "jcr:uuid", "mode:localName", "mode:depth"});
    protected final JcrQueryContext context;
    protected final QueryResults results;
    protected final String queryStatement;
    private final NodeSequence sequence;
    private final boolean restartable;
    private List<String> warnings;
    private boolean accessed = false;

    protected JcrQueryResult(JcrQueryContext context, String query, QueryResults results, boolean restartable, int numRowsInMemory) {
        this.context = context;
        this.results = results;
        this.queryStatement = query;
        this.restartable = restartable;
        if (!restartable || results.getRows().isEmpty()) {
            this.sequence = results.getRows();
        } else {
            String workspace = context.getWorkspaceName();
            BufferManager bufferMgr = context.getBufferManager();
            CachedNodeSupplier nodeCache = results.getCachedNodes();
            this.sequence = new RestartableSequence(workspace, results.getRows(), bufferMgr, nodeCache, numRowsInMemory);
        }
        assert (this.context != null);
        assert (this.results != null);
        assert (this.queryStatement != null);
    }

    protected List<String> getColumnNameList() {
        return this.results.getColumns().getColumnNames();
    }

    protected List<String> getColumnTypeList() {
        return this.results.getColumns().getColumnTypes();
    }

    protected final NodeSequence sequence() {
        return this.sequence;
    }

    public String[] getColumnNames() {
        List<String> names = this.getColumnNameList();
        return names.toArray(new String[names.size()]);
    }

    public String[] getColumnTypes() {
        List<String> types = this.getColumnTypeList();
        return types.toArray(new String[types.size()]);
    }

    public String[] getSelectorNames() {
        List<String> selectorNames = this.results.getColumns().getSelectorNames();
        return selectorNames.toArray(new String[selectorNames.size()]);
    }

    public NodeIterator getNodes() throws RepositoryException {
        if (this.accessed) {
            if (!this.restartable) {
                throw new RepositoryException(JcrI18n.multipleCallsToGetRowsOrNodesIsNotAllowed.text(new Object[]{this.queryStatement}));
            }
            ((NodeSequence.Restartable)((Object)this.sequence)).restart();
        }
        if (this.getSelectorNames().length > 1) {
            throw new RepositoryException(JcrI18n.multipleSelectorsAppearInQueryUnableToCallMethod.text(new Object[]{this.queryStatement}));
        }
        this.accessed = true;
        int defaultSelectorIndex = this.computeDefaultSelectorIndex();
        return new QueryResultNodeIterator(this.context, this.sequence, defaultSelectorIndex);
    }

    protected int computeDefaultSelectorIndex() {
        QueryResults.Columns columns = this.results.getColumns();
        List<String> selectorNames = columns.getSelectorNames();
        if (selectorNames.size() == 1) {
            return columns.getSelectorIndex(selectorNames.get(0));
        }
        return 0;
    }

    public RowIterator getRows() throws RepositoryException {
        if (this.accessed) {
            if (!this.restartable) {
                throw new RepositoryException(JcrI18n.multipleCallsToGetRowsOrNodesIsNotAllowed.text(new Object[]{this.queryStatement}));
            }
            ((NodeSequence.Restartable)((Object)this.sequence)).restart();
        }
        this.accessed = true;
        QueryResults.Columns columns = this.results.getColumns();
        if (columns.getSelectorNames().size() == 1) {
            return new SingleSelectorQueryResultRowIterator(this.context, this.queryStatement, this.sequence, this.results.getColumns());
        }
        return new QueryResultRowIterator(this.context, this.queryStatement, this.sequence, this.results.getColumns());
    }

    public String getPlan() {
        return this.results.getPlan();
    }

    public Collection<String> getWarnings() {
        if (this.warnings == null) {
            if (!this.results.hasWarnings()) {
                this.warnings = Collections.emptyList();
            } else {
                LinkedList<String> messages = new LinkedList<String>();
                for (Problem problem : this.results.getProblems()) {
                    String msg;
                    if (problem.getStatus() != Problem.Status.WARNING || messages.contains(msg = problem.getMessageString())) continue;
                    messages.add(msg);
                }
                this.warnings = Collections.unmodifiableList(messages);
            }
        }
        return this.warnings;
    }

    public boolean isEmpty() {
        return false;
    }

    public String toString() {
        return this.results.toString();
    }

    public void close() {
        this.sequence.close();
    }

    protected static class MultiSelectorQueryResultRow
    extends AbstractRow {
        protected MultiSelectorQueryResultRow(QueryResultRowIterator iterator, NodeSequence.Batch batchAtRow) {
            super(iterator, batchAtRow);
        }

        public Value getValue(String columnName) throws ItemNotFoundException, RepositoryException {
            String selectorName = this.iterator.columns.getSelectorNameForColumnName(columnName);
            int nodeIndex = this.iterator.columns.getSelectorIndex(selectorName);
            if (nodeIndex == -1) {
                throw new RepositoryException(JcrI18n.queryResultsDoNotIncludeColumn.text(new Object[]{columnName, this.iterator.query}));
            }
            CachedNode cachedNode = this.batchAtRow.getNode(nodeIndex);
            return this.getValue(columnName, cachedNode, nodeIndex);
        }
    }

    protected static class SingleSelectorQueryResultRow
    extends AbstractRow {
        protected final CachedNode cachedNode;
        protected final Node node;
        protected final int selectorIndex;

        protected SingleSelectorQueryResultRow(QueryResultRowIterator iterator, NodeSequence.Batch batchAtRow, int selectorIndex) {
            super(iterator, batchAtRow);
            this.selectorIndex = selectorIndex;
            this.cachedNode = batchAtRow.getNode(selectorIndex);
            this.node = iterator.context.getNode(this.cachedNode);
        }

        @Override
        public Node getNode(String selectorName) throws RepositoryException {
            if (!this.iterator.hasSelector(selectorName)) {
                throw new RepositoryException(JcrI18n.selectorNotUsedInQuery.text(new Object[]{selectorName, this.iterator.query}));
            }
            return this.node;
        }

        public Value getValue(String columnName) throws ItemNotFoundException, RepositoryException {
            return this.getValue(columnName, this.cachedNode, this.selectorIndex);
        }

        @Override
        public Node getNode() {
            return this.node;
        }

        @Override
        public String getPath() throws RepositoryException {
            return this.node.getPath();
        }

        @Override
        public String getPath(String selectorName) throws RepositoryException {
            if (!this.iterator.hasSelector(selectorName)) {
                throw new RepositoryException(JcrI18n.selectorNotUsedInQuery.text(new Object[]{selectorName, this.iterator.query}));
            }
            return this.node.getPath();
        }

        @Override
        public double getScore() {
            return this.batchAtRow.getScore(this.selectorIndex);
        }

        @Override
        public double getScore(String selectorName) throws RepositoryException {
            if (!this.iterator.hasSelector(selectorName)) {
                throw new RepositoryException(JcrI18n.selectorNotUsedInQuery.text(new Object[]{selectorName, this.iterator.query}));
            }
            return this.getScore();
        }
    }

    protected static abstract class AbstractRow
    implements Row {
        protected final QueryResultRowIterator iterator;
        protected final NodeSequence.Batch batchAtRow;
        private Value[] values = null;

        protected AbstractRow(QueryResultRowIterator iterator, NodeSequence.Batch batchAtRow) {
            this.iterator = iterator;
            this.batchAtRow = batchAtRow;
            assert (this.iterator != null);
            assert (this.batchAtRow != null);
        }

        public Node getNode(String selectorName) throws RepositoryException {
            int nodeIndex = this.iterator.nodeIndexForSelector(selectorName);
            if (nodeIndex < 0) {
                throw new RepositoryException(JcrI18n.selectorNotUsedInQuery.text(new Object[]{selectorName, this.iterator.query}));
            }
            CachedNode cachedNode = this.batchAtRow.getNode(nodeIndex);
            return cachedNode == null ? null : this.iterator.context.getNode(cachedNode);
        }

        protected Value getValue(String columnName, CachedNode cachedNode, int nodeIndex) throws ItemNotFoundException, RepositoryException {
            Node node;
            if (cachedNode == null) {
                return null;
            }
            String propertyName = this.iterator.getPropertyNameForColumnName(columnName);
            if (propertyName == null) {
                return null;
            }
            if (PSEUDO_COLUMNS.contains(propertyName)) {
                if (JcrQueryResult.JCR_PATH_COLUMN_NAME.equals(propertyName)) {
                    return this.iterator.jcrPath(cachedNode);
                }
                if (JcrQueryResult.JCR_NAME_COLUMN_NAME.equals(propertyName)) {
                    return this.iterator.jcrName(cachedNode);
                }
                if (JcrQueryResult.MODE_LOCALNAME_COLUMN_NAME.equals(propertyName)) {
                    return this.iterator.jcrLocalName(cachedNode);
                }
                if (JcrQueryResult.MODE_DEPTH_COLUMN_NAME.equals(propertyName)) {
                    return this.iterator.jcrDepth(cachedNode);
                }
                if (JcrQueryResult.JCR_SCORE_COLUMN_NAME.equals(propertyName)) {
                    float score = this.batchAtRow.getScore(nodeIndex);
                    return this.iterator.jcrDouble(Float.valueOf(score));
                }
                if (JcrQueryResult.JCR_UUID_COLUMN_NAME.equals(propertyName)) {
                    return this.iterator.jcrUuid(cachedNode);
                }
            }
            if ((node = this.iterator.context.getNode(cachedNode)) == null || !node.hasProperty(propertyName)) {
                return null;
            }
            Property property = node.getProperty(propertyName);
            Value value = null;
            if (property.isMultiple()) {
                Value[] values = property.getValues();
                if (values.length > 0) {
                    value = property.getValues()[0];
                }
            } else {
                value = property.getValue();
            }
            return value;
        }

        public Value[] getValues() throws RepositoryException {
            if (this.values == null) {
                int i = 0;
                this.values = new Value[this.iterator.columnNames.size()];
                for (String columnName : this.iterator.columnNames) {
                    this.values[i++] = this.getValue(columnName);
                }
            }
            return this.values;
        }

        public Node getNode() throws RepositoryException {
            throw new RepositoryException(JcrI18n.multipleSelectorsAppearInQueryRequireSpecifyingSelectorName.text(new Object[]{this.iterator.query}));
        }

        public String getPath() throws RepositoryException {
            throw new RepositoryException(JcrI18n.multipleSelectorsAppearInQueryRequireSpecifyingSelectorName.text(new Object[]{this.iterator.query}));
        }

        public double getScore() throws RepositoryException {
            throw new RepositoryException(JcrI18n.multipleSelectorsAppearInQueryRequireSpecifyingSelectorName.text(new Object[]{this.iterator.query}));
        }

        public String getPath(String selectorName) throws RepositoryException {
            Node node = this.getNode(selectorName);
            return node == null ? null : node.getPath();
        }

        public double getScore(String selectorName) throws RepositoryException {
            if (!this.iterator.hasSelector(selectorName)) {
                throw new RepositoryException(JcrI18n.selectorNotUsedInQuery.text(new Object[]{selectorName, this.iterator.query}));
            }
            int nodeIndex = this.iterator.columns.getSelectorNames().indexOf(selectorName);
            return this.batchAtRow.getScore(nodeIndex);
        }
    }

    @NotThreadSafe
    protected static class SingleSelectorQueryResultRowIterator
    extends QueryResultRowIterator {
        private final int selectorIndex;

        protected SingleSelectorQueryResultRowIterator(JcrQueryContext context, String query, NodeSequence sequence, QueryResults.Columns columns) {
            super(context, query, sequence, columns);
            this.selectorIndex = columns.getSelectorIndex(columns.getSelectorNames().get(0));
        }

        @Override
        protected Row createRow(NodeSequence.Batch batch) {
            return new SingleSelectorQueryResultRow(this, batch, this.selectorIndex);
        }
    }

    @NotThreadSafe
    protected static class QueryResultRowIterator
    extends QueryResultIterator
    implements RowIterator {
        protected final List<String> columnNames;
        private final Set<String> selectorNames;
        protected final QueryResults.Columns columns;
        protected final String query;

        protected QueryResultRowIterator(JcrQueryContext context, String query, NodeSequence sequence, QueryResults.Columns columns) {
            super(context, sequence);
            this.query = query;
            this.columns = columns;
            this.columnNames = this.columns.getColumnNames();
            this.selectorNames = new HashSet<String>(columns.getSelectorNames());
        }

        public boolean hasSelector(String selectorName) {
            return this.selectorNames.contains(selectorName);
        }

        public Row nextRow() {
            return this.createRow(this.moveToNextRow());
        }

        public Object next() {
            return this.nextRow();
        }

        protected Row createRow(NodeSequence.Batch batch) {
            return new MultiSelectorQueryResultRow(this, batch);
        }

        protected String getPropertyNameForColumnName(String columnName) {
            return this.columns.getPropertyNameForColumnName(columnName);
        }

        protected int nodeIndexForSelector(String selector) {
            return this.columns.getSelectorIndex(selector);
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        protected Value jcrPath(CachedNode node) {
            assert (node != null);
            return this.context.createValue(8, this.context.getPath(node));
        }

        protected Value jcrUuid(CachedNode node) {
            assert (node != null);
            String uuid = this.context.getUuid(node);
            return uuid == null ? null : this.context.createValue(1, uuid);
        }

        protected Value jcrName(CachedNode node) {
            assert (node != null);
            return this.context.createValue(7, this.context.getName(node));
        }

        protected Value jcrLocalName(CachedNode node) {
            assert (node != null);
            return this.context.createValue(7, this.context.getName(node).getLocalName());
        }

        protected Value jcrDepth(CachedNode node) {
            assert (node != null);
            return this.context.createValue(3, this.context.getDepth(node));
        }

        protected Value jcrPath(String path) {
            return this.context.createValue(8, path);
        }

        protected Value jcrName(String name) {
            return this.context.createValue(7, name);
        }

        protected Value jcrName() {
            return this.context.createValue(7, "");
        }

        protected Value jcrString(String name) {
            return this.context.createValue(1, name);
        }

        protected Value jcrLong(Long value) {
            return this.context.createValue(3, value);
        }

        protected Value jcrDouble(Double score) {
            return this.context.createValue(4, score);
        }

        protected Value jcrDouble(Float score) {
            return this.context.createValue(4, score);
        }
    }

    @NotThreadSafe
    protected static class QueryResultNodeIterator
    extends QueryResultIterator
    implements NodeIterator {
        private final int defaultSelectorIndex;

        protected QueryResultNodeIterator(JcrQueryContext context, NodeSequence sequence, int defaultSelectorIndex) {
            super(context, sequence);
            this.defaultSelectorIndex = defaultSelectorIndex;
        }

        public Node nextNode() {
            CachedNode cachedNode = this.moveToNextRow().getNode(this.defaultSelectorIndex);
            Node node = this.context.getNode(cachedNode);
            return node;
        }

        public Object next() {
            return this.nextNode();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    @NotThreadSafe
    protected static abstract class QueryResultIterator
    implements RangeIterator {
        protected final JcrQueryContext context;
        private NodeSequence sequence;
        private long position = 0L;
        private NodeSequence.Batch currentBatch;

        protected QueryResultIterator(JcrQueryContext context, NodeSequence sequence) {
            this.context = context;
            this.sequence = sequence;
        }

        public boolean hasNext() {
            while (this.findNextBatch() != null) {
                if (this.currentBatch.hasNext()) {
                    return true;
                }
                this.currentBatch = null;
            }
            return false;
        }

        protected final NodeSequence.Batch moveToNextRow() {
            if (this.findNextBatch() == null || !this.currentBatch.hasNext()) {
                throw new NoSuchElementException();
            }
            this.currentBatch.nextRow();
            ++this.position;
            return this.currentBatch;
        }

        protected NodeSequence.Batch findNextBatch() {
            if (this.currentBatch == null) {
                this.currentBatch = this.sequence.nextBatch();
            }
            return this.currentBatch;
        }

        public long getPosition() {
            return this.position;
        }

        public void skip(long skipNum) {
            for (long i = 0L; i != skipNum; ++i) {
                this.moveToNextRow();
            }
        }

        public final long getSize() {
            return this.sequence.getRowCount();
        }
    }
}

