/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query.model;

import java.math.BigDecimal;
import java.net.URI;
import java.text.StringCharacterIterator;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.jcr.Binary;
import javax.jcr.Value;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.ExecutionContext;
import org.modeshape.jcr.api.value.DateTime;
import org.modeshape.jcr.query.model.AllNodes;
import org.modeshape.jcr.query.model.And;
import org.modeshape.jcr.query.model.ArithmeticOperand;
import org.modeshape.jcr.query.model.Between;
import org.modeshape.jcr.query.model.BindVariableName;
import org.modeshape.jcr.query.model.ChildNode;
import org.modeshape.jcr.query.model.ChildNodeJoinCondition;
import org.modeshape.jcr.query.model.Column;
import org.modeshape.jcr.query.model.Comparison;
import org.modeshape.jcr.query.model.DescendantNode;
import org.modeshape.jcr.query.model.DescendantNodeJoinCondition;
import org.modeshape.jcr.query.model.EquiJoinCondition;
import org.modeshape.jcr.query.model.FullTextSearch;
import org.modeshape.jcr.query.model.FullTextSearchScore;
import org.modeshape.jcr.query.model.Join;
import org.modeshape.jcr.query.model.Length;
import org.modeshape.jcr.query.model.Limit;
import org.modeshape.jcr.query.model.Literal;
import org.modeshape.jcr.query.model.LiteralValue;
import org.modeshape.jcr.query.model.LowerCase;
import org.modeshape.jcr.query.model.NamedSelector;
import org.modeshape.jcr.query.model.NodeDepth;
import org.modeshape.jcr.query.model.NodeLocalName;
import org.modeshape.jcr.query.model.NodeName;
import org.modeshape.jcr.query.model.NodePath;
import org.modeshape.jcr.query.model.Not;
import org.modeshape.jcr.query.model.Or;
import org.modeshape.jcr.query.model.Ordering;
import org.modeshape.jcr.query.model.PropertyExistence;
import org.modeshape.jcr.query.model.PropertyValue;
import org.modeshape.jcr.query.model.Query;
import org.modeshape.jcr.query.model.ReferenceValue;
import org.modeshape.jcr.query.model.Relike;
import org.modeshape.jcr.query.model.SameNode;
import org.modeshape.jcr.query.model.SameNodeJoinCondition;
import org.modeshape.jcr.query.model.SelectorName;
import org.modeshape.jcr.query.model.SetCriteria;
import org.modeshape.jcr.query.model.SetQuery;
import org.modeshape.jcr.query.model.StaticOperand;
import org.modeshape.jcr.query.model.Subquery;
import org.modeshape.jcr.query.model.UpperCase;
import org.modeshape.jcr.query.model.Visitable;
import org.modeshape.jcr.query.model.Visitor;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.NamespaceRegistry;
import org.modeshape.jcr.value.Path;
import org.modeshape.jcr.value.Reference;
import org.modeshape.jcr.value.StringFactory;
import org.modeshape.jcr.value.ValueFactories;

public class Visitors {
    protected static final char OPEN_SQUARE = '[';
    protected static final char CLOSE_SQUARE = ']';
    protected static final char DOUBLE_QUOTE = '\"';
    protected static final char SINGLE_QUOTE = '\'';
    private static final ExecutionContext DEFAULT_CONTEXT = new ExecutionContext();

    public static <StrategyVisitor extends Visitor> StrategyVisitor visitAll(Visitable visitable, StrategyVisitor strategyVisitor) {
        if (visitable != null) {
            visitable.accept(new WalkAllVisitor(strategyVisitor));
        }
        return strategyVisitor;
    }

    public static <StrategyVisitor extends Visitor> StrategyVisitor visitAll(Iterable<? extends Visitable> visitables, StrategyVisitor strategyVisitor) {
        if (visitables != null) {
            for (Visitable visitable : visitables) {
                if (visitable == null) continue;
                visitable.accept(new WalkAllVisitor(strategyVisitor));
            }
        }
        return strategyVisitor;
    }

    public static <GeneralVisitor extends Visitor> GeneralVisitor visit(Visitable visitable, GeneralVisitor visitor) {
        if (visitable != null) {
            visitable.accept(visitor);
        }
        return visitor;
    }

    public static String readable(Visitable visitable) {
        return Visitors.visit(visitable, new JcrSql2Writer(DEFAULT_CONTEXT)).getString();
    }

    public static String readable(Visitable visitable, ExecutionContext context) {
        return Visitors.visit(visitable, new JcrSql2Writer(context)).getString();
    }

    public static String readable(Object[] tuple) {
        return Visitors.readable(tuple, DEFAULT_CONTEXT);
    }

    public static String readable(Object[] tuple, ExecutionContext context) {
        if (tuple.length == 0) {
            return "||";
        }
        StringFactory stringFactory = context.getValueFactories().getStringFactory();
        StringBuilder sb = new StringBuilder();
        sb.append("| ");
        for (Object value : tuple) {
            if (value != null) {
                sb.append(' ');
                if (value instanceof Object[]) {
                    Object[] array = (Object[])value;
                    int len = array.length;
                    for (int i = 0; i != len; ++i) {
                        if (i != 0) {
                            sb.append(", ");
                        }
                        sb.append((String)stringFactory.create(array[i]));
                    }
                } else {
                    sb.append((String)stringFactory.create(value));
                }
            }
            sb.append(" |");
        }
        return sb.toString();
    }

    public static Collection<Subquery> subqueries(Visitable visitable, final boolean includeNestedSubqueries) {
        final LinkedList<Subquery> subqueries = new LinkedList<Subquery>();
        Visitors.visitAll(visitable, new AbstractVisitor(){

            @Override
            public void visit(Subquery subquery) {
                subqueries.add(subquery);
                if (includeNestedSubqueries) {
                    subquery.getQuery().accept(this);
                }
            }
        });
        return subqueries;
    }

    public static Map<SelectorName, SelectorName> getSelectorNamesByAlias(Visitable visitable) {
        final HashMap<SelectorName, SelectorName> result = new HashMap<SelectorName, SelectorName>();
        Visitors.visitAll(visitable, new AbstractVisitor(){

            @Override
            public void visit(AllNodes allNodes) {
                if (allNodes.hasAlias()) {
                    result.put(allNodes.alias(), allNodes.name());
                }
            }

            @Override
            public void visit(NamedSelector selector) {
                if (selector.hasAlias()) {
                    result.put(selector.alias(), selector.name());
                }
            }
        });
        return result;
    }

    public static Map<SelectorName, SelectorName> getSelectorAliasesByName(Visitable visitable) {
        final HashMap<SelectorName, SelectorName> result = new HashMap<SelectorName, SelectorName>();
        Visitors.visitAll(visitable, new AbstractVisitor(){

            @Override
            public void visit(AllNodes allNodes) {
                if (allNodes.hasAlias()) {
                    result.put(allNodes.name(), allNodes.aliasOrName());
                }
            }

            @Override
            public void visit(NamedSelector selector) {
                if (selector.hasAlias()) {
                    result.put(selector.name(), selector.aliasOrName());
                }
            }
        });
        return result;
    }

    public static Set<SelectorName> getSelectorsReferencedBy(Visitable visitable) {
        final HashSet<SelectorName> symbols = new HashSet<SelectorName>();
        Visitors.visitAll(visitable, new AbstractVisitor(){

            @Override
            public void visit(AllNodes allNodes) {
                if (allNodes.hasAlias()) {
                    symbols.add(allNodes.alias());
                } else {
                    symbols.add(allNodes.name());
                }
            }

            @Override
            public void visit(ChildNode childNode) {
                symbols.add(childNode.selectorName());
            }

            @Override
            public void visit(ChildNodeJoinCondition joinCondition) {
                symbols.add(joinCondition.childSelectorName());
                symbols.add(joinCondition.parentSelectorName());
            }

            @Override
            public void visit(Column column) {
                symbols.add(column.selectorName());
            }

            @Override
            public void visit(DescendantNode descendant) {
                symbols.add(descendant.selectorName());
            }

            @Override
            public void visit(DescendantNodeJoinCondition joinCondition) {
                symbols.add(joinCondition.ancestorSelectorName());
                symbols.add(joinCondition.descendantSelectorName());
            }

            @Override
            public void visit(EquiJoinCondition joinCondition) {
                symbols.add(joinCondition.selector1Name());
                symbols.add(joinCondition.selector2Name());
            }

            @Override
            public void visit(FullTextSearch fullTextSearch) {
                symbols.add(fullTextSearch.selectorName());
            }

            @Override
            public void visit(FullTextSearchScore fullTextSearchScore) {
                symbols.add(fullTextSearchScore.selectorName());
            }

            @Override
            public void visit(Length length) {
                symbols.add(length.selectorName());
            }

            @Override
            public void visit(NodeDepth depth) {
                symbols.add(depth.selectorName());
            }

            @Override
            public void visit(NodePath path) {
                symbols.add(path.selectorName());
            }

            @Override
            public void visit(NodeLocalName node) {
                symbols.add(node.selectorName());
            }

            @Override
            public void visit(NodeName node) {
                symbols.add(node.selectorName());
            }

            @Override
            public void visit(NamedSelector node) {
                if (node.hasAlias()) {
                    symbols.add(node.alias());
                } else {
                    symbols.add(node.name());
                }
            }

            @Override
            public void visit(PropertyExistence prop) {
                symbols.add(prop.selectorName());
            }

            @Override
            public void visit(PropertyValue prop) {
                symbols.add(prop.selectorName());
            }

            @Override
            public void visit(Subquery obj) {
            }

            @Override
            public void visit(ReferenceValue ref) {
                symbols.add(ref.selectorName());
            }

            @Override
            public void visit(SameNode node) {
                symbols.add(node.selectorName());
            }

            @Override
            public void visit(SameNodeJoinCondition joinCondition) {
                symbols.add(joinCondition.selector1Name());
                symbols.add(joinCondition.selector2Name());
            }
        });
        return symbols;
    }

    public static class JcrSql2Writer
    extends ReadableVisitor {
        public JcrSql2Writer(ExecutionContext context) {
            super(context);
        }

        protected final boolean needsQuotes(String str) {
            StringCharacterIterator iter = new StringCharacterIterator(str);
            char c = iter.first();
            while (c != '\uffff') {
                if (!Character.isLetterOrDigit(c)) {
                    return true;
                }
                c = iter.next();
            }
            return false;
        }

        protected void appendQuoted(char openQuote, String name, char closeQuote) {
            if (this.needsQuotes(name)) {
                this.append('[');
                this.append(name);
                this.append(']');
            } else {
                this.append(name);
            }
        }

        @Override
        protected ReadableVisitor append(String string) {
            return super.append(string);
        }

        @Override
        protected ReadableVisitor append(char character) {
            return super.append(character);
        }

        @Override
        protected ReadableVisitor append(int value) {
            return super.append(value);
        }

        @Override
        protected ReadableVisitor appendColumnName(String columnName) {
            this.appendQuoted('[', columnName, ']');
            return this;
        }

        @Override
        protected ReadableVisitor appendPropertyName(String propertyName) {
            this.appendQuoted('[', propertyName, ']');
            return this;
        }

        @Override
        protected ReadableVisitor appendAlias(String alias) {
            this.appendQuoted('[', alias, ']');
            return this;
        }

        @Override
        protected ReadableVisitor append(SelectorName name) {
            this.appendQuoted('[', name.name(), ']');
            return this;
        }

        @Override
        public void visit(Ordering ordering) {
            ordering.getOperand().accept(this);
            this.append(' ').append(ordering.order().symbol());
            this.append(' ').append(ordering.nullOrder().symbol());
        }
    }

    public static class ReadableVisitor
    implements Visitor {
        protected final StringBuilder sb = new StringBuilder();
        protected final ExecutionContext context;
        protected final NamespaceRegistry registry;

        public ReadableVisitor(ExecutionContext context) {
            CheckArg.isNotNull((Object)context, (String)"context");
            this.context = context;
            this.registry = context == null ? null : context.getNamespaceRegistry();
        }

        protected ReadableVisitor appendAlias(String columnName) {
            this.append(columnName);
            return this;
        }

        protected ReadableVisitor appendColumnName(String columnName) {
            this.append(columnName);
            return this;
        }

        protected ReadableVisitor appendPropertyName(String columnName) {
            this.append(columnName);
            return this;
        }

        protected ReadableVisitor append(String string) {
            this.sb.append(string);
            return this;
        }

        protected ReadableVisitor append(char character) {
            this.sb.append(character);
            return this;
        }

        protected ReadableVisitor append(int value) {
            this.sb.append(value);
            return this;
        }

        protected ReadableVisitor append(SelectorName name) {
            this.sb.append(name.getString());
            return this;
        }

        protected ReadableVisitor append(Name name) {
            this.append('\'');
            this.append(name.getString(this.registry, null, null));
            this.append('\'');
            return this;
        }

        protected ReadableVisitor append(Path path) {
            this.sb.append('\'');
            this.sb.append(path.getString(this.registry));
            this.sb.append('\'');
            return this;
        }

        public final ExecutionContext getContext() {
            return this.context;
        }

        public final String getString() {
            return this.sb.toString();
        }

        public String toString() {
            return this.sb.toString();
        }

        @Override
        public void visit(AllNodes allNodes) {
            this.append(allNodes.name());
            if (allNodes.hasAlias()) {
                this.append(" AS ").append(allNodes.alias());
            }
        }

        @Override
        public void visit(And and) {
            this.append('(');
            and.left().accept(this);
            this.append(" AND ");
            and.right().accept(this);
            this.append(')');
        }

        @Override
        public void visit(ArithmeticOperand arithmeticOperand) {
            this.append('(');
            arithmeticOperand.getLeft().accept(this);
            this.append(' ');
            this.append(arithmeticOperand.operator().symbol());
            this.append(' ');
            arithmeticOperand.getRight().accept(this);
            this.append(')');
        }

        @Override
        public void visit(Between between) {
            between.getOperand().accept(this);
            this.append(" BETWEEN ");
            between.getLowerBound().accept(this);
            if (!between.isLowerBoundIncluded()) {
                this.append(" EXCLUSIVE");
            }
            this.append(" AND ");
            between.getUpperBound().accept(this);
            if (!between.isUpperBoundIncluded()) {
                this.append(" EXCLUSIVE");
            }
        }

        @Override
        public void visit(BindVariableName variable) {
            this.append('$').append(variable.getBindVariableName());
        }

        @Override
        public void visit(ChildNode child) {
            this.append("ISCHILDNODE(");
            this.append(child.selectorName());
            this.append(',');
            this.append('\'');
            this.append(child.getParentPath());
            this.append('\'');
            this.append(')');
        }

        @Override
        public void visit(ChildNodeJoinCondition condition) {
            this.append("ISCHILDNODE(");
            this.append(condition.childSelectorName());
            this.append(',');
            this.append(condition.parentSelectorName());
            this.append(')');
        }

        @Override
        public void visit(Column column) {
            this.append(column.selectorName());
            if (column.getPropertyName() == null) {
                this.append(".*");
            } else {
                String propertyName = column.getPropertyName();
                this.append('.').appendPropertyName(propertyName);
                if (!(propertyName.equals(column.getColumnName()) || propertyName.equals(column.getColumnName()) || (column.selectorName() + "." + propertyName).equals(column.getColumnName()))) {
                    this.append(" AS ").appendAlias(column.getColumnName());
                }
            }
        }

        @Override
        public void visit(Comparison comparison) {
            comparison.getOperand1().accept(this);
            this.append(' ').append(comparison.operator().symbol()).append(' ');
            comparison.getOperand2().accept(this);
        }

        @Override
        public void visit(Relike relike) {
            this.append("RELIKE(");
            relike.getOperand1().accept(this);
            this.append(',');
            relike.getOperand2().accept(this);
            this.append(')');
        }

        @Override
        public void visit(DescendantNode descendant) {
            this.append("ISDESCENDANTNODE(");
            this.append(descendant.selectorName());
            this.append(',');
            this.append('\'');
            this.append(descendant.getAncestorPath());
            this.append('\'');
            this.append(')');
        }

        @Override
        public void visit(DescendantNodeJoinCondition condition) {
            this.append("ISDESCENDANTNODE(");
            this.append(condition.descendantSelectorName());
            this.append(',');
            this.append(condition.ancestorSelectorName());
            this.append(')');
        }

        @Override
        public void visit(EquiJoinCondition condition) {
            this.append(condition.selector1Name()).append('.').appendPropertyName(condition.getProperty1Name());
            this.append(" = ");
            this.append(condition.selector2Name()).append('.').appendPropertyName(condition.getProperty2Name());
        }

        @Override
        public void visit(FullTextSearch fullText) {
            this.append("CONTAINS(").append(fullText.selectorName());
            if (fullText.getPropertyName() != null) {
                this.append('.').appendPropertyName(fullText.getPropertyName());
            }
            this.sb.append(",'").append(fullText.fullTextSearchExpression()).append("')");
        }

        @Override
        public void visit(FullTextSearchScore score) {
            this.append("SCORE(").append(score.selectorName()).append(')');
        }

        @Override
        public void visit(Join join) {
            join.getLeft().accept(this);
            this.sb.append(' ').append(join.type().symbol());
            this.append(' ');
            join.getRight().accept(this);
            this.append(" ON ");
            join.getJoinCondition().accept(this);
        }

        @Override
        public void visit(Length length) {
            this.append("LENGTH(");
            length.getPropertyValue().accept(this);
            this.append(')');
        }

        @Override
        public void visit(Limit limit) {
            this.append("LIMIT ").append(limit.getRowLimit());
            if (limit.getOffset() != 0) {
                this.append(" OFFSET ").append(limit.getOffset());
            }
        }

        @Override
        public void visit(Literal literal) {
            if (literal instanceof LiteralValue) {
                LiteralValue literalValue = (LiteralValue)literal;
                Value value = literalValue.getLiteralValue();
                String typeName = null;
                ValueFactories factories = this.context.getValueFactories();
                switch (value.getType()) {
                    case 0: 
                    case 1: {
                        this.append('\'');
                        String str = (String)factories.getStringFactory().create(literalValue.value());
                        this.append(str);
                        this.append('\'');
                        return;
                    }
                    case 8: {
                        this.append("CAST(");
                        this.append((Path)factories.getPathFactory().create(literalValue.value()));
                        this.append(" AS ").append("Path".toUpperCase()).append(')');
                        return;
                    }
                    case 7: {
                        this.append("CAST(");
                        this.append((Name)factories.getNameFactory().create(literalValue.value()));
                        this.append(" AS ").append("Name".toUpperCase()).append(')');
                        return;
                    }
                    case 9: {
                        typeName = "Reference";
                        break;
                    }
                    case 10: {
                        typeName = "WeakReference";
                        break;
                    }
                    case 100: {
                        typeName = "SimpleReference";
                        break;
                    }
                    case 2: {
                        typeName = "Binary";
                        break;
                    }
                    case 6: {
                        typeName = "Boolean";
                        break;
                    }
                    case 5: {
                        typeName = "Date";
                        break;
                    }
                    case 12: {
                        typeName = "Decimal";
                        break;
                    }
                    case 4: {
                        typeName = "Double";
                        break;
                    }
                    case 3: {
                        typeName = "Long";
                        break;
                    }
                    case 11: {
                        typeName = "URI";
                    }
                }
                assert (typeName != null);
                String str = (String)factories.getStringFactory().create(literalValue.value());
                this.append("CAST('").append(str).append("' AS ").append(typeName.toUpperCase()).append(')');
            } else {
                Object value = literal.value();
                String typeName = null;
                ValueFactories factories = this.context.getValueFactories();
                if (value instanceof String || value instanceof Character) {
                    this.append('\'');
                    String str = (String)factories.getStringFactory().create(value);
                    this.append(str);
                    this.append('\'');
                    return;
                }
                if (value instanceof Path) {
                    this.append("CAST(");
                    this.append((Path)factories.getPathFactory().create(value));
                    this.append(" AS ").append("Path".toUpperCase()).append(')');
                    return;
                }
                if (value instanceof Name) {
                    this.append("CAST(");
                    this.append((Name)factories.getNameFactory().create(value));
                    this.append(" AS ").append("Name".toUpperCase()).append(')');
                    return;
                }
                if (value instanceof Reference) {
                    typeName = ((Reference)value).isWeak() ? "WeakReference".toUpperCase() : "Reference".toUpperCase();
                } else if (value instanceof Binary) {
                    typeName = "Binary".toUpperCase();
                } else if (value instanceof Boolean) {
                    typeName = "Boolean".toUpperCase();
                } else if (value instanceof DateTime) {
                    typeName = "Date".toUpperCase();
                } else if (value instanceof BigDecimal) {
                    typeName = "Decimal".toUpperCase();
                } else if (value instanceof Double || value instanceof Float) {
                    typeName = "Double".toUpperCase();
                } else if (value instanceof Long || value instanceof Integer || value instanceof Short) {
                    typeName = "Long".toUpperCase();
                } else if (value instanceof URI) {
                    typeName = "URI".toUpperCase();
                }
                assert (typeName != null);
                String str = (String)factories.getStringFactory().create(value);
                this.append("CAST('").append(str).append("' AS ").append(typeName.toUpperCase()).append(')');
            }
        }

        @Override
        public void visit(LowerCase lowerCase) {
            this.append("LOWER(");
            lowerCase.getOperand().accept(this);
            this.append(')');
        }

        @Override
        public void visit(NodeDepth depth) {
            this.append("DEPTH(").append(depth.selectorName()).append(')');
        }

        @Override
        public void visit(NodePath path) {
            this.append("PATH(").append(path.selectorName()).append(')');
        }

        @Override
        public void visit(NodeLocalName name) {
            this.append("LOCALNAME(").append(name.selectorName()).append(')');
        }

        @Override
        public void visit(NodeName name) {
            this.append("NAME(").append(name.selectorName()).append(')');
        }

        @Override
        public void visit(NamedSelector selector) {
            this.append(selector.name());
            if (selector.hasAlias()) {
                this.append(" AS ").append(selector.alias());
            }
        }

        @Override
        public void visit(Not not) {
            this.append("NOT ");
            this.append('(');
            not.getConstraint().accept(this);
            this.append(')');
        }

        @Override
        public void visit(Or or) {
            this.append('(');
            or.left().accept(this);
            this.append(" OR ");
            or.right().accept(this);
            this.append(')');
        }

        @Override
        public void visit(Ordering ordering) {
            ordering.getOperand().accept(this);
            this.append(' ').append(ordering.order().symbol());
        }

        @Override
        public void visit(PropertyExistence existence) {
            this.append(existence.selectorName()).append('.').appendPropertyName(existence.getPropertyName()).append(" IS NOT NULL");
        }

        @Override
        public void visit(PropertyValue value) {
            this.append(value.selectorName()).append('.').appendPropertyName(value.getPropertyName());
        }

        @Override
        public void visit(ReferenceValue value) {
            this.append("REFERENCE(");
            this.append(value.selectorName());
            if (value.getPropertyName() != null) {
                this.append('.').appendPropertyName(value.getPropertyName());
            }
            this.append(")");
        }

        @Override
        public void visit(Query query) {
            boolean isFirst;
            this.append("SELECT ");
            if (query.isDistinct()) {
                this.append("DISTINCT ");
            }
            if (query.columns().isEmpty()) {
                this.append('*');
            } else {
                isFirst = true;
                for (Column column : query.columns()) {
                    if (isFirst) {
                        isFirst = false;
                    } else {
                        this.append(", ");
                    }
                    column.accept(this);
                }
            }
            this.append(" FROM ");
            query.source().accept(this);
            if (query.constraint() != null) {
                this.append(" WHERE ");
                query.constraint().accept(this);
            }
            if (!query.orderings().isEmpty()) {
                this.append(" ORDER BY ");
                isFirst = true;
                for (Ordering ordering : query.orderings()) {
                    if (isFirst) {
                        isFirst = false;
                    } else {
                        this.append(", ");
                    }
                    ordering.accept(this);
                }
            }
            if (!query.getLimits().isUnlimited()) {
                this.append(' ');
                query.getLimits().accept(this);
            }
        }

        @Override
        public void visit(Subquery subquery) {
            this.append('(');
            subquery.getQuery().accept(this);
            this.append(')');
        }

        @Override
        public void visit(SameNode sameNode) {
            this.append("ISSAMENODE(").append(sameNode.selectorName()).append(",'").append(sameNode.getPath()).append("')");
        }

        @Override
        public void visit(SameNodeJoinCondition condition) {
            this.append("ISSAMENODE(").append(condition.selector1Name()).append(',').append(condition.selector2Name());
            if (condition.getSelector2Path() != null) {
                this.append(",'").append(condition.getSelector2Path()).append('\'');
            }
            this.append(')');
        }

        @Override
        public void visit(SetCriteria criteria) {
            criteria.leftOperand().accept(this);
            this.append(" IN (");
            Iterator<? extends StaticOperand> iter = criteria.rightOperands().iterator();
            if (iter.hasNext()) {
                iter.next().accept(this);
                while (iter.hasNext()) {
                    this.append(',');
                    iter.next().accept(this);
                }
            }
            this.append(')');
        }

        @Override
        public void visit(SetQuery query) {
            query.getLeft().accept(this);
            this.append(' ').append(query.operation().getSymbol()).append(' ');
            if (query.isAll()) {
                this.append("ALL ");
            }
            query.getRight().accept(this);
        }

        @Override
        public void visit(UpperCase upperCase) {
            this.append("UPPER(");
            upperCase.getOperand().accept(this);
            this.append(')');
        }
    }

    public static class WalkAllVisitor
    extends NavigationVisitor {
        public WalkAllVisitor(Visitor strategy) {
            super(strategy);
        }

        @Override
        public void visit(AllNodes allNodes) {
            this.strategy.visit(allNodes);
            this.visitNext();
        }

        @Override
        public void visit(And and) {
            this.strategy.visit(and);
            this.enqueue(and.left());
            this.enqueue(and.right());
            this.visitNext();
        }

        @Override
        public void visit(ArithmeticOperand arithmeticOperation) {
            this.strategy.visit(arithmeticOperation);
            this.enqueue(arithmeticOperation.getLeft());
            this.enqueue(arithmeticOperation.getRight());
            this.visitNext();
        }

        @Override
        public void visit(Between between) {
            this.strategy.visit(between);
            this.enqueue(between.getOperand());
            this.enqueue(between.getLowerBound());
            this.enqueue(between.getUpperBound());
            this.visitNext();
        }

        @Override
        public void visit(BindVariableName variableName) {
            this.strategy.visit(variableName);
            this.visitNext();
        }

        @Override
        public void visit(ChildNode child) {
            this.strategy.visit(child);
            this.visitNext();
        }

        @Override
        public void visit(ChildNodeJoinCondition joinCondition) {
            this.strategy.visit(joinCondition);
            this.visitNext();
        }

        @Override
        public void visit(Column column) {
            this.strategy.visit(column);
            this.visitNext();
        }

        @Override
        public void visit(Comparison comparison) {
            this.strategy.visit(comparison);
            this.enqueue(comparison.getOperand1());
            this.enqueue(comparison.getOperand2());
            this.visitNext();
        }

        @Override
        public void visit(Relike relike) {
            this.strategy.visit(relike);
            this.enqueue(relike.getOperand1());
            this.enqueue(relike.getOperand2());
            this.visitNext();
        }

        @Override
        public void visit(DescendantNode descendant) {
            this.strategy.visit(descendant);
            this.visitNext();
        }

        @Override
        public void visit(DescendantNodeJoinCondition condition) {
            this.strategy.visit(condition);
            this.visitNext();
        }

        @Override
        public void visit(EquiJoinCondition condition) {
            this.strategy.visit(condition);
            this.visitNext();
        }

        @Override
        public void visit(FullTextSearch fullTextSearch) {
            this.strategy.visit(fullTextSearch);
            this.enqueue(fullTextSearch.getFullTextSearchExpression());
            this.visitNext();
        }

        @Override
        public void visit(FullTextSearchScore score) {
            this.strategy.visit(score);
            this.visitNext();
        }

        @Override
        public void visit(Join join) {
            this.strategy.visit(join);
            this.enqueue(join.getLeft());
            this.enqueue(join.getJoinCondition());
            this.enqueue(join.getRight());
            this.visitNext();
        }

        @Override
        public void visit(Length length) {
            this.strategy.visit(length);
            this.visitNext();
        }

        @Override
        public void visit(Limit limit) {
            this.strategy.visit(limit);
            this.visitNext();
        }

        @Override
        public void visit(Literal literal) {
            this.strategy.visit(literal);
            this.visitNext();
        }

        @Override
        public void visit(LowerCase lowerCase) {
            this.strategy.visit(lowerCase);
            this.enqueue(lowerCase.getOperand());
            this.visitNext();
        }

        @Override
        public void visit(NodeDepth depth) {
            this.strategy.visit(depth);
            this.visitNext();
        }

        @Override
        public void visit(NodePath path) {
            this.strategy.visit(path);
            this.visitNext();
        }

        @Override
        public void visit(NodeName nodeName) {
            this.strategy.visit(nodeName);
            this.visitNext();
        }

        @Override
        public void visit(NodeLocalName nodeLocalName) {
            this.strategy.visit(nodeLocalName);
            this.visitNext();
        }

        @Override
        public void visit(NamedSelector selector) {
            this.strategy.visit(selector);
            this.visitNext();
        }

        @Override
        public void visit(Not not) {
            this.strategy.visit(not);
            this.enqueue(not.getConstraint());
            this.visitNext();
        }

        @Override
        public void visit(Or or) {
            this.strategy.visit(or);
            this.enqueue(or.left());
            this.enqueue(or.right());
            this.visitNext();
        }

        @Override
        public void visit(Ordering ordering) {
            this.strategy.visit(ordering);
            this.enqueue(ordering.getOperand());
            this.visitNext();
        }

        @Override
        public void visit(PropertyExistence existence) {
            this.strategy.visit(existence);
            this.visitNext();
        }

        @Override
        public void visit(PropertyValue propertyValue) {
            this.strategy.visit(propertyValue);
            this.visitNext();
        }

        @Override
        public void visit(Query query) {
            this.strategy.visit(query);
            this.enqueue(query.source());
            this.enqueue(query.columns());
            this.enqueue(query.constraint());
            this.enqueue(query.orderings());
            this.visitNext();
        }

        @Override
        public void visit(Subquery subquery) {
            this.strategy.visit(subquery);
            this.enqueue(subquery.getQuery());
            this.visitNext();
        }

        @Override
        public void visit(ReferenceValue referenceValue) {
            this.strategy.visit(referenceValue);
            this.visitNext();
        }

        @Override
        public void visit(SameNode sameNode) {
            this.strategy.visit(sameNode);
            this.visitNext();
        }

        @Override
        public void visit(SameNodeJoinCondition condition) {
            this.strategy.visit(condition);
            this.visitNext();
        }

        @Override
        public void visit(SetCriteria setCriteria) {
            this.strategy.visit(setCriteria);
            this.enqueue(setCriteria.leftOperand());
            for (StaticOperand staticOperand : setCriteria.rightOperands()) {
                this.enqueue(staticOperand);
            }
            this.visitNext();
        }

        @Override
        public void visit(SetQuery setQuery) {
            this.strategy.visit(setQuery);
            this.enqueue(setQuery.getLeft());
            this.enqueue(setQuery.getRight());
            this.visitNext();
        }

        @Override
        public void visit(UpperCase upperCase) {
            this.strategy.visit(upperCase);
            this.enqueue(upperCase.getOperand());
            this.visitNext();
        }
    }

    public static abstract class NavigationVisitor
    implements Visitor {
        protected final Visitor strategy;
        private final LinkedList<? super Visitable> itemQueue = new LinkedList();

        protected NavigationVisitor(Visitor strategy) {
            assert (strategy != null);
            this.strategy = strategy;
        }

        protected void enqueue(Visitable objectToBeVisited) {
            if (objectToBeVisited != null) {
                this.itemQueue.add(objectToBeVisited);
            }
        }

        protected void enqueue(Iterable<? extends Visitable> objectsToBeVisited) {
            for (Visitable visitable : objectsToBeVisited) {
                this.enqueue(visitable);
            }
        }

        protected final void visitNext() {
            if (!this.itemQueue.isEmpty()) {
                Visitable first = this.itemQueue.removeFirst();
                assert (first != null);
                first.accept(this);
            }
        }
    }

    public static class AbstractVisitor
    implements Visitor {
        @Override
        public void visit(AllNodes obj) {
        }

        @Override
        public void visit(And obj) {
        }

        @Override
        public void visit(ArithmeticOperand obj) {
        }

        @Override
        public void visit(Between obj) {
        }

        @Override
        public void visit(BindVariableName obj) {
        }

        @Override
        public void visit(ChildNode obj) {
        }

        @Override
        public void visit(ChildNodeJoinCondition obj) {
        }

        @Override
        public void visit(Column obj) {
        }

        @Override
        public void visit(Comparison obj) {
        }

        @Override
        public void visit(DescendantNode obj) {
        }

        @Override
        public void visit(DescendantNodeJoinCondition obj) {
        }

        @Override
        public void visit(EquiJoinCondition obj) {
        }

        @Override
        public void visit(FullTextSearch obj) {
        }

        @Override
        public void visit(FullTextSearchScore obj) {
        }

        @Override
        public void visit(Join obj) {
        }

        @Override
        public void visit(Length obj) {
        }

        @Override
        public void visit(Limit limit) {
        }

        @Override
        public void visit(Literal obj) {
        }

        @Override
        public void visit(LowerCase obj) {
        }

        @Override
        public void visit(NodeDepth obj) {
        }

        @Override
        public void visit(NodePath obj) {
        }

        @Override
        public void visit(NodeName obj) {
        }

        @Override
        public void visit(NodeLocalName obj) {
        }

        @Override
        public void visit(NamedSelector obj) {
        }

        @Override
        public void visit(Not obj) {
        }

        @Override
        public void visit(Or obj) {
        }

        @Override
        public void visit(Ordering obj) {
        }

        @Override
        public void visit(PropertyExistence obj) {
        }

        @Override
        public void visit(PropertyValue obj) {
        }

        @Override
        public void visit(Query obj) {
        }

        @Override
        public void visit(Subquery obj) {
        }

        @Override
        public void visit(ReferenceValue obj) {
        }

        @Override
        public void visit(SameNode obj) {
        }

        @Override
        public void visit(SameNodeJoinCondition obj) {
        }

        @Override
        public void visit(SetCriteria obj) {
        }

        @Override
        public void visit(SetQuery obj) {
        }

        @Override
        public void visit(UpperCase obj) {
        }

        @Override
        public void visit(Relike obj) {
        }
    }
}

