/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.git;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.infinispan.schematic.document.Document;
import org.modeshape.common.i18n.I18nResource;
import org.modeshape.connector.git.CallSpecification;
import org.modeshape.connector.git.GitConnector;
import org.modeshape.connector.git.GitFunction;
import org.modeshape.connector.git.GitI18n;
import org.modeshape.connector.git.GitLexicon;
import org.modeshape.connector.git.GitTree;
import org.modeshape.connector.git.PageableGitFunction;
import org.modeshape.connector.git.Values;
import org.modeshape.jcr.spi.federation.DocumentWriter;
import org.modeshape.jcr.spi.federation.PageKey;
import org.modeshape.jcr.spi.federation.PageWriter;

public class GitCommitDetails
extends GitFunction
implements PageableGitFunction {
    public static final String DIFF_CHARSET_NAME = "UTF-8";
    protected static final String NAME = "commit";
    protected static final String ID = "/commit";

    protected static Object referenceToCommit(ObjectId id, Values values) {
        return values.referenceTo("/commit/" + id.getName());
    }

    protected static Object[] referencesToCommits(ObjectId[] ids, Values values) {
        int size = ids.length;
        Object[] results = new Object[size];
        for (int i = 0; i != size; ++i) {
            results[i] = GitCommitDetails.referenceToCommit(ids[i], values);
        }
        return results;
    }

    public GitCommitDetails(GitConnector connector) {
        super(NAME, connector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Document execute(Repository repository, Git git, CallSpecification spec, DocumentWriter writer, Values values) throws GitAPIException, IOException {
        if (spec.parameterCount() == 0) {
            writer.setPrimaryType(GitLexicon.DETAILS);
            this.addBranchesAsChildren(git, spec, writer);
            this.addTagsAsChildren(git, spec, writer);
            this.addCommitsAsChildren(git, spec, writer, this.pageSize);
        } else if (spec.parameterCount() == 1) {
            writer.setPrimaryType(GitLexicon.DETAILED_COMMIT);
            RevWalk walker = new RevWalk(repository);
            walker.setRetainBody(true);
            try {
                String branchOrTagOrCommitId = spec.parameter(0);
                ObjectId objId = this.resolveBranchOrTagOrCommitId(repository, branchOrTagOrCommitId);
                RevCommit commit = walker.parseCommit((AnyObjectId)objId);
                writer.addProperty(GitLexicon.OBJECT_ID, (Object)objId.name());
                writer.addProperty(GitLexicon.AUTHOR, (Object)this.authorName(commit));
                writer.addProperty(GitLexicon.COMMITTER, (Object)this.commiterName(commit));
                writer.addProperty(GitLexicon.COMMITTED, (Object)values.dateFrom(commit.getCommitTime()));
                writer.addProperty(GitLexicon.TITLE, (Object)commit.getShortMessage());
                writer.addProperty(GitLexicon.MESSAGE, (Object)commit.getFullMessage().trim());
                writer.addProperty(GitLexicon.PARENTS, GitCommitDetails.referencesToCommits((ObjectId[])commit.getParents(), values));
                writer.addProperty(GitLexicon.TREE, GitTree.referenceToTree(objId, objId.name(), values));
                List<DiffEntry> differences = this.computeDifferences(commit, walker, repository);
                String patchFile = this.computePatch(differences, repository);
                writer.addProperty(GitLexicon.DIFF, (Object)patchFile);
            }
            finally {
                walker.dispose();
            }
        } else {
            return null;
        }
        return writer.document();
    }

    @Override
    public boolean isPaged() {
        return true;
    }

    @Override
    public Document execute(Repository repository, Git git, CallSpecification spec, PageWriter writer, Values values, PageKey pageKey) throws GitAPIException, IOException {
        if (spec.parameterCount() != 0) {
            return null;
        }
        this.addCommitsAsPageOfChildren(git, repository, spec, writer, pageKey);
        return writer.document();
    }

    protected List<DiffEntry> computeDifferences(RevCommit commit, RevWalk walker, Repository repository) throws MissingObjectException, IncorrectObjectTypeException, CorruptObjectException, IOException {
        RevCommit[] parents;
        TreeWalk tw = new TreeWalk(repository);
        tw.setRecursive(true);
        tw.addTree((AnyObjectId)commit.getTree());
        for (RevCommit parent : parents = commit.getParents()) {
            RevCommit parentCommit = walker.parseCommit((AnyObjectId)parent);
            tw.addTree((AnyObjectId)parentCommit.getTree());
            if (parents.length <= 1) continue;
            this.connector.getLogger().warn((I18nResource)GitI18n.commitWithMultipleParents, new Object[]{commit.getName(), parentCommit.getName()});
            break;
        }
        if (tw.getTreeCount() == 1) {
            this.connector.getLogger().warn((I18nResource)GitI18n.commitWithSingleParent, new Object[]{commit.getName(), tw.getObjectId(0).name()});
            return Collections.emptyList();
        }
        return DiffEntry.scan((TreeWalk)tw);
    }

    protected String computePatch(Iterable<DiffEntry> entries, Repository repository) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        DiffFormatter formatter = new DiffFormatter((OutputStream)output);
        formatter.setRepository(repository);
        for (DiffEntry entry : entries) {
            formatter.format(entry);
        }
        return output.toString(DIFF_CHARSET_NAME);
    }
}

