/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jdbc;

import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.query.Row;
import org.modeshape.jdbc.JdbcJcrValueFactory;
import org.modeshape.jdbc.QueryResultRowIterator;
import org.modeshape.jdbc.TestUtil;

class QueryResultRow
implements Row {
    protected final QueryResultRowIterator iterator;
    private Node[] nodes;
    protected final Object[] tuple;

    protected QueryResultRow(QueryResultRowIterator iterator, Node[] nodes, Object[] tuple) {
        this.iterator = iterator;
        this.tuple = tuple;
        this.nodes = nodes;
    }

    public Node getNode() throws RepositoryException {
        if (this.nodes.length == 1) {
            return this.nodes[0];
        }
        throw new RepositoryException("More than one selector");
    }

    public Node getNode(String selectorName) throws RepositoryException {
        for (int i = 0; i < this.nodes.length; ++i) {
            if (!this.nodes[i].getName().equals(selectorName)) continue;
            return this.nodes[i];
        }
        return null;
    }

    public String getPath() throws RepositoryException {
        if (this.nodes.length == 1) {
            return this.nodes[0].getPath();
        }
        throw new RepositoryException("More than one selector");
    }

    public String getPath(String selectorName) throws RepositoryException {
        for (int i = 0; i < this.nodes.length; ++i) {
            if (!this.nodes[i].getName().equals(selectorName)) continue;
            return this.nodes[i].getPath();
        }
        return null;
    }

    public double getScore() {
        throw new UnsupportedOperationException();
    }

    public double getScore(String selectorName) {
        throw new UnsupportedOperationException();
    }

    public Value getValue(String arg0) throws ItemNotFoundException {
        for (int i = 0; i < TestUtil.COLUMN_NAMES.length; ++i) {
            if (!TestUtil.COLUMN_NAMES[i].equals(arg0)) continue;
            return JdbcJcrValueFactory.createValue((Object)this.tuple[i]);
        }
        throw new ItemNotFoundException("Item " + arg0 + " not found");
    }

    public Value[] getValues() {
        Value[] values = new Value[this.tuple.length];
        for (int i = 0; i < this.tuple.length; ++i) {
            values[i] = JdbcJcrValueFactory.createValue((Object)this.tuple[i]);
        }
        return values;
    }
}

