/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.webdav.methods;

import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import org.modeshape.common.i18n.I18nResource;
import org.modeshape.common.i18n.TextI18n;
import org.modeshape.common.logging.Logger;
import org.modeshape.webdav.ITransaction;
import org.modeshape.webdav.IWebdavStore;
import org.modeshape.webdav.StoredObject;
import org.modeshape.webdav.WebdavStatus;
import org.modeshape.webdav.exceptions.AccessDeniedException;
import org.modeshape.webdav.exceptions.LockFailedException;
import org.modeshape.webdav.exceptions.WebdavException;
import org.modeshape.webdav.fromcatalina.RequestUtil;
import org.modeshape.webdav.fromcatalina.XMLHelper;
import org.modeshape.webdav.fromcatalina.XMLWriter;
import org.modeshape.webdav.locking.LockedObject;
import org.modeshape.webdav.locking.ResourceLocks;
import org.modeshape.webdav.methods.AbstractMethod;
import org.modeshape.webdav.methods.DeterminableMethod;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class DoProppatch
extends AbstractMethod {
    private static Logger LOG = Logger.getLogger(DoProppatch.class);
    private boolean readOnly;
    private IWebdavStore store;
    private ResourceLocks resourceLocks;

    public DoProppatch(IWebdavStore store, ResourceLocks resLocks, boolean readOnly) {
        this.readOnly = readOnly;
        this.store = store;
        this.resourceLocks = resLocks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void execute(ITransaction transaction, HttpServletRequest req, HttpServletResponse resp) throws IOException, LockFailedException {
        LOG.trace("-- " + this.getClass().getName(), new Object[0]);
        if (this.readOnly) {
            resp.sendError(403);
            return;
        }
        String path = this.getRelativePath(req);
        String parentPath = this.getParentPath(this.getCleanPath(path));
        Hashtable<String, Integer> errorList = new Hashtable<String, Integer>();
        if (!this.isUnlocked(transaction, req, this.resourceLocks, parentPath)) {
            resp.setStatus(423);
            return;
        }
        if (!this.isUnlocked(transaction, req, this.resourceLocks, path)) {
            resp.setStatus(423);
            return;
        }
        String tempLockOwner = "doProppatch" + System.currentTimeMillis() + req.toString();
        if (!this.resourceLocks.lock(transaction, path, tempLockOwner, false, 0, 10, true)) {
            resp.sendError(500);
            return;
        }
        StoredObject so = null;
        LockedObject lo = null;
        try {
            boolean lockTokenMatchesIfHeader;
            so = this.store.getStoredObject(transaction, path);
            lo = this.resourceLocks.getLockedObjectByPath(transaction, this.getCleanPath(path));
            if (so == null) {
                resp.sendError(404);
                return;
            }
            if (so.isNullResource()) {
                String methodsAllowed = DeterminableMethod.determineMethodsAllowed(so);
                resp.addHeader("Allow", methodsAllowed);
                resp.sendError(405);
                return;
            }
            String[] lockTokens = this.getLockIdFromIfHeader(req);
            boolean bl = lockTokenMatchesIfHeader = lockTokens != null && lockTokens[0].equals(lo.getID());
            if (lo != null && lo.isExclusive() && !lockTokenMatchesIfHeader) {
                errorList = new Hashtable();
                errorList.put(path, 423);
                this.sendReport(req, resp, errorList);
                return;
            }
            Map<Object, Object> propertiesToSet = new HashMap();
            AbstractList propertiesToRemove = new ArrayList();
            Vector<Object> allProperties = new Vector<Object>();
            Map<String, String> response = null;
            path = this.getCleanPath(this.getRelativePath(req));
            Node tosetNode = null;
            Node toremoveNode = null;
            if (!RequestUtil.streamNotConsumed(req)) {
                resp.sendError(500);
                return;
            }
            DocumentBuilder documentBuilder = this.getDocumentBuilder();
            try {
                Document document = documentBuilder.parse(new InputSource((InputStream)req.getInputStream()));
                Element rootElement = document.getDocumentElement();
                tosetNode = XMLHelper.findSubElement(XMLHelper.findSubElement(rootElement, "set"), "prop");
                if (tosetNode != null) {
                    propertiesToSet = XMLHelper.getPropertiesWithValuesFromXML(tosetNode);
                }
                if ((toremoveNode = XMLHelper.findSubElement(XMLHelper.findSubElement(rootElement, "remove"), "prop")) != null) {
                    propertiesToRemove = XMLHelper.getPropertiesFromXML(toremoveNode);
                }
                if (!propertiesToSet.isEmpty() || !propertiesToRemove.isEmpty()) {
                    response = this.store.setCustomProperties(transaction, path, propertiesToSet, propertiesToRemove);
                }
            }
            catch (Exception e) {
                resp.sendError(500);
                this.resourceLocks.unlockTemporaryLockedObjects(transaction, path, tempLockOwner);
                return;
            }
            allProperties.addAll(propertiesToSet.keySet());
            allProperties.addAll(propertiesToRemove);
            HashMap<String, String> namespaces = new HashMap<String, String>();
            namespaces.put("DAV:", "D");
            resp.setStatus(207);
            resp.setContentType("text/xml; charset=UTF-8");
            XMLWriter generatedXML = new XMLWriter(resp.getWriter(), namespaces);
            generatedXML.writeXMLHeader();
            generatedXML.writeElement("DAV::multistatus", 0);
            generatedXML.writeElement("DAV::response", 0);
            generatedXML.writeElement("DAV::href", 0);
            String href = req.getContextPath();
            href = href.endsWith("/") && path.startsWith("/") ? href + path.substring(1) : href + path;
            if (so.isFolder() && !href.endsWith("/")) {
                href = href + "/";
            }
            generatedXML.writeText(this.rewriteUrl(href));
            generatedXML.writeElement("DAV::href", 1);
            for (String string : allProperties) {
                generatedXML.writeElement("DAV::propstat", 0);
                generatedXML.writeElement("DAV::prop", 0);
                generatedXML.writeElement(string, 2);
                generatedXML.writeElement("DAV::prop", 1);
                generatedXML.writeElement("DAV::status", 0);
                generatedXML.writeText(this.statusForProperty(string, response));
                generatedXML.writeElement("DAV::status", 1);
                generatedXML.writeElement("DAV::propstat", 1);
            }
            if (response != null && !response.isEmpty()) {
                String firstErrorMessage = response.entrySet().iterator().next().getValue();
                generatedXML.writeProperty("DAV::responsedescription", firstErrorMessage);
            }
            generatedXML.writeElement("DAV::response", 1);
            generatedXML.writeElement("DAV::multistatus", 1);
            generatedXML.sendData();
            return;
        }
        catch (AccessDeniedException e) {
            resp.sendError(403);
            return;
        }
        catch (WebdavException e) {
            resp.sendError(500);
            return;
        }
        catch (ServletException e) {
            LOG.error((Throwable)e, (I18nResource)new TextI18n("Cannot create document builder"), new Object[0]);
            return;
        }
        finally {
            this.resourceLocks.unlockTemporaryLockedObjects(transaction, path, tempLockOwner);
        }
    }

    private String statusForProperty(String propertyName, Map<String, String> response) {
        if (response == null || response.isEmpty()) {
            return "HTTP/1.1 200 " + WebdavStatus.getStatusText(200);
        }
        if (response.containsKey(propertyName)) {
            return "HTTP/1.1 400 " + WebdavStatus.getStatusText(400);
        }
        return "HTTP/1.1 424 " + WebdavStatus.getStatusText(424);
    }
}

