/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.teiid.xmi;

import java.util.ArrayList;
import java.util.List;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.HashCode;
import org.modeshape.common.util.StringUtil;
import org.modeshape.sequencer.teiid.xmi.XmiAttribute;
import org.modeshape.sequencer.teiid.xmi.XmiBasePart;
import org.modeshape.sequencer.teiid.xmi.XmiDescendent;

public class XmiElement
extends XmiBasePart
implements XmiDescendent {
    public static final String NAME_ATTR_NAME = "name";
    private final List<XmiAttribute> attributes = new ArrayList<XmiAttribute>();
    private final List<XmiElement> children = new ArrayList<XmiElement>();
    private XmiElement parent;

    public XmiElement(String name) {
        super(name);
    }

    public void addAttribute(XmiAttribute newAttribute) {
        CheckArg.isNotNull((Object)newAttribute, (String)"newAttribute");
        this.attributes.add(newAttribute);
        newAttribute.setParent(this);
    }

    public void addChild(XmiElement newChild) {
        CheckArg.isNotNull((Object)newChild, (String)"newChild");
        this.children.add(newChild);
        newChild.setParent(this);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof XmiElement)) {
            return false;
        }
        XmiElement that = (XmiElement)obj;
        if (!this.attributes.containsAll(that.attributes) || !that.attributes.containsAll(this.attributes)) {
            return false;
        }
        if (!this.children.containsAll(that.children) || !that.children.containsAll(this.children)) {
            return false;
        }
        return this.parent == that.parent;
    }

    public XmiElement findChild(String childName, String namespaceUri) {
        CheckArg.isNotEmpty((String)childName, (String)"childName");
        for (XmiElement kid : this.getChildren()) {
            if (!childName.equals(kid.getName()) || !(StringUtil.isBlank((String)namespaceUri) ? StringUtil.isBlank((String)kid.getNamespaceUri()) : namespaceUri.equals(kid.getNamespaceUri()))) continue;
            return kid;
        }
        return null;
    }

    public XmiAttribute getAttribute(String name, String namespaceUri) {
        CheckArg.isNotEmpty((String)name, (String)"attributeName");
        for (XmiAttribute attribute : this.getAttributes()) {
            if (!attribute.getName().equals(name) || !(StringUtil.isBlank((String)namespaceUri) ? StringUtil.isBlank((String)attribute.getNamespaceUri()) : namespaceUri.equals(attribute.getNamespaceUri()))) continue;
            return attribute;
        }
        return null;
    }

    public List<XmiAttribute> getAttributes() {
        return this.attributes;
    }

    public List<XmiAttribute> getAttributes(String namespaceUri) {
        CheckArg.isNotNull((Object)namespaceUri, (String)"namespaceUri");
        ArrayList<XmiAttribute> matches = new ArrayList<XmiAttribute>();
        for (XmiAttribute attribute : this.getAttributes()) {
            if (StringUtil.isBlank((String)namespaceUri)) {
                if (!StringUtil.isBlank((String)attribute.getNamespaceUri())) continue;
                matches.add(attribute);
                continue;
            }
            if (!namespaceUri.equals(attribute.getNamespaceUri())) continue;
            matches.add(attribute);
        }
        return matches;
    }

    public String getAttributeValue(String name, String namespaceUri) {
        CheckArg.isNotNull((Object)name, (String)NAME_ATTR_NAME);
        XmiAttribute attribute = this.getAttribute(name, namespaceUri);
        if (attribute != null) {
            return attribute.getValue();
        }
        return null;
    }

    public List<XmiElement> getChildren() {
        return this.children;
    }

    public XmiAttribute getNameAttribute(String namespaceUri) {
        return this.getAttribute(NAME_ATTR_NAME, namespaceUri);
    }

    @Override
    public String getNamespacePrefix() {
        XmiElement parent;
        String prefix = super.getNamespacePrefix();
        if (StringUtil.isBlank((String)prefix) && (parent = this.getParent()) != null) {
            return parent.getNamespacePrefix();
        }
        return prefix;
    }

    @Override
    public String getNamespaceUri() {
        XmiElement parent;
        String uri = super.getNamespaceUri();
        if (StringUtil.isBlank((String)uri) && (parent = this.getParent()) != null) {
            return parent.getNamespaceUri();
        }
        return uri;
    }

    @Override
    public XmiElement getParent() {
        return this.parent;
    }

    public String getUuid() {
        return this.getAttributeValue("uuid", "http://www.omg.org/XMI");
    }

    @Override
    public int hashCode() {
        return HashCode.compute((Object[])new Object[]{super.hashCode(), this.parent, this.attributes, this.children});
    }

    @Override
    public void setParent(XmiElement parent) {
        this.parent = parent;
    }

    @Override
    public String toString() {
        if (StringUtil.isBlank((String)this.getNamespaceUri())) {
            return this.getName();
        }
        if (!StringUtil.isBlank((String)this.getNamespacePrefix())) {
            return this.getNamespacePrefix() + ':' + this.getName();
        }
        return '{' + this.getNamespaceUri() + '}' + this.getName();
    }
}

