/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.io.InputStream;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.VersionException;
import org.modeshape.common.annotation.NotThreadSafe;
import org.modeshape.jcr.AbstractJcrNode;
import org.modeshape.jcr.AbstractJcrProperty;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrNodeListIterator;
import org.modeshape.jcr.JcrValue;
import org.modeshape.jcr.api.value.DateTime;
import org.modeshape.jcr.value.BinaryFactory;
import org.modeshape.jcr.value.BinaryValue;
import org.modeshape.jcr.value.DateTimeFactory;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.Property;
import org.modeshape.jcr.value.ValueFactories;
import org.modeshape.jcr.value.ValueFormatException;

@NotThreadSafe
final class JcrMultiValueProperty
extends AbstractJcrProperty {
    static final JcrValue[] EMPTY_VALUES = new JcrValue[0];

    JcrMultiValueProperty(AbstractJcrNode node, Name name, int propertyType) {
        super(node, name, propertyType);
    }

    public boolean isMultiple() {
        return true;
    }

    public boolean getBoolean() throws javax.jcr.ValueFormatException {
        throw new javax.jcr.ValueFormatException(JcrI18n.invalidMethodForMultiValuedProperty.text(new Object[0]));
    }

    public Calendar getDate() throws javax.jcr.ValueFormatException {
        throw new javax.jcr.ValueFormatException(JcrI18n.invalidMethodForMultiValuedProperty.text(new Object[0]));
    }

    public double getDouble() throws javax.jcr.ValueFormatException {
        throw new javax.jcr.ValueFormatException(JcrI18n.invalidMethodForMultiValuedProperty.text(new Object[0]));
    }

    public Node getNode() throws javax.jcr.ValueFormatException, RepositoryException {
        throw new javax.jcr.ValueFormatException(JcrI18n.invalidMethodForMultiValuedProperty.text(new Object[0]));
    }

    public long getLength() throws javax.jcr.ValueFormatException {
        throw new javax.jcr.ValueFormatException(JcrI18n.invalidMethodForMultiValuedProperty.text(new Object[0]));
    }

    public long[] getLengths() throws RepositoryException {
        this.checkSession();
        JcrValue[] values = this.getValues();
        long[] lengths = new long[values.length];
        int ndx = 0;
        for (JcrValue value : values) {
            lengths[ndx++] = value.getLength();
        }
        return lengths;
    }

    public long getLong() throws javax.jcr.ValueFormatException {
        throw new javax.jcr.ValueFormatException(JcrI18n.invalidMethodForMultiValuedProperty.text(new Object[0]));
    }

    public InputStream getStream() throws javax.jcr.ValueFormatException {
        throw new javax.jcr.ValueFormatException(JcrI18n.invalidMethodForMultiValuedProperty.text(new Object[0]));
    }

    public String getString() throws javax.jcr.ValueFormatException {
        throw new javax.jcr.ValueFormatException(JcrI18n.invalidMethodForMultiValuedProperty.text(new Object[0]));
    }

    @Override
    public JcrValue[] getValues() throws RepositoryException {
        this.checkSession();
        Property innerProp = this.property();
        JcrValue[] values = new JcrValue[innerProp.size()];
        Iterator iter = innerProp.iterator();
        int ndx = 0;
        while (iter.hasNext()) {
            values[ndx] = this.createValue(iter.next());
            ++ndx;
        }
        return values;
    }

    public final void setValue(Value[] values) throws javax.jcr.ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        if (values == null) {
            this.remove();
            return;
        }
        this.checkSession();
        this.checkForLock();
        this.checkForCheckedOut();
        this.internalSetValue(values);
    }

    protected final void internalSetValue(Value[] values) throws javax.jcr.ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        assert (values != null);
        Object[] literals = new Object[values.length];
        ValueFactories factories = null;
        for (int i = 0; i < values.length; ++i) {
            Value value = values[i];
            if (value != null) {
                JcrValue jcrValue = null;
                int type = this.getType();
                if (value instanceof JcrValue) {
                    jcrValue = (JcrValue)value;
                    if (jcrValue.value() == null) {
                        throw new javax.jcr.ValueFormatException(JcrI18n.valueMayNotContainNull.text(new Object[]{this.getName()}));
                    }
                } else {
                    if (factories == null) {
                        factories = this.context().getValueFactories();
                    }
                    jcrValue = new JcrValue(factories, value).asType(type, true);
                }
                literals[i] = jcrValue.asType(type, false).value();
                continue;
            }
            literals[i] = null;
        }
        Property newProperty = this.propertyFactory().create(this.name(), literals);
        this.mutable().setProperty(this.sessionCache(), newProperty);
    }

    public final void setValue(String[] values) throws javax.jcr.ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        if (values == null) {
            this.remove();
            return;
        }
        this.checkSession();
        this.checkForLock();
        this.checkForCheckedOut();
        Property newProperty = null;
        if (values.length != 0) {
            int numValues = values.length;
            Object[] literals = new Object[numValues];
            for (int i = 0; i != numValues; ++i) {
                String value = values[i];
                if (value == null) {
                    literals[i] = null;
                    continue;
                }
                JcrValue jcrValue = this.createValue(values[i], 1).asType(this.getType());
                literals[i] = jcrValue.value();
            }
            newProperty = this.propertyFactory().create(this.name(), literals);
        }
        if (newProperty == null) {
            newProperty = this.propertyFactory().create(this.name());
        }
        this.mutable().setProperty(this.sessionCache(), newProperty);
    }

    @Override
    public JcrValue getValue() throws javax.jcr.ValueFormatException {
        throw new javax.jcr.ValueFormatException(JcrI18n.invalidMethodForMultiValuedProperty.text(new Object[0]));
    }

    public final void setValue(Value value) throws javax.jcr.ValueFormatException {
        throw new javax.jcr.ValueFormatException(JcrI18n.invalidMethodForMultiValuedProperty.text(new Object[0]));
    }

    public final void setValue(String value) throws javax.jcr.ValueFormatException {
        throw new javax.jcr.ValueFormatException(JcrI18n.invalidMethodForMultiValuedProperty.text(new Object[0]));
    }

    public final void setValue(InputStream value) throws javax.jcr.ValueFormatException {
        throw new javax.jcr.ValueFormatException(JcrI18n.invalidMethodForMultiValuedProperty.text(new Object[0]));
    }

    public final void setValue(long value) throws javax.jcr.ValueFormatException {
        throw new javax.jcr.ValueFormatException(JcrI18n.invalidMethodForMultiValuedProperty.text(new Object[0]));
    }

    public final void setValue(double value) throws javax.jcr.ValueFormatException {
        throw new javax.jcr.ValueFormatException(JcrI18n.invalidMethodForMultiValuedProperty.text(new Object[0]));
    }

    public final void setValue(Calendar value) throws javax.jcr.ValueFormatException {
        throw new javax.jcr.ValueFormatException(JcrI18n.invalidMethodForMultiValuedProperty.text(new Object[0]));
    }

    public final void setValue(boolean value) throws javax.jcr.ValueFormatException {
        throw new javax.jcr.ValueFormatException(JcrI18n.invalidMethodForMultiValuedProperty.text(new Object[0]));
    }

    public final void setValue(Node value) throws javax.jcr.ValueFormatException {
        throw new javax.jcr.ValueFormatException(JcrI18n.invalidMethodForMultiValuedProperty.text(new Object[0]));
    }

    public Binary getBinary() throws javax.jcr.ValueFormatException, RepositoryException {
        throw new javax.jcr.ValueFormatException(JcrI18n.invalidMethodForMultiValuedProperty.text(new Object[0]));
    }

    public BigDecimal getDecimal() throws javax.jcr.ValueFormatException, RepositoryException {
        throw new javax.jcr.ValueFormatException(JcrI18n.invalidMethodForMultiValuedProperty.text(new Object[0]));
    }

    public javax.jcr.Property getProperty() throws javax.jcr.ValueFormatException, RepositoryException {
        throw new javax.jcr.ValueFormatException(JcrI18n.invalidMethodForMultiValuedProperty.text(new Object[0]));
    }

    public void setValue(BigDecimal value) throws javax.jcr.ValueFormatException, RepositoryException {
        throw new javax.jcr.ValueFormatException(JcrI18n.invalidMethodForMultiValuedProperty.text(new Object[0]));
    }

    public void setValue(Binary value) throws javax.jcr.ValueFormatException, RepositoryException {
        throw new javax.jcr.ValueFormatException(JcrI18n.invalidMethodForMultiValuedProperty.text(new Object[0]));
    }

    public <T> T getAs(Class<T> type) throws RepositoryException {
        if (!type.isArray() && !type.equals(NodeIterator.class)) {
            throw new javax.jcr.ValueFormatException(JcrI18n.unableToConvertPropertyValueToType.text(new Object[]{this.getPath(), type.getSimpleName()}));
        }
        Property property = this.property();
        try {
            if (String[].class.equals(type)) {
                return type.cast(property.getValuesAsArray(this.context().getValueFactories().getStringFactory()));
            }
            if (Long[].class.equals(type)) {
                return type.cast(property.getValuesAsArray(this.context().getValueFactories().getLongFactory()));
            }
            if (Boolean[].class.equals(type)) {
                return type.cast(property.getValuesAsArray(this.context().getValueFactories().getBooleanFactory()));
            }
            if (Date[].class.equals(type)) {
                final DateTimeFactory dateFactory = this.context().getValueFactories().getDateFactory();
                Date[] result = property.getValuesAsArray(new Property.ValueTypeTransformer<Date>(){

                    @Override
                    public Date transform(Object value) {
                        return ((DateTime)dateFactory.create(value)).toDate();
                    }
                }, Date.class);
                return type.cast(result);
            }
            if (Calendar[].class.equals(type)) {
                final DateTimeFactory dateFactory = this.context().getValueFactories().getDateFactory();
                Calendar[] result = property.getValuesAsArray(new Property.ValueTypeTransformer<Calendar>(){

                    @Override
                    public Calendar transform(Object value) {
                        return ((DateTime)dateFactory.create(value)).toCalendar();
                    }
                }, Calendar.class);
                return type.cast(result);
            }
            if (DateTime[].class.equals(type)) {
                return type.cast(property.getValuesAsArray(this.context().getValueFactories().getDateFactory()));
            }
            if (Double[].class.equals(type)) {
                return type.cast(property.getValuesAsArray(this.context().getValueFactories().getDoubleFactory()));
            }
            if (BigDecimal[].class.equals(type)) {
                return type.cast(property.getValuesAsArray(this.context().getValueFactories().getDecimalFactory()));
            }
            if (InputStream[].class.equals(type)) {
                final BinaryFactory binaryFactory = this.context().getValueFactories().getBinaryFactory();
                InputStream[] result = property.getValuesAsArray(new Property.ValueTypeTransformer<InputStream>(){

                    @Override
                    public InputStream transform(Object value) {
                        try {
                            BinaryValue binaryValue = (BinaryValue)binaryFactory.create(value);
                            return binaryValue.getStream();
                        }
                        catch (RepositoryException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }, InputStream.class);
                return type.cast(result);
            }
            if (Binary[].class.isAssignableFrom(type)) {
                return type.cast(property.getValuesAsArray(this.context().getValueFactories().getBinaryFactory()));
            }
            if (Node[].class.equals(type)) {
                Node[] nodes = property.getValuesAsArray(new Property.ValueTypeTransformer<Node>(){

                    @Override
                    public Node transform(Object value) {
                        try {
                            return JcrMultiValueProperty.this.valueToNode(value);
                        }
                        catch (RepositoryException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }, Node.class);
                return type.cast(nodes);
            }
            if (NodeIterator.class.equals(type)) {
                Node[] nodes = property.getValuesAsArray(new Property.ValueTypeTransformer<Node>(){

                    @Override
                    public Node transform(Object value) {
                        try {
                            return JcrMultiValueProperty.this.valueToNode(value);
                        }
                        catch (RepositoryException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }, Node.class);
                return type.cast(new JcrNodeListIterator(Arrays.asList(nodes).iterator(), nodes.length));
            }
            throw new javax.jcr.ValueFormatException(JcrI18n.unableToConvertPropertyValueToType.text(new Object[]{this.getPath(), type.getSimpleName()}));
        }
        catch (ValueFormatException e) {
            throw new javax.jcr.ValueFormatException((Throwable)e);
        }
    }
}

