/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.schematic.internal;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commons.marshall.SerializeWith;
import org.infinispan.commons.util.Util;
import org.infinispan.schematic.SchematicEntry;
import org.infinispan.schematic.document.Document;
import org.infinispan.schematic.document.EditableDocument;
import org.infinispan.schematic.document.Path;
import org.infinispan.schematic.internal.SchematicExternalizer;
import org.infinispan.schematic.internal.delta.Operation;
import org.infinispan.schematic.internal.document.BasicDocument;
import org.infinispan.schematic.internal.document.DocumentEditor;
import org.infinispan.schematic.internal.document.MutableDocument;
import org.infinispan.schematic.internal.document.Paths;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@SerializeWith(value=Externalizer.class)
public class SchematicEntryLiteral
implements SchematicEntry {
    private static final Log LOGGER = LogFactory.getLog(SchematicEntryLiteral.class);
    private volatile MutableDocument value;
    volatile boolean copied = false;
    volatile boolean removed = false;

    public static SchematicEntry newInstance(Cache<String, SchematicEntry> cache, String key) {
        SchematicEntry value = new SchematicEntryLiteral(key);
        SchematicEntry oldValue = (SchematicEntry)cache.putIfAbsent((Object)key, (Object)value);
        if (oldValue != null) {
            value = oldValue;
        }
        return value;
    }

    public SchematicEntryLiteral() {
        this.value = new BasicDocument("metadata", new BasicDocument(), "content", new BasicDocument());
    }

    public SchematicEntryLiteral(String key) {
        this(key, (Document)new BasicDocument());
    }

    protected SchematicEntryLiteral(MutableDocument document) {
        this.value = document;
        assert (this.value != null);
    }

    public SchematicEntryLiteral(String key, Document content) {
        BasicDocument metadata = new BasicDocument("id", key);
        this.value = new BasicDocument("metadata", metadata, "content", this.unwrap(content));
    }

    protected SchematicEntryLiteral(Document metadata, Document content) {
        this.value = new BasicDocument("metadata", this.unwrap(metadata), "content", this.unwrap(content));
    }

    protected MutableDocument unwrap(Document doc) {
        if (doc instanceof EditableDocument) {
            doc = ((EditableDocument)doc).unwrap();
        }
        return (MutableDocument)doc;
    }

    protected final String key() {
        return this.getMetadata().getString("id");
    }

    protected final MutableDocument data() {
        return this.value;
    }

    protected void setDocument(Document document) {
        assert (this.value != null);
        this.value = this.unwrap(document);
    }

    public String toString() {
        return "SchematicEntryLiteral" + this.value;
    }

    public void markRemoved(boolean b) {
        this.removed = b;
    }

    @Override
    public Document getMetadata() {
        return this.value.getDocument("metadata");
    }

    protected String getKey() {
        return this.getMetadata().getString("id");
    }

    @Override
    public Document getContent() {
        return this.value.getDocument("content");
    }

    protected void setMetadata(Document metadata) {
        if (metadata != null) {
            if (metadata instanceof EditableDocument) {
                metadata = ((EditableDocument)metadata).unwrap();
            }
            Document existingMetadata = this.getMetadata();
            BasicDocument newMetadata = new BasicDocument(metadata.size() + 1);
            newMetadata.put("id", existingMetadata.get("id"));
            for (Document.Field field : metadata.fields()) {
                String fieldName = field.getName();
                if (fieldName.equals("id")) continue;
                newMetadata.put(fieldName, field.getValue());
            }
            this.value.put("metadata", newMetadata);
        }
    }

    @Override
    public void setContent(Document content) {
        this.value.put("content", this.unwrap(content));
    }

    @Override
    public Document asDocument() {
        return this.value;
    }

    protected EditableDocument edit(String key, AdvancedCache<String, SchematicEntry> cache, AdvancedCache<String, SchematicEntry> lockingCache) {
        if (lockingCache != null) {
            lockingCache.lock((Object[])new String[]{key});
        }
        MutableDocument copy = (MutableDocument)this.value.clone();
        SchematicEntryLiteral newEntry = new SchematicEntryLiteral(copy);
        cache.put((Object)this.getKey(), (Object)newEntry);
        return new DocumentEditor((MutableDocument)newEntry.getContent());
    }

    public SchematicEntryLiteral clone() {
        return new SchematicEntryLiteral((MutableDocument)this.value.clone());
    }

    boolean apply(Iterable<Operation> changes) {
        try {
            for (Operation o : changes) {
                o.replay(this.value);
            }
        }
        catch (AssertionError e) {
            LOGGER.debug((Object)("Assertion while applying changes to " + this.value + " --> " + changes));
            throw e;
        }
        return true;
    }

    public static final class Externalizer
    extends SchematicExternalizer<SchematicEntryLiteral> {
        private static final long serialVersionUID = 1L;

        public void writeObject(ObjectOutput output, SchematicEntryLiteral literal) throws IOException {
            output.writeObject(literal.data());
        }

        public SchematicEntryLiteral readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            MutableDocument doc = (MutableDocument)input.readObject();
            return new SchematicEntryLiteral(doc);
        }

        @Override
        public Integer getId() {
            return 1600;
        }

        @Override
        public Set<Class<? extends SchematicEntryLiteral>> getTypeClasses() {
            return Util.asSet((Object[])new Class[]{SchematicEntryLiteral.class});
        }
    }

    protected static class FieldPath {
        protected static final Path ROOT = Paths.path(new String[0]);
        protected static final Path METADATA = Paths.path("metadata");
        protected static final Path CONTENT = Paths.path("content");
        protected static final Path ID = Paths.path("metadata", "id");

        protected FieldPath() {
        }
    }
}

