/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.subsystem;

import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.jboss.modules.Module;
import org.modeshape.jboss.subsystem.AddressContext;
import org.modeshape.jboss.subsystem.ModelAttributes;

class AddWebApp
extends AbstractAddStepHandler {
    private static final Logger LOGGER = Logger.getLogger((String)AddWebApp.class.getPackage().getName());
    static final AddWebApp INSTANCE = new AddWebApp();

    AddWebApp() {
    }

    protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        if (!this.requiresRuntime(context)) {
            return;
        }
        AddressContext addressContext = AddressContext.forOperation(operation);
        String webappName = addressContext.lastPathElementValue();
        Module module = Module.forClass(AddWebApp.class);
        if (module == null) {
            LOGGER.debugv("Skipping the deployment of {0} because the module which contains the {1} class cannot be loaded", (Object)webappName, (Object)AddWebApp.class.getName());
            return;
        }
        URL url = module.getExportedResource(webappName);
        if (url == null) {
            LOGGER.warnv("Cannot deploy ModeShape webapp {0} because it cannot be located by the main modeshape module", (Object)webappName);
            return;
        }
        boolean exploded = this.attribute(context, resource.getModel(), (AttributeDefinition)ModelAttributes.EXPLODED).asBoolean();
        resource.getModel().setEmptyObject();
        PathAddress deploymentAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"deployment", (String)webappName)});
        ModelNode deploymentOp = Util.createOperation((String)"add", (PathAddress)deploymentAddress);
        deploymentOp.get("enabled").set(true);
        deploymentOp.get("persistent").set(false);
        ModelNode contentItem = new ModelNode();
        if (exploded) {
            String urlString = null;
            try {
                urlString = new File(url.toURI()).getAbsolutePath();
            }
            catch (URISyntaxException e) {
                throw new OperationFailedException(e.getMessage(), (Throwable)e);
            }
            contentItem.get("path").set(urlString);
            contentItem.get("archive").set(false);
        } else {
            contentItem.get("url").set(url.toExternalForm());
        }
        deploymentOp.get("content").add(contentItem);
        ImmutableManagementResourceRegistration rootResourceRegistration = context.getRootResourceRegistration();
        OperationStepHandler addDeploymentHandler = rootResourceRegistration.getOperationHandler(deploymentAddress, "add");
        context.addStep(deploymentOp, addDeploymentHandler, OperationContext.Stage.MODEL);
    }

    private ModelNode attribute(OperationContext context, ModelNode model, AttributeDefinition defn) throws OperationFailedException {
        assert (defn.getDefaultValue() != null && defn.getDefaultValue().isDefined());
        return defn.resolveModelAttribute(context, model);
    }

    protected void populateModel(ModelNode operation, ModelNode model) {
    }

    protected boolean requiresRuntimeVerification() {
        return false;
    }
}

