/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.subsystem;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.ListAttributeDefinition;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamWriter;
import org.modeshape.jboss.subsystem.Attribute;
import org.modeshape.jboss.subsystem.Element;
import org.modeshape.jboss.subsystem.ModelAttributes;
import org.modeshape.jboss.subsystem.Namespace;

public class ModeShapeSubsystemXMLWriter
implements XMLStreamConstants,
XMLElementWriter<SubsystemMarshallingContext> {
    public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
        context.startSubsystemElement(Namespace.CURRENT.getUri(), false);
        ModelNode model = context.getModelNode();
        if (model.isDefined()) {
            if (model.hasDefined("repository")) {
                for (Property entry : model.get("repository").asPropertyList()) {
                    String repositoryName = entry.getName();
                    ModelNode repository = entry.getValue();
                    this.writeRepositoryConfiguration(writer, repository, repositoryName);
                }
            }
            if (model.hasDefined("webapp")) {
                for (Property entry : model.get("webapp").asPropertyList()) {
                    String webappName = entry.getName();
                    ModelNode webapp = entry.getValue();
                    this.writeWebAppConfiguration(writer, webapp, webappName);
                }
            }
        }
        writer.writeEndElement();
    }

    private void writeWebAppConfiguration(XMLExtendedStreamWriter writer, ModelNode webapp, String repositoryName) throws XMLStreamException {
        writer.writeStartElement(Element.WEBAPP.getLocalName());
        writer.writeAttribute(Attribute.NAME.getLocalName(), repositoryName);
        ModelAttributes.EXPLODED.marshallAsAttribute(webapp, false, (XMLStreamWriter)writer);
        writer.writeEndElement();
    }

    private void writeRepositoryConfiguration(XMLExtendedStreamWriter writer, ModelNode repository, String repositoryName) throws XMLStreamException {
        writer.writeStartElement(Element.REPOSITORY.getLocalName());
        writer.writeAttribute(Attribute.NAME.getLocalName(), repositoryName);
        ModelAttributes.CACHE_NAME.marshallAsAttribute(repository, false, (XMLStreamWriter)writer);
        ModelAttributes.CACHE_CONFIG.marshallAsAttribute(repository, false, (XMLStreamWriter)writer);
        ModelAttributes.CONFIG_RELATIVE_TO.marshallAsAttribute(repository, false, (XMLStreamWriter)writer);
        ModelAttributes.JNDI_NAME.marshallAsAttribute(repository, false, (XMLStreamWriter)writer);
        ModelAttributes.ENABLE_MONITORING.marshallAsAttribute(repository, false, (XMLStreamWriter)writer);
        ModelAttributes.SECURITY_DOMAIN.marshallAsAttribute(repository, false, (XMLStreamWriter)writer);
        this.writeAttributeAsList(writer, repository, ModelAttributes.ANONYMOUS_ROLES);
        ModelAttributes.ANONYMOUS_USERNAME.marshallAsAttribute(repository, false, (XMLStreamWriter)writer);
        ModelAttributes.USE_ANONYMOUS_IF_AUTH_FAILED.marshallAsAttribute(repository, false, (XMLStreamWriter)writer);
        ModelAttributes.GARBAGE_COLLECTION_THREAD_POOL.marshallAsAttribute(repository, false, (XMLStreamWriter)writer);
        ModelAttributes.GARBAGE_COLLECTION_INITIAL_TIME.marshallAsAttribute(repository, false, (XMLStreamWriter)writer);
        ModelAttributes.GARBAGE_COLLECTION_INTERVAL.marshallAsAttribute(repository, false, (XMLStreamWriter)writer);
        ModelAttributes.DOCUMENT_OPTIMIZATION_THREAD_POOL.marshallAsAttribute(repository, false, (XMLStreamWriter)writer);
        ModelAttributes.DOCUMENT_OPTIMIZATION_INITIAL_TIME.marshallAsAttribute(repository, false, (XMLStreamWriter)writer);
        ModelAttributes.DOCUMENT_OPTIMIZATION_INTERVAL.marshallAsAttribute(repository, false, (XMLStreamWriter)writer);
        ModelAttributes.DOCUMENT_OPTIMIZATION_CHILD_COUNT_TARGET.marshallAsAttribute(repository, false, (XMLStreamWriter)writer);
        ModelAttributes.DOCUMENT_OPTIMIZATION_CHILD_COUNT_TOLERANCE.marshallAsAttribute(repository, false, (XMLStreamWriter)writer);
        this.writeNodeTypes(writer, repository);
        this.writeWorkspaces(writer, repository);
        this.writeJournaling(writer, repository);
        this.writeAuthenticators(writer, repository);
        this.writeIndexProviders(writer, repository);
        this.writeIndexes(writer, repository);
        this.writeBinaryStorage(writer, repository);
        this.writeSequencing(writer, repository);
        this.writeExternalSources(writer, repository);
        this.writeTextExtraction(writer, repository);
        writer.writeEndElement();
    }

    private void writeNodeTypes(XMLExtendedStreamWriter writer, ModelNode repository) throws XMLStreamException {
        boolean started = false;
        if (this.has(repository, "node-types")) {
            started = this.startIfNeeded(writer, Element.NODE_TYPES, started);
            List nodeTypes = repository.get("node-types").asList();
            for (ModelNode nodeType : nodeTypes) {
                writer.writeStartElement(Element.NODE_TYPE.getLocalName());
                writer.writeCharacters(nodeType.asString());
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    private void writeWorkspaces(XMLExtendedStreamWriter writer, ModelNode repository) throws XMLStreamException {
        boolean started = false;
        if (ModelAttributes.DEFAULT_WORKSPACE.isMarshallable(repository, false)) {
            started = this.startIfNeeded(writer, Element.WORKSPACES, started);
            ModelAttributes.DEFAULT_WORKSPACE.marshallAsAttribute(repository, (XMLStreamWriter)writer);
        }
        if (ModelAttributes.ALLOW_WORKSPACE_CREATION.isMarshallable(repository, false)) {
            started = this.startIfNeeded(writer, Element.WORKSPACES, started);
            ModelAttributes.ALLOW_WORKSPACE_CREATION.marshallAsAttribute(repository, (XMLStreamWriter)writer);
        }
        if (ModelAttributes.WORKSPACES_CACHE_CONTAINER.isMarshallable(repository, false)) {
            started = this.startIfNeeded(writer, Element.WORKSPACES, started);
            ModelAttributes.WORKSPACES_CACHE_CONTAINER.marshallAsAttribute(repository, (XMLStreamWriter)writer);
        }
        if (this.has(repository, "predefined-workspace-names")) {
            started = this.startIfNeeded(writer, Element.WORKSPACES, started);
            ModelNode names = repository.get("predefined-workspace-names");
            if (names.isDefined()) {
                HashMap<String, String> workspacesInitialContent = new HashMap<String, String>();
                if (this.has(repository, "workspaces-initial-content")) {
                    List initialContentNodes = repository.get("workspaces-initial-content").asList();
                    for (ModelNode modelNode : initialContentNodes) {
                        Property property = modelNode.asProperty();
                        workspacesInitialContent.put(property.getName(), property.getValue().asString());
                    }
                }
                for (ModelNode workspace : repository.get("predefined-workspace-names").asList()) {
                    writer.writeStartElement(Element.WORKSPACE.getLocalName());
                    String name = workspace.asString();
                    writer.writeAttribute(Attribute.NAME.getLocalName(), name);
                    if (workspacesInitialContent.containsKey(name)) {
                        writer.writeStartElement(Element.INITIAL_CONTENT.getLocalName());
                        writer.writeCharacters((String)workspacesInitialContent.get(name));
                        writer.writeEndElement();
                    }
                    writer.writeEndElement();
                }
            }
        }
        if (this.has(repository, "default-initial-content")) {
            started = this.startIfNeeded(writer, Element.WORKSPACES, started);
            writer.writeStartElement(Element.INITIAL_CONTENT.getLocalName());
            writer.writeCharacters(repository.get("default-initial-content").asString());
            writer.writeEndElement();
        }
        if (started) {
            writer.writeEndElement();
        }
    }

    private void writeJournaling(XMLExtendedStreamWriter writer, ModelNode repository) throws XMLStreamException {
        boolean started = false;
        if (ModelAttributes.JOURNAL_PATH.isMarshallable(repository, false)) {
            started = this.startIfNeeded(writer, Element.JOURNALING, started);
            ModelAttributes.JOURNAL_PATH.marshallAsAttribute(repository, (XMLStreamWriter)writer);
        }
        if (ModelAttributes.JOURNAL_RELATIVE_TO.isMarshallable(repository, false)) {
            started = this.startIfNeeded(writer, Element.JOURNALING, started);
            ModelAttributes.JOURNAL_RELATIVE_TO.marshallAsAttribute(repository, (XMLStreamWriter)writer);
        }
        if (ModelAttributes.MAX_DAYS_TO_KEEP_RECORDS.isMarshallable(repository, false)) {
            started = this.startIfNeeded(writer, Element.JOURNALING, started);
            ModelAttributes.MAX_DAYS_TO_KEEP_RECORDS.marshallAsAttribute(repository, (XMLStreamWriter)writer);
        }
        if (ModelAttributes.ASYNC_WRITES.isMarshallable(repository, false)) {
            started = this.startIfNeeded(writer, Element.JOURNALING, started);
            ModelAttributes.ASYNC_WRITES.marshallAsAttribute(repository, (XMLStreamWriter)writer);
        }
        if (ModelAttributes.JOURNAL_GC_INITIAL_TIME.isMarshallable(repository, false)) {
            started = this.startIfNeeded(writer, Element.JOURNALING, started);
            ModelAttributes.JOURNAL_GC_INITIAL_TIME.marshallAsAttribute(repository, (XMLStreamWriter)writer);
        }
        if (ModelAttributes.JOURNAL_GC_THREAD_POOL.isMarshallable(repository, false)) {
            started = this.startIfNeeded(writer, Element.JOURNALING, started);
            ModelAttributes.JOURNAL_GC_THREAD_POOL.marshallAsAttribute(repository, (XMLStreamWriter)writer);
        }
        if (started) {
            writer.writeEndElement();
        }
    }

    private boolean startIfNeeded(XMLExtendedStreamWriter writer, Element name, boolean alreadyStarted) throws XMLStreamException {
        if (!alreadyStarted) {
            writer.writeStartElement(name.getLocalName());
        }
        return true;
    }

    private void writeBinaryStorage(XMLExtendedStreamWriter writer, ModelNode repository) throws XMLStreamException {
        if (this.has(repository, "configuration", "binary-storage")) {
            ModelNode configuration = repository.get("configuration");
            ModelNode binaryStorage = configuration.get("binary-storage");
            ModelNode binaryStorageType = binaryStorage.get("storage-type");
            String storageType = binaryStorageType.isDefined() && binaryStorageType.keys().size() == 1 ? (String)binaryStorageType.keys().toArray()[0] : null;
            ModelNode storage = storageType != null ? binaryStorageType.get((String)binaryStorageType.keys().toArray()[0]) : new ModelNode();
            this.writeBinaryStorageModel(writer, storageType, storage);
        }
    }

    private void writeBinaryStorageModel(XMLExtendedStreamWriter writer, String storageType, ModelNode storage) throws XMLStreamException {
        if ("file-binary-storage".equals(storageType)) {
            writer.writeStartElement(Element.FILE_BINARY_STORAGE.getLocalName());
            ModelAttributes.MINIMUM_BINARY_SIZE.marshallAsAttribute(storage, false, (XMLStreamWriter)writer);
            ModelAttributes.MINIMUM_STRING_SIZE.marshallAsAttribute(storage, false, (XMLStreamWriter)writer);
            ModelAttributes.PATH.marshallAsAttribute(storage, false, (XMLStreamWriter)writer);
            ModelAttributes.RELATIVE_TO.marshallAsAttribute(storage, false, (XMLStreamWriter)writer);
            ModelAttributes.STORE_NAME.marshallAsAttribute(storage, false, (XMLStreamWriter)writer);
            writer.writeEndElement();
        } else if ("cache-binary-storage".equals(storageType)) {
            writer.writeStartElement(Element.CACHE_BINARY_STORAGE.getLocalName());
            ModelAttributes.MINIMUM_BINARY_SIZE.marshallAsAttribute(storage, false, (XMLStreamWriter)writer);
            ModelAttributes.MINIMUM_STRING_SIZE.marshallAsAttribute(storage, false, (XMLStreamWriter)writer);
            ModelAttributes.DATA_CACHE_NAME.marshallAsAttribute(storage, false, (XMLStreamWriter)writer);
            ModelAttributes.METADATA_CACHE_NAME.marshallAsAttribute(storage, false, (XMLStreamWriter)writer);
            ModelAttributes.CHUNK_SIZE.marshallAsAttribute(storage, false, (XMLStreamWriter)writer);
            ModelAttributes.CACHE_CONFIG.marshallAsAttribute(storage, false, (XMLStreamWriter)writer);
            ModelAttributes.STORE_NAME.marshallAsAttribute(storage, false, (XMLStreamWriter)writer);
            writer.writeEndElement();
        } else if ("db-binary-storage".equals(storageType)) {
            writer.writeStartElement(Element.DB_BINARY_STORAGE.getLocalName());
            ModelAttributes.MINIMUM_BINARY_SIZE.marshallAsAttribute(storage, false, (XMLStreamWriter)writer);
            ModelAttributes.MINIMUM_STRING_SIZE.marshallAsAttribute(storage, false, (XMLStreamWriter)writer);
            ModelAttributes.DATA_SOURCE_JNDI_NAME.marshallAsAttribute(storage, false, (XMLStreamWriter)writer);
            ModelAttributes.STORE_NAME.marshallAsAttribute(storage, false, (XMLStreamWriter)writer);
            writer.writeEndElement();
        } else if ("composite-binary-storage".equals(storageType)) {
            writer.writeStartElement(Element.COMPOSITE_BINARY_STORAGE.getLocalName());
            ModelAttributes.MINIMUM_BINARY_SIZE.marshallAsAttribute(storage, false, (XMLStreamWriter)writer);
            ModelAttributes.MINIMUM_STRING_SIZE.marshallAsAttribute(storage, false, (XMLStreamWriter)writer);
            ModelAttributes.STORE_NAME.marshallAsAttribute(storage, false, (XMLStreamWriter)writer);
            this.writeNestedStoresOfType(storage, "nested-storage-type-file", "file-binary-storage", writer);
            this.writeNestedStoresOfType(storage, "nested-storage-type-cache", "cache-binary-storage", writer);
            this.writeNestedStoresOfType(storage, "nested-storage-type-db", "db-binary-storage", writer);
            this.writeNestedStoresOfType(storage, "nested-storage-type-custom", "custom-binary-storage", writer);
            writer.writeEndElement();
        } else if ("custom-binary-storage".equals(storageType)) {
            writer.writeStartElement(Element.CUSTOM_BINARY_STORAGE.getLocalName());
            ModelAttributes.MINIMUM_BINARY_SIZE.marshallAsAttribute(storage, false, (XMLStreamWriter)writer);
            ModelAttributes.MINIMUM_STRING_SIZE.marshallAsAttribute(storage, false, (XMLStreamWriter)writer);
            ModelAttributes.STORE_NAME.marshallAsAttribute(storage, false, (XMLStreamWriter)writer);
            for (String key : storage.keys()) {
                if (key.equals("classname")) {
                    ModelAttributes.CLASSNAME.marshallAsAttribute(storage, false, (XMLStreamWriter)writer);
                    continue;
                }
                if (key.equals("module")) {
                    ModelAttributes.MODULE.marshallAsAttribute(storage, false, (XMLStreamWriter)writer);
                    continue;
                }
                writer.writeAttribute(key, storage.get(key).asString());
            }
            writer.writeEndElement();
        }
    }

    private void writeNestedStoresOfType(ModelNode storage, String nestedStorageType, String storeType, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (this.has(storage, nestedStorageType)) {
            List nestedCacheStores = storage.get(nestedStorageType).asList();
            for (ModelNode nestedStore : nestedCacheStores) {
                String storeName = (String)nestedStore.keys().toArray()[0];
                this.writeBinaryStorageModel(writer, storeType, nestedStore.get(storeName));
            }
        }
    }

    private void writeAuthenticators(XMLExtendedStreamWriter writer, ModelNode repository) throws XMLStreamException {
        if (this.has(repository, "authenticator")) {
            writer.writeStartElement(Element.AUTHENTICATORS.getLocalName());
            for (Property authenticator : repository.get("authenticator").asPropertyList()) {
                writer.writeStartElement(Element.AUTHENTICATOR.getLocalName());
                writer.writeAttribute(Attribute.NAME.getLocalName(), authenticator.getName());
                ModelNode prop = authenticator.getValue();
                ModelAttributes.AUTHENTICATOR_CLASSNAME.marshallAsAttribute(prop, (XMLStreamWriter)writer);
                ModelAttributes.MODULE.marshallAsAttribute(prop, (XMLStreamWriter)writer);
                if (this.has(prop, "properties")) {
                    ModelNode properties = prop.get("properties");
                    for (Property property : properties.asPropertyList()) {
                        writer.writeAttribute(property.getName(), property.getValue().asString());
                    }
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    private void writeSequencing(XMLExtendedStreamWriter writer, ModelNode repository) throws XMLStreamException {
        if (this.has(repository, "sequencer")) {
            writer.writeStartElement(Element.SEQUENCERS.getLocalName());
            ModelNode sequencerNode = repository.get("sequencer");
            for (Property sequencer : sequencerNode.asPropertyList()) {
                writer.writeStartElement(Element.SEQUENCER.getLocalName());
                writer.writeAttribute(Attribute.NAME.getLocalName(), sequencer.getName());
                ModelNode prop = sequencer.getValue();
                ModelAttributes.SEQUENCER_CLASSNAME.marshallAsAttribute(prop, (XMLStreamWriter)writer);
                ModelAttributes.MODULE.marshallAsAttribute(prop, (XMLStreamWriter)writer);
                if (this.has(prop, "properties")) {
                    ModelNode properties = prop.get("properties");
                    for (Property property : properties.asPropertyList()) {
                        writer.writeAttribute(property.getName(), property.getValue().asString());
                    }
                }
                if (this.has(prop, "path-expressions")) {
                    List pathExpressions = prop.get("path-expressions").asList();
                    switch (pathExpressions.size()) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            ModelNode pathExpression = (ModelNode)pathExpressions.iterator().next();
                            writer.writeAttribute(Attribute.PATH_EXPRESSION.getLocalName(), pathExpression.asString());
                            break;
                        }
                        default: {
                            for (ModelNode pathExpr : pathExpressions) {
                                writer.writeStartElement(Element.PATH_EXPRESSION.getLocalName());
                                writer.writeCharacters(pathExpr.asString());
                                writer.writeEndElement();
                            }
                        }
                    }
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    private void writeIndexProviders(XMLExtendedStreamWriter writer, ModelNode repository) throws XMLStreamException {
        if (this.has(repository, "index-provider")) {
            writer.writeStartElement(Element.INDEX_PROVIDERS.getLocalName());
            ModelNode providerNode = repository.get("index-provider");
            for (Property provider : providerNode.asPropertyList()) {
                writer.writeStartElement(Element.INDEX_PROVIDER.getLocalName());
                writer.writeAttribute(Attribute.NAME.getLocalName(), provider.getName());
                ModelNode prop = provider.getValue();
                ModelAttributes.CLASSNAME.marshallAsAttribute(prop, (XMLStreamWriter)writer);
                ModelAttributes.MODULE.marshallAsAttribute(prop, (XMLStreamWriter)writer);
                ModelAttributes.RELATIVE_TO.marshallAsAttribute(prop, (XMLStreamWriter)writer);
                ModelAttributes.PATH.marshallAsAttribute(prop, (XMLStreamWriter)writer);
                if (this.has(prop, "properties")) {
                    ModelNode properties = prop.get("properties");
                    for (Property property : properties.asPropertyList()) {
                        writer.writeAttribute(property.getName(), property.getValue().asString());
                    }
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    private void writeIndexes(XMLExtendedStreamWriter writer, ModelNode repository) throws XMLStreamException {
        if (this.has(repository, "index")) {
            writer.writeStartElement(Element.INDEXES.getLocalName());
            ModelNode providerNode = repository.get("index");
            for (Property index : providerNode.asPropertyList()) {
                writer.writeStartElement(Element.INDEX.getLocalName());
                writer.writeAttribute(Attribute.NAME.getLocalName(), index.getName());
                ModelNode prop = index.getValue();
                ModelAttributes.PROVIDER_NAME.marshallAsAttribute(prop, (XMLStreamWriter)writer);
                ModelAttributes.INDEX_KIND.marshallAsAttribute(prop, (XMLStreamWriter)writer);
                ModelAttributes.SYNCHRONOUS.marshallAsAttribute(prop, (XMLStreamWriter)writer);
                ModelAttributes.NODE_TYPE_NAME.marshallAsAttribute(prop, (XMLStreamWriter)writer);
                ModelAttributes.INDEX_COLUMNS.marshallAsAttribute(prop, (XMLStreamWriter)writer);
                if (this.has(prop, "properties")) {
                    ModelNode properties = prop.get("properties");
                    for (Property property : properties.asPropertyList()) {
                        writer.writeAttribute(property.getName(), property.getValue().asString());
                    }
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    private void writeExternalSources(XMLExtendedStreamWriter writer, ModelNode repository) throws XMLStreamException {
        if (this.has(repository, "source")) {
            writer.writeStartElement(Element.EXTERNAL_SOURCES.getLocalName());
            ModelNode externalSourceNode = repository.get("source");
            for (Property externalSource : externalSourceNode.asPropertyList()) {
                writer.writeStartElement(Element.SOURCE.getLocalName());
                writer.writeAttribute(Attribute.NAME.getLocalName(), externalSource.getName());
                ModelNode prop = externalSource.getValue();
                ModelAttributes.CONNECTOR_CLASSNAME.marshallAsAttribute(prop, (XMLStreamWriter)writer);
                ModelAttributes.MODULE.marshallAsAttribute(prop, (XMLStreamWriter)writer);
                ModelAttributes.CACHE_TTL_SECONDS.marshallAsAttribute(prop, (XMLStreamWriter)writer);
                ModelAttributes.QUERYABLE.marshallAsAttribute(prop, (XMLStreamWriter)writer);
                ModelAttributes.READONLY.marshallAsAttribute(prop, (XMLStreamWriter)writer);
                ModelAttributes.EXPOSE_AS_WORKSPACE.marshallAsAttribute(prop, (XMLStreamWriter)writer);
                if (this.has(prop, "properties")) {
                    ModelNode properties = prop.get("properties");
                    for (Property property : properties.asPropertyList()) {
                        writer.writeAttribute(property.getName(), property.getValue().asString());
                    }
                }
                if (this.has(prop, "projections")) {
                    List projections = prop.get("projections").asList();
                    for (ModelNode projection : projections) {
                        writer.writeStartElement(Element.PROJECTION.getLocalName());
                        writer.writeCharacters(projection.asString());
                        writer.writeEndElement();
                    }
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    private void writeTextExtraction(XMLExtendedStreamWriter writer, ModelNode repository) throws XMLStreamException {
        if (this.has(repository, "text-extractor")) {
            writer.writeStartElement(Element.TEXT_EXTRACTORS.getLocalName());
            for (Property extractor : repository.get("text-extractor").asPropertyList()) {
                writer.writeStartElement(Element.TEXT_EXTRACTOR.getLocalName());
                writer.writeAttribute(Attribute.NAME.getLocalName(), extractor.getName());
                ModelNode prop = extractor.getValue();
                ModelAttributes.TEXT_EXTRACTOR_CLASSNAME.marshallAsAttribute(prop, (XMLStreamWriter)writer);
                ModelAttributes.MODULE.marshallAsAttribute(prop, (XMLStreamWriter)writer);
                if (this.has(prop, "properties")) {
                    ModelNode properties = prop.get("properties");
                    for (Property property : properties.asPropertyList()) {
                        writer.writeAttribute(property.getName(), property.getValue().asString());
                    }
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    private boolean has(ModelNode node, String name) {
        return node.isDefined() && node.has(name) && node.get(name).isDefined();
    }

    private boolean has(ModelNode node, String ... names) {
        for (String name : names) {
            if (!node.isDefined() || !node.has(name)) {
                return false;
            }
            node = node.get(name);
        }
        return true;
    }

    private void writeAttributeAsList(XMLExtendedStreamWriter writer, ModelNode node, ListAttributeDefinition modelAttribute) throws XMLStreamException {
        if (modelAttribute.isMarshallable(node, false)) {
            StringBuilder sb = new StringBuilder();
            Iterator iter = node.get(modelAttribute.getName()).asList().iterator();
            if (iter.hasNext()) {
                sb.append(((ModelNode)iter.next()).asString());
                while (iter.hasNext()) {
                    sb.append(" ").append(((ModelNode)iter.next()).asString());
                }
                writer.writeAttribute(modelAttribute.getXmlName(), sb.toString());
            }
        }
    }
}

