/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.batchindexing.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import org.hibernate.CacheMode;
import org.hibernate.SessionFactory;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.search.backend.spi.BatchBackend;
import org.hibernate.search.batchindexing.MassIndexerProgressMonitor;
import org.hibernate.search.batchindexing.impl.BatchTransactionalContext;
import org.hibernate.search.batchindexing.impl.ErrorHandledRunnable;
import org.hibernate.search.batchindexing.impl.IdentifierConsumerDocumentProducer;
import org.hibernate.search.batchindexing.impl.IdentifierProducer;
import org.hibernate.search.batchindexing.impl.OptionallyWrapInJTATransaction;
import org.hibernate.search.batchindexing.impl.ProducerConsumerQueue;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.exception.ErrorHandler;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.util.impl.Executors;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class BatchIndexingWorkspace
extends ErrorHandledRunnable {
    private static final Log log = LoggerFactory.make();
    private final SessionFactoryImplementor sessionFactory;
    private final ProducerConsumerQueue<List<Serializable>> primaryKeyStream;
    private final int documentBuilderThreads;
    private final Class<?> indexedType;
    private final String idNameOfIndexedType;
    private final CountDownLatch producerEndSignal;
    private final CountDownLatch endAllSignal;
    private final MassIndexerProgressMonitor monitor;
    private final CacheMode cacheMode;
    private final int objectLoadingBatchSize;
    private final BatchBackend backend;
    private final long objectsLimit;
    private final int idFetchSize;
    private final String tenantId;
    private final List<Future<?>> tasks = new ArrayList();

    public BatchIndexingWorkspace(ExtendedSearchIntegrator extendedIntegrator, SessionFactoryImplementor sessionFactory, Class<?> entityType, int objectLoadingThreads, CacheMode cacheMode, int objectLoadingBatchSize, CountDownLatch endAllSignal, MassIndexerProgressMonitor monitor, BatchBackend backend, long objectsLimit, int idFetchSize, String tenantId) {
        super(extendedIntegrator);
        this.indexedType = entityType;
        this.idFetchSize = idFetchSize;
        this.tenantId = tenantId;
        this.idNameOfIndexedType = extendedIntegrator.getIndexBinding(entityType).getDocumentBuilder().getIdentifierName();
        this.sessionFactory = sessionFactory;
        this.documentBuilderThreads = objectLoadingThreads;
        this.cacheMode = cacheMode;
        this.objectLoadingBatchSize = objectLoadingBatchSize;
        this.backend = backend;
        this.primaryKeyStream = new ProducerConsumerQueue(1);
        this.endAllSignal = endAllSignal;
        this.producerEndSignal = new CountDownLatch(this.documentBuilderThreads);
        this.monitor = monitor;
        this.objectsLimit = objectsLimit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runWithErrorHandler() {
        if (this.tasks.size() > 0) {
            throw new AssertionFailure("BatchIndexingWorkspace instance not expected to be reused - tasks should be empty");
        }
        try {
            ErrorHandler errorHandler = this.extendedIntegrator.getErrorHandler();
            BatchTransactionalContext transactionalContext = new BatchTransactionalContext(this.extendedIntegrator, this.sessionFactory, errorHandler, this.tenantId);
            this.startTransformationToLuceneWork(transactionalContext, errorHandler);
            this.startProducingPrimaryKeys(transactionalContext, errorHandler);
            try {
                this.producerEndSignal.await();
                log.debugf("All work for type %s has been produced", (Object)this.indexedType.getName());
            }
            catch (InterruptedException e) {
                for (Future<?> task : this.tasks) {
                    if (task.isDone()) continue;
                    task.cancel(true);
                }
                Thread.currentThread().interrupt();
                throw new SearchException("Interrupted on batch Indexing; index will be left in unknown state!");
            }
        }
        finally {
            this.endAllSignal.countDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startProducingPrimaryKeys(BatchTransactionalContext transactionalContext, ErrorHandler errorHandler) {
        OptionallyWrapInJTATransaction primaryKeyOutputter = new OptionallyWrapInJTATransaction(transactionalContext, new IdentifierProducer(this.primaryKeyStream, (SessionFactory)this.sessionFactory, this.objectLoadingBatchSize, this.indexedType, this.monitor, this.objectsLimit, errorHandler, this.idFetchSize, this.tenantId), this.tenantId);
        ThreadPoolExecutor execIdentifiersLoader = Executors.newFixedThreadPool((int)1, (String)"identifierloader");
        try {
            this.tasks.add(execIdentifiersLoader.submit(primaryKeyOutputter));
        }
        finally {
            execIdentifiersLoader.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startTransformationToLuceneWork(BatchTransactionalContext transactionalContext, ErrorHandler errorHandler) {
        OptionallyWrapInJTATransaction documentOutputter = new OptionallyWrapInJTATransaction(transactionalContext, new IdentifierConsumerDocumentProducer(this.primaryKeyStream, this.monitor, (SessionFactory)this.sessionFactory, this.producerEndSignal, this.cacheMode, this.indexedType, this.extendedIntegrator, this.idNameOfIndexedType, this.backend, errorHandler, this.tenantId), this.tenantId);
        ThreadPoolExecutor execFirstLoader = Executors.newFixedThreadPool((int)this.documentBuilderThreads, (String)"entityloader");
        try {
            for (int i = 0; i < this.documentBuilderThreads; ++i) {
                this.tasks.add(execFirstLoader.submit(documentOutputter));
            }
        }
        finally {
            execFirstLoader.shutdown();
        }
    }
}

