/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.embedded.impl;

import org.hibernate.hql.QueryParser;
import org.hibernate.hql.ast.spi.AstProcessingChain;
import org.hibernate.hql.ast.spi.EntityNamesResolver;
import org.hibernate.hql.lucene.LuceneProcessingChain;
import org.hibernate.hql.lucene.LuceneQueryParsingResult;
import org.hibernate.search.spi.SearchIntegrator;
import org.infinispan.query.SearchManager;
import org.infinispan.query.dsl.embedded.LuceneQuery;
import org.infinispan.query.dsl.embedded.impl.EmbeddedLuceneQuery;
import org.infinispan.query.dsl.embedded.impl.EmbeddedLuceneQueryFactory;
import org.infinispan.query.dsl.embedded.impl.QueryCache;
import org.infinispan.query.dsl.impl.BaseQueryBuilder;
import org.infinispan.query.dsl.impl.JPAQueryGenerator;
import org.infinispan.query.logging.Log;
import org.infinispan.util.KeyValuePair;
import org.infinispan.util.logging.LogFactory;

final class EmbeddedLuceneQueryBuilder
extends BaseQueryBuilder<LuceneQuery> {
    private static final Log log = (Log)LogFactory.getLog(EmbeddedLuceneQueryBuilder.class, Log.class);
    private final SearchManager searchManager;
    private final QueryCache queryCache;
    private final EntityNamesResolver entityNamesResolver;

    public EmbeddedLuceneQueryBuilder(EmbeddedLuceneQueryFactory queryFactory, SearchManager searchManager, QueryCache queryCache, EntityNamesResolver entityNamesResolver, String rootType) {
        super(queryFactory, rootType);
        this.searchManager = searchManager;
        this.queryCache = queryCache;
        this.entityNamesResolver = entityNamesResolver;
    }

    @Override
    public LuceneQuery build() {
        LuceneQueryParsingResult parsingResult;
        String jpqlString = this.accept(new JPAQueryGenerator());
        if (log.isTraceEnabled()) {
            log.tracef("JPQL string : %s", jpqlString);
        }
        if (this.queryCache != null) {
            KeyValuePair queryCacheKey = new KeyValuePair((Object)jpqlString, LuceneQueryParsingResult.class);
            parsingResult = (LuceneQueryParsingResult)this.queryCache.get((KeyValuePair<String, Class>)queryCacheKey);
            if (parsingResult == null) {
                parsingResult = this.parse(jpqlString);
                this.queryCache.put((KeyValuePair<String, Class>)queryCacheKey, parsingResult);
            }
        } else {
            parsingResult = this.parse(jpqlString);
        }
        return new EmbeddedLuceneQuery(this.queryFactory, jpqlString, this.searchManager, parsingResult, this.startOffset, this.maxResults);
    }

    private LuceneQueryParsingResult parse(String jpqlString) {
        SearchIntegrator searchFactory = this.searchManager.unwrap(SearchIntegrator.class);
        LuceneProcessingChain processingChain = new LuceneProcessingChain.Builder(searchFactory, this.entityNamesResolver).buildProcessingChainForClassBasedEntities();
        QueryParser queryParser = new QueryParser();
        return (LuceneQueryParsingResult)queryParser.parseQuery(jpqlString, (AstProcessingChain)processingChain);
    }
}

