/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.teiid;

import java.io.InputStream;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.Property;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.api.sequencer.Sequencer;
import org.modeshape.sequencer.teiid.TeiidI18n;
import org.modeshape.sequencer.teiid.VdbManifest;
import org.modeshape.sequencer.teiid.VdbSequencer;

public class VdbDynamicSequencer
extends VdbSequencer {
    @Override
    public boolean execute(Property inputProperty, Node outputNode, Sequencer.Context context) throws Exception {
        LOGGER.debug("VdbDynamicSequencer.execute called:outputNode name='{0}', path='{1}'", new Object[]{outputNode.getName(), outputNode.getPath()});
        Binary binaryValue = inputProperty.getBinary();
        CheckArg.isNotNull((Object)binaryValue, (String)"binary");
        try (InputStream stream = binaryValue.getStream();){
            VdbManifest manifest = this.readManifest(binaryValue, stream, outputNode, context);
            if (manifest == null) {
                throw new Exception("VdbDynamicSequencer.execute failed. The xml cannot be read.");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(TeiidI18n.errorReadingVdbFile.text(new Object[]{inputProperty.getPath(), e.getMessage()}), e);
        }
        return true;
    }
}

