/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.jcr.AccessDeniedException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.ValueFormatException;
import org.modeshape.common.i18n.I18nResource;
import org.modeshape.common.logging.Logger;
import org.modeshape.common.util.StringUtil;
import org.modeshape.jcr.AbstractJcrItem;
import org.modeshape.jcr.AbstractJcrNode;
import org.modeshape.jcr.ExecutionContext;
import org.modeshape.jcr.JcrLexicon;
import org.modeshape.jcr.JcrMixLexicon;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.JcrSession;
import org.modeshape.jcr.RepositoryI18n;
import org.modeshape.jcr.RepositoryStatistics;
import org.modeshape.jcr.Sequencers;
import org.modeshape.jcr.api.Binary;
import org.modeshape.jcr.api.JcrTools;
import org.modeshape.jcr.api.monitor.DurationMetric;
import org.modeshape.jcr.api.monitor.ValueMetric;
import org.modeshape.jcr.api.sequencer.Sequencer;
import org.modeshape.jcr.api.value.DateTime;
import org.modeshape.jcr.cache.change.RecordingChanges;
import org.modeshape.jcr.value.Name;

final class SequencingRunner
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger((String)"org.modeshape.jcr.sequencing.runner");
    private static final boolean TRACE = LOGGER.isTraceEnabled();
    private static final boolean DEBUG = LOGGER.isDebugEnabled();
    private static final String DERIVED_NODE_TYPE_NAME = "mode:derived";
    private static final String DERIVED_FROM_PROPERTY_NAME = "mode:derivedFrom";
    private final JcrRepository.RunningState repository;
    private final Sequencers.SequencingWorkItem work;

    protected SequencingRunner(JcrRepository.RunningState repository, Sequencers.SequencingWorkItem work) {
        this.repository = repository;
        this.work = work;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block33: {
            JcrSession inputSession = null;
            JcrSession outputSession = null;
            RepositoryStatistics stats = this.repository.statistics();
            Sequencer sequencer = null;
            String sequencerName = null;
            try {
                String mimeType;
                inputSession = this.repository.loginInternalSession(this.work.getInputWorkspaceName());
                outputSession = this.work.getOutputWorkspaceName() != null && !this.work.getOutputWorkspaceName().equals(this.work.getInputWorkspaceName()) ? this.repository.loginInternalSession(this.work.getOutputWorkspaceName()) : inputSession;
                sequencer = this.repository.sequencers().getSequencer(this.work.getSequencerId());
                if (sequencer == null) {
                    if (DEBUG) {
                        LOGGER.debug("Unable to find sequencer with ID '{0}' in repository '{1}'; skipping input '{3}:{2}' and output '{5}:{4}'", new Object[]{this.work.getSequencerId(), this.repository.name(), this.work.getInputPath(), this.work.getInputWorkspaceName(), this.work.getOutputPath(), this.work.getOutputWorkspaceName()});
                    }
                    return;
                }
                sequencerName = sequencer.getName();
                String logMsg = null;
                if (TRACE || DEBUG) {
                    logMsg = StringUtil.createString((String)"sequencer '{0}' in repository '{1}' with input '{3}:{2}' to produce '{5}:{4}'", (Object[])new Object[]{sequencerName, this.repository.name(), this.work.getInputPath(), this.work.getInputWorkspaceName(), this.work.getOutputPath(), this.work.getOutputWorkspaceName() != null ? this.work.getOutputWorkspaceName() : this.work.getInputWorkspaceName()});
                    LOGGER.debug("Running {0}", new Object[]{logMsg});
                }
                AbstractJcrNode selectedNode = inputSession.getNode(this.work.getSelectedPath());
                AbstractJcrItem inputItem = inputSession.getItem(this.work.getInputPath());
                Property changedProperty = null;
                if (inputItem instanceof Property) {
                    changedProperty = (Property)inputItem;
                } else {
                    Node changedNode = (Node)inputItem;
                    changedProperty = changedNode.getProperty(this.work.getChangedPropertyName());
                }
                assert (changedProperty != null);
                if (sequencer.hasAcceptedMimeTypes() && (mimeType = SequencingRunner.getInputMimeType(changedProperty)) != null && !sequencer.isAccepted(mimeType)) {
                    LOGGER.debug("Skipping sequencing because MIME type of input doesn't match expectations for {0}", new Object[]{logMsg});
                    return;
                }
                AbstractJcrNode outputNode = null;
                String primaryType = null;
                if (this.work.getSelectedPath().equals(this.work.getOutputPath())) {
                    outputNode = selectedNode.getName().equals("jcr:content") ? selectedNode.getParent() : selectedNode;
                    primaryType = selectedNode.getPrimaryNodeType().getName();
                } else {
                    AbstractJcrNode parentOfOutput = null;
                    try {
                        parentOfOutput = outputSession.getNode(this.work.getOutputPath());
                    }
                    catch (PathNotFoundException e) {
                        LOGGER.trace("Creating missing output path for {0}", new Object[]{logMsg});
                        JcrTools tools = new JcrTools();
                        parentOfOutput = (AbstractJcrNode)tools.findOrCreateNode((Session)outputSession, this.work.getOutputPath());
                    }
                    String outputNodeName = this.computeOutputNodeName(selectedNode);
                    this.removeExistingOutputNodes(parentOfOutput, outputNodeName, this.work.getSelectedPath(), logMsg);
                    if (parentOfOutput.isNew() && parentOfOutput.getName().equals(outputNodeName)) {
                        outputNode = parentOfOutput;
                    } else {
                        if (TRACE) {
                            LOGGER.trace("Creating output node '{0}' under parent '{1}' for {2}", new Object[]{outputNodeName, parentOfOutput.getPath(), logMsg});
                        }
                        outputNode = parentOfOutput.addNode(outputNodeName, "nt:unstructured");
                    }
                    outputNode.addMixin(DERIVED_NODE_TYPE_NAME);
                    outputNode.setProperty(DERIVED_FROM_PROPERTY_NAME, this.work.getSelectedPath());
                }
                DateTime now = outputSession.dateFactory().create();
                Sequencers.SequencingContext context = new Sequencers.SequencingContext(now, outputSession.getValueFactory());
                if (!inputSession.isLive() || inputSession != outputSession && !outputSession.isLive()) break block33;
                long start = System.nanoTime();
                try {
                    LOGGER.trace("Executing {0}", new Object[]{logMsg});
                    if (sequencer.execute(changedProperty, (Node)outputNode, (Sequencer.Context)context)) {
                        LOGGER.trace("Completed executing {0}", new Object[]{logMsg});
                        if (selectedNode == outputNode && !selectedNode.getPrimaryNodeType().getName().equals(primaryType)) {
                            String msg = RepositoryI18n.sequencersMayNotChangeThePrimaryTypeOfTheSelectedNode.text(new Object[0]);
                            throw new RepositoryException(msg);
                        }
                        List<AbstractJcrNode> outputNodes = this.findOutputNodes(outputNode);
                        this.setCreatedByIfNecessary(outputSession, outputNodes);
                        LOGGER.trace("Saving session used by {0}", new Object[]{logMsg});
                        outputSession.save();
                        LOGGER.trace("Firing events resulting from {0}", new Object[]{logMsg});
                        this.fireSequencingEvent(selectedNode, outputNodes, outputSession, sequencerName);
                        long durationInNanos = Math.abs(System.nanoTime() - start);
                        HashMap<String, String> payload = new HashMap<String, String>();
                        payload.put("sequencerName", sequencer.getClass().getName());
                        payload.put("sequencedPath", changedProperty.getPath());
                        payload.put("outputPath", outputNode.getPath());
                        stats.recordDuration(DurationMetric.SEQUENCER_EXECUTION_TIME, durationInNanos, TimeUnit.NANOSECONDS, payload);
                    }
                }
                catch (Throwable t) {
                    this.fireSequencingFailureEvent(selectedNode, inputSession, t, sequencerName);
                    throw t;
                }
            }
            catch (InterruptedException ie) {
                Thread.interrupted();
                LOGGER.warn((I18nResource)RepositoryI18n.shutdownWhileSequencing, new Object[]{this.work.getInputPath(), ie.getMessage()});
            }
            catch (Throwable t) {
                if (!this.repository.sequencers().acceptsWork()) {
                    LOGGER.warn((I18nResource)RepositoryI18n.shutdownWhileSequencing, new Object[]{this.work.getInputPath(), t.getMessage()});
                } else if (this.work.getOutputWorkspaceName() != null) {
                    LOGGER.error(t, (I18nResource)RepositoryI18n.errorWhileSequencingNodeIntoWorkspace, new Object[]{sequencerName, this.repository.name(), this.work.getInputPath(), this.work.getInputWorkspaceName(), this.work.getOutputPath(), this.work.getOutputWorkspaceName()});
                } else {
                    LOGGER.error(t, (I18nResource)RepositoryI18n.errorWhileSequencingNode, new Object[]{sequencerName, this.repository.name(), this.work.getInputPath(), this.work.getInputWorkspaceName(), this.work.getOutputPath()});
                }
            }
            finally {
                stats.increment(ValueMetric.SEQUENCED_COUNT);
                stats.decrement(ValueMetric.SEQUENCER_QUEUE_SIZE);
                if (inputSession != null && inputSession.isLive()) {
                    inputSession.logout();
                }
                if (outputSession != null && outputSession != inputSession && outputSession.isLive()) {
                    outputSession.logout();
                }
            }
        }
    }

    static String getInputMimeType(Property changedProperty) throws ItemNotFoundException, AccessDeniedException, RepositoryException, PathNotFoundException, ValueFormatException, IOException {
        javax.jcr.Binary binary;
        Property property;
        Node parent = changedProperty.getParent();
        String mimeType = null;
        if (parent.hasProperty("jcr:mimeType")) {
            property = parent.getProperty("jcr:mimeType");
            if (!property.isMultiple()) {
                mimeType = property.getString();
            }
        } else if (parent.getName().equals("jcr:content")) {
            try {
                parent = parent.getParent();
                if (parent.hasProperty("jcr:mimeType") && !(property = parent.getProperty("jcr:mimeType")).isMultiple()) {
                    mimeType = property.getString();
                }
            }
            catch (ItemNotFoundException e) {
                // empty catch block
            }
        }
        if (mimeType == null && !changedProperty.isMultiple() && changedProperty.getType() == 2 && (binary = changedProperty.getBinary()) instanceof Binary) {
            mimeType = ((Binary)binary).getMimeType(parent.getName());
        }
        return mimeType;
    }

    private void setCreatedByIfNecessary(JcrSession outputSession, List<AbstractJcrNode> outputNodes) throws RepositoryException {
        for (AbstractJcrNode node : outputNodes) {
            if (!node.isNodeType(JcrMixLexicon.CREATED)) continue;
            node.setProperty(JcrLexicon.CREATED_BY, outputSession.getValueFactory().createValue(this.work.getUserId()), true, true, false, false);
        }
    }

    private void fireSequencingEvent(AbstractJcrNode sequencedNode, List<AbstractJcrNode> outputNodes, JcrSession outputSession, String sequencerName) throws RepositoryException {
        ExecutionContext context = outputSession.context();
        RecordingChanges sequencingChanges = new RecordingChanges(outputSession.sessionId(), context.getProcessId(), outputSession.getRepository().repositoryKey(), outputSession.workspaceName(), outputSession.getRepository().journalId());
        Name primaryType = sequencedNode.getPrimaryTypeName();
        Set<Name> mixinTypes = sequencedNode.getMixinTypeNames();
        for (AbstractJcrNode outputNode : outputNodes) {
            sequencingChanges.nodeSequenced(sequencedNode.key(), sequencedNode.path(), primaryType, mixinTypes, outputNode.key(), outputNode.path(), this.work.getOutputPath(), this.work.getUserId(), this.work.getSelectedPath(), sequencerName, sequencedNode.node().isQueryable(outputSession.cache()));
        }
        sequencingChanges.freeze(outputSession.getUserID(), null, context.getValueFactories().getDateFactory().create());
        this.repository.changeBus().notify(sequencingChanges);
    }

    private void fireSequencingFailureEvent(AbstractJcrNode sequencedNode, JcrSession inputSession, Throwable cause, String sequencerName) throws RepositoryException {
        assert (sequencedNode != null);
        assert (inputSession != null);
        Name primaryType = sequencedNode.getPrimaryTypeName();
        Set<Name> mixinTypes = sequencedNode.getMixinTypeNames();
        ExecutionContext context = inputSession.context();
        RecordingChanges sequencingChanges = new RecordingChanges(inputSession.sessionId(), context.getProcessId(), inputSession.getRepository().repositoryKey(), inputSession.workspaceName(), inputSession.getRepository().journalId());
        sequencingChanges.nodeSequencingFailure(sequencedNode.key(), sequencedNode.path(), primaryType, mixinTypes, this.work.getOutputPath(), this.work.getUserId(), this.work.getSelectedPath(), sequencerName, sequencedNode.node().isQueryable(inputSession.cache()), cause);
        this.repository.changeBus().notify(sequencingChanges);
    }

    private List<AbstractJcrNode> findOutputNodes(AbstractJcrNode rootOutputNode) throws RepositoryException {
        if (rootOutputNode.isNew()) {
            return Arrays.asList(rootOutputNode);
        }
        ArrayList<AbstractJcrNode> nodes = new ArrayList<AbstractJcrNode>();
        NodeIterator childrenIt = rootOutputNode.getNodesInternal();
        while (childrenIt.hasNext()) {
            Node child = childrenIt.nextNode();
            if (!child.isNew()) continue;
            nodes.add((AbstractJcrNode)child);
        }
        return nodes;
    }

    protected final String computeOutputNodeName(Node selectedNode) throws RepositoryException {
        String selectedNodeName = selectedNode.getName();
        if (selectedNodeName.equals("jcr:content")) {
            try {
                return selectedNode.getParent().getName();
            }
            catch (ItemNotFoundException itemNotFoundException) {
                // empty catch block
            }
        }
        return selectedNodeName;
    }

    private void removeExistingOutputNodes(AbstractJcrNode parentOfOutput, String outputNodeName, String selectedPath, String logMsg) throws RepositoryException {
        if (TRACE) {
            LOGGER.trace("Looking under '{0}' for existing output to be removed for {1}", new Object[]{parentOfOutput.getPath(), logMsg});
        }
        NodeIterator outputIter = parentOfOutput.getNodesInternal(outputNodeName);
        while (outputIter.hasNext()) {
            String derivedFrom;
            Node outputNode = outputIter.nextNode();
            if (!outputNode.isNodeType(DERIVED_NODE_TYPE_NAME) || !outputNode.hasProperty(DERIVED_FROM_PROPERTY_NAME) || !selectedPath.equals(derivedFrom = outputNode.getProperty(DERIVED_FROM_PROPERTY_NAME).getPath())) continue;
            if (TRACE) {
                LOGGER.trace("Removing existing output node '{0}' for {1}", new Object[]{outputNode.getPath(), logMsg});
            }
            outputNode.remove();
        }
    }
}

