/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.index.local;

import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.jcr.query.qom.Constraint;
import org.modeshape.jcr.api.index.IndexManager;
import org.modeshape.jcr.index.local.LocalIndex;
import org.modeshape.jcr.spi.index.IndexConstraints;
import org.modeshape.jcr.spi.index.provider.Filter;
import org.modeshape.jcr.spi.index.provider.IndexChangeAdapter;
import org.modeshape.jcr.spi.index.provider.ManagedIndex;

public class ManagedLocalIndex
implements ManagedIndex {
    private final LocalIndex<?> index;
    private final IndexChangeAdapter adapter;
    private final AtomicBoolean enabled = new AtomicBoolean(true);
    private final AtomicReference<IndexManager.IndexStatus> status = new AtomicReference<IndexManager.IndexStatus>(IndexManager.IndexStatus.ENABLED);

    ManagedLocalIndex(LocalIndex<?> index, IndexChangeAdapter adapter) {
        assert (adapter != null);
        assert (index != null);
        this.index = index;
        this.adapter = adapter;
    }

    @Override
    public long estimateTotalCount() {
        return this.index.estimateTotalCount();
    }

    @Override
    public long estimateCardinality(Constraint constraint, Map<String, Object> variables) {
        return this.index.estimateCardinality(constraint, variables);
    }

    @Override
    public Filter.Results filter(IndexConstraints constraints) {
        return this.index.filter(constraints);
    }

    @Override
    public IndexChangeAdapter getIndexChangeAdapter() {
        return this.adapter;
    }

    @Override
    public void enable(boolean enable) {
        this.enabled.set(enable);
        if (enable) {
            this.updateStatus(IndexManager.IndexStatus.DISABLED, IndexManager.IndexStatus.ENABLED);
        } else {
            this.updateStatus(IndexManager.IndexStatus.ENABLED, IndexManager.IndexStatus.DISABLED);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown(boolean destroyed) {
        try {
            this.index.shutdown(destroyed);
        }
        finally {
            this.enable(false);
        }
    }

    @Override
    public void removeAll() {
        this.index.removeAll();
    }

    @Override
    public IndexManager.IndexStatus getStatus() {
        return this.status.get();
    }

    @Override
    public void updateStatus(IndexManager.IndexStatus currentStatus, IndexManager.IndexStatus newStatus) {
        this.status.compareAndSet(currentStatus, newStatus);
    }

    protected boolean isNew() {
        return this.index.isNew();
    }
}

