/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query.engine;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Set;
import org.modeshape.common.logging.Logger;
import org.modeshape.jcr.ExecutionContext;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.query.NodeSequence;
import org.modeshape.jcr.query.QueryContext;
import org.modeshape.jcr.query.QueryEngine;
import org.modeshape.jcr.query.QueryResults;
import org.modeshape.jcr.query.engine.IndexPlan;
import org.modeshape.jcr.query.engine.IndexPlanners;
import org.modeshape.jcr.query.engine.QuerySources;
import org.modeshape.jcr.query.engine.ScanningQueryEngine;
import org.modeshape.jcr.query.model.QueryCommand;
import org.modeshape.jcr.query.optimize.AddIndexes;
import org.modeshape.jcr.query.optimize.Optimizer;
import org.modeshape.jcr.query.optimize.OptimizerRule;
import org.modeshape.jcr.query.optimize.RuleBasedOptimizer;
import org.modeshape.jcr.query.plan.PlanHints;
import org.modeshape.jcr.query.plan.PlanNode;
import org.modeshape.jcr.query.plan.Planner;
import org.modeshape.jcr.spi.index.Index;
import org.modeshape.jcr.spi.index.IndexCostCalculator;
import org.modeshape.jcr.spi.index.IndexManager;
import org.modeshape.jcr.spi.index.provider.IndexPlanner;
import org.modeshape.jcr.spi.index.provider.IndexProvider;

public class IndexQueryEngine
extends ScanningQueryEngine {
    protected static final Logger LOGGER = Logger.getLogger((String)"org.modeshape.jcr.query");
    protected static final boolean TRACE = LOGGER.isTraceEnabled();
    protected static final boolean DEBUG = LOGGER.isDebugEnabled();
    private final IndexManager indexManager;

    public static Builder builder() {
        return new Builder();
    }

    protected IndexQueryEngine(ExecutionContext context, String repositoryName, Planner planner, Optimizer optimizer, IndexManager indexManager) {
        super(context, repositoryName, planner, optimizer);
        this.indexManager = indexManager;
    }

    @Override
    protected NodeSequence createNodeSequenceForSource(QueryCommand originalQuery, QueryContext context, PlanNode sourceNode, IndexPlan indexPlan, QueryResults.Columns columns, QuerySources sources) {
        Index index;
        NodeSequence sequence = super.createNodeSequenceForSource(originalQuery, context, sourceNode, indexPlan, columns, sources);
        if (sequence != null) {
            return sequence;
        }
        String providerName = indexPlan.getProviderName();
        IndexProvider provider = this.indexManager.getProvider(providerName);
        if (provider != null && (index = provider.getIndex(indexPlan.getName(), indexPlan.getWorkspaceName())) != null) {
            return sources.fromIndex(index, indexPlan.getConstraints(), context.getVariables(), indexPlan.getParameters(), context.getExecutionContext().getValueFactories(), provider.batchSize());
        }
        return null;
    }

    protected static class ProviderIndexPlanner
    extends IndexPlanner {
        protected final String providerName;
        private final IndexPlanner providerPlanner;

        protected ProviderIndexPlanner(String providerName, IndexPlanner providerPlanner) {
            this.providerName = providerName;
            this.providerPlanner = providerPlanner;
        }

        @Override
        public void applyIndexes(QueryContext context, IndexCostCalculator calculator) {
            if (!context.getIndexDefinitions().hasIndexDefinitions()) {
                return;
            }
            this.providerPlanner.applyIndexes(context, calculator);
        }

        public String toString() {
            return this.providerPlanner.toString();
        }
    }

    public static class Builder
    extends ScanningQueryEngine.Builder {
        @Override
        public QueryEngine build() {
            Set providerNames = this.indexManager().getProviderNames();
            if (providerNames.isEmpty()) {
                return super.build();
            }
            HashMap<String, IndexPlanner> plannersByProviderName = new HashMap<String, IndexPlanner>();
            for (String providerName : this.indexManager().getProviderNames()) {
                IndexProvider provider = this.indexManager().getProvider(providerName);
                if (provider == null) continue;
                IndexPlanner planner = provider.getIndexPlanner();
                if (planner == null) {
                    throw new IllegalStateException(JcrI18n.indexProviderMissingPlanner.text(new Object[]{providerName, this.repositoryName()}));
                }
                plannersByProviderName.put(providerName, planner);
            }
            IndexPlanners indexPlanners = IndexPlanners.withProviders(plannersByProviderName);
            Optimizer optimizer = this.optimizer();
            if (optimizer == null) {
                final AddIndexes indexingRule = AddIndexes.with(indexPlanners);
                optimizer = new RuleBasedOptimizer(){

                    @Override
                    protected void populateIndexingRules(LinkedList<OptimizerRule> ruleStack, PlanHints hints) {
                        ruleStack.addLast(indexingRule);
                    }
                };
            }
            return new IndexQueryEngine(this.context(), this.repositoryName(), this.planner(), optimizer, this.indexManager());
        }

        @Override
        protected final Optimizer defaultOptimizer() {
            return null;
        }
    }
}

