/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.objectfilter.impl.syntax;

import java.util.ArrayList;
import java.util.List;
import org.infinispan.objectfilter.impl.syntax.AndExpr;
import org.infinispan.objectfilter.impl.syntax.BooleanExpr;
import org.infinispan.objectfilter.impl.syntax.BooleanOperatorExpr;
import org.infinispan.objectfilter.impl.syntax.ComparisonExpr;
import org.infinispan.objectfilter.impl.syntax.ConstantBooleanExpr;
import org.infinispan.objectfilter.impl.syntax.ConstantValueExpr;
import org.infinispan.objectfilter.impl.syntax.IsNullExpr;
import org.infinispan.objectfilter.impl.syntax.LikeExpr;
import org.infinispan.objectfilter.impl.syntax.NoOpVisitor;
import org.infinispan.objectfilter.impl.syntax.NotExpr;
import org.infinispan.objectfilter.impl.syntax.OrExpr;
import org.infinispan.objectfilter.impl.syntax.PrimaryPredicateExpr;
import org.infinispan.objectfilter.impl.syntax.PropertyValueExpr;
import org.infinispan.objectfilter.impl.syntax.ValueExpr;
import org.infinispan.objectfilter.impl.syntax.Visitor;

public final class BooleanFilterNormalizer {
    private final Visitor simplifierVisitor = new NoOpVisitor(){

        @Override
        public BooleanExpr visit(NotExpr notExpr) {
            return (BooleanExpr)notExpr.getChild().acceptVisitor(BooleanFilterNormalizer.this.deMorganVisitor);
        }

        @Override
        public BooleanExpr visit(OrExpr orExpr) {
            ArrayList<BooleanExpr> children = new ArrayList<BooleanExpr>(orExpr.getChildren().size());
            for (BooleanExpr child : orExpr.getChildren()) {
                if ((child = (BooleanExpr)child.acceptVisitor(this)) instanceof ConstantBooleanExpr) {
                    if (!((ConstantBooleanExpr)child).getValue()) continue;
                    return ConstantBooleanExpr.TRUE;
                }
                if (child instanceof OrExpr) {
                    children.addAll(((OrExpr)child).getChildren());
                    continue;
                }
                children.add(child);
            }
            this.optimizePredicates(children, false);
            if (children.size() == 1) {
                return (BooleanExpr)children.get(0);
            }
            return new OrExpr(children);
        }

        @Override
        public BooleanExpr visit(AndExpr andExpr) {
            ArrayList<BooleanExpr> children = new ArrayList<BooleanExpr>(andExpr.getChildren().size());
            for (BooleanExpr child : andExpr.getChildren()) {
                if ((child = (BooleanExpr)child.acceptVisitor(this)) instanceof ConstantBooleanExpr) {
                    if (((ConstantBooleanExpr)child).getValue()) continue;
                    return ConstantBooleanExpr.FALSE;
                }
                if (child instanceof AndExpr) {
                    children.addAll(((AndExpr)child).getChildren());
                    continue;
                }
                children.add(child);
            }
            this.optimizePredicates(children, true);
            if (children.size() == 1) {
                return (BooleanExpr)children.get(0);
            }
            return new AndExpr(children);
        }

        private void optimizePredicates(List<BooleanExpr> children, boolean isConjunction) {
            this.removeRedundantPredicates(children, isConjunction);
            this.optimizeOverlappingIntervalPredicates(children, isConjunction);
        }

        private void removeRedundantPredicates(List<BooleanExpr> children, boolean isConjunction) {
            for (int i = 0; i < children.size(); ++i) {
                BooleanExpr ci = children.get(i);
                if (ci instanceof BooleanOperatorExpr) continue;
                boolean isCiNegated = ci instanceof NotExpr;
                if (isCiNegated) {
                    ci = ((NotExpr)ci).getChild();
                }
                assert (ci instanceof PrimaryPredicateExpr);
                PrimaryPredicateExpr ci1 = (PrimaryPredicateExpr)ci;
                assert (ci1.getChild() instanceof PropertyValueExpr);
                PropertyValueExpr pve = (PropertyValueExpr)ci1.getChild();
                if (pve.isRepeated()) continue;
                int j = i + 1;
                while (j < children.size()) {
                    BooleanExpr cj = children.get(j);
                    if (!(cj instanceof BooleanOperatorExpr)) {
                        boolean isCjNegated = cj instanceof NotExpr;
                        if (isCjNegated) {
                            cj = ((NotExpr)cj).getChild();
                        }
                        PrimaryPredicateExpr cj1 = (PrimaryPredicateExpr)cj;
                        assert (cj1.getChild() instanceof PropertyValueExpr);
                        PropertyValueExpr pve2 = (PropertyValueExpr)cj1.getChild();
                        if (!pve2.isRepeated()) {
                            int res = this.comparePrimaryPredicateExpr(isCiNegated, ci1, isCjNegated, cj1);
                            if (res == 0) {
                                children.remove(j);
                                continue;
                            }
                            if (res == 1) {
                                children.clear();
                                children.add(ConstantBooleanExpr.forBoolean(!isConjunction));
                                return;
                            }
                        }
                    }
                    ++j;
                }
            }
        }

        private int comparePrimaryPredicateExpr(boolean isFirstNegated, PrimaryPredicateExpr first, boolean isSecondNegated, PrimaryPredicateExpr second) {
            if (first.getClass() == second.getClass()) {
                if (first instanceof ComparisonExpr) {
                    ComparisonExpr comparison1 = (ComparisonExpr)first;
                    ComparisonExpr comparison2 = (ComparisonExpr)second;
                    assert (comparison1.getLeftChild() instanceof PropertyValueExpr);
                    assert (comparison1.getRightChild() instanceof ConstantValueExpr);
                    assert (comparison2.getLeftChild() instanceof PropertyValueExpr);
                    assert (comparison2.getRightChild() instanceof ConstantValueExpr);
                    assert (!isFirstNegated);
                    assert (!isSecondNegated);
                    if (comparison1.getLeftChild().equals(comparison2.getLeftChild()) && comparison1.getRightChild().equals(comparison2.getRightChild())) {
                        ComparisonExpr.Type cmpType2;
                        ComparisonExpr.Type cmpType1 = comparison1.getComparisonType();
                        return cmpType1 == (cmpType2 = comparison2.getComparisonType()) ? 0 : (cmpType1 == cmpType2.negate() ? 1 : -1);
                    }
                } else if (first.equals(second)) {
                    return isFirstNegated == isSecondNegated ? 0 : 1;
                }
            }
            return -1;
        }

        private void optimizeOverlappingIntervalPredicates(List<BooleanExpr> children, boolean isConjunction) {
            for (int i = 0; i < children.size(); ++i) {
                BooleanExpr ci = children.get(i);
                if (!(ci instanceof ComparisonExpr)) continue;
                ComparisonExpr first = (ComparisonExpr)ci;
                assert (first.getLeftChild() instanceof PropertyValueExpr);
                assert (first.getRightChild() instanceof ConstantValueExpr);
                PropertyValueExpr pve = (PropertyValueExpr)first.getLeftChild();
                if (pve.isRepeated()) continue;
                int j = i + 1;
                while (j < children.size()) {
                    BooleanExpr cj = children.get(j);
                    if (cj instanceof ComparisonExpr) {
                        BooleanExpr res;
                        ComparisonExpr second = (ComparisonExpr)cj;
                        assert (second.getLeftChild() instanceof PropertyValueExpr);
                        assert (second.getRightChild() instanceof ConstantValueExpr);
                        PropertyValueExpr pve2 = (PropertyValueExpr)second.getLeftChild();
                        if (!pve2.isRepeated() && first.getLeftChild().equals(second.getLeftChild()) && (res = this.optimizeOverlappingIntervalPredicates(first, second, isConjunction)) != null) {
                            if (res instanceof ConstantBooleanExpr) {
                                children.clear();
                                children.add(res);
                                return;
                            }
                            children.remove(j);
                            if (res == first) continue;
                            first = (ComparisonExpr)res;
                            children.set(i, first);
                            continue;
                        }
                    }
                    ++j;
                }
            }
        }

        private BooleanExpr optimizeOverlappingIntervalPredicates(ComparisonExpr first, ComparisonExpr second, boolean isConjunction) {
            Comparable firstValue = ((ConstantValueExpr)first.getRightChild()).getConstantValue();
            Comparable secondValue = ((ConstantValueExpr)second.getRightChild()).getConstantValue();
            int cmp = firstValue.compareTo(secondValue);
            if (first.getComparisonType() == ComparisonExpr.Type.EQUAL) {
                return BooleanFilterNormalizer.this.eqAndInterval(first, second, isConjunction, cmp);
            }
            if (second.getComparisonType() == ComparisonExpr.Type.EQUAL) {
                return BooleanFilterNormalizer.this.eqAndInterval(second, first, isConjunction, -cmp);
            }
            if (first.getComparisonType() == ComparisonExpr.Type.NOT_EQUAL) {
                return BooleanFilterNormalizer.this.notEqAndInterval(first, second, isConjunction, cmp);
            }
            if (second.getComparisonType() == ComparisonExpr.Type.NOT_EQUAL) {
                return BooleanFilterNormalizer.this.notEqAndInterval(second, first, isConjunction, -cmp);
            }
            if (cmp == 0) {
                if (first.getComparisonType() == second.getComparisonType()) {
                    return first;
                }
                if (first.getComparisonType() == second.getComparisonType().negate()) {
                    return isConjunction ? ConstantBooleanExpr.FALSE : ConstantBooleanExpr.TRUE;
                }
                if (first.getComparisonType() == ComparisonExpr.Type.LESS_OR_EQUAL || first.getComparisonType() == ComparisonExpr.Type.GREATER_OR_EQUAL) {
                    return isConjunction ? new ComparisonExpr(first.getLeftChild(), first.getRightChild(), ComparisonExpr.Type.EQUAL) : ConstantBooleanExpr.TRUE;
                }
                return isConjunction ? ConstantBooleanExpr.FALSE : new ComparisonExpr(first.getLeftChild(), first.getRightChild(), ComparisonExpr.Type.NOT_EQUAL);
            }
            if (first.getComparisonType() == second.getComparisonType().negate() || first.getComparisonType() == second.getComparisonType().reverse()) {
                if (cmp < 0) {
                    if (first.getComparisonType() == ComparisonExpr.Type.LESS || first.getComparisonType() == ComparisonExpr.Type.LESS_OR_EQUAL) {
                        if (isConjunction) {
                            return ConstantBooleanExpr.FALSE;
                        }
                    } else if (!isConjunction) {
                        return ConstantBooleanExpr.TRUE;
                    }
                } else if (first.getComparisonType() == ComparisonExpr.Type.GREATER || first.getComparisonType() == ComparisonExpr.Type.GREATER_OR_EQUAL) {
                    if (isConjunction) {
                        return ConstantBooleanExpr.FALSE;
                    }
                } else if (!isConjunction) {
                    return ConstantBooleanExpr.TRUE;
                }
                return null;
            }
            if (first.getComparisonType() == ComparisonExpr.Type.LESS || first.getComparisonType() == ComparisonExpr.Type.LESS_OR_EQUAL) {
                if (isConjunction) {
                    return cmp < 0 ? first : second;
                }
                return cmp < 0 ? second : first;
            }
            if (isConjunction) {
                return cmp < 0 ? second : first;
            }
            return cmp < 0 ? first : second;
        }

        @Override
        public BooleanExpr visit(ComparisonExpr comparisonExpr) {
            ValueExpr leftChild = comparisonExpr.getLeftChild();
            leftChild = (ValueExpr)leftChild.acceptVisitor(this);
            ValueExpr rightChild = comparisonExpr.getRightChild();
            rightChild = (ValueExpr)rightChild.acceptVisitor(this);
            ComparisonExpr.Type comparisonType = comparisonExpr.getComparisonType();
            if (leftChild instanceof ConstantValueExpr) {
                if (rightChild instanceof ConstantValueExpr) {
                    Comparable leftValue = ((ConstantValueExpr)leftChild).getConstantValue();
                    Comparable rightValue = ((ConstantValueExpr)rightChild).getConstantValue();
                    int compRes = leftValue.compareTo(rightValue);
                    switch (comparisonType) {
                        case LESS: {
                            return ConstantBooleanExpr.forBoolean(compRes < 0);
                        }
                        case LESS_OR_EQUAL: {
                            return ConstantBooleanExpr.forBoolean(compRes <= 0);
                        }
                        case EQUAL: {
                            return ConstantBooleanExpr.forBoolean(compRes == 0);
                        }
                        case NOT_EQUAL: {
                            return ConstantBooleanExpr.forBoolean(compRes != 0);
                        }
                        case GREATER_OR_EQUAL: {
                            return ConstantBooleanExpr.forBoolean(compRes >= 0);
                        }
                        case GREATER: {
                            return ConstantBooleanExpr.forBoolean(compRes > 0);
                        }
                    }
                    throw new IllegalStateException("Unexpected comparison type: " + (Object)((Object)comparisonType));
                }
                ValueExpr temp = rightChild;
                rightChild = leftChild;
                leftChild = temp;
                comparisonType = comparisonType.reverse();
            }
            return new ComparisonExpr(leftChild, rightChild, comparisonType);
        }
    };
    private final Visitor deMorganVisitor = new NoOpVisitor(){

        @Override
        public BooleanExpr visit(ConstantBooleanExpr constantBooleanExpr) {
            return constantBooleanExpr.negate();
        }

        @Override
        public BooleanExpr visit(NotExpr notExpr) {
            return (BooleanExpr)notExpr.getChild().acceptVisitor(BooleanFilterNormalizer.this.simplifierVisitor);
        }

        @Override
        public BooleanExpr visit(OrExpr orExpr) {
            ArrayList<BooleanExpr> children = new ArrayList<BooleanExpr>(orExpr.getChildren().size());
            for (BooleanExpr child : orExpr.getChildren()) {
                if ((child = (BooleanExpr)child.acceptVisitor(this)) instanceof ConstantBooleanExpr) {
                    if (((ConstantBooleanExpr)child).getValue()) continue;
                    return ConstantBooleanExpr.FALSE;
                }
                if (child instanceof AndExpr) {
                    children.addAll(((AndExpr)child).getChildren());
                    continue;
                }
                children.add(child);
            }
            if (children.size() == 1) {
                return (BooleanExpr)children.get(0);
            }
            return new AndExpr(children);
        }

        @Override
        public BooleanExpr visit(AndExpr andExpr) {
            ArrayList<BooleanExpr> children = new ArrayList<BooleanExpr>(andExpr.getChildren().size());
            for (BooleanExpr child : andExpr.getChildren()) {
                if ((child = (BooleanExpr)child.acceptVisitor(this)) instanceof ConstantBooleanExpr) {
                    if (!((ConstantBooleanExpr)child).getValue()) continue;
                    return ConstantBooleanExpr.TRUE;
                }
                if (child instanceof OrExpr) {
                    children.addAll(((OrExpr)child).getChildren());
                    continue;
                }
                children.add(child);
            }
            if (children.size() == 1) {
                return (BooleanExpr)children.get(0);
            }
            return new OrExpr(children);
        }

        @Override
        public BooleanExpr visit(ComparisonExpr comparisonExpr) {
            BooleanExpr booleanExpr = comparisonExpr.acceptVisitor(BooleanFilterNormalizer.this.simplifierVisitor);
            if (booleanExpr instanceof ConstantBooleanExpr) {
                return ((ConstantBooleanExpr)booleanExpr).negate();
            }
            if (booleanExpr instanceof NotExpr) {
                return ((NotExpr)booleanExpr).getChild();
            }
            if (booleanExpr instanceof ComparisonExpr) {
                ComparisonExpr c = (ComparisonExpr)booleanExpr;
                return new ComparisonExpr(c.getLeftChild(), c.getRightChild(), c.getComparisonType().negate());
            }
            return new NotExpr(booleanExpr);
        }

        @Override
        public BooleanExpr visit(IsNullExpr isNullExpr) {
            return new NotExpr(isNullExpr);
        }

        @Override
        public BooleanExpr visit(LikeExpr likeExpr) {
            return new NotExpr(likeExpr);
        }
    };

    private BooleanExpr eqAndInterval(ComparisonExpr first, ComparisonExpr second, boolean isConjunction, int cmp) {
        switch (second.getComparisonType()) {
            case EQUAL: {
                if (cmp == 0) {
                    return first;
                }
                return isConjunction ? ConstantBooleanExpr.FALSE : null;
            }
            case NOT_EQUAL: {
                if (cmp == 0) {
                    return ConstantBooleanExpr.forBoolean(!isConjunction);
                }
                return isConjunction ? first : null;
            }
            case LESS: {
                if (cmp == 0) {
                    return isConjunction ? ConstantBooleanExpr.FALSE : new ComparisonExpr(first.getLeftChild(), first.getRightChild(), ComparisonExpr.Type.LESS_OR_EQUAL);
                }
                if (cmp < 0) {
                    return isConjunction ? first : second;
                }
                return isConjunction ? ConstantBooleanExpr.FALSE : null;
            }
            case LESS_OR_EQUAL: {
                if (cmp <= 0) {
                    return isConjunction ? first : second;
                }
                return isConjunction ? ConstantBooleanExpr.FALSE : null;
            }
            case GREATER: {
                if (cmp == 0) {
                    return isConjunction ? ConstantBooleanExpr.FALSE : new ComparisonExpr(first.getLeftChild(), first.getRightChild(), ComparisonExpr.Type.GREATER_OR_EQUAL);
                }
                if (cmp > 0) {
                    return isConjunction ? first : second;
                }
                return isConjunction ? ConstantBooleanExpr.FALSE : null;
            }
            case GREATER_OR_EQUAL: {
                if (cmp >= 0) {
                    return isConjunction ? first : second;
                }
                return isConjunction ? ConstantBooleanExpr.FALSE : null;
            }
        }
        return null;
    }

    private BooleanExpr notEqAndInterval(ComparisonExpr first, ComparisonExpr second, boolean isConjunction, int cmp) {
        switch (second.getComparisonType()) {
            case EQUAL: {
                if (cmp == 0) {
                    return ConstantBooleanExpr.FALSE;
                }
                return isConjunction ? second : first;
            }
            case NOT_EQUAL: {
                if (cmp == 0) {
                    return first;
                }
                return isConjunction ? null : ConstantBooleanExpr.TRUE;
            }
            case LESS: {
                if (cmp >= 0) {
                    return isConjunction ? second : first;
                }
                return isConjunction ? null : ConstantBooleanExpr.TRUE;
            }
            case LESS_OR_EQUAL: {
                if (cmp < 0) {
                    return isConjunction ? null : ConstantBooleanExpr.TRUE;
                }
                if (cmp > 0) {
                    return isConjunction ? second : first;
                }
                return isConjunction ? new ComparisonExpr(first.getLeftChild(), first.getRightChild(), ComparisonExpr.Type.LESS) : ConstantBooleanExpr.TRUE;
            }
            case GREATER: {
                if (cmp > 0) {
                    return isConjunction ? null : ConstantBooleanExpr.TRUE;
                }
                return isConjunction ? second : first;
            }
            case GREATER_OR_EQUAL: {
                if (cmp < 0) {
                    return isConjunction ? second : first;
                }
                if (cmp > 0) {
                    return isConjunction ? new ComparisonExpr(first.getLeftChild(), first.getRightChild(), ComparisonExpr.Type.GREATER) : ConstantBooleanExpr.TRUE;
                }
                return isConjunction ? ConstantBooleanExpr.FALSE : null;
            }
        }
        return null;
    }

    public BooleanExpr normalize(BooleanExpr booleanExpr) {
        return (BooleanExpr)booleanExpr.acceptVisitor(this.simplifierVisitor);
    }
}

