/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.operations;

import java.net.SocketAddress;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import net.jcip.annotations.Immutable;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.impl.VersionedOperationResponse;
import org.infinispan.client.hotrod.impl.operations.RetryOnFailureOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.protocol.HeaderParams;
import org.infinispan.client.hotrod.impl.transport.Transport;
import org.infinispan.client.hotrod.impl.transport.TransportFactory;
import org.infinispan.commons.logging.BasicLogFactory;
import org.jboss.logging.BasicLogger;

@Immutable
public abstract class AbstractKeyOperation<T>
extends RetryOnFailureOperation<T> {
    private static final BasicLogger log = BasicLogFactory.getLog(AbstractKeyOperation.class);
    protected final byte[] key;

    protected AbstractKeyOperation(Codec codec, TransportFactory transportFactory, byte[] key, byte[] cacheName, AtomicInteger topologyId, Flag[] flags) {
        super(codec, transportFactory, cacheName, topologyId, flags);
        this.key = key;
    }

    @Override
    protected Transport getTransport(int retryCount, Set<SocketAddress> failedServers) {
        if (retryCount == 0) {
            return this.transportFactory.getTransport(this.key, failedServers, this.cacheName);
        }
        return this.transportFactory.getTransport(failedServers, this.cacheName);
    }

    protected short sendKeyOperation(byte[] key, Transport transport, byte opCode, byte opRespCode) {
        HeaderParams params = this.writeHeader(transport, opCode);
        transport.writeArray(key);
        transport.flush();
        return this.readHeaderAndValidate(transport, params);
    }

    protected byte[] returnPossiblePrevValue(Transport transport, short status) {
        return this.codec.returnPossiblePrevValue(transport, status, this.flags);
    }

    protected VersionedOperationResponse returnVersionedOperationResponse(Transport transport, HeaderParams params) {
        VersionedOperationResponse.RspCode code;
        short respStatus = this.readHeaderAndValidate(transport, params);
        if (respStatus == 0 || respStatus == 3) {
            code = VersionedOperationResponse.RspCode.SUCCESS;
        } else if (respStatus == 1 || respStatus == 4) {
            code = VersionedOperationResponse.RspCode.MODIFIED_KEY;
        } else if (respStatus == 2) {
            code = VersionedOperationResponse.RspCode.NO_SUCH_KEY;
        } else {
            throw new IllegalStateException("Unknown response status: " + Integer.toHexString(respStatus));
        }
        byte[] prevValue = this.returnPossiblePrevValue(transport, respStatus);
        return new VersionedOperationResponse(prevValue, code);
    }
}

