/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.teiid;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.StringUtil;

public class VdbModel
implements Comparable<VdbModel> {
    public static final String DEFAULT_METADATA_TYPE = "DDL";
    private String description;
    private String name;
    private String type;
    private String pathInVdb;
    private List<Source> sources = new ArrayList<Source>();
    private boolean visible = true;
    private boolean builtIn = false;
    private long checksum;
    private final Set<String> imports = new HashSet<String>();
    private List<ValidationMarker> problems = new ArrayList<ValidationMarker>();
    private final Map<String, String> properties = new HashMap<String, String>();
    private String metadata;
    private String metadataType;

    public VdbModel(String name, String type, String pathInVdb) {
        CheckArg.isNotEmpty((String)name, (String)"name");
        this.name = name;
        this.pathInVdb = pathInVdb;
        this.type = StringUtil.isBlank((String)type) ? "PHYSICAL" : type;
    }

    public String getDescription() {
        return this.description == null ? "" : this.description;
    }

    public void setDescription(String newValue) {
        this.description = newValue;
    }

    public String getName() {
        return this.name;
    }

    public String getModelDefinition() {
        return this.metadata;
    }

    public void setModelDefinition(String modelDefinition) {
        this.metadata = modelDefinition;
    }

    public String getMetadataType() {
        if (StringUtil.isBlank((String)this.metadata)) {
            return null;
        }
        if (StringUtil.isBlank((String)this.metadataType)) {
            return DEFAULT_METADATA_TYPE;
        }
        return this.metadataType;
    }

    public void setMetadataType(String metadataType) {
        this.metadataType = metadataType;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public String getType() {
        return this.type;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean isBuiltIn() {
        return this.builtIn;
    }

    public boolean isDeclarative() {
        return !this.getProperties().containsKey("indexName");
    }

    public void setBuiltIn(boolean builtIn) {
        this.builtIn = builtIn;
    }

    public long getChecksum() {
        return this.checksum;
    }

    public void setChecksum(long checksum) {
        this.checksum = checksum;
    }

    public String getPathInVdb() {
        return this.pathInVdb;
    }

    public Set<String> getImports() {
        return this.imports;
    }

    public void addImport(String newImport) {
        CheckArg.isNotEmpty((String)newImport, (String)"newImport");
        this.imports.add(newImport);
    }

    public List<Source> getSources() {
        return this.sources;
    }

    public void addSource(Source source) {
        CheckArg.isNotNull((Object)source, (String)"source");
        this.sources.add(source);
    }

    public List<ValidationMarker> getProblems() {
        return this.problems;
    }

    public void addProblem(Severity severity, String path, String message) {
        this.problems.add(new ValidationMarker(severity, path, message));
    }

    public void addProblem(String severity, String path, String message) {
        if (severity != null) {
            try {
                this.addProblem(Severity.valueOf(severity.trim().toUpperCase()), path, message);
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
    }

    @Override
    public int compareTo(VdbModel that) {
        if (that == null) {
            return 1;
        }
        if (that == this) {
            return 0;
        }
        if (this.getImports().contains(that.getPathInVdb())) {
            return 1;
        }
        if (that.getImports().contains(this.getPathInVdb())) {
            return -1;
        }
        return this.getImports().size() - that.getImports().size();
    }

    public static class ValidationMarker {
        private final String path;
        private final Severity severity;
        private final String message;

        public ValidationMarker(Severity severity, String path, String message) {
            this.severity = severity != null ? severity : Severity.ERROR;
            this.path = path != null ? path : "";
            this.message = message != null ? message : "";
        }

        public String getMessage() {
            return this.message;
        }

        public String getPath() {
            return this.path;
        }

        public Severity getSeverity() {
            return this.severity;
        }

        public String toString() {
            return this.severity.name() + " '" + this.path + "': " + this.message;
        }
    }

    public static enum Severity {
        WARNING,
        INFO,
        ERROR;

    }

    public class Source {
        private String name;
        private String translator;
        private String jndiName;

        public Source(String name, String translator) {
            CheckArg.isNotEmpty((String)name, (String)"name");
            CheckArg.isNotNull((Object)translator, (String)"translator");
            this.name = name;
            this.translator = translator;
        }

        public String getName() {
            return this.name;
        }

        public String getTranslator() {
            return this.translator;
        }

        public String getJndiName() {
            return this.jndiName;
        }

        public void setJndiName(String jndiName) {
            this.jndiName = jndiName;
        }
    }
}

