/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.security;

import java.security.AccessController;
import java.security.Principal;
import java.util.Map;
import javax.jcr.Credentials;
import javax.jcr.SimpleCredentials;
import javax.security.auth.Subject;
import org.jboss.logging.Logger;
import org.jboss.security.AuthenticationManager;
import org.jboss.security.ISecurityManagement;
import org.modeshape.jboss.service.RepositoryService;
import org.modeshape.jcr.ExecutionContext;
import org.modeshape.jcr.api.JaasCredentials;
import org.modeshape.jcr.security.EnvironmentAuthenticationProvider;
import org.modeshape.jcr.security.JaasSecurityContext;
import org.modeshape.jcr.security.JaccSubjectResolver;
import org.modeshape.jcr.security.SecurityContext;
import org.modeshape.jcr.security.SimplePrincipal;

public class JBossDomainAuthenticationProvider
extends EnvironmentAuthenticationProvider {
    private static final Logger LOGGER = Logger.getLogger((String)JBossDomainAuthenticationProvider.class.getPackage().getName());
    private AuthenticationManager authenticationManager;
    private JaccSubjectResolver jaccSubjectResolver;

    public void initialize() {
        String domainName = this.securityDomain();
        this.authenticationManager = ((ISecurityManagement)this.environment().getSecurityManagementServiceInjector().getValue()).getAuthenticationManager(domainName);
        assert (this.authenticationManager != null);
        this.jaccSubjectResolver = new JaccSubjectResolver();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Initialized JBoss authentication provider using the container's authentication manager....");
        }
    }

    public ExecutionContext authenticate(Credentials credentials, String repositoryName, String workspaceName, ExecutionContext repositoryContext, Map<String, Object> sessionAttributes) {
        if (credentials == null) {
            return this.getPreauthenticatedSubject(repositoryContext);
        }
        if (credentials instanceof SimpleCredentials) {
            return this.validateSimpleCredentials((SimpleCredentials)credentials, repositoryContext);
        }
        if (credentials instanceof JaasCredentials) {
            return this.getSubjectFromJaas((JaasCredentials)credentials, repositoryContext);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debugv("Unknown {0} implementation: {1}. Please user either {2} or {3}", new Object[]{Credentials.class.getName(), credentials.getClass().getName(), SimpleCredentials.class.getName(), JaasCredentials.class.getName()});
        }
        return null;
    }

    private ExecutionContext getSubjectFromJaas(JaasCredentials credentials, ExecutionContext repositoryContext) {
        Subject subject;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Looking for an active subject in the JaasCredentials instance...");
        }
        if ((subject = credentials.getLoginContext().getSubject()) == null) {
            LOGGER.warn((Object)"Cannot authenticate because the JassCredentials instance has a login context with a null subject...");
            return null;
        }
        return repositoryContext.with((SecurityContext)new JBossSecurityContext(new JaasSecurityContext(subject)));
    }

    private ExecutionContext validateSimpleCredentials(SimpleCredentials credentials, ExecutionContext repositoryContext) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debugv("Authenticating {0} in the {1} security domain using the JBoss Server security manager", (Object)credentials.getUserID(), (Object)this.securityDomain());
        }
        Subject subject = new Subject();
        if (this.authenticationManager.isValid((Principal)SimplePrincipal.newInstance((String)credentials.getUserID()), (Object)credentials.getPassword(), subject)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"Authentication successful....");
            }
            return repositoryContext.with((SecurityContext)new JBossSecurityContext(new JaasSecurityContext(subject)));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debugv("Credentials for {0} are not valid for the {1} security domain", (Object)credentials.getUserID(), (Object)this.securityDomain());
        }
        return null;
    }

    private ExecutionContext getPreauthenticatedSubject(ExecutionContext repositoryContext) {
        Subject subject;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Received null credentials, attempting to search for an active subject on the calling thread via JACC");
        }
        if ((subject = Subject.getSubject(AccessController.getContext())) != null) {
            return repositoryContext.with((SecurityContext)new JBossSecurityContext(new JaasSecurityContext(subject)));
        }
        subject = this.jaccSubjectResolver.resolveSubject();
        return subject != null ? repositoryContext.with((SecurityContext)new JBossSecurityContext(new JaasSecurityContext(subject))) : null;
    }

    protected RepositoryService environment() {
        return (RepositoryService)super.environment();
    }

    private final class JBossSecurityContext
    implements SecurityContext {
        private final JaasSecurityContext jaasSecurityContext;

        private JBossSecurityContext(JaasSecurityContext jaasSecurityContext) {
            assert (jaasSecurityContext != null);
            this.jaasSecurityContext = jaasSecurityContext;
        }

        public boolean isAnonymous() {
            return this.jaasSecurityContext.isAnonymous();
        }

        public String getUserName() {
            return this.jaasSecurityContext.getUserName();
        }

        public boolean hasRole(String roleName) {
            return this.jaasSecurityContext.hasRole(roleName);
        }

        public void logout() {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"Logging out security context....");
            }
            JBossDomainAuthenticationProvider.this.authenticationManager.logout((Principal)SimplePrincipal.newInstance((String)this.jaasSecurityContext.getUserName()), null);
            this.jaasSecurityContext.logout();
        }
    }
}

