/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.service;

import java.util.HashMap;
import java.util.Map;
import org.infinispan.schematic.Schematic;
import org.infinispan.schematic.document.Document;
import org.infinispan.schematic.document.EditableDocument;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.modeshape.jboss.service.BinaryStorage;
import org.modeshape.jboss.subsystem.ModeShapeServiceNames;

public class CompositeBinaryStorageService
implements Service<BinaryStorage> {
    private final String repositoryName;
    private final EditableDocument binaries;
    private final Map<String, InjectedValue<BinaryStorage>> nestedStoresValues;

    public CompositeBinaryStorageService(String repositoryName, EditableDocument binaries) {
        this.repositoryName = repositoryName;
        this.binaries = binaries;
        this.nestedStoresValues = new HashMap<String, InjectedValue<BinaryStorage>>();
    }

    public BinaryStorage getValue() throws IllegalStateException, IllegalArgumentException {
        return new BinaryStorage(this.binaries);
    }

    public InjectedValue<BinaryStorage> nestedStoreConfiguration(String storeName) {
        if (!this.nestedStoresValues.containsKey(storeName)) {
            this.nestedStoresValues.put(storeName, (InjectedValue<BinaryStorage>)new InjectedValue());
        }
        return this.nestedStoresValues.get(storeName);
    }

    public void start(StartContext startContext) {
        EditableDocument compositeDocument = Schematic.newDocument();
        for (String storeName : this.nestedStoresValues.keySet()) {
            compositeDocument.set(storeName, (Object)((BinaryStorage)this.nestedStoresValues.get(storeName).getValue()).getBinaryConfiguration());
        }
        this.binaries.setDocument("namedStores", (Document)compositeDocument);
    }

    public void stop(StopContext stopContext) {
        ServiceContainer serviceContainer = stopContext.getController().getServiceContainer();
        for (String storeName : this.nestedStoresValues.keySet()) {
            ServiceName serviceName = ModeShapeServiceNames.binaryStorageNestedServiceName(this.repositoryName, storeName);
            Service service = serviceContainer.getService(serviceName).getService();
            service.stop(stopContext);
        }
    }
}

