/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.subsystem;

import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.modeshape.jboss.subsystem.AddressContext;

class RemoveWebApp
extends AbstractRemoveStepHandler {
    static final RemoveWebApp INSTANCE = new RemoveWebApp();

    RemoveWebApp() {
    }

    protected void performRemove(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        if (!this.requiresRuntime(context)) {
            return;
        }
        if (!model.isDefined()) {
            return;
        }
        AddressContext addressContext = AddressContext.forOperation(operation);
        String webappName = addressContext.lastPathElementValue();
        PathAddress deploymentAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"deployment", (String)webappName)});
        ModelNode deploymentOp = Util.createOperation((String)"deployment", (PathAddress)deploymentAddress);
        ImmutableManagementResourceRegistration rootResourceRegistration = context.getRootResourceRegistration();
        OperationStepHandler removeDeploymentHandler = rootResourceRegistration.getOperationHandler(deploymentAddress, "remove");
        context.addStep(deploymentOp, removeDeploymentHandler, OperationContext.Stage.MODEL);
        super.performRemove(context, operation, model);
    }
}

