/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.bridge.builtin.impl;

import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;
import org.hibernate.search.bridge.LuceneOptions;
import org.hibernate.search.bridge.TwoWayFieldBridge;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class NullEncodingTwoWayFieldBridge
implements TwoWayFieldBridge {
    private static final Log LOG = LoggerFactory.make();
    private final TwoWayFieldBridge fieldBridge;
    private final String nullMarker;

    public NullEncodingTwoWayFieldBridge(TwoWayFieldBridge fieldBridge, String nullMarker) {
        this.fieldBridge = fieldBridge;
        this.nullMarker = nullMarker;
    }

    @Override
    public Object get(String name, Document document) {
        IndexableField field = document.getField(name);
        if (field == null) {
            LOG.loadingNonExistentField(name);
            return null;
        }
        String stringValue = field.stringValue();
        if (this.nullMarker.equals(stringValue)) {
            return null;
        }
        return this.fieldBridge.get(name, document);
    }

    @Override
    public String objectToString(Object object) {
        if (object == null) {
            return this.nullMarker;
        }
        return this.fieldBridge.objectToString(object);
    }

    public TwoWayFieldBridge unwrap() {
        return this.fieldBridge;
    }

    @Override
    public void set(String name, Object value, Document document, LuceneOptions luceneOptions) {
        if (value == null) {
            luceneOptions.addFieldToDocument(name, this.nullMarker, document);
        } else {
            this.fieldBridge.set(name, value, document, luceneOptions);
        }
    }
}

