/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.backend;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.search.cfg.SearchMapping;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.cfg.spi.SearchConfigurationBase;
import org.hibernate.search.engine.service.classloading.impl.DefaultClassLoaderService;
import org.hibernate.search.engine.service.classloading.spi.ClassLoaderService;
import org.hibernate.search.engine.service.spi.Service;
import org.hibernate.search.engine.spi.SearchMappingHelper;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.hibernate.search.spi.CacheManagerService;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.backend.ComponentRegistryService;
import org.infinispan.query.backend.DirectoryProviderService;
import org.infinispan.query.backend.InfinispanLoopbackService;

public class SearchableCacheConfiguration
extends SearchConfigurationBase
implements SearchConfiguration {
    private static final String HSEARCH_PREFIX = "hibernate.search.";
    private final Map<String, Class<?>> classes;
    private final Properties properties;
    private final SearchMapping searchMapping;
    private final Map<Class<? extends Service>, Object> providedServices;
    private final DefaultClassLoaderService classLoaderService = new DefaultClassLoaderService();

    public SearchableCacheConfiguration(Class<?>[] classArray, Properties properties, EmbeddedCacheManager uninitializedCacheManager, ComponentRegistry cr) {
        this.providedServices = SearchableCacheConfiguration.initializeProvidedServices(uninitializedCacheManager, cr);
        this.properties = properties == null ? new Properties() : SearchableCacheConfiguration.rescopeProperties(properties);
        this.classes = new HashMap();
        for (Class<?> c : classArray) {
            String classname = c.getName();
            this.classes.put(classname, c);
        }
        this.searchMapping = SearchMappingHelper.extractSearchMapping((SearchConfiguration)this);
        if (this.searchMapping != null) {
            Set mappedEntities = this.searchMapping.getMappedEntities();
            for (Class entity : mappedEntities) {
                this.classes.put(entity.getName(), entity);
            }
        }
    }

    private static Map initializeProvidedServices(EmbeddedCacheManager uninitializedCacheManager, ComponentRegistry cr) {
        InfinispanLoopbackService loopService = new InfinispanLoopbackService(cr, uninitializedCacheManager);
        HashMap<Class<org.hibernate.search.cfg.spi.DirectoryProviderService>, Object> map = new HashMap<Class<org.hibernate.search.cfg.spi.DirectoryProviderService>, Object>(2);
        map.put(ComponentRegistryService.class, loopService);
        map.put(CacheManagerService.class, loopService);
        DirectoryProviderService directoryProviderService = new DirectoryProviderService();
        map.put(org.hibernate.search.cfg.spi.DirectoryProviderService.class, (Object)directoryProviderService);
        return Collections.unmodifiableMap(map);
    }

    public boolean isDeleteByTermEnforced() {
        return true;
    }

    public Iterator<Class<?>> getClassMappings() {
        return this.classes.values().iterator();
    }

    public Class<?> getClassMapping(String name) {
        return this.classes.get(name);
    }

    public String getProperty(String propertyName) {
        return this.properties.getProperty(propertyName);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public ReflectionManager getReflectionManager() {
        return null;
    }

    public SearchMapping getProgrammaticMapping() {
        return this.searchMapping;
    }

    public Map<Class<? extends Service>, Object> getProvidedServices() {
        return this.providedServices;
    }

    public boolean isTransactionManagerExpected() {
        return false;
    }

    public boolean isIdProvidedImplicit() {
        return true;
    }

    private static Properties rescopeProperties(Properties origin) {
        Properties target = new Properties();
        for (Map.Entry<Object, Object> entry : origin.entrySet()) {
            Object key = entry.getKey();
            if (key instanceof String && !key.toString().startsWith(HSEARCH_PREFIX)) {
                key = HSEARCH_PREFIX + key.toString();
            }
            target.put(key, entry.getValue());
        }
        return target;
    }

    public ClassLoaderService getClassLoaderService() {
        return this.classLoaderService;
    }
}

