/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.index.elasticsearch.query;

import java.util.ArrayList;
import org.modeshape.jcr.index.elasticsearch.client.EsRequest;
import org.modeshape.jcr.index.elasticsearch.query.Query;

public class BoolQuery
extends Query {
    private final ArrayList<Query> must = new ArrayList();
    private final ArrayList<Query> should = new ArrayList();

    public BoolQuery must(Query q) {
        this.must.add(q);
        return this;
    }

    public BoolQuery should(Query q) {
        this.should.add(q);
        return this;
    }

    @Override
    public EsRequest build() {
        EsRequest query = new EsRequest();
        if (!this.must.isEmpty()) {
            query.put("must", this.documents(this.must));
        }
        if (!this.should.isEmpty()) {
            query.put("should", this.documents(this.should));
        }
        EsRequest body = new EsRequest();
        body.put("bool", query);
        return body;
    }

    private EsRequest[] documents(ArrayList<Query> list) {
        EsRequest[] res = new EsRequest[list.size()];
        int i = 0;
        for (Query query : list) {
            res[i++] = query.build();
        }
        return res;
    }
}

