/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.rangetree;

import org.apache.lucene.rangetree.HeapSliceReader;
import org.apache.lucene.rangetree.SliceReader;
import org.apache.lucene.rangetree.SliceWriter;

final class HeapSliceWriter
implements SliceWriter {
    final long[] values;
    final int[] docIDs;
    final long[] ords;
    private int nextWrite;

    public HeapSliceWriter(int count) {
        this.values = new long[count];
        this.docIDs = new int[count];
        this.ords = new long[count];
    }

    @Override
    public void append(long value, long ord, int docID) {
        this.values[this.nextWrite] = value;
        this.ords[this.nextWrite] = ord;
        this.docIDs[this.nextWrite] = docID;
        ++this.nextWrite;
    }

    @Override
    public SliceReader getReader(long start) {
        return new HeapSliceReader(this.values, this.ords, this.docIDs, (int)start, this.values.length);
    }

    @Override
    public void close() {
        if (this.nextWrite != this.values.length) {
            throw new IllegalStateException("only wrote " + this.nextWrite + " values, but expected " + this.values.length);
        }
    }

    @Override
    public void destroy() {
    }

    public String toString() {
        return "HeapSliceWriter(count=" + this.values.length + ")";
    }
}

