/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.metric;

import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.jboss.msc.service.ServiceController;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jboss.subsystem.AddressContext;
import org.modeshape.jboss.subsystem.ModeShapeServiceNames;
import org.modeshape.jcr.api.monitor.History;
import org.modeshape.jcr.api.monitor.RepositoryMonitor;
import org.modeshape.jcr.api.monitor.Statistics;
import org.modeshape.jcr.api.monitor.Window;

public abstract class ModeShapeMetricHandler
extends AbstractRuntimeOnlyHandler {
    private Logger logger;
    private final Window window;

    protected ModeShapeMetricHandler(Window metricWindow) {
        CheckArg.isNotNull((Object)metricWindow, (String)"metricWindow");
        this.window = metricWindow;
    }

    protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
        AddressContext addressContext = AddressContext.forOperation(operation);
        String repositoryName = addressContext.repositoryName();
        ServiceController sc = context.getServiceRegistry(false).getService(ModeShapeServiceNames.monitorServiceName(repositoryName));
        if (sc == null) {
            this.logger().debugv("ModeShape metric handler for repository {0} ignoring runtime step because the monitoring service is unavailable.Most likely the repository has been removed", (Object)repositoryName);
            return;
        }
        RepositoryMonitor repoStats = (RepositoryMonitor)sc.getValue();
        try {
            History history = this.history(repoStats);
            Statistics[] stats = history.getStats();
            if (stats.length != 0 && stats[stats.length - 1] != null) {
                ModelNode result = context.getResult();
                for (Statistics sample : stats) {
                    if (sample == null) continue;
                    result.add(sample.getMaximum());
                }
            }
            context.stepCompleted();
        }
        catch (Exception e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    protected abstract History history(RepositoryMonitor var1) throws Exception;

    protected final Logger logger() {
        if (this.logger == null) {
            this.logger = Logger.getLogger((String)((Object)((Object)this)).getClass().getName());
        }
        return this.logger;
    }

    protected Window window() {
        return this.window;
    }
}

