/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.service;

import org.infinispan.schematic.document.EditableDocument;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.modeshape.jboss.service.BinaryStorage;

public class BinaryStorageService
implements Service<BinaryStorage> {
    private final InjectedValue<String> binaryStorageBasePathInjector = new InjectedValue();
    private final BinaryStorage binaryStorage;

    public static BinaryStorageService createDefault() {
        return new BinaryStorageService(BinaryStorage.defaultConfig());
    }

    public static BinaryStorageService createWithConfiguration(EditableDocument binaryConfig) {
        return new BinaryStorageService(new BinaryStorage(binaryConfig));
    }

    private BinaryStorageService(BinaryStorage storage) {
        this.binaryStorage = storage;
    }

    private String getBinaryStorageBasePath() {
        return this.appendDirDelim((String)this.binaryStorageBasePathInjector.getOptionalValue());
    }

    private String appendDirDelim(String value) {
        if (value != null && !value.endsWith("/")) {
            value = value + "/";
        }
        return value;
    }

    public InjectedValue<String> getBinaryStorageBasePathInjector() {
        return this.binaryStorageBasePathInjector;
    }

    public BinaryStorage getValue() throws IllegalStateException, IllegalArgumentException {
        assert (this.binaryStorage != null);
        return this.binaryStorage;
    }

    public void start(StartContext arg0) {
        String binaryStorageBasePath = this.getBinaryStorageBasePath();
        if (binaryStorageBasePath != null) {
            String trashPath;
            EditableDocument binaryConfig = this.binaryStorage.getBinaryConfiguration();
            String relativePath = binaryConfig.getString("directory");
            if (relativePath != null) {
                binaryConfig.set("directory", (Object)(binaryStorageBasePath + relativePath));
            }
            if ((trashPath = binaryConfig.getString("trash")) != null) {
                binaryConfig.set("trash", (Object)(binaryStorageBasePath + trashPath));
            }
        }
    }

    public void stop(StopContext arg0) {
    }
}

