/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.subsystem;

import org.infinispan.schematic.document.EditableDocument;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.modeshape.jboss.subsystem.AbstractAddBinaryStorage;
import org.modeshape.jboss.subsystem.ModelAttributes;

public class AddCacheBinaryStorage
extends AbstractAddBinaryStorage {
    public static final AddCacheBinaryStorage INSTANCE = new AddCacheBinaryStorage();
    private String containerName;

    private AddCacheBinaryStorage() {
    }

    @Override
    protected void writeBinaryStorageConfiguration(String repositoryName, OperationContext context, ModelNode model, EditableDocument binaries) throws OperationFailedException {
        ModelNode infinispanConfig;
        binaries.set("type", (Object)"cache");
        String defaultDataCache = repositoryName + "-binary-data";
        String defaultMetaCache = repositoryName + "-binary-metadata";
        ModelNode dataNode = ModelAttributes.DATA_CACHE_NAME.resolveModelAttribute(context, model);
        ModelNode metaNode = ModelAttributes.METADATA_CACHE_NAME.resolveModelAttribute(context, model);
        String dataCache = dataNode.isDefined() ? dataNode.asString() : defaultDataCache;
        String metaCache = metaNode.isDefined() ? metaNode.asString() : defaultMetaCache;
        binaries.set("dataCacheName", (Object)dataCache);
        binaries.set("metadataCacheName", (Object)metaCache);
        ModelNode chunkSize = ModelAttributes.CHUNK_SIZE.resolveModelAttribute(context, model);
        if (chunkSize.isDefined()) {
            binaries.set("chunkSize", (Object)chunkSize.asInt());
        }
        if ((infinispanConfig = ModelAttributes.CACHE_CONFIG.resolveModelAttribute(context, model)).isDefined()) {
            binaries.set("cacheConfiguration", (Object)infinispanConfig.asString());
        }
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        AddCacheBinaryStorage.populate(operation, model, ModelAttributes.CACHE_BINARY_STORAGE_ATTRIBUTES);
    }
}

