/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.common.util;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.common.util.NamedThreadFactory;
import org.modeshape.common.util.ThreadPoolFactory;

@ThreadSafe
public class ThreadPools
implements ThreadPoolFactory {
    private static final int DEFAULT_MAX_THREAD_COUNT = 4;
    private static final int DEFAULT_SCHEDULED_THREAD_COUNT = 1;
    private final ConcurrentMap<String, ExecutorService> poolsByName = new ConcurrentHashMap<String, ExecutorService>();

    @Override
    public ExecutorService getThreadPool(String name) {
        return this.getOrCreateNewPool(name, Executors.newFixedThreadPool(4, new NamedThreadFactory(name)));
    }

    @Override
    public ExecutorService getCachedTreadPool(String name, int maxPoolSize) {
        NamedThreadFactory threadFactory = new NamedThreadFactory(name);
        ThreadPoolExecutor executorService = new ThreadPoolExecutor(0, maxPoolSize, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), threadFactory);
        return this.getOrCreateNewPool(name, executorService);
    }

    @Override
    public ScheduledExecutorService getScheduledThreadPool(String name) {
        return (ScheduledExecutorService)this.getOrCreateNewPool(name, Executors.newScheduledThreadPool(1, new NamedThreadFactory(name)));
    }

    private ExecutorService getOrCreateNewPool(String name, ExecutorService executorService) {
        ExecutorService executor = (ExecutorService)this.poolsByName.get(name);
        if (executor == null) {
            executor = this.poolsByName.putIfAbsent(name, executorService);
            if (executor != null) {
                executor.shutdownNow();
            }
            executor = executorService;
        }
        return executor;
    }

    @Override
    public void releaseThreadPool(ExecutorService executor) {
        for (String executorServiceName : this.poolsByName.keySet()) {
            ExecutorService executorService = (ExecutorService)this.poolsByName.get(executorServiceName);
            if (!executor.equals(executorService)) continue;
            executorService.shutdown();
            return;
        }
    }

    @Override
    public void terminateAllPools(long maxWaitTime, TimeUnit unit) {
        Iterator entryIterator = this.poolsByName.entrySet().iterator();
        while (entryIterator.hasNext()) {
            block5: {
                Map.Entry entry = entryIterator.next();
                ExecutorService executorService = (ExecutorService)entry.getValue();
                if (!executorService.isShutdown()) {
                    executorService.shutdown();
                    try {
                        if (maxWaitTime > 0L) {
                            executorService.awaitTermination(maxWaitTime, unit);
                        }
                        executorService.shutdownNow();
                    }
                    catch (InterruptedException e) {
                        if (!Thread.interrupted()) break block5;
                        executorService.shutdownNow();
                    }
                }
            }
            entryIterator.remove();
        }
    }
}

