/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.git;

import java.io.IOException;
import java.io.InputStream;
import javax.jcr.RepositoryException;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.infinispan.schematic.document.Document;
import org.modeshape.common.i18n.I18nResource;
import org.modeshape.connector.git.CallSpecification;
import org.modeshape.connector.git.GitBinaryValue;
import org.modeshape.connector.git.GitCommitDetails;
import org.modeshape.connector.git.GitConnector;
import org.modeshape.connector.git.GitFunction;
import org.modeshape.connector.git.GitHistory;
import org.modeshape.connector.git.GitI18n;
import org.modeshape.connector.git.GitLexicon;
import org.modeshape.connector.git.PageableGitFunction;
import org.modeshape.connector.git.Values;
import org.modeshape.jcr.JcrLexicon;
import org.modeshape.jcr.api.value.DateTime;
import org.modeshape.jcr.spi.federation.DocumentWriter;
import org.modeshape.jcr.spi.federation.PageKey;
import org.modeshape.jcr.spi.federation.PageWriter;
import org.modeshape.jcr.value.BinaryKey;

public class GitTree
extends GitFunction
implements PageableGitFunction {
    protected static final String JCR_CONTENT = "jcr:content";
    protected static final String JCR_CONTENT_SUFFIX = "/jcr:content";
    protected static final String NAME = "tree";
    protected static final String ID = "/tree";

    protected static Object referenceToTree(ObjectId commitId, String branchOrTagOrCommitId, Values values) {
        return values.referenceTo("/tree/" + branchOrTagOrCommitId);
    }

    public GitTree(GitConnector connector) {
        super(NAME, connector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Document execute(Repository repository, Git git, CallSpecification spec, DocumentWriter writer, Values values) throws GitAPIException, IOException {
        if (spec.parameterCount() == 0) {
            writer.setPrimaryType(GitLexicon.TREES);
            this.addBranchesAsChildren(git, spec, writer);
            this.addTagsAsChildren(git, spec, writer);
            this.addCommitsAsChildren(git, spec, writer, this.pageSize);
        } else if (spec.parameterCount() == 1) {
            String branchOrTagOrObjectId = spec.parameter(0);
            ObjectId objId = this.resolveBranchOrTagOrCommitId(repository, branchOrTagOrObjectId);
            RevWalk walker = new RevWalk(repository);
            walker.setRetainBody(true);
            try {
                RevCommit commit = walker.parseCommit((AnyObjectId)objId);
                if (commit != null) {
                    String committer = this.commiterName(commit);
                    String author = this.authorName(commit);
                    DateTime committed = values.dateFrom(commit.getCommitTime());
                    writer.setPrimaryType(GitLexicon.FOLDER);
                    writer.addProperty(JcrLexicon.CREATED, (Object)committed);
                    writer.addProperty(JcrLexicon.CREATED_BY, (Object)committer);
                    writer.addProperty(GitLexicon.OBJECT_ID, (Object)objId.name());
                    writer.addProperty(GitLexicon.AUTHOR, (Object)author);
                    writer.addProperty(GitLexicon.COMMITTER, (Object)committer);
                    writer.addProperty(GitLexicon.COMMITTED, (Object)committed);
                    writer.addProperty(GitLexicon.TITLE, (Object)commit.getShortMessage());
                    writer.addProperty(GitLexicon.HISTORY, GitHistory.referenceToHistory(objId, branchOrTagOrObjectId, values));
                    writer.addProperty(GitLexicon.DETAIL, GitCommitDetails.referenceToCommit(objId, values));
                    this.addInformationForPath(repository, writer, commit, "", spec, values);
                }
                this.connector.getLogger().warn((I18nResource)GitI18n.cannotReadCommit, new Object[]{objId});
            }
            finally {
                walker.dispose();
            }
        } else {
            String branchOrTagOrObjectId = spec.parameter(0);
            String path = spec.parametersAsPath(1);
            ObjectId objId = this.resolveBranchOrTagOrCommitId(repository, branchOrTagOrObjectId);
            RevWalk walker = new RevWalk(repository);
            walker.setRetainBody(true);
            try {
                RevCommit commit = walker.parseCommit((AnyObjectId)objId);
                if (commit != null) {
                    this.addInformationForPath(repository, writer, commit, path, spec, values);
                }
            }
            finally {
                walker.dispose();
            }
        }
        return writer.document();
    }

    protected void addInformationForPath(Repository repository, DocumentWriter writer, RevCommit commit, String path, CallSpecification spec, Values values) throws GitAPIException, IOException {
        if (path.startsWith("/")) {
            path = path.length() == 1 ? "" : path.substring(1);
        }
        boolean isContentNode = false;
        if (path.endsWith(JCR_CONTENT_SUFFIX)) {
            isContentNode = true;
            path = path.substring(0, path.length() - JCR_CONTENT_SUFFIX.length());
        }
        TreeWalk tw = new TreeWalk(repository);
        tw.addTree((AnyObjectId)commit.getTree());
        if ("".equals(path)) {
            tw.setRecursive(false);
            while (tw.next()) {
                String childName = tw.getNameString();
                String childId = spec.childId(childName);
                writer.addChild(childId, childName);
            }
        } else {
            PathFilter filter = PathFilter.create((String)path);
            tw.setFilter((TreeFilter)filter);
            while (tw.next() && !filter.isDone(tw)) {
                if (!tw.isSubtree()) continue;
                tw.enterSubtree();
            }
            if (tw.isSubtree()) {
                tw.enterSubtree();
                writer.setPrimaryType(GitLexicon.FOLDER);
                String committer = this.commiterName(commit);
                String author = this.authorName(commit);
                DateTime committed = values.dateFrom(commit.getCommitTime());
                writer.addProperty(JcrLexicon.CREATED, (Object)committed);
                writer.addProperty(JcrLexicon.CREATED_BY, (Object)committer);
                writer.addProperty(GitLexicon.OBJECT_ID, (Object)commit.getId().name());
                writer.addProperty(GitLexicon.AUTHOR, (Object)author);
                writer.addProperty(GitLexicon.COMMITTER, (Object)committer);
                writer.addProperty(GitLexicon.COMMITTED, (Object)committed);
                writer.addProperty(GitLexicon.TITLE, (Object)commit.getShortMessage());
                while (tw.next()) {
                    String childName = tw.getNameString();
                    String childId = spec.childId(childName);
                    writer.addChild(childId, childName);
                }
            } else if (isContentNode) {
                writer.setPrimaryType(GitLexicon.RESOURCE);
                String committer = this.commiterName(commit);
                String author = this.authorName(commit);
                DateTime committed = values.dateFrom(commit.getCommitTime());
                writer.addProperty(JcrLexicon.LAST_MODIFIED, (Object)committed);
                writer.addProperty(JcrLexicon.LAST_MODIFIED_BY, (Object)committer);
                writer.addProperty(GitLexicon.OBJECT_ID, (Object)commit.getId().name());
                writer.addProperty(GitLexicon.AUTHOR, (Object)author);
                writer.addProperty(GitLexicon.COMMITTER, (Object)committer);
                writer.addProperty(GitLexicon.COMMITTED, (Object)committed);
                writer.addProperty(GitLexicon.TITLE, (Object)commit.getShortMessage());
                ObjectId fileObjectId = tw.getObjectId(0);
                ObjectLoader fileLoader = repository.open((AnyObjectId)fileObjectId);
                BinaryKey key = new BinaryKey(fileObjectId.getName());
                Object value = values.binaryFor(key, fileLoader.getSize());
                if (value == null) {
                    value = fileLoader.isLarge() ? values.binaryFrom((InputStream)fileLoader.openStream()) : new GitBinaryValue(fileObjectId, fileLoader, this.connector.getSourceName(), this.name, this.connector.getMimeTypeDetector());
                }
                writer.addProperty(JcrLexicon.DATA, value);
                if (this.connector.includeMimeType()) {
                    try {
                        String filename = spec.parameter(spec.parameterCount() - 1);
                        String mimeType = value.getMimeType(filename);
                        if (mimeType != null) {
                            writer.addProperty(JcrLexicon.MIMETYPE, (Object)mimeType);
                        }
                    }
                    catch (RepositoryException repositoryException) {
                    }
                    catch (IOException iOException) {}
                }
            } else {
                writer.setPrimaryType(GitLexicon.FILE);
                String committer = this.commiterName(commit);
                String author = this.authorName(commit);
                DateTime committed = values.dateFrom(commit.getCommitTime());
                writer.addProperty(JcrLexicon.CREATED, (Object)committed);
                writer.addProperty(JcrLexicon.CREATED_BY, (Object)committer);
                writer.addProperty(GitLexicon.OBJECT_ID, (Object)commit.getId().name());
                writer.addProperty(GitLexicon.AUTHOR, (Object)author);
                writer.addProperty(GitLexicon.COMMITTER, (Object)committer);
                writer.addProperty(GitLexicon.COMMITTED, (Object)committed);
                writer.addProperty(GitLexicon.TITLE, (Object)commit.getShortMessage());
                String childId = spec.childId(JCR_CONTENT);
                writer.addChild(childId, JCR_CONTENT);
            }
        }
    }

    @Override
    public boolean isPaged() {
        return true;
    }

    @Override
    public Document execute(Repository repository, Git git, CallSpecification spec, PageWriter writer, Values values, PageKey pageKey) throws GitAPIException, IOException {
        if (spec.parameterCount() != 0) {
            return null;
        }
        this.addCommitsAsPageOfChildren(git, repository, spec, writer, pageKey);
        return writer.document();
    }
}

