/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.index.elasticsearch;

import java.io.IOException;
import java.util.List;
import org.infinispan.schematic.document.Document;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.index.elasticsearch.EsIndexException;
import org.modeshape.jcr.index.elasticsearch.client.EsClient;
import org.modeshape.jcr.index.elasticsearch.client.EsRequest;
import org.modeshape.jcr.index.elasticsearch.client.EsResponse;
import org.modeshape.jcr.spi.index.ResultWriter;
import org.modeshape.jcr.spi.index.provider.Filter;

public class SearchResults
implements Filter.Results {
    private final EsClient client;
    private final EsRequest query;
    private final String index;
    private final String type;
    private int pos = 0;
    private int totalHits;

    public SearchResults(EsClient client, String index, String type, EsRequest query) {
        this.client = client;
        this.query = query;
        this.index = index;
        this.type = type;
    }

    public boolean getNextBatch(ResultWriter writer, int batchSize) {
        this.query.put("from", this.pos);
        this.query.put("size", batchSize);
        try {
            EsResponse res = this.client.search(this.index, this.type, this.query);
            Document hits = (Document)res.get("hits");
            this.totalHits = hits.getInteger("total");
            List items = hits.getArray("hits");
            for (Object doc : items) {
                Document hit = (Document)doc;
                String nodeKey = hit.getString("_id");
                float score = hit.getDouble("_score").floatValue();
                writer.add(new NodeKey(nodeKey), score);
                ++this.pos;
            }
            return this.pos < this.totalHits;
        }
        catch (IOException e) {
            return false;
        }
    }

    public void close() {
    }

    public long getCardinality() {
        if (this.pos > 0) {
            return this.totalHits;
        }
        try {
            EsResponse res = this.client.search(this.index, this.type, this.query);
            Document hits = (Document)res.get("hits");
            this.totalHits = hits.getInteger("total");
            return this.totalHits;
        }
        catch (Exception e) {
            throw new EsIndexException(e);
        }
    }
}

