/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.jcr.RepositoryException;
import org.modeshape.common.SystemFailureException;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.common.collection.ArrayListMultimap;
import org.modeshape.common.collection.Collections;
import org.modeshape.common.collection.Multimap;
import org.modeshape.common.collection.SimpleProblems;
import org.modeshape.common.i18n.I18nResource;
import org.modeshape.common.logging.Logger;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.Reflection;
import org.modeshape.jcr.ExecutionContext;
import org.modeshape.jcr.ExtensionLogger;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrLexicon;
import org.modeshape.jcr.JcrNodeType;
import org.modeshape.jcr.JcrProblems;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.ModeShapeLexicon;
import org.modeshape.jcr.NodeTypes;
import org.modeshape.jcr.RepositoryConfiguration;
import org.modeshape.jcr.RepositoryIndexColumnDefinitionTemplate;
import org.modeshape.jcr.RepositoryIndexDefinition;
import org.modeshape.jcr.RepositoryIndexDefinitionTemplate;
import org.modeshape.jcr.RepositoryIndexes;
import org.modeshape.jcr.RepositoryNodeTypeManager;
import org.modeshape.jcr.SystemContent;
import org.modeshape.jcr.api.Problems;
import org.modeshape.jcr.api.index.IndexColumnDefinition;
import org.modeshape.jcr.api.index.IndexColumnDefinitionTemplate;
import org.modeshape.jcr.api.index.IndexDefinition;
import org.modeshape.jcr.api.index.IndexDefinitionTemplate;
import org.modeshape.jcr.api.index.IndexExistsException;
import org.modeshape.jcr.api.index.IndexManager;
import org.modeshape.jcr.api.index.InvalidIndexDefinitionException;
import org.modeshape.jcr.api.index.NoSuchIndexException;
import org.modeshape.jcr.cache.SessionCache;
import org.modeshape.jcr.cache.WorkspaceNotFoundException;
import org.modeshape.jcr.cache.change.Change;
import org.modeshape.jcr.cache.change.ChangeSet;
import org.modeshape.jcr.cache.change.NodeAdded;
import org.modeshape.jcr.cache.change.NodeRemoved;
import org.modeshape.jcr.cache.change.PropertyChanged;
import org.modeshape.jcr.cache.change.WorkspaceAdded;
import org.modeshape.jcr.cache.change.WorkspaceRemoved;
import org.modeshape.jcr.query.CompositeIndexWriter;
import org.modeshape.jcr.query.engine.ScanningQueryEngine;
import org.modeshape.jcr.spi.index.IndexDefinitionChanges;
import org.modeshape.jcr.spi.index.IndexFeedback;
import org.modeshape.jcr.spi.index.IndexManager;
import org.modeshape.jcr.spi.index.IndexWriter;
import org.modeshape.jcr.spi.index.WorkspaceChanges;
import org.modeshape.jcr.spi.index.provider.IndexProvider;
import org.modeshape.jcr.spi.index.provider.IndexProviderExistsException;
import org.modeshape.jcr.spi.index.provider.ManagedIndex;
import org.modeshape.jcr.spi.index.provider.NoSuchProviderException;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.NameFactory;
import org.modeshape.jcr.value.Path;
import org.modeshape.jcr.value.PathFactory;
import org.modeshape.jcr.value.StringFactory;
import org.modeshape.jcr.value.ValueFactory;

@ThreadSafe
class RepositoryIndexManager
implements IndexManager,
NodeTypes.Listener {
    private static final Set<Name> NON_UNIQUE_PROPERTY_NAMES = Collections.unmodifiableSet((Object[])new Name[]{JcrLexicon.PRIMARY_TYPE, JcrLexicon.MIXIN_TYPES, JcrLexicon.PATH, ModeShapeLexicon.DEPTH, ModeShapeLexicon.LOCALNAME});
    private static final Set<Name> NON_ENUMERATED_PROPERTY_NAMES = Collections.unmodifiableSet((Object[])new Name[]{JcrLexicon.PRIMARY_TYPE, JcrLexicon.MIXIN_TYPES, JcrLexicon.PATH, ModeShapeLexicon.DEPTH, ModeShapeLexicon.LOCALNAME});
    private final JcrRepository.RunningState repository;
    private final RepositoryConfiguration config;
    private final ExecutionContext context;
    private final String systemWorkspaceName;
    private final Path indexesPath;
    private final Collection<RepositoryConfiguration.Component> components;
    private final ConcurrentMap<String, IndexProvider> providers = new ConcurrentHashMap<String, IndexProvider>();
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private volatile IndexWriter indexWriter;
    private final Logger logger = Logger.getLogger(this.getClass());
    private volatile RepositoryIndexes indexes = RepositoryIndexes.NO_INDEXES;

    RepositoryIndexManager(JcrRepository.RunningState repository, RepositoryConfiguration config) {
        this.repository = repository;
        this.config = config;
        this.context = repository.context();
        this.systemWorkspaceName = this.repository.repositoryCache().getSystemWorkspaceName();
        PathFactory pathFactory = this.context.getValueFactories().getPathFactory();
        this.indexesPath = pathFactory.createAbsolutePath(JcrLexicon.SYSTEM, ModeShapeLexicon.INDEXES);
        this.components = config.getIndexProviders();
        for (RepositoryConfiguration.Component component : this.components) {
            try {
                IndexProvider provider = (IndexProvider)component.createInstance(ScanningQueryEngine.class.getClassLoader());
                this.register(provider);
            }
            catch (Throwable t) {
                if (t.getCause() != null) {
                    t = t.getCause();
                }
                this.repository.error(t, JcrI18n.unableToInitializeIndexProvider, component, repository.name(), t.getMessage());
            }
        }
    }

    protected synchronized ScanningTasks initialize() {
        if (this.initialized.get()) {
            return null;
        }
        Iterator providerIter = this.providers.entrySet().iterator();
        while (providerIter.hasNext()) {
            IndexProvider provider = (IndexProvider)providerIter.next().getValue();
            try {
                this.doInitialize(provider);
            }
            catch (Throwable t) {
                if (t.getCause() != null) {
                    t = t.getCause();
                }
                this.repository.error(t, JcrI18n.unableToInitializeIndexProvider, provider.getName(), this.repository.name(), t.getMessage());
                providerIter.remove();
            }
        }
        RepositoryIndexes indexes = this.readIndexDefinitions();
        ScanningTasks feedback = new ScanningTasks();
        Iterator providerIter2 = this.providers.entrySet().iterator();
        while (providerIter2.hasNext()) {
            IndexProvider provider = (IndexProvider)providerIter2.next().getValue();
            if (provider == null) continue;
            String providerName = provider.getName();
            IndexChanges changes = new IndexChanges();
            for (IndexDefinition indexDefn : indexes.getIndexDefinitions().values()) {
                if (!providerName.equals(indexDefn.getProviderName())) continue;
                changes.change(indexDefn);
            }
            try {
                provider.notify(changes, this.repository.changeBus(), (NodeTypes.Supplier)this.repository.nodeTypeManager(), this.repository.repositoryCache().getWorkspaceNames(), feedback.forProvider(providerName));
            }
            catch (RuntimeException e) {
                this.logger.error((Throwable)e, (I18nResource)JcrI18n.errorNotifyingProviderOfIndexChanges, new Object[]{providerName, this.repository.name(), e.getMessage()});
            }
        }
        this.refreshIndexWriter();
        this.initialized.set(true);
        return feedback;
    }

    @Override
    public void notify(NodeTypes updatedNodeTypes) {
        for (IndexProvider provider : this.providers.values()) {
            provider.notify(updatedNodeTypes);
        }
    }

    synchronized void importIndexDefinitions() throws RepositoryException {
        RepositoryConfiguration.Indexes indexes = this.config.getIndexes();
        if (indexes.isEmpty()) {
            return;
        }
        ArrayList<IndexDefinition> defns = new ArrayList<IndexDefinition>();
        for (String indexName : indexes.getIndexNames()) {
            IndexDefinition defn = indexes.getIndex(indexName);
            if (defn == null) continue;
            defns.add(defn);
        }
        if (!defns.isEmpty()) {
            IndexDefinition[] array = defns.toArray(new IndexDefinition[defns.size()]);
            this.registerIndexes(array, true);
            try {
                Thread.sleep(500L + (long)array.length * 50L);
            }
            catch (Exception e) {
                throw new SystemFailureException((Throwable)e);
            }
            this.repository.queryManager().reindexSystemContent();
        }
    }

    protected void refreshIndexWriter() {
        this.indexWriter = CompositeIndexWriter.create(this.providers.values());
    }

    protected void doInitialize(IndexProvider provider) throws RepositoryException {
        Reflection.setValue((Object)provider, (String)"context", (Object)this.repository.context());
        Reflection.setValue((Object)provider, (String)"environment", (Object)this.repository.environment());
        provider.initialize();
        Method postInitialize = Reflection.findMethod(IndexProvider.class, (String)"postInitialize");
        Reflection.invokeAccessibly((Object)provider, (Method)postInitialize, (Object[])new Object[0]);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Successfully initialized index provider '{0}' in repository '{1}'", new Object[]{provider.getName(), this.repository.name()});
        }
    }

    void shutdown() {
        for (IndexProvider provider : this.providers.values()) {
            try {
                provider.shutdown();
            }
            catch (RepositoryException e) {
                this.logger.error((Throwable)e, (I18nResource)JcrI18n.errorShuttingDownIndexProvider, new Object[]{this.repository.name(), provider.getName(), e.getMessage()});
            }
        }
    }

    IndexWriter getIndexWriter() {
        return this.indexWriter;
    }

    IndexWriter getIndexWriterForProviders(Set<String> providerNames) {
        LinkedList<IndexProvider> reindexProviders = new LinkedList<IndexProvider>();
        for (IndexProvider provider : this.providers.values()) {
            if (!providerNames.contains(provider.getName())) continue;
            reindexProviders.add(provider);
        }
        return CompositeIndexWriter.create(reindexProviders);
    }

    @Override
    public synchronized void register(IndexProvider provider) throws RepositoryException {
        IndexProvider existing;
        if (this.providers.containsKey(provider.getName())) {
            throw new IndexProviderExistsException(JcrI18n.indexProviderAlreadyExists.text(new Object[]{provider.getName(), this.repository.name()}));
        }
        Reflection.setValue((Object)provider, (String)"repositoryName", (Object)this.repository.name());
        Reflection.setValue((Object)provider, (String)"logger", (Object)ExtensionLogger.getLogger(provider.getClass()));
        Reflection.setValue((Object)provider, (String)"systemWorkspaceName", (Object)this.systemWorkspaceName);
        if (this.initialized.get()) {
            this.doInitialize(provider);
        }
        if ((existing = this.providers.putIfAbsent(provider.getName(), provider)) != null) {
            throw new IndexProviderExistsException(JcrI18n.indexProviderAlreadyExists.text(new Object[]{provider.getName(), this.repository.name()}));
        }
        this.readIndexDefinitions();
        this.refreshIndexWriter();
    }

    @Override
    public void unregister(String providerName) throws RepositoryException {
        IndexProvider provider = (IndexProvider)this.providers.remove(providerName);
        if (provider == null) {
            throw new NoSuchProviderException(JcrI18n.indexProviderDoesNotExist.text(new Object[]{providerName, this.repository.name()}));
        }
        if (this.initialized.get()) {
            provider.shutdown();
        }
        this.readIndexDefinitions();
        this.refreshIndexWriter();
    }

    public IndexManager.IndexStatus getIndexStatus(String providerName, String indexName, String workspaceName) {
        CheckArg.isNotNull((Object)providerName, (String)"providerName");
        CheckArg.isNotNull((Object)indexName, (String)"indexName");
        CheckArg.isNotNull((Object)workspaceName, (String)"workspaceName");
        IndexProvider provider = this.getProvider(providerName);
        if (provider == null) {
            return IndexManager.IndexStatus.NON_EXISTENT;
        }
        ManagedIndex managedIndex = provider.getManagedIndex(indexName, workspaceName);
        return managedIndex != null ? managedIndex.getStatus() : IndexManager.IndexStatus.NON_EXISTENT;
    }

    @Override
    public List<ManagedIndex> getIndexes(String providerName, String workspaceName, final IndexManager.IndexStatus status) {
        CheckArg.isNotNull((Object)providerName, (String)"providerName");
        CheckArg.isNotNull((Object)workspaceName, (String)"workspaceName");
        final ArrayList<ManagedIndex> result = new ArrayList<ManagedIndex>();
        IndexProvider provider = this.getProvider(providerName);
        if (provider == null) {
            return result;
        }
        provider.onEachIndexInWorkspace(workspaceName, new IndexProvider.ManagedIndexOperation(){

            @Override
            public void apply(String workspaceName, ManagedIndex index, IndexDefinition defn) {
                if (index.getStatus().equals((Object)status)) {
                    result.add(index);
                }
            }
        });
        return result;
    }

    public List<String> getIndexNames(String providerName, String workspaceName, final IndexManager.IndexStatus status) {
        CheckArg.isNotNull((Object)providerName, (String)"providerName");
        CheckArg.isNotNull((Object)workspaceName, (String)"workspaceName");
        final ArrayList<String> result = new ArrayList<String>();
        IndexProvider provider = this.getProvider(providerName);
        if (provider == null) {
            return result;
        }
        provider.onEachIndexInWorkspace(workspaceName, new IndexProvider.ManagedIndexOperation(){

            @Override
            public void apply(String workspaceName, ManagedIndex index, IndexDefinition defn) {
                if (index.getStatus().equals((Object)status)) {
                    result.add(defn.getName());
                }
            }
        });
        return result;
    }

    public Set<String> getProviderNames() {
        return Collections.unmodifiableSet(new HashSet(this.providers.keySet()));
    }

    protected Iterable<IndexProvider> getProviders() {
        return new ArrayList<IndexProvider>(this.providers.values());
    }

    @Override
    public IndexProvider getProvider(String name) {
        return (IndexProvider)this.providers.get(name);
    }

    public Map<String, IndexDefinition> getIndexDefinitions() {
        return this.indexes.getIndexDefinitions();
    }

    public IndexColumnDefinitionTemplate createIndexColumnDefinitionTemplate() {
        return new RepositoryIndexColumnDefinitionTemplate();
    }

    public IndexDefinitionTemplate createIndexDefinitionTemplate() {
        return new RepositoryIndexDefinitionTemplate();
    }

    public void registerIndex(IndexDefinition indexDefinition, boolean allowUpdate) throws InvalidIndexDefinitionException, IndexExistsException, RepositoryException {
        this.registerIndexes(new IndexDefinition[]{indexDefinition}, allowUpdate);
    }

    public void registerIndexes(IndexDefinition[] indexDefinitions, boolean allowUpdate) throws InvalidIndexDefinitionException, IndexExistsException {
        CheckArg.isNotNull((Object)indexDefinitions, (String)"indexDefinitions");
        RepositoryNodeTypeManager nodeTypeManager = this.repository.nodeTypeManager();
        ArrayList<IndexDefinition> validated = new ArrayList<IndexDefinition>(indexDefinitions.length);
        SimpleProblems problems = new SimpleProblems();
        for (IndexDefinition defn : indexDefinitions) {
            String name = defn.getName();
            String providerName = defn.getProviderName();
            if (name == null) {
                problems.addError(JcrI18n.indexMustHaveName, new Object[]{defn, this.repository.name()});
                continue;
            }
            if (this.indexes.getIndexDefinitions().containsKey(name) && !allowUpdate) {
                String msg = JcrI18n.indexAlreadyExists.text(new Object[]{defn.getName(), this.repository.name()});
                throw new IndexExistsException(msg);
            }
            if (providerName == null) {
                problems.addError(JcrI18n.indexMustHaveProviderName, new Object[]{defn.getName(), this.repository.name()});
                continue;
            }
            if (defn.hasSingleColumn()) {
                IndexColumnDefinition columnDefn = defn.getColumnDefinition(0);
                Name propName = (Name)this.context.getValueFactories().getNameFactory().create(columnDefn.getPropertyName());
                switch (defn.getKind()) {
                    case UNIQUE_VALUE: {
                        if (!NON_UNIQUE_PROPERTY_NAMES.contains(propName)) break;
                        problems.addError(JcrI18n.unableToCreateUniqueIndexForColumn, new Object[]{defn.getName(), columnDefn.getPropertyName()});
                        break;
                    }
                    case ENUMERATED_VALUE: {
                        if (!NON_ENUMERATED_PROPERTY_NAMES.contains(propName)) break;
                        problems.addError(JcrI18n.unableToCreateEnumeratedIndexForColumn, new Object[]{defn.getName(), columnDefn.getPropertyName()});
                        break;
                    }
                }
            } else if (defn.getKind() == IndexDefinition.IndexKind.NODE_TYPE) {
                problems.addError(JcrI18n.nodeTypeIndexMustHaveOneColumn, new Object[]{defn.getName()});
            }
            IndexProvider provider = (IndexProvider)this.providers.get(providerName);
            if (provider == null) {
                problems.addError(JcrI18n.indexProviderDoesNotExist, new Object[]{defn.getName(), this.repository.name()});
                continue;
            }
            provider.validateDefaultColumnTypes(this.context, defn, (org.modeshape.common.collection.Problems)problems);
            provider.validateProposedIndex(this.context, defn, nodeTypeManager, (org.modeshape.common.collection.Problems)problems);
            defn = RepositoryIndexDefinition.createFrom(defn, true);
            validated.add(defn);
        }
        if (problems.hasErrors()) {
            String msg = JcrI18n.invalidIndexDefinitions.text(new Object[]{this.repository.name(), problems});
            throw new InvalidIndexDefinitionException((Problems)new JcrProblems((org.modeshape.common.collection.Problems)problems), msg);
        }
        SessionCache systemCache = this.repository.createSystemSession(this.context, false);
        SystemContent system = new SystemContent(systemCache);
        for (IndexDefinition defn : validated) {
            String providerName = defn.getProviderName();
            defn = RepositoryIndexDefinition.createFrom(defn, this.providers.containsKey(providerName));
            system.store(defn, allowUpdate);
        }
        systemCache.save();
        this.indexes = this.readIndexDefinitions();
    }

    public void unregisterIndexes(String ... indexNames) throws NoSuchIndexException, RepositoryException {
        if (indexNames == null || indexNames.length == 0) {
            return;
        }
        SessionCache systemCache = this.repository.createSystemSession(this.context, false);
        SystemContent system = new SystemContent(systemCache);
        for (String indexName : indexNames) {
            IndexDefinition defn = this.indexes.getIndexDefinitions().get(indexName);
            if (defn == null) {
                throw new NoSuchIndexException(JcrI18n.indexDoesNotExist.text(new Object[]{indexName, this.repository.name()}));
            }
            system.remove(defn);
        }
        system.save();
        this.indexes = this.readIndexDefinitions();
    }

    RepositoryIndexManager with(JcrRepository.RunningState repository) {
        return new RepositoryIndexManager(repository, this.config);
    }

    protected final ValueFactory<String> strings() {
        return this.context.getValueFactories().getStringFactory();
    }

    public RepositoryIndexes getIndexes() {
        return this.indexes;
    }

    protected ScanningTasks notify(ChangeSet changeSet) {
        if (changeSet.getWorkspaceName() == null) {
            RepositoryIndexes indexes = this.readIndexDefinitions();
            ScanningTasks feedback = new ScanningTasks();
            if (!indexes.getIndexDefinitions().isEmpty()) {
                HashSet<String> addedWorkspaces = new HashSet<String>();
                HashSet<String> removedWorkspaces = new HashSet<String>();
                for (Object change : changeSet) {
                    if (change instanceof WorkspaceAdded) {
                        WorkspaceAdded added = (WorkspaceAdded)change;
                        addedWorkspaces.add(added.getWorkspaceName());
                        continue;
                    }
                    if (!(change instanceof WorkspaceRemoved)) continue;
                    WorkspaceRemoved removed = (WorkspaceRemoved)change;
                    removedWorkspaces.add(removed.getWorkspaceName());
                }
                if (!addedWorkspaces.isEmpty() || !removedWorkspaces.isEmpty()) {
                    String providerName;
                    HashMap<String, ArrayList<IndexDefinition>> defnsByProvider = new HashMap<String, ArrayList<IndexDefinition>>();
                    for (IndexDefinition defn : indexes.getIndexDefinitions().values()) {
                        providerName = defn.getProviderName();
                        ArrayList<IndexDefinition> defns = (ArrayList<IndexDefinition>)defnsByProvider.get(providerName);
                        if (defns == null) {
                            defns = new ArrayList<IndexDefinition>();
                            defnsByProvider.put(providerName, defns);
                        }
                        defns.add(defn);
                    }
                    for (Map.Entry entry : defnsByProvider.entrySet()) {
                        providerName = (String)entry.getKey();
                        WorkspaceIndexChanges changes = new WorkspaceIndexChanges((List)entry.getValue(), addedWorkspaces, removedWorkspaces);
                        IndexProvider provider = (IndexProvider)this.providers.get(providerName);
                        if (provider == null) continue;
                        provider.notify(changes, this.repository.changeBus(), (NodeTypes.Supplier)this.repository.nodeTypeManager(), this.repository.repositoryCache().getWorkspaceNames(), feedback.forProvider(providerName));
                    }
                }
            }
            return feedback;
        }
        if (!this.systemWorkspaceName.equals(changeSet.getWorkspaceName())) {
            return null;
        }
        AtomicReference<Map<Name, IndexChangeInfo>> changesByProviderName = new AtomicReference<Map<Name, IndexChangeInfo>>();
        for (Change change : changeSet) {
            PropertyChanged propChanged;
            Path changedPath;
            Name indexName;
            Name providerName;
            if (change instanceof NodeAdded) {
                NodeAdded added = (NodeAdded)change;
                Path addedPath = added.getPath();
                if (!this.indexesPath.isAncestorOf(addedPath)) continue;
                providerName = addedPath.getSegment(2).getName();
                if (addedPath.size() <= 3) continue;
                indexName = addedPath.getSegment(3).getName();
                RepositoryIndexManager.changeInfoForProvider(changesByProviderName, providerName).changed(indexName);
                continue;
            }
            if (change instanceof NodeRemoved) {
                NodeRemoved removed = (NodeRemoved)change;
                Path removedPath = removed.getPath();
                if (!this.indexesPath.isAncestorOf(removedPath)) continue;
                providerName = removedPath.getSegment(2).getName();
                if (removedPath.size() > 4) {
                    indexName = removedPath.getSegment(3).getName();
                    RepositoryIndexManager.changeInfoForProvider(changesByProviderName, providerName).removed(indexName);
                    continue;
                }
                if (removedPath.size() > 3) {
                    indexName = removedPath.getSegment(3).getName();
                    RepositoryIndexManager.changeInfoForProvider(changesByProviderName, providerName).removed(indexName);
                    continue;
                }
                if (removedPath.size() != 3) continue;
                RepositoryIndexManager.changeInfoForProvider(changesByProviderName, providerName).removedAll();
                continue;
            }
            if (!(change instanceof PropertyChanged) || !this.indexesPath.isAncestorOf(changedPath = (propChanged = (PropertyChanged)change).getPathToNode()) || changedPath.size() <= 3) continue;
            providerName = changedPath.getSegment(2).getName();
            indexName = changedPath.getSegment(3).getName();
            RepositoryIndexManager.changeInfoForProvider(changesByProviderName, providerName).changed(indexName);
        }
        if (changesByProviderName.get() == null || ((Map)changesByProviderName.get()).isEmpty()) {
            return null;
        }
        RepositoryIndexes indexes = this.readIndexDefinitions();
        StringFactory strings = this.context.getValueFactories().getStringFactory();
        ScanningTasks feedback = new ScanningTasks();
        for (Map.Entry entry : ((Map)changesByProviderName.get()).entrySet()) {
            String providerName = (String)strings.create((Name)entry.getKey());
            IndexProvider provider = (IndexProvider)this.providers.get(providerName);
            if (provider == null) continue;
            IndexChanges changes = new IndexChanges();
            IndexChangeInfo info = (IndexChangeInfo)entry.getValue();
            if (info.removedAll) {
                for (IndexDefinition defn : indexes.getIndexDefinitions().values()) {
                    if (!defn.getProviderName().equals(providerName)) continue;
                    changes.remove(defn.getName());
                }
            }
            for (Name name : info.removedIndexes) {
                changes.remove((String)strings.create(name));
            }
            for (Name name : info.changedIndexes) {
                IndexDefinition defn = indexes.getIndexDefinitions().get(strings.create(name));
                if (defn == null) continue;
                changes.change(defn);
            }
            try {
                provider.notify(changes, this.repository.changeBus(), (NodeTypes.Supplier)this.repository.nodeTypeManager(), this.repository.repositoryCache().getWorkspaceNames(), feedback.forProvider(providerName));
            }
            catch (RuntimeException e) {
                this.logger.error((Throwable)e, (I18nResource)JcrI18n.errorNotifyingProviderOfIndexChanges, new Object[]{providerName, this.repository.name(), e.getMessage()});
            }
        }
        this.indexes = indexes;
        return feedback;
    }

    protected boolean hasProviders() {
        return !this.providers.isEmpty();
    }

    protected static IndexChangeInfo changeInfoForProvider(AtomicReference<Map<Name, IndexChangeInfo>> changesByProviderName, Name providerName) {
        IndexChangeInfo info;
        Map<Name, IndexChangeInfo> byProviderName = changesByProviderName.get();
        if (byProviderName == null) {
            byProviderName = new HashMap<Name, IndexChangeInfo>();
            changesByProviderName.set(byProviderName);
        }
        if ((info = byProviderName.get(providerName)) == null) {
            info = new IndexChangeInfo();
            byProviderName.put(providerName, info);
        }
        return info;
    }

    protected RepositoryIndexes readIndexDefinitions() {
        NodeTypes nodeTypes = this.repository.nodeTypeManager().getNodeTypes();
        try {
            SessionCache systemCache = this.repository.createSystemSession(this.context, false);
            SystemContent system = new SystemContent(systemCache);
            List<IndexDefinition> indexDefns = system.readAllIndexDefinitions(this.providers.keySet());
            this.indexes = new Indexes(this.context, indexDefns, nodeTypes);
            return this.indexes;
        }
        catch (WorkspaceNotFoundException systemCache) {
        }
        catch (Throwable e) {
            this.logger.error(e, (I18nResource)JcrI18n.errorRefreshingIndexDefinitions, new Object[]{this.repository.name()});
        }
        return this.indexes;
    }

    @ThreadSafe
    static class ScanningTasks {
        private final Set<String> providerNames = new HashSet<String>();
        private Multimap<String, PathToScan> pathsByWorkspaceName = ArrayListMultimap.create();

        ScanningTasks() {
        }

        public synchronized boolean add(ScanningTasks other) {
            if (other != null) {
                this.providerNames.addAll(other.providerNames);
                for (Map.Entry entry : other.pathsByWorkspaceName.entries()) {
                    this.add((String)entry.getKey(), (PathToScan)entry.getValue());
                }
            }
            return !this.providerNames.isEmpty();
        }

        public synchronized ScanningRequest drain() {
            if (this.providerNames.isEmpty()) {
                return ScanningRequest.EMPTY;
            }
            HashSet<String> providerNames = new HashSet<String>(this.providerNames);
            Multimap<String, PathToScan> pathsToScanByWorkspace = this.pathsByWorkspaceName;
            this.pathsByWorkspaceName = ArrayListMultimap.create();
            this.providerNames.clear();
            return new ScanningRequest(pathsToScanByWorkspace, providerNames);
        }

        protected synchronized void add(String providerName, String workspaceName, Path path, IndexFeedback.IndexingCallback callback) {
            assert (providerName != null);
            assert (workspaceName != null);
            assert (path != null);
            this.providerNames.add(providerName);
            this.add(workspaceName, path, callback);
        }

        private void add(String workspaceName, PathToScan pathToScan) {
            Collection pathsToScan = this.pathsByWorkspaceName.get((Object)workspaceName);
            if (pathsToScan.isEmpty()) {
                pathsToScan.add(pathToScan);
            } else {
                Iterator iter = pathsToScan.iterator();
                boolean add = true;
                Path path = pathToScan.path();
                while (iter.hasNext()) {
                    PathToScan existing = (PathToScan)iter.next();
                    Path existingPath = existing.path();
                    if (path.isAtOrAbove(existingPath)) {
                        iter.remove();
                        pathToScan.addCallbacks(existing);
                        continue;
                    }
                    if (!path.isDescendantOf(existingPath)) continue;
                    add = false;
                    existing.addCallbacks(pathToScan);
                    break;
                }
                if (add) {
                    this.pathsByWorkspaceName.put((Object)workspaceName, (Object)pathToScan);
                }
            }
        }

        private void add(String workspaceName, Path path, IndexFeedback.IndexingCallback callback) {
            this.add(workspaceName, new PathToScan(path, callback));
        }

        protected IndexFeedback forProvider(final String providerName) {
            assert (providerName != null);
            return new IndexFeedback(){

                @Override
                public void scan(String workspaceName, IndexFeedback.IndexingCallback callback) {
                    ScanningTasks.this.add(providerName, workspaceName, Path.ROOT_PATH, callback);
                }

                @Override
                public void scan(String workspaceName, IndexFeedback.IndexingCallback callback, Path path) {
                    ScanningTasks.this.add(providerName, workspaceName, path, callback);
                }
            };
        }
    }

    private static class PathToScan
    implements Iterable<IndexFeedback.IndexingCallback> {
        private final Path path;
        private final Set<IndexFeedback.IndexingCallback> callbacks = new CopyOnWriteArraySet<IndexFeedback.IndexingCallback>();

        protected PathToScan(Path path, IndexFeedback.IndexingCallback callback) {
            this.path = path;
            if (callback != null) {
                this.callbacks.add(callback);
            }
        }

        public void addCallbacks(PathToScan other) {
            this.callbacks.addAll(other.callbacks);
        }

        public Path path() {
            return this.path;
        }

        public int hashCode() {
            return this.path.hashCode();
        }

        public boolean equals(Object obj) {
            return this.path.equals(obj);
        }

        @Override
        public Iterator<IndexFeedback.IndexingCallback> iterator() {
            return this.callbacks.iterator();
        }
    }

    @Immutable
    static class ScanningRequest {
        protected static final ScanningRequest EMPTY = new ScanningRequest();
        private final Set<String> providerNames;
        private final Multimap<String, PathToScan> pathsToScanByWorkspace;

        protected ScanningRequest() {
            this.providerNames = java.util.Collections.emptySet();
            this.pathsToScanByWorkspace = ArrayListMultimap.create();
        }

        protected ScanningRequest(Multimap<String, PathToScan> pathsToScanByWorkspace, Set<String> providerNames) {
            assert (pathsToScanByWorkspace != null);
            assert (providerNames != null);
            this.providerNames = Collections.unmodifiableSet(providerNames);
            this.pathsToScanByWorkspace = pathsToScanByWorkspace;
        }

        public boolean isEmpty() {
            return this.providerNames.isEmpty();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onEachPathInWorkspace(ScanOperation operation) {
            for (Map.Entry entry : this.pathsToScanByWorkspace.entries()) {
                String workspaceName = (String)entry.getKey();
                PathToScan pathToScan = (PathToScan)entry.getValue();
                for (IndexFeedback.IndexingCallback callback : pathToScan) {
                    callback.beforeIndexing();
                    try {
                        operation.scan(workspaceName, pathToScan.path(), callback.writer());
                    }
                    catch (Exception e) {
                        Logger.getLogger(this.getClass()).error((Throwable)e, (I18nResource)JcrI18n.errorIndexing, new Object[]{pathToScan.path(), workspaceName, e.getMessage()});
                    }
                    finally {
                        callback.afterIndexing();
                    }
                }
            }
        }

        public Set<String> providerNames() {
            return this.providerNames;
        }
    }

    static interface ScanOperation {
        public void scan(String var1, Path var2, IndexWriter var3);
    }

    @Immutable
    public static final class Indexes
    extends RepositoryIndexes {
        private final Map<String, IndexDefinition> indexByName = new HashMap<String, IndexDefinition>();
        private final Map<String, Map<String, Collection<IndexDefinition>>> indexesByProviderByNodeTypeName = new HashMap<String, Map<String, Collection<IndexDefinition>>>();

        protected Indexes(ExecutionContext context, Collection<IndexDefinition> defns, NodeTypes nodeTypes) {
            if (!defns.isEmpty()) {
                HashMap<Name, LinkedList<String>> subtypesByName = new HashMap<Name, LinkedList<String>>();
                for (JcrNodeType nodeType : nodeTypes.getAllNodeTypes()) {
                    for (JcrNodeType supertype : nodeType.getTypeAndSupertypes()) {
                        LinkedList<String> types = (LinkedList<String>)subtypesByName.get(supertype.getInternalName());
                        if (types == null) {
                            types = new LinkedList<String>();
                            subtypesByName.put(supertype.getInternalName(), types);
                        }
                        types.add(nodeType.getName());
                    }
                }
                NameFactory names = context.getValueFactories().getNameFactory();
                HashSet nodeTypeNames = new HashSet();
                for (IndexDefinition defn : defns) {
                    nodeTypeNames.clear();
                    Name nodeTypeName = (Name)names.create(defn.getNodeTypeName());
                    if (!subtypesByName.containsKey(nodeTypeName)) {
                        Logger.getLogger(this.getClass()).warn((I18nResource)JcrI18n.errorIndexing, new Object[]{"not creating index " + defn.getName() + " because of unknown nodeType " + nodeTypeName.getString()});
                        continue;
                    }
                    this.indexByName.put(defn.getName(), defn);
                    for (String typeAndSubtype : (Collection)subtypesByName.get(nodeTypeName)) {
                        Collection<IndexDefinition> indexes;
                        Map<String, Collection<IndexDefinition>> byProvider = this.indexesByProviderByNodeTypeName.get(typeAndSubtype);
                        if (byProvider == null) {
                            byProvider = new HashMap<String, Collection<IndexDefinition>>();
                            this.indexesByProviderByNodeTypeName.put(typeAndSubtype, byProvider);
                        }
                        if ((indexes = byProvider.get(defn.getProviderName())) == null) {
                            indexes = new LinkedList<IndexDefinition>();
                            byProvider.put(typeAndSubtype, indexes);
                        }
                        indexes.add(defn);
                    }
                }
            }
        }

        @Override
        public boolean hasIndexDefinitions() {
            return !this.indexByName.isEmpty();
        }

        @Override
        public Map<String, IndexDefinition> getIndexDefinitions() {
            return java.util.Collections.unmodifiableMap(this.indexByName);
        }

        @Override
        public Iterable<IndexDefinition> indexesFor(String nodeTypeName, String providerName) {
            Map<String, Collection<IndexDefinition>> defnsByProvider = this.indexesByProviderByNodeTypeName.get(nodeTypeName);
            if (defnsByProvider == null) {
                return null;
            }
            return defnsByProvider.get(providerName);
        }
    }

    protected static final class WorkspaceIndexChanges
    implements WorkspaceChanges {
        private final List<IndexDefinition> definitions;
        private final Set<String> addedWorkspaceNames;
        private final Set<String> removedWorkspaceNames;

        protected WorkspaceIndexChanges(List<IndexDefinition> defns, Set<String> addedWorkspaces, Set<String> removedWorkspaces) {
            this.definitions = defns;
            this.addedWorkspaceNames = addedWorkspaces;
            this.removedWorkspaceNames = removedWorkspaces;
        }

        @Override
        public Collection<IndexDefinition> getIndexDefinitions() {
            return this.definitions;
        }

        @Override
        public Set<String> getAddedWorkspaces() {
            return this.addedWorkspaceNames;
        }

        @Override
        public Set<String> getRemovedWorkspaces() {
            return this.removedWorkspaceNames;
        }
    }

    protected static final class IndexChanges
    implements IndexDefinitionChanges {
        private final Set<String> removedDefinitions = new HashSet<String>();
        private final Map<String, IndexDefinition> changedDefinitions = new HashMap<String, IndexDefinition>();

        protected IndexChanges() {
        }

        protected void remove(String name) {
            this.removedDefinitions.add(name);
        }

        protected void change(IndexDefinition indexDefn) {
            this.changedDefinitions.put(indexDefn.getName(), indexDefn);
        }

        @Override
        public Set<String> getRemovedIndexDefinitions() {
            return this.removedDefinitions;
        }

        @Override
        public Map<String, IndexDefinition> getUpdatedIndexDefinitions() {
            return this.changedDefinitions;
        }
    }

    protected static final class IndexChangeInfo {
        protected final Set<Name> changedIndexes = new HashSet<Name>();
        protected final Set<Name> removedIndexes = new HashSet<Name>();
        protected boolean removedAll = false;

        protected IndexChangeInfo() {
        }

        public void changed(Name indexName) {
            this.changedIndexes.add(indexName);
            this.removedIndexes.remove(indexName);
        }

        public void removed(Name indexName) {
            this.removedIndexes.add(indexName);
            this.changedIndexes.remove(indexName);
        }

        public void removedAll() {
            this.removedAll = true;
            this.removedIndexes.clear();
            this.changedIndexes.clear();
        }
    }
}

