/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.cache;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.annotation.NotThreadSafe;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.common.collection.EmptyIterator;
import org.modeshape.jcr.cache.ChildReference;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.NamespaceRegistry;
import org.modeshape.jcr.value.Path;

@Immutable
public interface ChildReferences
extends Iterable<ChildReference> {
    public static final long UNKNOWN_SIZE = -1L;

    public long size();

    public boolean isEmpty();

    public int getChildCount(Name var1);

    public ChildReference getChild(Name var1);

    public ChildReference getChild(Name var1, int var2);

    public ChildReference getChild(Name var1, int var2, Context var3);

    public ChildReference getChild(Path.Segment var1);

    public boolean hasChild(NodeKey var1);

    public ChildReference getChild(NodeKey var1);

    public ChildReference getChild(NodeKey var1, Context var2);

    public boolean supportsGetChildReferenceByKey();

    public Iterator<ChildReference> iterator(Name var1);

    public Iterator<ChildReference> iterator(Name var1, Context var2);

    @Override
    public Iterator<ChildReference> iterator();

    public Iterator<ChildReference> iterator(Collection<?> var1, NamespaceRegistry var2);

    public Iterator<ChildReference> iterator(Context var1);

    public Iterator<ChildReference> iterator(Context var1, Collection<?> var2, NamespaceRegistry var3);

    public boolean allowsSNS();

    public Iterator<NodeKey> getAllKeys();

    @ThreadSafe
    public static class WithChanges
    implements Context {
        private final Context delegate;
        private final Changes changes;

        public WithChanges(Context delegate, Changes changes) {
            this.delegate = delegate;
            this.changes = changes;
        }

        @Override
        public int consume(Name name, NodeKey key) {
            return this.delegate.consume(name, key);
        }

        @Override
        public Changes changes() {
            return this.changes;
        }
    }

    @NotThreadSafe
    public static class BasicContext
    implements Context {
        private final Map<Name, AtomicInteger> indexes = new HashMap<Name, AtomicInteger>();

        @Override
        public int consume(Name name, NodeKey key) {
            AtomicInteger index = this.indexes.get(name);
            if (index == null) {
                index = new AtomicInteger(1);
                this.indexes.put(name, index);
                return 1;
            }
            return index.incrementAndGet();
        }

        @Override
        public Changes changes() {
            return null;
        }
    }

    @ThreadSafe
    public static class SingleNameContext
    implements Context {
        private int index = 0;

        @Override
        public int consume(Name name, NodeKey key) {
            return ++this.index;
        }

        @Override
        public Changes changes() {
            return null;
        }
    }

    @ThreadSafe
    public static final class NoSnsIndexesContext
    implements Context {
        @Override
        public int consume(Name name, NodeKey key) {
            return 1;
        }

        @Override
        public Changes changes() {
            return null;
        }
    }

    @Immutable
    public static final class NoChanges
    implements Changes {
        protected static final Iterator<ChildInsertions> NO_INSERTIONS_ITERATOR = new EmptyIterator();

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public int insertionCount() {
            return 0;
        }

        @Override
        public int insertionCount(Name name) {
            return 0;
        }

        @Override
        public int removalCount() {
            return 0;
        }

        @Override
        public int renameCount() {
            return 0;
        }

        @Override
        public Name renamed(NodeKey key) {
            return null;
        }

        @Override
        public Iterator<ChildInsertions> insertions(Name name) {
            return NO_INSERTIONS_ITERATOR;
        }

        @Override
        public ChildReference inserted(NodeKey key) {
            return null;
        }

        @Override
        public ChildInsertions insertionsBefore(ChildReference key) {
            return null;
        }

        @Override
        public boolean isRemoved(ChildReference key) {
            return false;
        }

        @Override
        public boolean isRenamed(ChildReference ref) {
            return false;
        }

        @Override
        public boolean isRenamed(Name newName) {
            return false;
        }
    }

    public static final class NoContext
    implements Context {
        public static final Context INSTANCE = new NoContext();

        private NoContext() {
        }

        @Override
        public int consume(Name name, NodeKey key) {
            return 1;
        }

        @Override
        public Changes changes() {
            return null;
        }
    }

    public static interface ChildInsertions {
        public Iterable<ChildReference> inserted();

        public ChildReference insertedBefore();
    }

    public static interface Changes {
        public Iterator<ChildInsertions> insertions(Name var1);

        public ChildReference inserted(NodeKey var1);

        public ChildInsertions insertionsBefore(ChildReference var1);

        public boolean isRemoved(ChildReference var1);

        public boolean isRenamed(ChildReference var1);

        public boolean isRenamed(Name var1);

        public Name renamed(NodeKey var1);

        public boolean isEmpty();

        public int removalCount();

        public int insertionCount();

        public int insertionCount(Name var1);

        public int renameCount();
    }

    public static interface Context {
        public int consume(Name var1, NodeKey var2);

        public Changes changes();
    }
}

