/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.service;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.jcr.RepositoryException;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.schematic.Schematic;
import org.infinispan.schematic.document.Changes;
import org.infinispan.schematic.document.Document;
import org.infinispan.schematic.document.EditableArray;
import org.infinispan.schematic.document.EditableDocument;
import org.infinispan.schematic.document.Editor;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.security.ISecurityManagement;
import org.modeshape.common.collection.Problems;
import org.modeshape.common.util.DelegatingClassLoader;
import org.modeshape.common.util.StringUtil;
import org.modeshape.jboss.service.BinaryStorage;
import org.modeshape.jboss.subsystem.MappedAttributeDefinition;
import org.modeshape.jcr.Environment;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.ModeShapeEngine;
import org.modeshape.jcr.NoSuchRepositoryException;
import org.modeshape.jcr.RepositoryConfiguration;
import org.modeshape.jcr.RepositoryStatistics;

public class RepositoryService
implements Service<JcrRepository>,
Environment {
    private static final Logger LOG = Logger.getLogger((String)RepositoryService.class.getPackage().getName());
    private final InjectedValue<ModeShapeEngine> engineInjector = new InjectedValue();
    private final InjectedValue<BinaryStorage> binaryStorageInjector = new InjectedValue();
    private final InjectedValue<String> dataDirectoryPathInjector = new InjectedValue();
    private final InjectedValue<ModuleLoader> moduleLoaderInjector = new InjectedValue();
    private final InjectedValue<RepositoryStatistics> monitorInjector = new InjectedValue();
    private final InjectedValue<ISecurityManagement> securityManagementServiceInjector = new InjectedValue();
    private final ConcurrentHashMap<String, CacheContainer> containers;
    private final String cacheConfigRelativeTo;
    private final String cacheConfig;
    private final RepositoryConfiguration repositoryConfiguration;
    private final Set<ModuleIdentifier> additionalModuleDependencies = new LinkedHashSet<ModuleIdentifier>();
    private String journalPath;
    private String journalRelativeTo;

    public RepositoryService(RepositoryConfiguration repositoryConfiguration, String cacheConfig, String cacheConfigRelativeTo, String additionalModuleDependencies) {
        this.repositoryConfiguration = repositoryConfiguration;
        this.containers = new ConcurrentHashMap();
        this.cacheConfig = cacheConfig;
        this.cacheConfigRelativeTo = cacheConfigRelativeTo;
        if (!StringUtil.isBlank((String)additionalModuleDependencies)) {
            for (String moduleName : additionalModuleDependencies.split(",")) {
                ModuleIdentifier moduleId = this.moduleIdentifierFromName(moduleName);
                if (moduleId == null) continue;
                this.additionalModuleDependencies.add(moduleId);
            }
        }
    }

    public JcrRepository getValue() throws IllegalStateException, IllegalArgumentException {
        try {
            return this.getEngine().getRepository(this.repositoryName());
        }
        catch (NoSuchRepositoryException e) {
            throw new IllegalStateException(e);
        }
    }

    private ModeShapeEngine getEngine() {
        return (ModeShapeEngine)this.engineInjector.getValue();
    }

    public CacheContainer getCacheContainer(String name) {
        CacheContainer cacheContainer = this.containers.get(name);
        if (cacheContainer != null) {
            return cacheContainer;
        }
        InputStream is = null;
        String resourceFile = name;
        if ("org/modeshape/jcr/default-workspace-cache-config.xml".equalsIgnoreCase(name)) {
            is = RepositoryService.class.getClassLoader().getResourceAsStream("org/modeshape/jcr/default-workspace-cache-config.xml");
            if (is == null) {
                throw new IllegalStateException("Cannot locate the default ModeShape workspace cache config in the classpath.");
            }
        } else {
            String cacheConfig = name;
            if (name.startsWith("/")) {
                cacheConfig = name.substring(1);
            }
            String cacheConfigPath = this.cacheConfigRelativeTo + cacheConfig;
            File file = new File(cacheConfigPath);
            try {
                is = new FileInputStream(file);
                resourceFile = cacheConfigPath;
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException("Cannot locate and read the Infinispan configuration file: " + cacheConfigPath);
            }
        }
        try {
            DefaultCacheManager defaultCacheManager = new DefaultCacheManager(is);
            CacheContainer storedCacheContainer = this.containers.putIfAbsent(name, (CacheContainer)defaultCacheManager);
            return storedCacheContainer != null ? storedCacheContainer : defaultCacheManager;
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot load the Infinispan configuration file: " + resourceFile, e);
        }
    }

    public ClassLoader getClassLoader(ClassLoader fallbackLoader, String ... classpathEntries) {
        HashSet<ModuleIdentifier> moduleIds = new HashSet<ModuleIdentifier>();
        if (classpathEntries != null && classpathEntries.length > 0) {
            for (String moduleId : classpathEntries) {
                ModuleIdentifier moduleIdentifier = this.moduleIdentifierFromName(moduleId);
                if (moduleIdentifier == null) continue;
                moduleIds.add(moduleIdentifier);
            }
        }
        moduleIds.addAll(this.additionalModuleDependencies);
        ArrayList<Object> delegatingLoaders = new ArrayList<Object>();
        if (!moduleIds.isEmpty()) {
            for (ModuleIdentifier moduleIdentifier : moduleIds) {
                try {
                    delegatingLoaders.add(this.moduleLoader().loadModule(moduleIdentifier).getClassLoader());
                }
                catch (ModuleLoadException e) {
                    LOG.warnv("Cannot load module from (from classpath entry) with identifier: {0}", (Object)moduleIdentifier);
                }
            }
        }
        ClassLoader currentLoader = this.getClass().getClassLoader();
        if (fallbackLoader != null && !fallbackLoader.equals(currentLoader)) {
            if (fallbackLoader.getParent().equals(currentLoader)) {
                currentLoader = fallbackLoader;
            } else {
                delegatingLoaders.add(fallbackLoader);
            }
        }
        return delegatingLoaders.isEmpty() ? currentLoader : new DelegatingClassLoader(currentLoader, delegatingLoaders);
    }

    private ModuleIdentifier moduleIdentifierFromName(String moduleName) {
        if (StringUtil.isBlank((String)moduleName)) {
            return null;
        }
        try {
            return ModuleIdentifier.fromString((String)moduleName.trim());
        }
        catch (IllegalArgumentException e) {
            LOG.warnv("{0} is not a valid module identifier", (Object)moduleName);
            return null;
        }
    }

    public void shutdown() {
    }

    public final String repositoryName() {
        return this.repositoryConfiguration.getName();
    }

    public void start(StartContext arg0) throws StartException {
        ModeShapeEngine engine = this.getEngine();
        try {
            String repositoryName = this.repositoryName();
            BinaryStorage binaryStorageConfig = (BinaryStorage)this.binaryStorageInjector.getValue();
            assert (binaryStorageConfig != null);
            EditableDocument binaryConfig = binaryStorageConfig.getBinaryConfiguration();
            String binaryStoreType = binaryConfig.getString("type");
            if ("cache".equalsIgnoreCase(binaryStoreType)) {
                String cacheConfiguration = binaryConfig.getString("cacheConfiguration");
                if (StringUtil.isBlank((String)cacheConfiguration)) {
                    binaryConfig.set("cacheConfiguration", (Object)this.cacheConfig);
                }
            } else if ("composite".equalsIgnoreCase(binaryStoreType)) {
                EditableDocument nestedStores = binaryConfig.getDocument("namedStores");
                for (String storeName : nestedStores.keySet()) {
                    String cacheConfiguration;
                    EditableDocument nestedStore = nestedStores.getDocument(storeName);
                    if (!"cache".equalsIgnoreCase(nestedStore.getString("type")) || !StringUtil.isBlank((String)(cacheConfiguration = nestedStore.getString("cacheConfiguration")))) continue;
                    nestedStore.set("cacheConfiguration", (Object)this.cacheConfig);
                }
            }
            EditableDocument config = Schematic.newDocument((Document)this.repositoryConfiguration.getDocument());
            config.getOrCreateDocument("storage").setDocument("binaryStorage", (Document)binaryConfig);
            if (config.containsField("journaling")) {
                if (StringUtil.isBlank((String)this.journalRelativeTo)) {
                    this.journalRelativeTo = (String)this.getDataDirectoryPathInjector().getValue();
                }
                if (StringUtil.isBlank((String)this.journalPath)) {
                    this.journalPath = "journal";
                }
                String finalJournalLocation = this.journalRelativeTo + "/" + this.journalPath;
                config.getDocument("journaling").setString("location", finalJournalLocation);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debugv("ModeShape configuration for '{0}' repository: {1}", (Object)repositoryName, (Object)config);
                Problems problems = this.repositoryConfiguration.validate();
                if (!problems.isEmpty()) {
                    LOG.debugv("Problems with configuration for '{0}' repository: {1}", (Object)repositoryName, (Object)problems);
                }
            }
            RepositoryConfiguration updatedConfiguration = new RepositoryConfiguration((Document)config, repositoryName);
            engine.deploy(updatedConfiguration.with((Environment)this));
        }
        catch (Exception e) {
            throw new StartException((Throwable)e);
        }
    }

    public void stop(StopContext context) {
        ModeShapeEngine engine = this.getEngine();
        if (engine != null) {
            try {
                engine.undeploy(this.repositoryName());
            }
            catch (NoSuchRepositoryException noSuchRepositoryException) {
                // empty catch block
            }
        }
    }

    public void changeField(MappedAttributeDefinition defn, ModelNode newValue) throws RepositoryException, OperationFailedException {
        String fieldName2;
        Editor editor;
        ModeShapeEngine engine = this.getEngine();
        String repositoryName = this.repositoryName();
        RepositoryConfiguration config = engine.getRepositoryConfiguration(repositoryName);
        Editor fieldContainer = editor = config.edit();
        for (String fieldName2 : defn.getPathToContainerOfField()) {
            fieldContainer = editor.getOrCreateDocument(fieldName2);
        }
        Object rawValue = defn.getTypedValue(newValue);
        fieldName2 = defn.getFieldName();
        fieldContainer.set(fieldName2, rawValue);
        Changes changes = editor.getChanges();
        engine.update(repositoryName, changes);
    }

    public void changeIndexProviderField(MappedAttributeDefinition defn, ModelNode newValue, String indexProviderName) throws RepositoryException, OperationFailedException {
        ModeShapeEngine engine = this.getEngine();
        String repositoryName = this.repositoryName();
        RepositoryConfiguration config = engine.getRepositoryConfiguration(repositoryName);
        Editor editor = config.edit();
        List<String> pathToContainer = defn.getPathToContainerOfField();
        EditableDocument providers = editor.getOrCreateDocument(pathToContainer.get(0));
        for (String configuredProviderName : providers.keySet()) {
            if (!indexProviderName.equals(configuredProviderName)) continue;
            EditableDocument provider = (EditableDocument)providers.get(configuredProviderName);
            String fieldName = defn.getFieldName();
            Object rawValue = defn.getTypedValue(newValue);
            provider.set(fieldName, rawValue);
            break;
        }
        Changes changes = editor.getChanges();
        engine.update(repositoryName, changes);
    }

    public void changeIndexDefinitionField(MappedAttributeDefinition defn, ModelNode newValue, String indexDefinitionName) throws RepositoryException, OperationFailedException {
        ModeShapeEngine engine = this.getEngine();
        String repositoryName = this.repositoryName();
        RepositoryConfiguration config = engine.getRepositoryConfiguration(repositoryName);
        Editor editor = config.edit();
        List<String> pathToContainer = defn.getPathToContainerOfField();
        EditableDocument indexes = editor.getOrCreateDocument(pathToContainer.get(0));
        for (String configuredIndexName : indexes.keySet()) {
            if (!indexDefinitionName.equals(configuredIndexName)) continue;
            EditableDocument provider = (EditableDocument)indexes.get(configuredIndexName);
            String fieldName = defn.getFieldName();
            Object rawValue = defn.getTypedValue(newValue);
            provider.set(fieldName, rawValue);
            break;
        }
        Changes changes = editor.getChanges();
        engine.update(repositoryName, changes);
    }

    public void changeSequencerField(MappedAttributeDefinition defn, ModelNode newValue, String sequencerName) throws RepositoryException, OperationFailedException {
        ModeShapeEngine engine = this.getEngine();
        String repositoryName = this.repositoryName();
        RepositoryConfiguration config = engine.getRepositoryConfiguration(repositoryName);
        Editor editor = config.edit();
        List<String> pathToContainer = defn.getPathToContainerOfField();
        EditableDocument sequencing = editor.getOrCreateDocument(pathToContainer.get(0));
        EditableArray sequencers = sequencing.getOrCreateArray(pathToContainer.get(1));
        for (String configuredSequencerName : sequencers.keySet()) {
            if (!sequencerName.equals(configuredSequencerName)) continue;
            EditableDocument sequencer = (EditableDocument)sequencers.get(configuredSequencerName);
            String fieldName = defn.getFieldName();
            Object rawValue = defn.getTypedValue(newValue);
            sequencer.set(fieldName, rawValue);
            break;
        }
        Changes changes = editor.getChanges();
        engine.update(repositoryName, changes);
    }

    public void changeSourceField(MappedAttributeDefinition defn, ModelNode newValue, String sourceName) throws RepositoryException, OperationFailedException {
        ModeShapeEngine engine = this.getEngine();
        String repositoryName = this.repositoryName();
        RepositoryConfiguration config = engine.getRepositoryConfiguration(repositoryName);
        Editor editor = config.edit();
        EditableDocument externalSources = editor.getOrCreateDocument("externalSources");
        EditableDocument externalSource = externalSources.getDocument(sourceName);
        assert (externalSource != null);
        String fieldName = defn.getFieldName();
        Object rawValue = defn.getTypedValue(newValue);
        externalSource.set(fieldName, rawValue);
        Changes changes = editor.getChanges();
        engine.update(repositoryName, changes);
    }

    public void changeTextExtractorField(MappedAttributeDefinition defn, ModelNode newValue, String extractorName) throws RepositoryException, OperationFailedException {
        ModeShapeEngine engine = this.getEngine();
        String repositoryName = this.repositoryName();
        RepositoryConfiguration config = engine.getRepositoryConfiguration(repositoryName);
        Editor editor = config.edit();
        List<String> pathToContainer = defn.getPathToContainerOfField();
        EditableDocument textExtracting = editor.getOrCreateDocument(pathToContainer.get(1));
        EditableDocument extractors = textExtracting.getOrCreateDocument(pathToContainer.get(2));
        for (String configuredExtractorName : extractors.keySet()) {
            if (!extractorName.equals(configuredExtractorName)) continue;
            EditableDocument extractor = (EditableDocument)extractors.get(configuredExtractorName);
            String fieldName = defn.getFieldName();
            Object rawValue = defn.getTypedValue(newValue);
            extractor.set(fieldName, rawValue);
            break;
        }
        Changes changes = editor.getChanges();
        engine.update(repositoryName, changes);
    }

    public void changeAuthenticatorField(MappedAttributeDefinition defn, ModelNode newValue, String authenticatorName) throws RepositoryException, OperationFailedException {
        ModeShapeEngine engine = this.getEngine();
        String repositoryName = this.repositoryName();
        RepositoryConfiguration config = engine.getRepositoryConfiguration(repositoryName);
        Editor editor = config.edit();
        EditableDocument security = editor.getOrCreateDocument("security");
        EditableArray providers = security.getOrCreateArray("providers");
        for (String configuredAuthenticatorName : providers.keySet()) {
            if (!authenticatorName.equals(configuredAuthenticatorName)) continue;
            boolean found = false;
            for (Object nested : providers) {
                EditableDocument doc;
                if (!(nested instanceof EditableDocument) || !(doc = (EditableDocument)nested).getString("name").equals(configuredAuthenticatorName)) continue;
                String fieldName = defn.getFieldName();
                Object rawValue = defn.getTypedValue(newValue);
                doc.set(fieldName, rawValue);
                found = true;
                break;
            }
            if (found) break;
            EditableDocument doc = Schematic.newDocument();
            doc.set("name", (Object)configuredAuthenticatorName);
            String fieldName = defn.getFieldName();
            Object rawValue = defn.getTypedValue(newValue);
            doc.set(fieldName, rawValue);
            providers.add((Object)doc);
            break;
        }
        Changes changes = editor.getChanges();
        engine.update(repositoryName, changes);
    }

    public InjectedValue<BinaryStorage> getBinaryStorageInjector() {
        return this.binaryStorageInjector;
    }

    public InjectedValue<RepositoryStatistics> getMonitorInjector() {
        return this.monitorInjector;
    }

    public InjectedValue<ModeShapeEngine> getEngineInjector() {
        return this.engineInjector;
    }

    public InjectedValue<String> getDataDirectoryPathInjector() {
        return this.dataDirectoryPathInjector;
    }

    public InjectedValue<ModuleLoader> getModuleLoaderInjector() {
        return this.moduleLoaderInjector;
    }

    public InjectedValue<ISecurityManagement> getSecurityManagementServiceInjector() {
        return this.securityManagementServiceInjector;
    }

    private ModuleLoader moduleLoader() {
        return (ModuleLoader)this.moduleLoaderInjector.getValue();
    }

    public void setJournalPath(String journalPath) {
        this.journalPath = journalPath;
    }

    public void setJournalRelativeTo(String journalRelativeTo) {
        this.journalRelativeTo = journalRelativeTo;
    }
}

