/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.subsystem;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.modeshape.jboss.subsystem.AddressContext;

abstract class AbstractModeShapeRemoveStepHandler
extends AbstractRemoveStepHandler {
    protected final Logger log = Logger.getLogger((String)((Object)((Object)this)).getClass().getName());
    private Map<ServiceName, Service<?>> removedServices;

    AbstractModeShapeRemoveStepHandler() {
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        String repositoryName = null;
        for (ServiceName serviceName : this.servicesToRemove(context, operation, model)) {
            ServiceController serviceController = context.getServiceRegistry(false).getService(serviceName);
            if (serviceController == null || !serviceController.getState().in(new ServiceController.State[]{ServiceController.State.UP})) continue;
            context.removeService(serviceController);
            this.removedServices().put(serviceName, serviceController.getService());
            if (!this.log.isDebugEnabled()) continue;
            if (repositoryName == null) {
                repositoryName = this.repositoryName(operation);
            }
            this.log.debugf("service '%s' removed for repository '%s'", (Object)serviceName, (Object)repositoryName);
        }
    }

    private Map<ServiceName, Service<?>> removedServices() {
        if (this.removedServices == null) {
            this.removedServices = new HashMap();
        }
        return this.removedServices;
    }

    protected boolean requiresRuntime(OperationContext context) {
        return true;
    }

    protected void recoverServices(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        String repositoryName = null;
        Map<ServiceName, Service<?>> removedServices = this.removedServices();
        for (Map.Entry<ServiceName, Service<?>> serviceEntry : removedServices.entrySet()) {
            context.getServiceTarget().addService(serviceEntry.getKey(), serviceEntry.getValue());
            if (!this.log.isDebugEnabled()) continue;
            if (repositoryName == null) {
                repositoryName = this.repositoryName(operation);
            }
            this.log.debugf("service '%s' recovered for repository '%s'", (Object)serviceEntry.getKey(), (Object)repositoryName);
        }
    }

    String repositoryName(ModelNode operation) throws OperationFailedException {
        AddressContext addressContext = AddressContext.forOperation(operation);
        String repositoryName = addressContext.repositoryName();
        if (repositoryName == null) {
            throw new OperationFailedException("Cannot determine repository name for: " + operation.asString());
        }
        return repositoryName;
    }

    abstract List<ServiceName> servicesToRemove(OperationContext var1, ModelNode var2, ModelNode var3) throws OperationFailedException;
}

