/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.subsystem;

import java.util.List;
import java.util.Properties;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.modeshape.jboss.service.IndexDefinitionService;
import org.modeshape.jboss.subsystem.AddressContext;
import org.modeshape.jboss.subsystem.ModeShapeServiceNames;
import org.modeshape.jboss.subsystem.ModelAttributes;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.ModeShapeEngine;

public class AddIndexDefinition
extends AbstractAddStepHandler {
    public static final AddIndexDefinition INSTANCE = new AddIndexDefinition();

    private AddIndexDefinition() {
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        AddIndexDefinition.populate(operation, model);
    }

    static void populate(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (AttributeDefinition attribute : ModelAttributes.INDEX_DEFINITION_ATTRIBUTES) {
            attribute.validateAndSet(operation, model);
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) {
        ServiceTarget target = context.getServiceTarget();
        Properties props = new Properties();
        AddressContext addressContext = AddressContext.forOperation(operation);
        String repositoryName = addressContext.repositoryName();
        String providerName = addressContext.lastPathElementValue();
        props.put("name", providerName);
        for (String key : operation.keys()) {
            ModelNode node;
            if (key.equals("address") || key.equals("operation") || key.equals("operation-headers") || !(node = operation.get(key)).isDefined()) continue;
            if (key.equals("provider-name") && ModelAttributes.PROVIDER_NAME.isMarshallable(operation)) {
                props.put("provider", node.asString());
                continue;
            }
            if (key.equals("index-kind") && ModelAttributes.INDEX_KIND.isMarshallable(operation)) {
                props.put("kind", node.asString());
                continue;
            }
            if (key.equals("synchronous") && ModelAttributes.SYNCHRONOUS.isMarshallable(operation)) {
                props.put("synchronous", (Object)node.asBoolean());
                continue;
            }
            if (key.equals("node-type-name") && ModelAttributes.NODE_TYPE_NAME.isMarshallable(operation)) {
                props.put("nodeType", node.asString());
                continue;
            }
            if (key.equals("index-columns") && ModelAttributes.INDEX_COLUMNS.isMarshallable(operation)) {
                props.put("columns", node.asString());
                continue;
            }
            if (key.equals("properties")) {
                for (Property property : node.asPropertyList()) {
                    props.put(property.getName(), property.getValue().asString());
                }
                continue;
            }
            props.put(key, node.asString());
        }
        IndexDefinitionService indexDefnService = new IndexDefinitionService(repositoryName, props);
        ServiceBuilder indexDefnBuilder = target.addService(ModeShapeServiceNames.indexDefinitionServiceName(repositoryName, providerName), (Service)indexDefnService);
        indexDefnBuilder.addDependency(ModeShapeServiceNames.ENGINE, ModeShapeEngine.class, indexDefnService.getModeShapeEngineInjector());
        indexDefnBuilder.addDependency(ModeShapeServiceNames.repositoryServiceName(repositoryName), JcrRepository.class, indexDefnService.getJcrRepositoryInjector());
        indexDefnBuilder.setInitialMode(ServiceController.Mode.ACTIVE);
        ServiceController controller = indexDefnBuilder.install();
        newControllers.add(controller);
    }
}

